/*
 * Decompiled with CFR 0.152.
 */
package com.github.venth.failsafe.rxjava2.completableobservation;

import com.github.venth.failsafe.rxjava2.completableobservation.ObservationActivated;
import com.github.venth.failsafe.rxjava2.completableobservation.ObservationDisposed;
import com.github.venth.failsafe.rxjava2.completableobservation.ObservationState;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;

class ObservationDeactivated
implements ObservationState {
    private final Disposable owner;
    private final CompletableObserver observer;
    private final CircuitBreaker circuitBreaker;
    private final Function<Disposable, ObservationActivated> observationActivatedSupplier;
    private final Supplier<ObservationDisposed> observationDisposedSupplier;

    ObservationDeactivated(Disposable owner, CompletableObserver observer, CircuitBreaker circuitBreaker) {
        this(owner, observer, circuitBreaker, disposable -> new ObservationActivated((Disposable)disposable, observer, circuitBreaker), ObservationDisposed::new);
    }

    ObservationDeactivated(Disposable owner, CompletableObserver observer, CircuitBreaker circuitBreaker, Function<Disposable, ObservationActivated> observationActivatedSupplier, Supplier<ObservationDisposed> observationDisposedSupplier) {
        this.owner = owner;
        this.observer = observer;
        this.circuitBreaker = circuitBreaker;
        this.observationActivatedSupplier = observationActivatedSupplier;
        this.observationDisposedSupplier = observationDisposedSupplier;
    }

    @Override
    public ObservationState activate(Disposable disposable) {
        if (this.circuitBreaker.allowsExecution()) {
            this.observer.onSubscribe(this.owner);
            return this.observationActivatedSupplier.apply(disposable);
        }
        disposable.dispose();
        this.observer.onSubscribe(this.owner);
        this.observer.onError((Throwable)new CircuitBreakerOpenException());
        return this.observationDisposedSupplier.get();
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
    }

    @Override
    public ObservationState dispose() {
        return this;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void onComplete() {
        this.observer.onComplete();
    }
}

