/*
 * Decompiled with CFR 0.152.
 */
package com.github.venth.failsafe.rxjava2.observation;

import com.github.venth.failsafe.rxjava2.observation.ObservationActivated;
import com.github.venth.failsafe.rxjava2.observation.ObservationDisposed;
import com.github.venth.failsafe.rxjava2.observation.ObservationState;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;

class ObservationDeactivated<T>
implements ObservationState<T> {
    private final Disposable owner;
    private final Observer<T> observer;
    private final CircuitBreaker circuitBreaker;
    private final Function<Disposable, ObservationActivated<T>> observationActivatedSupplier;
    private final Supplier<ObservationDisposed<T>> observationDisposedSupplier;

    ObservationDeactivated(Disposable owner, Observer<T> observer, CircuitBreaker circuitBreaker) {
        this(owner, observer, circuitBreaker, disposable -> new ObservationActivated((Disposable)disposable, observer, circuitBreaker), ObservationDisposed::new);
    }

    ObservationDeactivated(Disposable owner, Observer<T> observer, CircuitBreaker circuitBreaker, Function<Disposable, ObservationActivated<T>> observationActivatedSupplier, Supplier<ObservationDisposed<T>> observationDisposedSupplier) {
        this.owner = owner;
        this.observer = observer;
        this.circuitBreaker = circuitBreaker;
        this.observationActivatedSupplier = observationActivatedSupplier;
        this.observationDisposedSupplier = observationDisposedSupplier;
    }

    @Override
    public ObservationState<T> activate(Disposable disposable) {
        if (this.circuitBreaker.allowsExecution()) {
            this.observer.onSubscribe(this.owner);
            return this.observationActivatedSupplier.apply(disposable);
        }
        disposable.dispose();
        this.observer.onSubscribe(this.owner);
        this.observer.onError((Throwable)new CircuitBreakerOpenException());
        return this.observationDisposedSupplier.get();
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
    }

    @Override
    public void onComplete() {
        this.observer.onComplete();
    }

    @Override
    public ObservationState<T> dispose() {
        return this;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }
}

