/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network;

import com.snail.java.network.TaskInfo;
import com.snail.java.network.callback.MultiTaskListener;
import com.snail.java.network.callback.TaskListener;
import com.snail.java.network.callback.TaskObserver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u0001\u001fB\u001f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB%\b\u0010\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0013\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u000eR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/snail/java/network/TaskWorker;", "R", "T", "Lcom/snail/java/network/TaskInfo;", "", "info", "listener", "Lcom/snail/java/network/callback/TaskListener;", "(Lcom/snail/java/network/TaskInfo;Lcom/snail/java/network/callback/TaskListener;)V", "infos", "", "Lcom/snail/java/network/callback/MultiTaskListener;", "(Ljava/util/List;Lcom/snail/java/network/callback/MultiTaskListener;)V", "failedCount", "", "getListener", "()Lcom/snail/java/network/callback/TaskListener;", "successCount", "taskMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/snail/java/network/callback/TaskObserver;", "getTaskMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "totalTasks", "cancel", "", "(Lcom/snail/java/network/TaskInfo;)V", "execute", "isOngoing", "", "remaining", "LocalTaskListener", "java"})
public abstract class TaskWorker<R, T extends TaskInfo> {
    @NotNull
    private final ConcurrentHashMap<T, TaskObserver<R, T>> taskMap;
    @Nullable
    private final TaskListener<T> listener;
    private final int totalTasks;
    private int successCount;
    private int failedCount;

    @NotNull
    protected final ConcurrentHashMap<T, TaskObserver<R, T>> getTaskMap() {
        return this.taskMap;
    }

    @Nullable
    protected final TaskListener<T> getListener() {
        return this.listener;
    }

    protected abstract void execute(@NotNull T var1);

    public final boolean isOngoing() {
        return this.remaining() > 0;
    }

    public final int remaining() {
        return this.taskMap.size();
    }

    public final void cancel() {
        Collection<TaskObserver<R, T>> collection = this.taskMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"taskMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskObserver it = (TaskObserver)element$iv;
            boolean bl = false;
            it.dispose(true);
        }
        this.taskMap.clear();
    }

    public final void cancel(@NotNull T info) {
        block0: {
            Intrinsics.checkParameterIsNotNull(info, (String)"info");
            TaskObserver<R, T> taskObserver = this.taskMap.remove(info);
            if (taskObserver == null) break block0;
            taskObserver.dispose(true);
        }
    }

    public TaskWorker(@NotNull T info, @Nullable TaskListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        this.taskMap = new ConcurrentHashMap();
        this.listener = listener;
        this.totalTasks = 1;
        ((TaskInfo)info).reset$java();
        this.execute(info);
    }

    public TaskWorker(@NotNull List<? extends T> infos, @Nullable MultiTaskListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(infos, (String)"infos");
        this.taskMap = new ConcurrentHashMap();
        this.listener = listener;
        this.totalTasks = infos.size();
        Iterable $this$forEach$iv = infos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskInfo it = (TaskInfo)element$iv;
            boolean bl = false;
            it.reset$java();
            this.execute(it);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/snail/java/network/TaskWorker$LocalTaskListener;", "Lcom/snail/java/network/callback/TaskListener;", "(Lcom/snail/java/network/TaskWorker;)V", "onProgress", "", "info", "(Lcom/snail/java/network/TaskInfo;)V", "onStateChange", "t", "", "(Lcom/snail/java/network/TaskInfo;Ljava/lang/Throwable;)V", "java"})
    protected final class LocalTaskListener
    implements TaskListener<T> {
        @Override
        public void onStateChange(@NotNull T info, @Nullable Throwable t) {
            block5: {
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull(info, (String)"info");
                        TaskListener taskListener = TaskWorker.this.getListener();
                        if (taskListener != null) {
                            taskListener.onStateChange(info, t);
                        }
                        if (TaskWorker.this.totalTasks <= 1) break block5;
                        if (((TaskInfo)info).getState() != TaskInfo.State.COMPLETED) break block6;
                        TaskWorker.this.getTaskMap().remove(info);
                        TaskWorker taskWorker = TaskWorker.this;
                        int n = taskWorker.successCount;
                        taskWorker.successCount = n + 1;
                        TaskListener taskListener2 = TaskWorker.this.getListener();
                        if (!(taskListener2 instanceof MultiTaskListener)) {
                            taskListener2 = null;
                        }
                        MultiTaskListener multiTaskListener = (MultiTaskListener)taskListener2;
                        if (multiTaskListener == null) break block5;
                        multiTaskListener.onTotalProgress(TaskWorker.this.successCount, TaskWorker.this.failedCount, TaskWorker.this.totalTasks);
                        break block5;
                    }
                    if (((TaskInfo)info).getState() != TaskInfo.State.CANCEL && ((TaskInfo)info).getState() != TaskInfo.State.ERROR) break block7;
                    TaskWorker.this.getTaskMap().remove(info);
                    TaskWorker taskWorker = TaskWorker.this;
                    int n = taskWorker.failedCount;
                    taskWorker.failedCount = n + 1;
                    TaskListener taskListener = TaskWorker.this.getListener();
                    if (!(taskListener instanceof MultiTaskListener)) {
                        taskListener = null;
                    }
                    MultiTaskListener multiTaskListener = (MultiTaskListener)taskListener;
                    if (multiTaskListener == null) break block5;
                    multiTaskListener.onTotalProgress(TaskWorker.this.successCount, TaskWorker.this.failedCount, TaskWorker.this.totalTasks);
                    break block5;
                }
                if (((TaskInfo)info).getState() != TaskInfo.State.START) break block5;
                TaskListener taskListener = TaskWorker.this.getListener();
                if (!(taskListener instanceof MultiTaskListener)) {
                    taskListener = null;
                }
                MultiTaskListener multiTaskListener = (MultiTaskListener)taskListener;
                if (multiTaskListener != null) {
                    multiTaskListener.onTotalProgress(TaskWorker.this.successCount, TaskWorker.this.failedCount, TaskWorker.this.totalTasks);
                }
            }
        }

        @Override
        public void onProgress(@NotNull T info) {
            block0: {
                Intrinsics.checkParameterIsNotNull(info, (String)"info");
                TaskListener taskListener = TaskWorker.this.getListener();
                if (taskListener == null) break block0;
                taskListener.onProgress(info);
            }
        }
    }
}

