/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J \u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/snail/java/utils/EncryptUtils;", "", "()V", "MD5", "", "SHA1", "addSeparator", "code", "separator", "decrypt", "", "raw", "encrypted", "seed", "encrypt", "plain", "encryptByMessageDigest", "inputStream", "Ljava/io/InputStream;", "algorithm", "md", "Ljava/security/MessageDigest;", "bytes", "getFileMD5Code", "file", "Ljava/io/File;", "path", "getFileSHA1Code", "getMD5Code", "plainText", "iterations", "", "getRawKey", "getSHA1Code", "replaceMessageDigestCharacter", "offset", "len", "java"})
public final class EncryptUtils {
    @NotNull
    public static final String MD5 = "MD5";
    @NotNull
    public static final String SHA1 = "SHA1";
    public static final EncryptUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final String addSeparator(@NotNull String code, @Nullable String separator) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        try {
            StringBuilder sb = new StringBuilder();
            int loopTimes = code.length();
            for (int i = 0; i < loopTimes; i += 2) {
                String string;
                boolean bl;
                StringBuilder stringBuilder;
                int n;
                String string2;
                if (i != loopTimes - 2) {
                    string2 = code;
                    n = i + 2;
                    stringBuilder = sb;
                    bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(i, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    StringBuilder stringBuilder2 = stringBuilder.append(string);
                    String string3 = separator;
                    if (string3 == null) {
                        string3 = "";
                    }
                    stringBuilder2.append(string3);
                    continue;
                }
                string2 = code;
                n = i + 2;
                stringBuilder = sb;
                bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(i, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                stringBuilder.append(string);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getMD5Code(@NotNull String plainText, int iterations) {
        Intrinsics.checkParameterIsNotNull((Object)plainText, (String)"plainText");
        int iters = iterations;
        if (iters > 0) {
            String result = EncryptUtils.getMD5Code(plainText);
            if (--iters > 0 && result != null) {
                result = EncryptUtils.getMD5Code(result, iters);
            }
            return result;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final String getSHA1Code(@NotNull String plainText, int iterations) {
        Intrinsics.checkParameterIsNotNull((Object)plainText, (String)"plainText");
        int iters = iterations;
        if (iters > 0) {
            String result = EncryptUtils.getSHA1Code(plainText);
            if (--iters > 0 && result != null) {
                result = EncryptUtils.getSHA1Code(result, iters);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String replaceMessageDigestCharacter(@NotNull String code, int offset, int len) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        String string = "1234567890abcdef";
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] charArr = cArray;
        String string2 = code;
        boolean bl2 = false;
        char[] cArray2 = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
        char[] md5Arr = cArray2;
        int n = charArr.length;
        Random random = new Random();
        int n2 = offset;
        int n3 = offset + len;
        while (n2 < n3) {
            void i;
            char randomChar;
            md5Arr[i] = randomChar = charArr[random.nextInt(n)];
            ++i;
        }
        n2 = 0;
        n3 = md5Arr.length;
        boolean bl3 = false;
        return new String(md5Arr, n2, n3);
    }

    @JvmStatic
    @Nullable
    public static final String getMD5Code(@NotNull String plainText) {
        Intrinsics.checkParameterIsNotNull((Object)plainText, (String)"plainText");
        String string = plainText;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtils.encryptByMessageDigest(byArray, MD5);
    }

    @JvmStatic
    @Nullable
    public static final String getSHA1Code(@NotNull String plainText) {
        Intrinsics.checkParameterIsNotNull((Object)plainText, (String)"plainText");
        String string = plainText;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtils.encryptByMessageDigest(byArray, SHA1);
    }

    @JvmStatic
    @Nullable
    public static final String getFileMD5Code(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            FileInputStream fis = new FileInputStream(path);
            return EncryptUtils.getMD5Code(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getFileSHA1Code(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            FileInputStream fis = new FileInputStream(path);
            return EncryptUtils.getSHA1Code(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getFileMD5Code(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            FileInputStream fis = new FileInputStream(file);
            return EncryptUtils.getMD5Code(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getFileSHA1Code(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            FileInputStream fis = new FileInputStream(file);
            return EncryptUtils.getSHA1Code(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getMD5Code(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        return EncryptUtils.encryptByMessageDigest(inputStream, MD5);
    }

    @JvmStatic
    @Nullable
    public static final String getSHA1Code(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        return EncryptUtils.encryptByMessageDigest(inputStream, SHA1);
    }

    @JvmStatic
    @Nullable
    public static final String encryptByMessageDigest(@NotNull InputStream inputStream, @NotNull String algorithm) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] buf = new byte[1024];
            int len = inputStream.read(buf);
            while (len != -1) {
                messageDigest.update(buf, 0, len);
                len = inputStream.read(buf);
            }
            inputStream.close();
            MessageDigest messageDigest2 = messageDigest;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest2, (String)"messageDigest");
            return INSTANCE.encryptByMessageDigest(messageDigest2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String encryptByMessageDigest(@NotNull byte[] bytes, @NotNull String algorithm) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(bytes);
            MessageDigest messageDigest = md;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"md");
            return INSTANCE.encryptByMessageDigest(messageDigest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final String encryptByMessageDigest(MessageDigest md) {
        byte[] digest = md.digest();
        StringBuilder toRet = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                toRet.append("0");
            }
            toRet.append(hex);
        }
        String string = toRet.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toRet.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String seed, @NotNull String plain) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        Intrinsics.checkParameterIsNotNull((Object)plain, (String)"plain");
        String string = seed;
        EncryptUtils encryptUtils = INSTANCE;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] rawKey = encryptUtils.getRawKey(byArray2);
        object = plain;
        byArray2 = rawKey;
        encryptUtils = INSTANCE;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        byte[] byArray3 = ((String)object).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        byte[] encrypted = encryptUtils.encrypt(byArray2, byArray4);
        String string2 = Base64.getEncoder().encodeToString(encrypted);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.getEncoder().encodeToString(encrypted)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String seed, @NotNull String encrypted) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        Intrinsics.checkParameterIsNotNull((Object)encrypted, (String)"encrypted");
        String string = seed;
        Object object = INSTANCE;
        Object object2 = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes((Charset)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] rawKey = ((EncryptUtils)object).getRawKey(byArray2);
        object2 = encrypted;
        object = Base64.getDecoder();
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        byte[] byArray3 = ((String)object2).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray3;
        byte[] enc = ((Base64.Decoder)object).decode(byArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)enc, (String)"enc");
        byte[] result = INSTANCE.decrypt(rawKey, enc);
        boolean bl3 = false;
        return new String(result, Charsets.UTF_8);
    }

    private final byte[] getRawKey(byte[] seed) throws Exception {
        SecretKey key;
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(seed);
        keygen.init(128, random);
        SecretKey secretKey = key = keygen.generateKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"key");
        byte[] byArray = secretKey.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"key.encoded");
        return byArray;
    }

    private final byte[] encrypt(byte[] raw, byte[] plain) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, keySpec);
        byte[] byArray = cipher.doFinal(plain);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(plain)");
        return byArray;
    }

    private final byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, keySpec);
        byte[] byArray = cipher.doFinal(encrypted);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(encrypted)");
        return byArray;
    }

    private EncryptUtils() {
    }

    static {
        EncryptUtils encryptUtils;
        INSTANCE = encryptUtils = new EncryptUtils();
    }
}

