/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network.callback;

import com.snail.java.network.TaskInfo;
import com.snail.java.network.callback.ProgressListener;
import com.snail.java.network.callback.TaskListener;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\b\b&\u0018\u0000 \"*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u0001\"B!\b\u0007\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0004J\b\u0010\u0018\u001a\u00020\u0014H&J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\u0014H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/snail/java/network/callback/TaskObserver;", "R", "T", "Lcom/snail/java/network/TaskInfo;", "Lio/reactivex/Observer;", "Lcom/snail/java/network/callback/ProgressListener;", "info", "listener", "Lcom/snail/java/network/callback/TaskListener;", "(Lcom/snail/java/network/TaskInfo;Lcom/snail/java/network/callback/TaskListener;)V", "disposable", "Lio/reactivex/disposables/Disposable;", "getInfo", "()Lcom/snail/java/network/TaskInfo;", "Lcom/snail/java/network/TaskInfo;", "lastUpdateTime", "", "getListener", "()Lcom/snail/java/network/callback/TaskListener;", "dispose", "", "cancel", "", "handleSuccess", "onCancel", "onError", "e", "", "onProgress", "progress", "max", "onSubscribe", "d", "updateProgress", "Companion", "java"})
public abstract class TaskObserver<R, T extends TaskInfo>
implements Observer<R>,
ProgressListener {
    private Disposable disposable;
    private long lastUpdateTime;
    @NotNull
    private final T info;
    @Nullable
    private final TaskListener<T> listener;
    private static final int UPDATE_LIMIT_DURATION = 500;
    public static final Companion Companion = new Companion(null);

    public void onSubscribe(@NotNull Disposable d) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
            this.disposable = d;
            ((TaskInfo)this.info).setState$java(TaskInfo.State.START);
            TaskListener<T> taskListener = this.listener;
            if (taskListener == null) break block0;
            taskListener.onStateChange(this.info, null);
        }
    }

    public void onError(@NotNull Throwable e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            ((TaskInfo)this.info).setState$java(TaskInfo.State.ERROR);
            TaskListener<T> taskListener = this.listener;
            if (taskListener == null) break block0;
            taskListener.onStateChange(this.info, e);
        }
    }

    @Override
    public void onProgress(long progress, long max) {
        long completionLength = progress;
        if (((TaskInfo)this.info).getContentLength() > max) {
            completionLength += ((TaskInfo)this.info).getContentLength() - max;
        } else {
            ((TaskInfo)this.info).setContentLength$java(max);
        }
        ((TaskInfo)this.info).setCompletionLength$java(completionLength);
        if (System.currentTimeMillis() - this.lastUpdateTime >= (long)500 && (((TaskInfo)this.info).getState() == TaskInfo.State.IDLE || ((TaskInfo)this.info).getState() == TaskInfo.State.START || ((TaskInfo)this.info).getState() == TaskInfo.State.ONGOING)) {
            if (((TaskInfo)this.info).getState() != TaskInfo.State.ONGOING) {
                ((TaskInfo)this.info).setState$java(TaskInfo.State.ONGOING);
                TaskListener<T> taskListener = this.listener;
                if (taskListener != null) {
                    taskListener.onStateChange(this.info, null);
                }
            }
            this.updateProgress();
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    private final void updateProgress() {
        block1: {
            if (((TaskInfo)this.info).getCompletionLength() <= 0L || ((TaskInfo)this.info).getContentLength() <= 0L) break block1;
            TaskListener<T> taskListener = this.listener;
            if (taskListener != null) {
                taskListener.onProgress(this.info);
            }
        }
    }

    protected final void handleSuccess() {
        block0: {
            ((TaskInfo)this.info).setCompletionLength$java(((TaskInfo)this.info).getContentLength());
            this.updateProgress();
            ((TaskInfo)this.info).setState$java(TaskInfo.State.COMPLETED);
            TaskListener<T> taskListener = this.listener;
            if (taskListener == null) break block0;
            taskListener.onStateChange(this.info, null);
        }
    }

    public final void dispose(boolean cancel) {
        block4: {
            Disposable disposable = this.disposable;
            if (disposable != null) {
                disposable.dispose();
            }
            if (((TaskInfo)this.info).getState() != TaskInfo.State.ONGOING && ((TaskInfo)this.info).getState() != TaskInfo.State.START) break block4;
            if (cancel) {
                ((TaskInfo)this.info).setState$java(TaskInfo.State.CANCEL);
                this.onCancel();
            } else {
                ((TaskInfo)this.info).setState$java(TaskInfo.State.PAUSE);
            }
            TaskListener<T> taskListener = this.listener;
            if (taskListener != null) {
                taskListener.onStateChange(this.info, null);
            }
        }
    }

    public abstract void onCancel();

    @NotNull
    protected final T getInfo() {
        return this.info;
    }

    @Nullable
    protected final TaskListener<T> getListener() {
        return this.listener;
    }

    @JvmOverloads
    public TaskObserver(@NotNull T info, @Nullable TaskListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        this.info = info;
        this.listener = listener;
    }

    @JvmOverloads
    public /* synthetic */ TaskObserver(TaskInfo taskInfo, TaskListener taskListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            taskListener = null;
        }
        this(taskInfo, taskListener);
    }

    @JvmOverloads
    public TaskObserver(@NotNull T info) {
        this((TaskInfo)info, null, 2, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/snail/java/network/callback/TaskObserver$Companion;", "", "()V", "UPDATE_LIMIT_DURATION", "", "java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

