/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.utils;

import com.snail.java.utils.FileUtilsKt;
import java.io.File;
import java.text.DecimalFormat;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u001c\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0007J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0007J/\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0018\"\u00020\tH\u0007\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/snail/java/utils/FileUtils;", "", "()V", "checkAndRename", "Ljava/io/File;", "target", "copy", "", "src", "", "deleteSuffix", "fileName", "formatFileSize", "size", "", "format", "Ljava/text/DecimalFormat;", "generateRandonFileName", "getFileName", "path", "getFileNameWithoutSuffix", "getSuffix", "s", "removeDuplicate", "", "dup", "strs", "(Ljava/lang/String;[Ljava/lang/String;)[Ljava/lang/String;", "java"})
public final class FileUtils {
    public static final FileUtils INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String formatFileSize(long size, @Nullable DecimalFormat format) {
        DecimalFormat decimalFormat = format;
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat("#.00");
        }
        return size < 1024L ? String.valueOf(size) + "B" : (size < 0x100000L ? decimalFormat.format((float)size / 1024.0f) + "KB" : (size < 0x40000000L ? decimalFormat.format((float)size / 1048576.0f) + "MB" : (size < 0x10000000000L ? decimalFormat.format((float)size / 1.0737418E9f) + "GB" : (size < 0x4000000000000L ? decimalFormat.format((float)size / 1.0995116E12f) + "TB" : (size < 0x1000000000000000L ? decimalFormat.format((float)size / 1.1258999E15f) + "PB" : "size: out of range")))));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ String formatFileSize$default(long l, DecimalFormat decimalFormat, int n, Object object) {
        if ((n & 2) != 0) {
            decimalFormat = null;
        }
        return FileUtils.formatFileSize(l, decimalFormat);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String formatFileSize(long size) {
        return FileUtils.formatFileSize$default(size, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String getFileName(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            boolean bl;
            String fileName;
            int beginIndex;
            String $this$trim$iv = path;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if ((beginIndex = StringsKt.lastIndexOf$default((CharSequence)(fileName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"\\", (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = fileName;
                int n = beginIndex + 1;
                bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                fileName = string3;
            }
            if ((beginIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)"/", (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = fileName;
                int n = beginIndex + 1;
                bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                fileName = string5;
            }
            return fileName;
        }
        return path;
    }

    @JvmStatic
    @NotNull
    public static final String getFileNameWithoutSuffix(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            boolean bl;
            String fileName;
            int beginIndex;
            String $this$trim$iv = path;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if ((beginIndex = StringsKt.lastIndexOf$default((CharSequence)(fileName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"\\", (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = fileName;
                int n = beginIndex + 1;
                bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                fileName = string3;
            }
            if ((beginIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)"/", (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = fileName;
                int n = beginIndex + 1;
                bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                fileName = string5;
            }
            return FileUtils.deleteSuffix(fileName);
        }
        return FileUtils.deleteSuffix(path);
    }

    @JvmStatic
    @NotNull
    public static final String getSuffix(@NotNull String s) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (StringsKt.contains$default((CharSequence)s, (CharSequence)".", (boolean)false, (int)2, null)) {
            String string2 = s;
            int n = StringsKt.lastIndexOf$default((CharSequence)s, (String)".", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String deleteSuffix(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String filename = fileName;
        if (StringsKt.contains$default((CharSequence)filename, (CharSequence)".", (boolean)false, (int)2, null)) {
            String string = filename;
            int n = 0;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)filename, (String)".", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            filename = string2;
        }
        return filename;
    }

    @JvmStatic
    @NotNull
    public static final File checkAndRename(@NotNull File target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (target.exists()) {
            String string;
            String fileName;
            String string2 = fileName = target.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileName");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)".", (boolean)false, (int)2, null)) {
                String string3 = fileName;
                int n = 0;
                int n2 = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String sub = string4;
                string = StringsKt.replace$default((String)fileName, (String)sub, (String)(sub + "_" + System.currentTimeMillis()), (boolean)false, (int)4, null);
            } else {
                string = fileName + "_" + System.currentTimeMillis();
            }
            fileName = string;
            return new File(target.getParent(), fileName);
        }
        return target;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String[] removeDuplicate(@NotNull String dup, String ... strs) {
        String string;
        String[] stringArray;
        void var11_12;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)dup, (String)"dup");
        Intrinsics.checkParameterIsNotNull((Object)strs, (String)"strs");
        int size$iv = strs.length;
        boolean $i$f$Array = false;
        String[] result$iv = new String[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void i$iv;
            bl = i$iv;
            var11_12 = i$iv++;
            stringArray = result$iv;
            boolean bl2 = false;
            stringArray[var11_12] = string = "";
        }
        String[] out = result$iv;
        size$iv = 0;
        int n3 = strs.length;
        while (size$iv < n3) {
            void i;
            CharSequence charSequence = strs[i];
            String string2 = dup + '+';
            var11_12 = i;
            stringArray = out;
            n2 = 0;
            string2 = string = new Regex(string2);
            String string3 = "";
            bl = false;
            stringArray[var11_12] = string = string2.replace(charSequence, string3);
            ++i;
        }
        return out;
    }

    @JvmStatic
    @NotNull
    public static final String generateRandonFileName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        int beginIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null);
        String ext = "";
        if (beginIndex != -1) {
            String string = fileName;
            boolean bl = false;
            String string2 = string.substring(beginIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            ext = string2;
        }
        return UUID.randomUUID().toString() + ext;
    }

    @JvmStatic
    public static final void copy(@NotNull String src, @NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        FileUtilsKt.copyTo(new File(src), new File(target));
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

