/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network.download;

import com.snail.java.network.TaskInfo;
import com.snail.java.network.callback.ProgressListener;
import com.snail.java.network.download.DownloadInfo;
import com.snail.java.network.download.DownloadListener;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\n\b\u0000\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u00020\u0006:\u0001 B!\b\u0007\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/snail/java/network/download/DownloadObserver;", "T", "Lcom/snail/java/network/download/DownloadInfo;", "Lio/reactivex/Observer;", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "Lcom/snail/java/network/callback/ProgressListener;", "info", "listener", "Lcom/snail/java/network/download/DownloadListener;", "(Lcom/snail/java/network/download/DownloadInfo;Lcom/snail/java/network/download/DownloadListener;)V", "disposable", "Lio/reactivex/disposables/Disposable;", "Lcom/snail/java/network/download/DownloadInfo;", "lastUpdateTime", "", "dispose", "", "cancel", "", "onComplete", "onError", "e", "", "onNext", "t", "onProgress", "progress", "max", "onSubscribe", "d", "updateProgress", "Companion", "library"})
public final class DownloadObserver<T extends DownloadInfo>
implements Observer<Response<ResponseBody>>,
ProgressListener {
    private Disposable disposable;
    private long lastUpdateTime;
    private final T info;
    private final DownloadListener<T> listener;
    private static final int UPDATE_LIMIT_DURATION = 500;
    public static final Companion Companion = new Companion(null);

    public void onSubscribe(@NotNull Disposable d) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
            this.disposable = d;
            ((TaskInfo)this.info).setState$library(TaskInfo.State.START);
            DownloadListener<T> downloadListener = this.listener;
            if (downloadListener == null) break block0;
            downloadListener.onStateChange(this.info, null);
        }
    }

    public void onError(@NotNull Throwable e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            ((TaskInfo)this.info).setState$library(TaskInfo.State.ERROR);
            DownloadListener<T> downloadListener = this.listener;
            if (downloadListener == null) break block0;
            downloadListener.onStateChange(this.info, e);
        }
    }

    @Override
    public void onProgress(long progress, long max) {
        long completionLength = progress;
        if (((DownloadInfo)this.info).getContentLength() > max) {
            completionLength += ((DownloadInfo)this.info).getContentLength() - max;
        } else {
            ((DownloadInfo)this.info).setContentLength$library(max);
        }
        ((DownloadInfo)this.info).setCompletionLength$library(completionLength);
        if (System.currentTimeMillis() - this.lastUpdateTime >= (long)500 && (((TaskInfo)this.info).getState() == TaskInfo.State.IDLE || ((TaskInfo)this.info).getState() == TaskInfo.State.START || ((TaskInfo)this.info).getState() == TaskInfo.State.ONGOING)) {
            if (((TaskInfo)this.info).getState() != TaskInfo.State.ONGOING) {
                ((TaskInfo)this.info).setState$library(TaskInfo.State.ONGOING);
                DownloadListener<T> downloadListener = this.listener;
                if (downloadListener != null) {
                    downloadListener.onStateChange(this.info, null);
                }
            }
            this.updateProgress();
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public final void dispose(boolean cancel) {
        block4: {
            Disposable disposable = this.disposable;
            if (disposable != null) {
                disposable.dispose();
            }
            if (((TaskInfo)this.info).getState() != TaskInfo.State.ONGOING && ((TaskInfo)this.info).getState() != TaskInfo.State.START) break block4;
            if (cancel) {
                ((TaskInfo)this.info).setState$library(TaskInfo.State.CANCEL);
                new File(((DownloadInfo)this.info).getTemporaryFilePath$library()).delete();
            } else {
                ((TaskInfo)this.info).setState$library(TaskInfo.State.PAUSE);
            }
            DownloadListener<T> downloadListener = this.listener;
            if (downloadListener != null) {
                downloadListener.onStateChange(this.info, null);
            }
        }
    }

    public void onNext(@NotNull Response<ResponseBody> t) {
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
    }

    private final void updateProgress() {
        block1: {
            if (((DownloadInfo)this.info).getCompletionLength() <= 0L || ((DownloadInfo)this.info).getContentLength() <= 0L) break block1;
            DownloadListener<T> downloadListener = this.listener;
            if (downloadListener != null) {
                downloadListener.onProgress(this.info);
            }
        }
    }

    public void onComplete() {
        Schedulers.io().scheduleDirect(new Runnable(this){
            final /* synthetic */ DownloadObserver this$0;

            public final void run() {
                block2: {
                    block1: {
                        File destFile = new File(DownloadObserver.access$getInfo$p(this.this$0).getSavePath());
                        destFile.delete();
                        File tempFile = new File(DownloadObserver.access$getInfo$p(this.this$0).getTemporaryFilePath$library());
                        boolean success = tempFile.renameTo(destFile);
                        if (!success) {
                            tempFile.delete();
                        }
                        if (!success) break block1;
                        DownloadObserver.access$getInfo$p(this.this$0).setCompletionLength$library(DownloadObserver.access$getInfo$p(this.this$0).getContentLength());
                        DownloadObserver.access$updateProgress(this.this$0);
                        DownloadObserver.access$getInfo$p(this.this$0).setState$library(TaskInfo.State.COMPLETED);
                        DownloadListener downloadListener = DownloadObserver.access$getListener$p(this.this$0);
                        if (downloadListener == null) break block2;
                        downloadListener.onStateChange(DownloadObserver.access$getInfo$p(this.this$0), null);
                        break block2;
                    }
                    DownloadObserver.access$getInfo$p(this.this$0).setState$library(TaskInfo.State.ERROR);
                    DownloadListener downloadListener = DownloadObserver.access$getListener$p(this.this$0);
                    if (downloadListener == null) break block2;
                    downloadListener.onStateChange(DownloadObserver.access$getInfo$p(this.this$0), new Throwable("Renaming to target file failed"));
                }
            }
            {
                this.this$0 = downloadObserver;
            }
        });
    }

    @JvmOverloads
    public DownloadObserver(@NotNull T info, @Nullable DownloadListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        this.info = info;
        this.listener = listener;
    }

    @JvmOverloads
    public /* synthetic */ DownloadObserver(DownloadInfo downloadInfo, DownloadListener downloadListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            downloadListener = null;
        }
        this(downloadInfo, downloadListener);
    }

    @JvmOverloads
    public DownloadObserver(@NotNull T info) {
        this((DownloadInfo)info, null, 2, null);
    }

    public static final /* synthetic */ DownloadInfo access$getInfo$p(DownloadObserver $this) {
        return $this.info;
    }

    public static final /* synthetic */ void access$updateProgress(DownloadObserver $this) {
        $this.updateProgress();
    }

    public static final /* synthetic */ DownloadListener access$getListener$p(DownloadObserver $this) {
        return $this.listener;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/snail/java/network/download/DownloadObserver$Companion;", "", "()V", "UPDATE_LIMIT_DURATION", "", "library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

