/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network.download;

import com.snail.java.network.TaskInfo;
import com.snail.java.network.download.DownloadInfo;
import com.snail.java.network.download.DownloadListener;
import com.snail.java.network.download.DownloadObserver;
import com.snail.java.network.download.DownloadService;
import com.snail.java.network.download.MultiDownloadListener;
import com.snail.java.network.exception.RetryWhenException;
import com.snail.java.network.interceptor.ProgressInterceptor;
import com.snail.java.utils.IOUtils;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.internal.schedulers.IoScheduler;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001%B\u001f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B%\b\u0010\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u0006\u0010\u001b\u001a\u00020\u000fJ\u0006\u0010\u001c\u001a\u00020\u0016J\u0013\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u001d\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\u0016J\u0013\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J'\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/snail/java/network/download/DownloadWorker;", "T", "Lcom/snail/java/network/download/DownloadInfo;", "Lio/reactivex/disposables/Disposable;", "info", "listener", "Lcom/snail/java/network/download/DownloadListener;", "(Lcom/snail/java/network/download/DownloadInfo;Lcom/snail/java/network/download/DownloadListener;)V", "infos", "", "Lcom/snail/java/network/download/MultiDownloadListener;", "(Ljava/util/List;Lcom/snail/java/network/download/MultiDownloadListener;)V", "failedCount", "", "isCanceled", "", "successCount", "taskMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/snail/java/network/download/DownloadObserver;", "totalTasks", "cancel", "", "(Lcom/snail/java/network/download/DownloadInfo;)V", "dispose", "execute", "isDisposed", "isOngoing", "pause", "remaining", "resume", "writeToDisk", "responseBody", "Lokhttp3/ResponseBody;", "file", "Ljava/io/File;", "(Lokhttp3/ResponseBody;Ljava/io/File;Lcom/snail/java/network/download/DownloadInfo;)V", "LocalTaskListener", "library"})
public final class DownloadWorker<T extends DownloadInfo>
implements Disposable {
    private final ConcurrentHashMap<T, DownloadObserver<T>> taskMap;
    private final DownloadListener<T> listener;
    private final int totalTasks;
    private int successCount;
    private int failedCount;
    private boolean isCanceled;

    private final void execute(T info) {
        DownloadObserver<T> observer = new DownloadObserver<T>(info, this.listener == null ? null : new LocalTaskListener());
        ((Map)this.taskMap).put(info, observer);
        ProgressInterceptor interceptor = new ProgressInterceptor(observer);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)interceptor).build();
        ((DownloadService)new Retrofit.Builder().client(client).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(((TaskInfo)info).getBaseUrl()).build().create(DownloadService.class)).download("bytes=" + ((DownloadInfo)info).getCompletionLength() + "-", ((TaskInfo)info).getUrl()).retryWhen((Function)new RetryWhenException(0, 0L, 0L, 7, null)).map(new Function<T, R>(this, (DownloadInfo)info){
            final /* synthetic */ DownloadWorker this$0;
            final /* synthetic */ DownloadInfo $info;

            @NotNull
            public final Response<ResponseBody> apply(@NotNull Response<ResponseBody> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                DownloadWorker.access$writeToDisk(this.this$0, (ResponseBody)it.body(), new File(this.$info.getTemporaryFilePath$library()), this.$info);
                return it;
            }
            {
                this.this$0 = downloadWorker;
                this.$info = downloadInfo;
            }
        }).subscribeOn((Scheduler)new IoScheduler()).subscribe((Observer)observer);
    }

    public final void pause() {
        Collection<DownloadObserver<T>> collection = this.taskMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"taskMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadObserver it = (DownloadObserver)element$iv;
            boolean bl = false;
            it.dispose(false);
        }
    }

    public final void pause(@NotNull T info) {
        block0: {
            Intrinsics.checkParameterIsNotNull(info, (String)"info");
            DownloadObserver<T> downloadObserver = this.taskMap.get(info);
            if (downloadObserver == null) break block0;
            downloadObserver.dispose(false);
        }
    }

    public final void resume() {
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.taskMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"taskMap.keys");
        Iterable $this$forEach$iv = keySetView;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            if (it.getState() != TaskInfo.State.PAUSE) continue;
            DownloadInfo downloadInfo = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)downloadInfo, (String)"it");
            this.execute(downloadInfo);
        }
    }

    public final void resume(@NotNull T info) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        if (((TaskInfo)info).getState() == TaskInfo.State.PAUSE) {
            this.execute(info);
        }
    }

    public final boolean isOngoing() {
        return this.remaining() > 0;
    }

    public final int remaining() {
        return this.taskMap.size();
    }

    public final synchronized void cancel() {
        Collection<DownloadObserver<T>> collection = this.taskMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"taskMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadObserver it = (DownloadObserver)element$iv;
            boolean bl = false;
            it.dispose(true);
        }
        this.taskMap.clear();
        this.isCanceled = true;
    }

    public final synchronized void cancel(@NotNull T info) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        DownloadObserver<T> downloadObserver = this.taskMap.remove(info);
        if (downloadObserver != null) {
            downloadObserver.dispose(true);
        }
        if (this.taskMap.isEmpty()) {
            this.isCanceled = true;
        }
    }

    public boolean isDisposed() {
        return this.isCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeToDisk(ResponseBody responseBody, File file, T info) {
        if (responseBody == null) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream inputStream = responseBody.byteStream();
        long allLength = ((DownloadInfo)info).getContentLength() == 0L ? responseBody.contentLength() : ((DownloadInfo)info).getContentLength();
        try {
            Closeable closeable = new RandomAccessFile(file, "rwd").getChannel();
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileChannel it = (FileChannel)closeable;
                boolean bl2 = false;
                MappedByteBuffer mappedBuffer = it.map(FileChannel.MapMode.READ_WRITE, ((DownloadInfo)info).getCompletionLength(), allLength - ((DownloadInfo)info).getCompletionLength());
                byte[] buffer = new byte[81920];
                int len = inputStream.read(buffer);
                while (len != -1) {
                    mappedBuffer.put(buffer, 0, len);
                    len = inputStream.read(buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public DownloadWorker(@NotNull T info, @Nullable DownloadListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        this.taskMap = new ConcurrentHashMap();
        this.listener = listener;
        this.totalTasks = 1;
        ((DownloadInfo)info).reset$library();
        this.execute(info);
    }

    public DownloadWorker(@NotNull List<? extends T> infos, @Nullable MultiDownloadListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(infos, (String)"infos");
        this.taskMap = new ConcurrentHashMap();
        this.listener = listener;
        this.totalTasks = infos.size();
        Iterable $this$forEach$iv = infos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            it.reset$library();
            this.execute(it);
        }
    }

    public static final /* synthetic */ void access$writeToDisk(DownloadWorker $this, ResponseBody responseBody, File file, DownloadInfo info) {
        $this.writeToDisk(responseBody, file, info);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/snail/java/network/download/DownloadWorker$LocalTaskListener;", "Lcom/snail/java/network/download/DownloadListener;", "(Lcom/snail/java/network/download/DownloadWorker;)V", "onProgress", "", "info", "(Lcom/snail/java/network/download/DownloadInfo;)V", "onStateChange", "t", "", "(Lcom/snail/java/network/download/DownloadInfo;Ljava/lang/Throwable;)V", "library"})
    private final class LocalTaskListener
    implements DownloadListener<T> {
        @Override
        public void onStateChange(@NotNull T info, @Nullable Throwable t) {
            block5: {
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull(info, (String)"info");
                        DownloadListener downloadListener = DownloadWorker.this.listener;
                        if (downloadListener != null) {
                            downloadListener.onStateChange(info, t);
                        }
                        if (DownloadWorker.this.totalTasks <= 1) break block5;
                        if (((TaskInfo)info).getState() != TaskInfo.State.COMPLETED) break block6;
                        DownloadWorker.this.taskMap.remove(info);
                        DownloadWorker downloadWorker = DownloadWorker.this;
                        int n = downloadWorker.successCount;
                        downloadWorker.successCount = n + 1;
                        DownloadListener downloadListener2 = DownloadWorker.this.listener;
                        if (!(downloadListener2 instanceof MultiDownloadListener)) {
                            downloadListener2 = null;
                        }
                        MultiDownloadListener multiDownloadListener = (MultiDownloadListener)downloadListener2;
                        if (multiDownloadListener == null) break block5;
                        multiDownloadListener.onTotalProgress(DownloadWorker.this.successCount, DownloadWorker.this.failedCount, DownloadWorker.this.totalTasks);
                        break block5;
                    }
                    if (((TaskInfo)info).getState() != TaskInfo.State.CANCEL && ((TaskInfo)info).getState() != TaskInfo.State.ERROR) break block7;
                    DownloadWorker.this.taskMap.remove(info);
                    DownloadWorker downloadWorker = DownloadWorker.this;
                    int n = downloadWorker.failedCount;
                    downloadWorker.failedCount = n + 1;
                    DownloadListener downloadListener = DownloadWorker.this.listener;
                    if (!(downloadListener instanceof MultiDownloadListener)) {
                        downloadListener = null;
                    }
                    MultiDownloadListener multiDownloadListener = (MultiDownloadListener)downloadListener;
                    if (multiDownloadListener == null) break block5;
                    multiDownloadListener.onTotalProgress(DownloadWorker.this.successCount, DownloadWorker.this.failedCount, DownloadWorker.this.totalTasks);
                    break block5;
                }
                if (((TaskInfo)info).getState() != TaskInfo.State.START) break block5;
                DownloadListener downloadListener = DownloadWorker.this.listener;
                if (!(downloadListener instanceof MultiDownloadListener)) {
                    downloadListener = null;
                }
                MultiDownloadListener multiDownloadListener = (MultiDownloadListener)downloadListener;
                if (multiDownloadListener != null) {
                    multiDownloadListener.onTotalProgress(DownloadWorker.this.successCount, DownloadWorker.this.failedCount, DownloadWorker.this.totalTasks);
                }
            }
        }

        @Override
        public void onProgress(@NotNull T info) {
            block0: {
                Intrinsics.checkParameterIsNotNull(info, (String)"info");
                DownloadListener downloadListener = DownloadWorker.this.listener;
                if (downloadListener == null) break block0;
                downloadListener.onProgress(info);
            }
        }
    }
}

