/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.network.upload;

import com.snail.java.network.TaskInfo;
import com.snail.java.network.upload.UploadInfo;
import com.snail.java.network.upload.UploadListener;
import com.snail.java.network.upload.UploadProgressListener;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\n\b\u0000\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00022\u00020\u00052\u00020\u0006:\u0001#B'\b\u0007\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0005H\u0016R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/snail/java/network/upload/UploadObserver;", "T", "Lio/reactivex/Observer;", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "Lio/reactivex/disposables/Disposable;", "Lcom/snail/java/network/upload/UploadProgressListener;", "info", "Lcom/snail/java/network/upload/UploadInfo;", "listener", "Lcom/snail/java/network/upload/UploadListener;", "(Lcom/snail/java/network/upload/UploadInfo;Lcom/snail/java/network/upload/UploadListener;)V", "contentLengthMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "disposable", "lastUpdateTime", "dispose", "", "isDisposed", "", "onComplete", "onError", "e", "", "onNext", "t", "onProgress", "name", "progress", "max", "onSubscribe", "d", "Companion", "library"})
public final class UploadObserver<T>
implements Observer<retrofit2.Response<ResponseBody>>,
Disposable,
UploadProgressListener {
    private Disposable disposable;
    private long lastUpdateTime;
    private final HashMap<String, Long> contentLengthMap;
    private final UploadInfo<T> info;
    private final UploadListener<T> listener;
    private static final int UPDATE_LIMIT_DURATION = 500;
    public static final Companion Companion = new Companion(null);

    public void onSubscribe(@NotNull Disposable d) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
            this.disposable = d;
            this.info.setState$library(TaskInfo.State.START);
            UploadListener<T> uploadListener = this.listener;
            if (uploadListener == null) break block0;
            uploadListener.onStateChange(this.info.getState(), null);
        }
    }

    public void onError(@NotNull Throwable e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.info.setState$library(TaskInfo.State.ERROR);
            UploadListener<T> uploadListener = this.listener;
            if (uploadListener == null) break block0;
            uploadListener.onStateChange(this.info.getState(), e);
        }
    }

    public void onNext(@NotNull retrofit2.Response<ResponseBody> t) {
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        try {
            Object convertedBody = this.info.getConverter$library().convert(t.body());
            UploadListener uploadListener = this.listener;
            if (uploadListener != null) {
                Response response = t.raw();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"t.raw()");
                uploadListener.onResponseBodyParse(response, convertedBody);
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    @Override
    public void onProgress(@NotNull String name, long progress, long max) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        long completionLength = progress;
        Long contentLen = this.contentLengthMap.get(name);
        if (contentLen != null && contentLen > max) {
            completionLength += contentLen - max;
        } else {
            ((Map)this.contentLengthMap).put(name, max);
            contentLen = max;
        }
        if (System.currentTimeMillis() - this.lastUpdateTime >= (long)500 && (this.info.getState() == TaskInfo.State.IDLE || this.info.getState() == TaskInfo.State.START || this.info.getState() == TaskInfo.State.ONGOING)) {
            if (this.info.getState() != TaskInfo.State.ONGOING) {
                this.info.setState$library(TaskInfo.State.ONGOING);
                UploadListener<T> uploadListener = this.listener;
                if (uploadListener != null) {
                    uploadListener.onStateChange(this.info.getState(), null);
                }
            }
            UploadListener<T> uploadListener = this.listener;
            if (uploadListener != null) {
                uploadListener.onProgress(name, completionLength, contentLen);
            }
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public void onComplete() {
        block1: {
            Set<Map.Entry<String, Long>> set = this.contentLengthMap.entrySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"contentLengthMap.entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                UploadListener<T> uploadListener = this.listener;
                if (uploadListener == null) continue;
                Object k = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                String string = (String)k;
                Object v = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                long l = ((Number)v).longValue();
                Object v2 = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v2, (String)"it.value");
                uploadListener.onProgress(string, l, ((Number)v2).longValue());
            }
            this.info.setState$library(TaskInfo.State.COMPLETED);
            UploadListener<T> uploadListener = this.listener;
            if (uploadListener == null) break block1;
            uploadListener.onStateChange(this.info.getState(), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDisposed() {
        if (this.disposable == null) return true;
        Disposable disposable = this.disposable;
        if (disposable == null) {
            Intrinsics.throwNpe();
        }
        if (!disposable.isDisposed()) return false;
        return true;
    }

    public void dispose() {
        block2: {
            Disposable disposable = this.disposable;
            if (disposable != null) {
                disposable.dispose();
            }
            if (this.info.getState() != TaskInfo.State.ONGOING && this.info.getState() != TaskInfo.State.START) break block2;
            this.info.setState$library(TaskInfo.State.CANCEL);
            UploadListener<T> uploadListener = this.listener;
            if (uploadListener != null) {
                uploadListener.onStateChange(this.info.getState(), null);
            }
        }
    }

    @JvmOverloads
    public UploadObserver(@NotNull UploadInfo<T> info, @Nullable UploadListener<T> listener) {
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        this.info = info;
        this.listener = listener;
        this.contentLengthMap = new HashMap();
    }

    @JvmOverloads
    public /* synthetic */ UploadObserver(UploadInfo uploadInfo, UploadListener uploadListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uploadListener = null;
        }
        this(uploadInfo, uploadListener);
    }

    @JvmOverloads
    public UploadObserver(@NotNull UploadInfo<T> info) {
        this(info, null, 2, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/snail/java/network/upload/UploadObserver$Companion;", "", "()V", "UPDATE_LIMIT_DURATION", "", "library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

