/*
 * Decompiled with CFR 0.152.
 */
package com.snail.java.utils;

import com.snail.java.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0003\u001a\u001e\u0010\f\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u000f*\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0003\u001a\u001e\u0010\u0015\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0018"}, d2={"compareAndDeleteSrc", "", "src", "Ljava/io/File;", "target", "copyDir", "", "sourceDir", "targetDir", "copyFile", "source", "clear", "compressByGZIP", "bufferSize", "", "", "copyTo", "moveTo", "replace", "size", "", "toFile", "Ljava/io/InputStream;", "targetFile", "library"})
public final class FileUtilsKt {
    public static final void clear(@NotNull File $this$clear) {
        Intrinsics.checkParameterIsNotNull((Object)$this$clear, (String)"$this$clear");
        File[] files = $this$clear.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File f;
                File file = f = fileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"f");
                if (file.isDirectory()) {
                    FilesKt.deleteRecursively((File)$this$clear);
                    continue;
                }
                f.delete();
            }
        }
    }

    public static final long size(@NotNull File $this$size) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"$this$size");
        if (!$this$size.exists()) {
            l = -1L;
        } else if ($this$size.isFile()) {
            l = $this$size.length();
        } else {
            long s = 0L;
            File[] files = $this$size.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file;
                    File file2 = file = fileArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    s += file2.isDirectory() ? FileUtilsKt.size($this$size) : file.length();
                }
                l = s;
            } else {
                l = 0L;
            }
        }
        return l;
    }

    public static final boolean moveTo(@NotNull File $this$moveTo, @NotNull File target, boolean replace) {
        Intrinsics.checkParameterIsNotNull((Object)$this$moveTo, (String)"$this$moveTo");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File targetFile = target;
        if (!$this$moveTo.exists()) {
            return false;
        }
        if (!replace) {
            targetFile = FileUtils.checkAndRename(targetFile);
        }
        FileUtilsKt.copyTo($this$moveTo, targetFile);
        return FileUtilsKt.compareAndDeleteSrc($this$moveTo, targetFile);
    }

    private static final boolean compareAndDeleteSrc(File src, File target) {
        if (src.isFile()) {
            if (target.exists() && target.length() == src.length()) {
                src.delete();
                return true;
            }
        } else if (FileUtilsKt.size(src) == FileUtilsKt.size(target)) {
            FilesKt.deleteRecursively((File)src);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] compressByGZIP(@NotNull byte[] $this$compressByGZIP) {
        Intrinsics.checkParameterIsNotNull((Object)$this$compressByGZIP, (String)"$this$compressByGZIP");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Closeable closeable = new GZIPOutputStream(baos);
        boolean bl = false;
        Throwable throwable = null;
        try {
            GZIPOutputStream it = (GZIPOutputStream)closeable;
            boolean bl2 = false;
            it.write($this$compressByGZIP);
            it.finish();
            it.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public static final void compressByGZIP(@NotNull File $this$compressByGZIP, @NotNull File target, int bufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$compressByGZIP, (String)"$this$compressByGZIP");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Closeable closeable = new FileInputStream($this$compressByGZIP);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new GZIPOutputStream(new FileOutputStream(target));
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                GZIPOutputStream out = (GZIPOutputStream)closeable2;
                boolean bl4 = false;
                byte[] buf = new byte[bufferSize];
                int num = it.read(buf);
                while (num != -1) {
                    out.write(buf, 0, num);
                    num = it.read(buf);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmOverloads
    public static /* synthetic */ void compressByGZIP$default(File file, File file2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10240;
        }
        FileUtilsKt.compressByGZIP(file, file2, n);
    }

    @JvmOverloads
    public static final void compressByGZIP(@NotNull File $this$compressByGZIP, @NotNull File target) {
        FileUtilsKt.compressByGZIP$default($this$compressByGZIP, target, 0, 2, null);
    }

    public static final void copyTo(@NotNull File $this$copyTo, @NotNull File target) {
        Intrinsics.checkParameterIsNotNull((Object)$this$copyTo, (String)"$this$copyTo");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if ($this$copyTo.isFile()) {
            FileUtilsKt.copyFile($this$copyTo, target);
        } else {
            FileUtilsKt.copyDir($this$copyTo, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public static final void toFile(@NotNull InputStream $this$toFile, @NotNull File targetFile, int bufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toFile, (String)"$this$toFile");
        Intrinsics.checkParameterIsNotNull((Object)targetFile, (String)"targetFile");
        Closeable closeable = new BufferedInputStream($this$toFile);
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(targetFile));
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream out = (BufferedOutputStream)closeable2;
                boolean bl4 = false;
                byte[] b = new byte[bufferSize];
                int len = it.read(b);
                while (len != -1) {
                    out.write(b, 0, len);
                    len = it.read(b);
                }
                out.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmOverloads
    public static /* synthetic */ void toFile$default(InputStream inputStream, File file, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10240;
        }
        FileUtilsKt.toFile(inputStream, file, n);
    }

    @JvmOverloads
    public static final void toFile(@NotNull InputStream $this$toFile, @NotNull File targetFile) {
        FileUtilsKt.toFile$default($this$toFile, targetFile, 0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyFile(File source2, File target) {
        Closeable closeable = new FileInputStream(source2).getChannel();
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new FileOutputStream(target).getChannel();
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                FileChannel out = (FileChannel)closeable2;
                boolean bl4 = false;
                long position = 0L;
                long size = it.size();
                while (size > 0L) {
                    long count = it.transferTo(position, size, out);
                    if (count <= 0L) continue;
                    position += count;
                    size -= count;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void copyDir(File sourceDir, File targetDir) {
        File[] files;
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File[] fileArray = files = sourceDir.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File file2 = file = fileArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            if (file2.isFile()) {
                FileUtilsKt.copyFile(file, new File(targetDir, file.getName()));
                continue;
            }
            FileUtilsKt.copyDir(file, new File(targetDir, file.getName()));
        }
    }
}

