/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.api;

import com.google.gson.annotations.SerializedName;
import com.weebkun.api.Github;
import com.weebkun.api.Language;
import com.weebkun.api.License;
import com.weebkun.api.Owner;
import com.weebkun.api.RepoPermissions;
import com.weebkun.api.Tag;
import com.weebkun.api.Team;
import com.weebkun.api.User;
import com.weebkun.utils.HttpErrorException;
import com.weebkun.utils.UnauthorisedException;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Repository {
    private int id;
    private String node_id;
    public String name;
    public String full_name;
    public Owner owner;
    @SerializedName(value="private")
    public boolean is_private;
    public String html_url;
    public String description;
    public boolean fork;
    public License license;
    public Owner organization;
    public String url;
    public String forks_url;
    public String keys_url;
    public String collaborators_url;
    public String teams_url;
    public String hooks_url;
    public String issue_events_url;
    public String events_url;
    public String assignees_url;
    public String branches_url;
    public String tags_url;
    public String blobs_url;
    public String git_tags_url;
    public String git_refs_url;
    public String trees_url;
    public String statuses_url;
    public String languages_url;
    public String stargazers_url;
    public String contributors_url;
    public String subscribers_url;
    public String subscription_url;
    public String commits_url;
    public String git_commits_url;
    public String comments_url;
    public String issue_comment_url;
    public String contents_url;
    public String compare_url;
    public String merges_url;
    public String archive_url;
    public String downloads_url;
    public String issues_url;
    public String pulls_url;
    public String milestones_url;
    public String notifications_url;
    public String labels_url;
    public String releases_url;
    public String deployments_url;
    public String pushed_at;
    public String created_at;
    public String updated_at;
    public String git_url;
    public String ssh_url;
    public String clone_url;
    public String svn_url;
    public String homepage;
    public int size;
    public int stargazers_count;
    public int watchers_count;
    public String language;
    public boolean has_issues;
    public boolean has_projects;
    public boolean has_downloads;
    public boolean has_wiki;
    public boolean has_pages;
    public int forks_count;
    public String mirror_url;
    public int open_issues_count;
    public int forks;
    public int open_issues;
    public boolean is_template;
    public String[] topics;
    public int watchers;
    public String default_branch;
    public int network_count;
    public int subscribers_count;
    public boolean archived;
    public boolean disabled;
    public String visibility;
    public RepoPermissions permissions;
    public boolean allow_rebase_merge;
    public Repository template_repository;
    public String temp_clone_token;
    public boolean allow_squash_merge;
    public boolean delete_branch_on_merge;
    public boolean allow_merge_commit;
    public Repository parent;
    public Repository source;

    public static Repository get(String owner, String name) throws UnauthorisedException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s", owner, name)).build();
        Repository repo = null;
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            repo = (Repository)Github.getGson().fromJson(response.body().string(), Repository.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return repo;
    }

    public static Repository[] getAllPublic(String since, int perPage, String visibility) {
        if (perPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repositories?since=%s&per_page=%d&visibility=%s", since, perPage, visibility)).build();
        Repository[] repositories = new Repository[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            repositories = (Repository[])Github.getGson().fromJson(response.body().string(), Repository[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return repositories;
    }

    public static void update(String owner, String name, String json) throws UnauthorisedException {
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s", owner, name)).patch(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            Repository repo = (Repository)Github.getGson().fromJson(response.body().string(), Repository.class);
            System.out.printf("Repository %s successfully updated. Response:\nstatus: %s\n%s\n\n%s", repo.full_name, response.code() + " " + response.message(), response.headers(), response.body().string());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delete(String owner, String name) throws UnauthorisedException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s", owner, name)).delete().build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 204) {
                throw new UnauthorisedException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void create(String json) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + "/user/repos").post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void create(String templateOwner, String templateName, String owner, String name, String description, boolean isPrivate) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{'owner': '%s''name': '%s''description': '%s''private': '%s'}", owner, name, description, isPrivate), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/generate", templateOwner, templateName)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 201) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update(String json) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s", this.owner.getName(), this.name)).patch(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            Repository updatedRepo = (Repository)Github.getGson().fromJson(response.body().string(), Repository.class);
            System.out.printf("Repository %s successfully updated. Response:\nstatus: %s\n%s\n\n%s\n", updatedRepo.full_name, response.code() + " " + response.message(), response.headers(), response.body().string());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() throws HttpErrorException {
        RequestBody body = RequestBody.create((String)Github.getGson().toJson((Object)this), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s", this.owner.getName(), this.name)).patch(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
            Repository repo = (Repository)Github.getGson().fromJson(response.body().string(), Repository.class);
            System.out.printf("Repository %s successfully updated. Response:\nstatus: %s\n%s\n\n%s\n", repo.full_name, response.code() + " " + response.message(), response.headers(), response.body().string());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void delete() throws UnauthorisedException {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s", this.owner.getName(), this.name)).delete().build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 204) {
                throw new UnauthorisedException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public UpdateRepo update() {
        UpdateRepo repo = new UpdateRepo();
        repo.name = this.name;
        repo.owner = this.owner.getName();
        repo.description = this.description;
        repo.homepage = this.homepage;
        repo.isPrivate = this.is_private;
        repo.visibility = this.visibility;
        repo.hasIssues = this.has_issues;
        repo.hasProjects = this.has_projects;
        repo.hasWiki = this.has_wiki;
        repo.isTemplate = this.is_template;
        repo.defaultBranch = this.default_branch;
        repo.allowSquashMerge = this.allow_squash_merge;
        repo.allowMergeCommit = this.allow_merge_commit;
        repo.allowRebaseMerge = this.allow_rebase_merge;
        repo.deleteBranchOnMerge = this.delete_branch_on_merge;
        repo.archived = this.archived;
        return repo;
    }

    public User[] getContributors(boolean includeAnonymous, int resultsPerPage, int page) {
        if (resultsPerPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contributors?anon=%s&per_page=%d&page=%d", this.owner.getName(), this.name, includeAnonymous, resultsPerPage, page)).build();
        User[] contributorList = new User[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            contributorList = (User[])Github.getMoshi().adapter(User[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contributorList;
    }

    public User[] getContributors(boolean includeAnonymous) {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contributors?anon=%s", this.owner.getName(), this.name, includeAnonymous)).build();
        User[] contributorList = new User[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            contributorList = (User[])Github.getMoshi().adapter(User[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contributorList;
    }

    public User[] getContributors() {
        return this.getContributors(true);
    }

    public Language listLanguages() {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/languages", this.owner.getName(), this.name)).build();
        Language languages = null;
        try (Response response = Github.getClient().newCall(request).execute();){
            languages = (Language)Github.getGson().fromJson(response.body().string(), Language.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return languages;
    }

    public Tag[] listTags() {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/tags", this.owner.getName(), this.name)).build();
        Tag[] tags = new Tag[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            tags = (Tag[])Github.getMoshi().adapter(Tag[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tags;
    }

    public Tag[] listTags(int resultsPerPage, int page) {
        if (resultsPerPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/tags?per_page=%d&page=%d", this.owner.getName(), this.name, resultsPerPage, page)).build();
        Tag[] tags = new Tag[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            tags = (Tag[])Github.getMoshi().adapter(Tag[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tags;
    }

    public Team[] listTeams() {
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/teams", this.owner.getName(), this.name)).build();
        Team[] teams = new Team[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            teams = (Team[])Github.getMoshi().adapter(Team[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return teams;
    }

    public Team[] listTeams(int resultsPerPage, int page) {
        if (resultsPerPage > 100) {
            throw new IndexOutOfBoundsException("results per page exceeds 100.");
        }
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/teams?per_page=%d&page=%d", this.owner.getName(), this.name, resultsPerPage, page)).build();
        Team[] teams = new Team[]{};
        try (Response response = Github.getClient().newCall(request).execute();){
            teams = (Team[])Github.getMoshi().adapter(Team[].class).fromJson(response.body().source());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return teams;
    }

    public void replaceTopics(String[] topics) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{'names': %s}", Github.getMoshi().adapter(String[].class).toJson((Object)topics)), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/topics", this.owner.getName(), this.name)).put(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void transfer(String newOwnerName, int[] teamIds) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{'new_owner': '%s''team_ids': '%s'}", newOwnerName, Github.getMoshi().adapter(int[].class).toJson((Object)teamIds)), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/transfer", this.owner.getName(), this.name)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 202) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void transfer(String newOwnerName) throws HttpErrorException {
        RequestBody body = RequestBody.create((String)String.format("{'new_owner': '%s'}", newOwnerName), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/transfer", this.owner.getName(), this.name)).post(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 202) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toJson() {
        return Github.getGson().toJson((Object)this, Repository.class);
    }

    public int getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.node_id;
    }

    public static final class UpdateRepo {
        private String owner;
        private String name;
        private String description;
        private String homepage;
        private boolean isPrivate = false;
        private String visibility = "public";
        private boolean hasIssues = true;
        private boolean hasProjects = true;
        private boolean hasWiki = true;
        private boolean isTemplate = false;
        private String defaultBranch = "main";
        private boolean allowSquashMerge = true;
        private boolean allowMergeCommit = true;
        private boolean allowRebaseMerge = true;
        private boolean deleteBranchOnMerge = false;
        private boolean archived = false;

        public UpdateRepo setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public UpdateRepo setName(String name) {
            this.name = name;
            return this;
        }

        public UpdateRepo setDescription(String description) {
            this.description = description;
            return this;
        }

        public UpdateRepo setHomepage(String url) {
            this.homepage = url;
            return this;
        }

        public UpdateRepo isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public UpdateRepo setVisibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public UpdateRepo hasIssues(boolean hasIssues) {
            this.hasIssues = hasIssues;
            return this;
        }

        public UpdateRepo hasProjects(boolean hasProjects) {
            this.hasProjects = hasProjects;
            return this;
        }

        public UpdateRepo hasWiki(boolean hasWiki) {
            this.hasWiki = hasWiki;
            return this;
        }

        public UpdateRepo isTemplate(boolean isTemplate) {
            this.isTemplate = isTemplate;
            return this;
        }

        public UpdateRepo setDefaultBranch(String branch) {
            this.defaultBranch = branch;
            return this;
        }

        public UpdateRepo allowSquashMerge(boolean allow) {
            this.allowSquashMerge = allow;
            return this;
        }

        public UpdateRepo allowMergeCommit(boolean allow) {
            this.allowMergeCommit = allow;
            return this;
        }

        public UpdateRepo allowRebaseMerge(boolean allow) {
            this.allowRebaseMerge = allow;
            return this;
        }

        public UpdateRepo deleteBranchOnMerge(boolean delete) {
            this.deleteBranchOnMerge = delete;
            return this;
        }

        public UpdateRepo archived(boolean archive) {
            this.archived = archive;
            return this;
        }

        public String json() {
            return String.format("{'name':'%s''description': '%s''homepage': '%s''private': '%s''visibility': '%s''has_issues': '%s''has_projects': '%s''has_wiki': '%s''is_template': '%s''default branch': '%s''allow_squash_merge': '%s''allow_merge_commit': '%s''allow_rebase_merge': '%s''delete_branch_on_merge': '%s''archived': '%s'}", this.name, this.description, this.homepage, this.isPrivate, this.visibility, this.hasIssues, this.hasProjects, this.hasWiki, this.isTemplate, this.defaultBranch, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.deleteBranchOnMerge, this.archived);
        }

        public void update() throws UnauthorisedException {
            Repository.update(this.owner, this.name, this.json());
        }
    }

    public static class Builder {
        public String name;
        public String description;
        public String homepage;
        public boolean isPrivate;
        public String visibility = "public";
        public boolean hasIssues = true;
        public boolean hasProjects = true;
        public boolean hasWiki = true;
        public boolean isTemplate = false;
        public boolean allowSquashMerge = true;
        public boolean allowMergeCommit = true;
        public boolean allowRebaseMerge = true;
        public boolean deleteBranchOnMerge = false;
        public boolean autoInit = false;
        public String gitignoreTemplate;
        public String licenseTemplate;

        public void build() throws HttpErrorException {
            String json = String.format("{'name':'%s''description': '%s''homepage': '%s''private': '%s''visibility': '%s''has_issues': '%s''has_projects': '%s''has_wiki': '%s''is_template': '%s''auto_init': '%s''gitignore_template': '%s'license_template': '%s''allow_squash_merge': '%s''allow_merge_commit': '%s''allow_rebase_merge': '%s''delete_branch_on_merge': '%s'}", this.name, this.description, this.homepage, this.isPrivate, this.visibility, this.hasIssues, this.hasProjects, this.hasWiki, this.isTemplate, this.autoInit, this.gitignoreTemplate, this.licenseTemplate, this.allowSquashMerge, this.allowMergeCommit, this.allowRebaseMerge, this.deleteBranchOnMerge);
            Repository.create(json);
        }
    }
}

