/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.github;

import com.squareup.moshi.Json;
import com.squareup.moshi.ToJson;
import com.weebkun.github.App;
import com.weebkun.github.Commit;
import com.weebkun.github.Github;
import com.weebkun.github.Team;
import com.weebkun.github.User;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Branch {
    public String owner;
    public String repo;
    public String name;
    public Commit commit;
    @Json(name="protected")
    public boolean isProtected;
    public Protection protection;
    public String protection_url;

    protected String getEndPoint(String endPoint) {
        return String.format("/repos/%s/%s/branches/%s%s", this.owner, this.repo, this.name, endPoint);
    }

    public Protection getProtection() {
        Protection protection = Github.getNetworkUtil().get(this.getEndPoint("/protection"), Protection.class);
        protection.owner = this.owner;
        protection.repo = this.repo;
        protection.name = this.name;
        protection.branch = this;
        return protection;
    }

    public void rename(String name) {
        Github.getNetworkUtil().post(this.getEndPoint("/rename"), String.format("{\"new_name\": \"%s\"}", name));
    }

    public static class Protection {
        private transient String owner;
        private transient String repo;
        private transient String name;
        private transient Branch branch;
        public String url;
        public RequiredStatusChecks required_status_checks;
        public EnforceAdmins enforce_admins;
        public RequiredPullRequestReviews required_pull_request_reviews;
        public Restrictions restrictions;
        public RequiredLinearHistory required_linear_history;
        public AllowForcePushes allow_force_pushes;
        public AllowDeletions allow_deletions;

        public void update() {
            Github.getNetworkUtil().put(this.branch.getEndPoint("/protection"), Github.getMoshi().adapter(Protection.class).toJson((Object)this));
        }

        public void disable() {
            Github.getNetworkUtil().delete(this.branch.getEndPoint("/protection"));
        }

        public EnforceAdmins isAdminPolicyEnforced() {
            return Github.getNetworkUtil().get(this.branch.getEndPoint("/protection/enforce_admins"), EnforceAdmins.class);
        }

        public void enforceAdmins(boolean enforce) {
            if (enforce) {
                Github.getNetworkUtil().post(this.branch.getEndPoint("/protection/enforce_admins"), "");
            } else {
                Github.getNetworkUtil().delete(this.branch.getEndPoint("/protection/enforce_admins"));
            }
        }

        public RequiredPullRequestReviews getRequiredPullRequestReviewPolicy() {
            return Github.getNetworkUtil().get(this.branch.getEndPoint("/protection/required_pull_request_reviews"), RequiredPullRequestReviews.class);
        }

        public void updatePullRequestReviewPolicy(RequiredPullRequestReviews policy, boolean enabled) {
            if (enabled) {
                Github.getNetworkUtil().patch(this.branch.getEndPoint("/protection/required_pull_request_reviews"), Github.getMoshi().adapter(RequiredPullRequestReviews.class).toJson((Object)policy));
            } else {
                Github.getNetworkUtil().delete(this.branch.getEndPoint("/protection/required_pull_request_reviews"));
            }
        }

        public RequireCommitSignatures getCommitSignaturePolicy() {
            return Github.getNetworkUtil().get(this.branch.getEndPoint("/protection/required_signatures"), RequireCommitSignatures.class);
        }

        public void updateCommitSignaturePolicy(boolean enabled) {
            if (enabled) {
                Github.getNetworkUtil().post(this.branch.getEndPoint("/protection/required_signatures"), "");
            } else {
                Github.getNetworkUtil().delete(this.branch.getEndPoint("/protection/required_signatures"));
            }
        }

        public RequiredStatusChecks getStatusCheckPolicy() {
            return Github.getNetworkUtil().get(this.branch.getEndPoint("/protection/required_status_checks"), RequiredStatusChecks.class);
        }

        public void updateStatusCheckPolicy(RequiredStatusChecks policy, boolean enabled) {
            if (enabled) {
                Github.getNetworkUtil().patch(this.branch.getEndPoint("/protection/required_status_checks"), Github.getMoshi().adapter(RequiredStatusChecks.class).toJson((Object)policy));
            } else {
                Github.getNetworkUtil().delete(this.branch.getEndPoint("/protection/required_status_checks"));
            }
        }

        public String[] getStatusCheckContexts() {
            return Github.getNetworkUtil().get(this.branch.getEndPoint("/protection/required_status_checks/contexts"), String[].class);
        }

        public void updateStatusCheckContexts(String[] contexts, boolean overwrite) {
            if (overwrite) {
                Github.getNetworkUtil().put(this.branch.getEndPoint("/protection/required_status_checks/contexts"), Github.getMoshi().adapter(String[].class).toJson((Object)contexts));
            } else {
                Github.getNetworkUtil().post(this.branch.getEndPoint("/protection/required_status_checks/contexts"), Github.getMoshi().adapter(String[].class).toJson((Object)contexts));
            }
        }

        public void removeStatusCheckContexts(String[] contexts) {
            Github.getNetworkUtil().delete(this.branch.getEndPoint("/protection/required_status_checks/contexts"), Github.getMoshi().adapter(String[].class).toJson((Object)contexts));
        }

        public static class EnforceAdmins {
            public String url;
            public boolean enabled;
        }

        public static class RequiredPullRequestReviews {
            public String url;
            public DismissalRestrictions dismissal_restrictions;
            public boolean dismiss_stale_reviews;
            public boolean require_code_owner_reviews;
            public int required_approving_review_count;

            public static class DismissalRestrictions {
                public String url;
                public String users_url;
                public String teams_url;
                public User[] users;
                public Team[] teams;
            }
        }

        public static class RequireCommitSignatures {
            public String url;
            public boolean enabled;
        }

        public static class RequiredStatusChecks {
            public String url;
            public String enforcement_level;
            public boolean strict;
            public String[] contexts;
            public String contexts_url;
        }

        public static class UpdateAdapter {
            public ProtectionJson.RequiredPullRequestReviews toJson(RequiredPullRequestReviews requiredPullRequestReviews) {
                return new ProtectionJson.RequiredPullRequestReviews(new ProtectionJson.RequiredPullRequestReviews.DismissalRestrictions(requiredPullRequestReviews.dismissal_restrictions), requiredPullRequestReviews.dismiss_stale_reviews, requiredPullRequestReviews.require_code_owner_reviews, requiredPullRequestReviews.required_approving_review_count);
            }

            @ToJson
            public ProtectionJson toJson(Protection protection) {
                ProtectionJson json = new ProtectionJson();
                json.required_status_checks = protection.required_status_checks != null ? new ProtectionJson.RequiredStatusChecks(protection.required_status_checks.strict, protection.required_status_checks.contexts) : null;
                json.enforce_admins = protection.enforce_admins.enabled;
                json.required_pull_request_reviews = new ProtectionJson.RequiredPullRequestReviews(new ProtectionJson.RequiredPullRequestReviews.DismissalRestrictions(protection.required_pull_request_reviews.dismissal_restrictions), protection.required_pull_request_reviews.dismiss_stale_reviews, protection.required_pull_request_reviews.require_code_owner_reviews, protection.required_pull_request_reviews.required_approving_review_count);
                json.restrictions = new ProtectionJson.Restrictions(protection.restrictions);
                json.required_linear_history = protection.required_linear_history.enabled;
                json.allow_force_pushes = protection.allow_force_pushes.enabled;
                json.allow_deletions = protection.allow_deletions.enabled;
                return json;
            }

            private static class ProtectionJson {
                RequiredStatusChecks required_status_checks;
                boolean enforce_admins;
                RequiredPullRequestReviews required_pull_request_reviews;
                Restrictions restrictions;
                boolean required_linear_history = false;
                boolean allow_force_pushes = false;
                boolean allow_deletions = false;

                private ProtectionJson() {
                }

                static class Restrictions {
                    String[] users;
                    String[] teams;
                    String[] apps;

                    Restrictions(com.weebkun.github.Branch$Protection$Restrictions restrictions) {
                        this.users = Arrays.stream(restrictions.users).map(User::getLogin).collect(Collectors.toList()).toArray(new String[0]);
                        this.teams = Arrays.stream(restrictions.teams).map(team -> team.slug).collect(Collectors.toList()).toArray(new String[0]);
                        this.apps = Arrays.stream(restrictions.apps).map(app -> app.slug).collect(Collectors.toList()).toArray(new String[0]);
                    }
                }

                static class RequiredPullRequestReviews {
                    DismissalRestrictions dismissal_restrictions;
                    boolean dismiss_stale_reviews;
                    boolean require_code_owner_reviews;
                    int required_approving_review_count;

                    RequiredPullRequestReviews(DismissalRestrictions restrictions, boolean dismiss_stale_reviews, boolean require_code_owner_reviews, int required_approving_review_count) {
                        this.dismissal_restrictions = restrictions;
                        this.dismiss_stale_reviews = dismiss_stale_reviews;
                        this.require_code_owner_reviews = require_code_owner_reviews;
                        this.required_approving_review_count = required_approving_review_count;
                    }

                    static class DismissalRestrictions {
                        String[] users;
                        String[] teams;

                        DismissalRestrictions(com.weebkun.github.Branch$Protection$RequiredPullRequestReviews$DismissalRestrictions restrictions) {
                            this.users = Arrays.stream(restrictions.users).map(User::getLogin).collect(Collectors.toList()).toArray(new String[0]);
                            this.teams = Arrays.stream(restrictions.teams).map(team -> team.slug).collect(Collectors.toList()).toArray(new String[0]);
                        }
                    }
                }

                static class RequiredStatusChecks {
                    boolean strict;
                    String[] contexts;

                    RequiredStatusChecks(boolean strict, String[] contexts) {
                        this.strict = strict;
                        this.contexts = contexts;
                    }
                }
            }
        }

        public static class AllowDeletions {
            public boolean enabled;
        }

        public static class AllowForcePushes {
            public boolean enabled;
        }

        public static class RequiredLinearHistory {
            public boolean enabled;
        }

        public static class Restrictions {
            String url;
            public String users_url;
            public String teams_url;
            public String apps_url;
            public User[] users;
            public Team[] teams;
            public App[] apps;
        }
    }
}

