/*
 * Decompiled with CFR 0.152.
 */
package com.weebkun.github;

import com.weebkun.github.Content;
import com.weebkun.github.Github;
import com.weebkun.utils.HttpErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class File
extends Content {
    public String content;
    public String owner;
    public String repo;

    public void update(String message, String branch, InputStream newData) throws HttpErrorException, IOException {
        String json = "{" + String.format("\"message\": \"%s\"", message) + String.format("\"content\": \"%s\"", Base64.getEncoder().encodeToString(newData.readAllBytes())) + String.format("\"sha\": \"%s\"", this.sha) + String.format("\"branch\": \"%s\"", branch) + "}";
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents/%s", this.owner, this.repo, this.path)).put(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
        }
    }

    public void delete(String message, String branch) throws HttpErrorException {
        String json = "{" + String.format("\"message\": \"%s\"", message) + String.format("\"sha\": \"%s\"", this.sha) + String.format("\"branch\": \"%s\"", branch) + "}";
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(Github.getRoot() + String.format("/repos/%s/%s/contents/%s", this.owner, this.repo, this.path)).delete(body).build();
        try (Response response = Github.getClient().newCall(request).execute();){
            if (response.code() != 200) {
                throw new HttpErrorException(response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

