/*
 * Decompiled with CFR 0.152.
 */
package com.api.json;

import com.api.json.JSON;
import com.api.json.JSONArtifact;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class JSONArray
extends ArrayList<Object>
implements JSONArtifact {
    private static final long serialVersionUID = 8669267182948350538L;

    public static JSONArray parse(InputStream is) throws IOException {
        JSONArtifact artifact = JSON.parse(is);
        try {
            return (JSONArray)artifact;
        }
        catch (ClassCastException cce) {
            throw new IOException("Does not parse as a JSONArray. It is a " + artifact.getClass().getName());
        }
    }

    public static JSONArray parse(Reader reader) throws IOException {
        JSONArtifact artifact = JSON.parse(reader);
        try {
            return (JSONArray)artifact;
        }
        catch (ClassCastException cce) {
            throw new IOException("Does not parse as a JSONArray. It is a " + artifact.getClass().getName());
        }
    }

    public static JSONArray parse(String input) throws IOException {
        JSONArtifact artifact = JSON.parse(input);
        try {
            return (JSONArray)artifact;
        }
        catch (ClassCastException cce) {
            throw new IOException("Does not parse as a JSONArray. It is a " + artifact.getClass().getName());
        }
    }

    public JSONArray() {
    }

    public JSONArray(int intialCapacity) {
        super(intialCapacity);
    }

    @Override
    public void add(int index, Object element) {
        if (element != null && !JSON.isValidType(element.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + element.getClass().getName() + "] with value: [" + element + "]");
        }
        if (element == this) {
            throw new IllegalArgumentException("Can not put an object into itself.");
        }
        if (element instanceof Number) {
            element = JSON.getNumber(((Number)element).doubleValue(), element.toString());
        }
        super.add(index, element);
    }

    @Override
    public boolean add(Object element) {
        if (element != null && !JSON.isValidType(element.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + element.getClass().getName() + "] with value: [" + element + "]");
        }
        if (element == this) {
            throw new IllegalArgumentException("Can not put an object into itself.");
        }
        if (element instanceof Number) {
            element = JSON.getNumber(((Number)element).doubleValue(), element.toString());
        }
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        ArrayList testCol = new ArrayList();
        for (Object element : collection) {
            if (element != null && !JSON.isValidType(element.getClass())) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + element.getClass().getName() + "] with value: [" + element + "]");
            }
            if (element == this) {
                throw new IllegalArgumentException("Can not put an object into itself.");
            }
            if (element instanceof Number) {
                element = JSON.getNumber(((Number)element).doubleValue(), element.toString());
            }
            testCol.add(element);
        }
        return super.addAll(testCol);
    }

    @Override
    public boolean addAll(int index, Collection<?> collection) {
        ArrayList testCol = new ArrayList();
        for (Object element : collection) {
            if (element != null && !JSON.isValidType(element.getClass())) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + element.getClass().getName() + "] with value: [" + element + "]");
            }
            if (element == this) {
                throw new IllegalArgumentException("Can not put an object into itself.");
            }
            if (element instanceof Number) {
                element = JSON.getNumber(((Number)element).doubleValue(), element.toString());
            }
            testCol.add(element);
        }
        return super.addAll(index, testCol);
    }

    @Override
    public String serialize() throws IOException {
        return this.toString();
    }

    @Override
    public String serialize(boolean verbose) throws IOException {
        if (verbose) {
            StringBuilder sb = new StringBuilder();
            return this.toString(sb, 0, JSON.INCR);
        }
        return this.toString();
    }

    @Override
    public void serialize(OutputStream os) throws IOException {
        if (os == null) {
            throw new NullPointerException("OutputStream is null.");
        }
        os.write(this.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void serialize(OutputStream os, boolean verbose) throws IOException {
        if (os == null) {
            throw new NullPointerException("OutputStream is null.");
        }
        StringBuilder sb = new StringBuilder();
        os.write(this.toString(sb, 0, JSON.INCR).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer is null.");
        }
        writer.write(this.toString());
    }

    @Override
    public void serialize(Writer writer, boolean verbose) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer is null.");
        }
        StringBuilder sb = new StringBuilder();
        writer.write(this.toString(sb, 0, JSON.INCR));
    }

    @Override
    public Object set(int index, Object element) {
        if (element != null && !JSON.isValidType(element.getClass())) {
            throw new IllegalArgumentException("Invalid type of value.  Type: [" + element.getClass().getName() + "] with value: [" + element + "]");
        }
        return super.set(index, element);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return this.toString(sb, 0, 0);
    }

    @Override
    public String toString(StringBuilder sb, int indent, int incr) {
        boolean newObj = true;
        sb.append("[");
        if (incr > 0) {
            sb.append(System.lineSeparator());
        }
        indent += incr;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (newObj) {
                newObj = false;
            } else {
                sb.append(",");
                if (incr > 0) {
                    sb.append(System.lineSeparator());
                }
            }
            Object obj = it.next();
            for (int i = 0; i < indent; i += incr) {
                sb.append(JSON.BLANKS);
            }
            if (!JSON.isValidObject(obj)) continue;
            if (obj instanceof String) {
                sb.append("\"" + JSON.cleanUpString(obj) + "\"");
                continue;
            }
            if (obj instanceof JSONArtifact) {
                sb.append(((JSONArtifact)obj).toString(new StringBuilder(), indent, incr));
                continue;
            }
            sb.append(obj);
        }
        if (incr > 0 && this.size() > 0) {
            sb.append(System.lineSeparator());
        }
        indent -= incr;
        for (int i = 0; i < indent; i += incr) {
            sb.append(JSON.BLANKS);
        }
        sb.append("]");
        return sb.toString();
    }
}

