/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.rpc.client.RPCServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axis2Utils {
    private static final Logger logger = LoggerFactory.getLogger(Axis2Utils.class);

    public static String invoke(String url, String methodName, String targetNameSpace, Object ... params) throws Exception {
        long threadId = Thread.currentThread().getId();
        logger.info("[{}] invoke url={}, methodName={}", new Object[]{threadId, url, methodName});
        for (Object param : params) {
            logger.info("[{}] param:{}", (Object)threadId, param);
        }
        RPCServiceClient serviceClient = new RPCServiceClient();
        Options options = serviceClient.getOptions();
        EndpointReference targetEPR = new EndpointReference(url);
        options.setTo(targetEPR);
        Class[] classes = new Class[]{String.class};
        QName qName = new QName(targetNameSpace, methodName);
        Object result = serviceClient.invokeBlocking(qName, params, classes)[0];
        logger.info("[{}] responseObject={}", (Object)threadId, result);
        return String.valueOf(result);
    }
}

