/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Map;

public class DNSHelper {
    private static Map<String, Object> cacheMap = null;
    private static Constructor<?> entryConstructor = null;

    private static void init() throws Exception {
        if (cacheMap != null) {
            return;
        }
        Field cacheField = InetAddress.class.getDeclaredField("addressCache");
        cacheField.setAccessible(true);
        Object addressCache = cacheField.get(null);
        Field cacheMapField = addressCache.getClass().getDeclaredField("cache");
        cacheMapField.setAccessible(true);
        cacheMap = (Map)cacheMapField.get(addressCache);
        entryConstructor = Class.forName("java.net.InetAddress$CacheEntry").getDeclaredConstructors()[0];
        entryConstructor.setAccessible(true);
    }

    public static synchronized void setHost(String host, String ip) throws Exception {
        DNSHelper.init();
        Object cacheEntry = entryConstructor.newInstance(new InetAddress[]{InetAddress.getByName(ip)}, -1);
        cacheMap.put(host, cacheEntry);
    }

    public static synchronized void removeHost(String host) throws Exception {
        DNSHelper.init();
        cacheMap.remove(host);
    }
}

