/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FULLTIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    private static final ThreadLocal<Boolean> threadLenient = new ThreadLocal();

    public static void setLenient(boolean lenient) {
        threadLenient.set(lenient);
    }

    private static boolean getLenient() {
        Boolean lenient = threadLenient.get();
        if (lenient == null) {
            return false;
        }
        threadLenient.remove();
        return lenient;
    }

    public static String today() {
        return DateUtils.toDateString(new Date());
    }

    public static String now() {
        return DateUtils.toDateTimeString(new Date());
    }

    public static String nowMillis() {
        return DateUtils.toFullTimeString(new Date());
    }

    public static String timestamp() {
        return DateUtils.toTimestampString(new Date());
    }

    public static String getFormat(String date) {
        if (date.contains(" ")) {
            if (date.contains(".")) {
                return FULLTIME_FORMAT;
            }
            return DATETIME_FORMAT;
        }
        if (date.contains("-")) {
            return DATE_FORMAT;
        }
        if (date.contains(":")) {
            return TIME_FORMAT;
        }
        return TIMESTAMP_FORMAT.substring(0, date.length());
    }

    public static Date toDate(String date) {
        if (date == null) {
            return null;
        }
        date = date.trim();
        SimpleDateFormat format = new SimpleDateFormat(DateUtils.getFormat(date));
        boolean lenient = DateUtils.getLenient();
        format.setLenient(lenient);
        try {
            return format.parse(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(DateUtils.toInstant(localDate));
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(DateUtils.toInstant(localDateTime));
    }

    public static Calendar toCalendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(String date) {
        return DateUtils.toCalendar(DateUtils.toDate(date));
    }

    public static Calendar toCalendar(LocalDate localDate) {
        return DateUtils.toCalendar(DateUtils.toDate(localDate));
    }

    public static Calendar toCalendar(LocalDateTime localDateTime) {
        return DateUtils.toCalendar(DateUtils.toDate(localDateTime));
    }

    public static Calendar toCalendar(Instant instant) {
        return DateUtils.toCalendar(Date.from(instant));
    }

    public static LocalDate toLocalDate(long millis) {
        return DateUtils.toLocalDate(Instant.ofEpochMilli(millis));
    }

    public static LocalDate toLocalDate(Date date) {
        return DateUtils.toLocalDate(date.toInstant());
    }

    public static LocalDate toLocalDate(String date) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(DateUtils.getFormat(date)));
    }

    public static LocalDate toLocalDate(Instant instant) {
        return DateUtils.toLocalDateTime(instant).toLocalDate();
    }

    public static LocalTime toLocalTime(long millis) {
        return DateUtils.toLocalTime(Instant.ofEpochMilli(millis));
    }

    public static LocalTime toLocalTime(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(String date) {
        String format = DateUtils.getFormat(date);
        if (format.equals(TIME_FORMAT)) {
            return LocalTime.parse(date);
        }
        return DateUtils.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(Instant instant) {
        return DateUtils.toLocalDateTime(instant).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(long millis) {
        return DateUtils.toLocalDateTime(Instant.ofEpochMilli(millis));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return DateUtils.toLocalDateTime(date.toInstant());
    }

    public static LocalDateTime toLocalDateTime(String date) {
        return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(DateUtils.getFormat(date)));
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static Instant toInstant(String date) {
        return DateUtils.toInstant(DateUtils.toLocalDateTime(date));
    }

    public static Instant toInstant(LocalDate localDate) {
        return DateUtils.toInstant(DateUtils.toLocalDateTime(localDate));
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static String toString(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String toString(LocalDate localDate, String format) {
        if (localDate == null) {
            return null;
        }
        return localDate.format(DateTimeFormatter.ofPattern(format));
    }

    public static String toString(LocalTime localTime, String format) {
        if (localTime == null) {
            return null;
        }
        return localTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String toString(LocalDateTime localDateTime, String format) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String toString(Instant instant, String format) {
        if (instant == null) {
            return null;
        }
        return DateUtils.toString(DateUtils.toLocalDateTime(instant), format);
    }

    public static String toDateString(Date date) {
        return DateUtils.toString(date, DATE_FORMAT);
    }

    public static String toDateString(LocalDateTime localDateTime) {
        return DateUtils.toString(localDateTime, DATE_FORMAT);
    }

    public static String toDateString(Instant instant) {
        return DateUtils.toDateString(DateUtils.toLocalDateTime(instant));
    }

    public static String toTimeString(Date date) {
        return DateUtils.toString(date, TIME_FORMAT);
    }

    public static String toTimeString(LocalTime localTime) {
        return localTime.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
    }

    public static String toTimeString(LocalDateTime localDateTime) {
        return DateUtils.toTimeString(localDateTime.toLocalTime());
    }

    public static String toTimeString(Instant instant) {
        return DateUtils.toTimeString(DateUtils.toLocalTime(instant));
    }

    public static String toDateTimeString(Date date) {
        return DateUtils.toString(date, DATETIME_FORMAT);
    }

    public static String toDateTimeString(LocalDateTime localDateTime) {
        return DateUtils.toString(localDateTime, DATETIME_FORMAT);
    }

    public static String toDateTimeString(Instant instant) {
        return DateUtils.toDateTimeString(DateUtils.toLocalDateTime(instant));
    }

    public static String toFullTimeString(Date date) {
        return DateUtils.toString(date, FULLTIME_FORMAT);
    }

    public static String toFullTimeString(LocalDateTime localDateTime) {
        return DateUtils.toString(localDateTime, FULLTIME_FORMAT);
    }

    public static String toFullTimeString(Instant instant) {
        return DateUtils.toFullTimeString(DateUtils.toLocalDateTime(instant));
    }

    public static String toTimestampString(Date date) {
        return DateUtils.toString(date, TIMESTAMP_FORMAT);
    }

    public static String toTimestampString(LocalDateTime localDateTime) {
        return DateUtils.toString(localDateTime, TIMESTAMP_FORMAT);
    }

    public static String toTimestampString(Instant instant) {
        return DateUtils.toTimestampString(DateUtils.toLocalDateTime(instant));
    }

    public static Date clearTime(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String clearTime(String date) {
        return DateUtils.toDateString(DateUtils.clearTime(DateUtils.toDate(date)));
    }

    public static int getSecondInterval(Date beginDate, Date endDate) {
        long diffMillis = endDate.getTime() - beginDate.getTime();
        return (int)(diffMillis / 1000L);
    }

    public static int getSecondInterval(String beginDate, String endDate) {
        boolean lenient = DateUtils.getLenient();
        DateUtils.setLenient(lenient);
        Date begin = DateUtils.toDate(beginDate);
        DateUtils.setLenient(lenient);
        Date end = DateUtils.toDate(endDate);
        return DateUtils.getSecondInterval(begin, end);
    }

    public static int getMinuteInterval(Date beginDate, Date endDate) {
        return DateUtils.getSecondInterval(beginDate, endDate) / 60;
    }

    public static int getMinuteInterval(String beginDate, String endDate) {
        return DateUtils.getSecondInterval(beginDate, endDate) / 60;
    }

    public static int getHourInterval(Date beginDate, Date endDate) {
        return DateUtils.getMinuteInterval(beginDate, endDate) / 60;
    }

    public static int getHourInterval(String beginDate, String endDate) {
        return DateUtils.getMinuteInterval(beginDate, endDate) / 60;
    }

    public static int getDateIntervalFloored(Date beginDate, Date endDate) {
        return DateUtils.getHourInterval(DateUtils.clearTime(beginDate), DateUtils.clearTime(endDate)) / 24;
    }

    public static int getDateIntervalFloored(String beginDate, String endDate) {
        boolean lenient = DateUtils.getLenient();
        DateUtils.setLenient(lenient);
        Date begin = DateUtils.toDate(beginDate);
        DateUtils.setLenient(lenient);
        Date end = DateUtils.toDate(endDate);
        return DateUtils.getDateIntervalFloored(begin, end);
    }

    public static int getDateInterval(Date beginDate, Date endDate) {
        return DateUtils.getHourInterval(beginDate, endDate) / 24;
    }

    public static int getDateInterval(String beginDate, String endDate) {
        return DateUtils.getHourInterval(beginDate, endDate) / 24;
    }

    public static int getMonthInterval(Date beginDate, Date endDate) {
        Calendar begin = DateUtils.toCalendar(beginDate);
        Calendar end = DateUtils.toCalendar(endDate);
        int diffYears = end.get(1) - begin.get(1);
        int diffMonths = diffYears * 12 + end.get(2) - begin.get(2);
        if (end.after(begin) && end.get(5) < begin.get(5)) {
            --diffMonths;
        }
        if (begin.after(end) && begin.get(5) < end.get(5)) {
            ++diffMonths;
        }
        return diffMonths;
    }

    public static int getMonthInterval(String beginDate, String endDate) {
        boolean lenient = DateUtils.getLenient();
        DateUtils.setLenient(lenient);
        Date begin = DateUtils.toDate(beginDate);
        DateUtils.setLenient(lenient);
        Date end = DateUtils.toDate(endDate);
        return DateUtils.getMonthInterval(begin, end);
    }

    public static int getYearInterval(Date beginDate, Date endDate) {
        return DateUtils.getMonthInterval(beginDate, endDate) / 12;
    }

    public static int getYearInterval(String beginDate, String endDate) {
        return DateUtils.getMonthInterval(beginDate, endDate) / 12;
    }

    public static int getSecond(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(13);
    }

    public static int getSecond(String date) {
        return DateUtils.getSecond(DateUtils.toDate(date));
    }

    public static int getSecondOfZero(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return hour * 3600 + minute * 60 + second;
    }

    public static int getSecondOfZero(String date) {
        return DateUtils.getSecondOfZero(DateUtils.toDate(date));
    }

    public static Date setSecond(Date date, int second) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static String setSecond(String date, int second) {
        return DateUtils.toDateString(DateUtils.setSecond(DateUtils.toDate(date), second));
    }

    public static Date setSecondOfZero(Date date, int second) {
        date = DateUtils.clearTime(date);
        return DateUtils.addSecond(date, second);
    }

    public static String setSecondOfZero(String date, int second) {
        return DateUtils.toDateString(DateUtils.setSecondOfZero(DateUtils.toDate(date), second));
    }

    public static Date addSecond(Date date, int inteval) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.add(13, inteval);
        return calendar.getTime();
    }

    public static String addSecond(String date, int inteval) {
        return DateUtils.toDateString(DateUtils.addSecond(DateUtils.toDate(date), inteval));
    }

    public static int getMinute(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(12);
    }

    public static int getMinute(String date) {
        return DateUtils.getMinute(DateUtils.toDate(date));
    }

    public static int getMinuteOfZero(Date date) {
        return DateUtils.getSecondOfZero(date) / 60;
    }

    public static int getMinuteOfZero(String date) {
        return DateUtils.getSecondOfZero(date) / 60;
    }

    public static Date setMinute(Date date, int minute) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(12, minute);
        return calendar.getTime();
    }

    public static String setMinute(String date, int minute) {
        return DateUtils.toDateString(DateUtils.setMinute(DateUtils.toDate(date), minute));
    }

    public static Date setMinuteOfZero(Date date, int minute) {
        date = DateUtils.clearTime(date);
        return DateUtils.addMinute(date, minute);
    }

    public static String setMinuteOfZero(String date, int minute) {
        return DateUtils.toDateString(DateUtils.setMinuteOfZero(DateUtils.toDate(date), minute));
    }

    public static Date addMinute(Date date, int inteval) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.add(12, inteval);
        return calendar.getTime();
    }

    public static String addMinute(String date, int inteval) {
        return DateUtils.toDateString(DateUtils.addMinute(DateUtils.toDate(date), inteval));
    }

    public static int getHour(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(11);
    }

    public static int getHour(String date) {
        return DateUtils.getHour(DateUtils.toDate(date));
    }

    public static Date setHour(Date date, int hour) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(11, hour);
        return calendar.getTime();
    }

    public static String setHour(String date, int hour) {
        return DateUtils.toDateString(DateUtils.setHour(DateUtils.toDate(date), hour));
    }

    public static Date addHour(Date date, int inteval) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.add(11, inteval);
        return calendar.getTime();
    }

    public static String addHour(String date, int inteval) {
        return DateUtils.toDateString(DateUtils.addHour(DateUtils.toDate(date), inteval));
    }

    public static int getDate(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(5);
    }

    public static int getDate(String date) {
        return DateUtils.getDate(DateUtils.toDate(date));
    }

    public static Date setDate(Date date, int day) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static String setDate(String date, int day) {
        return DateUtils.toDateString(DateUtils.setDate(DateUtils.toDate(date), day));
    }

    public static Date addDate(Date date, int inteval) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.add(5, inteval);
        return calendar.getTime();
    }

    public static String addDate(String date, int inteval) {
        return DateUtils.toDateString(DateUtils.addDate(DateUtils.toDate(date), inteval));
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(2);
    }

    public static int getMonth(String date) {
        return DateUtils.getMonth(DateUtils.toDate(date));
    }

    public static Date setMonth(Date date, int month) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(2, month);
        return calendar.getTime();
    }

    public static String setMonth(String date, int month) {
        return DateUtils.toDateString(DateUtils.setMonth(DateUtils.toDate(date), month));
    }

    public static Date addMonth(Date date, int inteval) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.add(2, inteval);
        return calendar.getTime();
    }

    public static String addMonth(String date, int inteval) {
        return DateUtils.toDateString(DateUtils.addMonth(DateUtils.toDate(date), inteval));
    }

    public static int getYear(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(1);
    }

    public static int getYear(String date) {
        return DateUtils.getYear(DateUtils.toDate(date));
    }

    public static Date setYear(Date date, int year) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static String setYear(String date, int year) {
        return DateUtils.toDateString(DateUtils.setYear(DateUtils.toDate(date), year));
    }

    public static Date addYear(Date date, int inteval) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.add(1, inteval);
        return calendar.getTime();
    }

    public static String addYear(String date, int inteval) {
        return DateUtils.toDateString(DateUtils.addYear(DateUtils.toDate(date), inteval));
    }

    public static boolean isLastDayOfMonth(Date date) {
        return DateUtils.getMonth(DateUtils.addDate(date, 1)) != DateUtils.getMonth(date);
    }

    public static boolean isLastDayOfMonth(String date) {
        return DateUtils.isLastDayOfMonth(DateUtils.toDate(date));
    }

    public static Date setLastDayOfMonth(Date date) {
        date = DateUtils.setDate(date, 1);
        date = DateUtils.addMonth(date, 1);
        return DateUtils.addDate(date, -1);
    }

    public static String setLastDayOfMonth(String date) {
        return DateUtils.toDateString(DateUtils.setLastDayOfMonth(DateUtils.toDate(date)));
    }
}

