/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FileUtils {
    public static InputStream getResourceAsStream(String path) {
        return FileUtils.class.getClassLoader().getResourceAsStream(path);
    }

    public static String getWebRootPath() {
        String classPath = FileUtils.class.getClassLoader().getResource("").getPath();
        if (classPath.endsWith("WEB-INF/classes/")) {
            return classPath.substring(0, classPath.length() - 16);
        }
        return classPath;
    }

    public static boolean copyFile(File from, File to) throws Exception {
        if (!from.isFile() || to.isDirectory() || from.equals(to)) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out = new FileOutputStream(to);){
            int length;
            byte[] buffer = new byte[0x100000];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            out.flush();
        }
        return true;
    }

    public static boolean deleteFile(File file) throws Exception {
        if (file.isFile()) {
            return file.delete();
        }
        if (file.isDirectory()) {
            for (File subfile : file.listFiles()) {
                FileUtils.deleteFile(subfile);
            }
            return file.delete();
        }
        return true;
    }

    public static boolean moveFile(File from, File to) throws Exception {
        if (!FileUtils.copyFile(from, to)) {
            return false;
        }
        return FileUtils.deleteFile(from);
    }

    public static byte[] readStream(InputStream in) throws Exception {
        int length;
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        byte[] buffer = new byte[0x100000];
        while ((length = in.read(buffer)) != -1) {
            cache.write(buffer, 0, length);
        }
        return cache.toByteArray();
    }

    public static String readStream(InputStream in, String charset) throws Exception {
        String line;
        if (charset == null) {
            charset = Charset.defaultCharset().name();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append(System.lineSeparator());
        }
        return buffer.toString();
    }

    public static byte[] readFile(File file) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            byte[] byArray = FileUtils.readStream(in);
            return byArray;
        }
    }

    public static String readFile(File file, String charset) throws Exception {
        if (charset == null) {
            charset = Charset.defaultCharset().name();
        }
        try (FileInputStream in = new FileInputStream(file);){
            String string = FileUtils.readStream(in, charset);
            return string;
        }
    }

    public static void writeFile(File file, byte[] data, boolean append) throws Exception {
        try (FileOutputStream out = new FileOutputStream(file, append);){
            out.write(data);
            out.flush();
        }
    }
}

