/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import com.github.woshikid.utils.DateUtils;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class IDUtils {
    private static final int[] IDPowers = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] IDValidations = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};

    public static boolean isValid(String IDNo) {
        if (StringUtils.isEmpty((CharSequence)IDNo)) {
            return false;
        }
        if (!IDNo.matches("^[1-9]\\d{5}(19|20)\\d{9}[\\dxX]$")) {
            return false;
        }
        try {
            IDUtils.getBirthday(IDNo);
        }
        catch (Exception e) {
            return false;
        }
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            int num = Integer.valueOf(IDNo.substring(i, i + 1));
            sum += num * IDPowers[i];
        }
        String validation = IDValidations[sum % 11];
        return IDNo.endsWith(validation);
    }

    public static String getBirthdayString(String IDNo) {
        return IDNo.substring(6, 14);
    }

    public static Date getBirthday(String IDNo) {
        return DateUtils.toDate(IDUtils.getBirthdayString(IDNo));
    }

    public static int getAge(String IDNo) {
        return DateUtils.getYearInterval(IDUtils.getBirthday(IDNo), new Date());
    }

    public static boolean isMale(String IDNo) {
        return !IDUtils.isFemale(IDNo);
    }

    public static boolean isFemale(String IDNo) {
        String flag = IDNo.substring(16, 17);
        return Integer.valueOf(flag) % 2 == 0;
    }

    public static String getSN(String sn, int length) {
        sn = StringUtils.leftPad((String)sn, (int)length, (char)'0');
        return StringUtils.right((String)sn, (int)length);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

