/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import com.github.woshikid.utils.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceUtils.class);

    private static String xmlToString(Document xml) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(xml), new StreamResult(cache));
        return cache.toString("UTF-8");
    }

    public static Map<String, String> getSOAPHeader(String url, boolean SOAP12) throws MalformedURLException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/soap+xml, text/*");
        header.put("Cache-Control", "no-cache");
        header.put("Pragma", "no-cache");
        header.put("Host", new URL(url).getHost());
        if (SOAP12) {
            header.put("Content-Type", "application/soap+xml; charset=utf-8");
        } else {
            header.put("Content-Type", "text/xml; charset=utf-8");
            header.put("SOAPAction", "");
        }
        return header;
    }

    public static String toSOAP(String methodName, String targetNameSpace, LinkedHashMap<String, String> paramMap, boolean SOAP12) throws Exception {
        String nameSpace = "http://schemas.xmlsoap.org/soap/envelope/";
        if (SOAP12) {
            nameSpace = "http://www.w3.org/2003/05/soap-envelope";
        }
        String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if (SOAP12) {
            encodingStyle = "http://www.w3.org/2001/12/soap-encoding";
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        document.setXmlStandalone(true);
        Element envelope = document.createElementNS(nameSpace, "soapenv:Envelope");
        envelope.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        envelope.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document.appendChild(envelope);
        Element body = document.createElement("soapenv:Body");
        envelope.appendChild(body);
        Element method = document.createElement(methodName);
        if (targetNameSpace != null) {
            method.setAttribute("xmlns", targetNameSpace);
        }
        method.setAttribute("soapenv:encodingStyle", encodingStyle);
        body.appendChild(method);
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                Element param = document.createElement(key);
                param.setAttribute("xsi:type", "xsd:string");
                param.setTextContent(paramMap.get(key));
                method.appendChild(param);
            }
        }
        return WebServiceUtils.xmlToString(document);
    }

    public static LinkedHashMap<String, String> fromSOAP(String xml, boolean SOAP12) throws Exception {
        String nameSpace = "http://schemas.xmlsoap.org/soap/envelope/";
        if (SOAP12) {
            nameSpace = "http://www.w3.org/2003/05/soap-envelope";
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        Element envelope = (Element)document.getElementsByTagNameNS(nameSpace, "Envelope").item(0);
        Element body = (Element)envelope.getElementsByTagNameNS(nameSpace, "Body").item(0);
        Element method = (Element)body.getFirstChild();
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        NodeList params = method.getChildNodes();
        for (int i = 0; i < params.getLength(); ++i) {
            Node node = params.item(i);
            if (node.getNodeType() != 1) continue;
            Element param = (Element)node;
            paramMap.put(param.getTagName(), param.getTextContent());
        }
        return paramMap;
    }

    public static String invoke(String url, String methodName, String targetNameSpace, LinkedHashMap<String, String> paramMap, boolean SOAP12) throws Exception {
        long threadId = Thread.currentThread().getId();
        logger.info("[{}] invoke url={}, methodName={}", new Object[]{threadId, url, methodName});
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                String value = paramMap.get(key);
                logger.info("[{}] param:{}={}", new Object[]{threadId, key, value});
            }
        }
        Map<String, String> header = WebServiceUtils.getSOAPHeader(url, SOAP12);
        String requestText = WebServiceUtils.toSOAP(methodName, targetNameSpace, paramMap, SOAP12);
        logger.info("[{}] requestText={}", (Object)threadId, (Object)requestText);
        HttpUtils.Response response = HttpUtils.request(url, header, requestText.getBytes(StandardCharsets.UTF_8));
        String responseText = response.charset == null ? new String(response.data, StandardCharsets.UTF_8) : new String(response.data, response.charset);
        logger.info("[{}] responseText={}", (Object)threadId, (Object)responseText);
        try {
            LinkedHashMap<String, String> responseMap = WebServiceUtils.fromSOAP(responseText, SOAP12);
            String returnText = responseMap.values().iterator().next();
            logger.info("[{}] returnText={}", (Object)threadId, (Object)returnText);
            return returnText;
        }
        catch (Exception e) {
            logger.error("[" + threadId + "] error when dealing with soap message", (Throwable)e);
            throw new SOAPException(e, responseText);
        }
    }

    public static class SOAPException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public String responseText;

        public SOAPException(Throwable t, String responseText) {
            super(t);
            this.responseText = responseText;
        }
    }
}

