/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AutoWatcher
implements Watcher,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoWatcher.class);
    private ZooKeeper zk;
    private String path;

    public AutoWatcher(ZooKeeper zk, String path) {
        this.zk = zk;
        this.path = path;
    }

    private void waitForConnect() {
        for (int i = 0; i < 10 && !this.zk.getState().equals((Object)ZooKeeper.States.CONNECTED); ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void register() {
        this.waitForConnect();
        try {
            this.doRegister(this.zk, this.path);
        }
        catch (Exception e) {
            logger.error("Error while registering watcher", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract void doRegister(ZooKeeper var1, String var2) throws Exception;

    public final void process(WatchedEvent event) {
        try {
            this.doProcess(event);
        }
        catch (Exception e) {
            logger.error("Error while calling watcher", (Throwable)e);
        }
        finally {
            this.register();
        }
    }

    protected abstract void doProcess(WatchedEvent var1) throws Exception;

    public final void afterPropertiesSet() throws Exception {
        this.register();
    }
}

