/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import com.github.woshikid.utils.DateUtils;
import com.github.woshikid.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DTOUtils {
    private static final ThreadLocal<String> dateFormat = new ThreadLocal();
    private static String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<Integer> bigDecimalScale = new ThreadLocal();

    private static String getDateFormat() {
        String format = dateFormat.get();
        if (format == null) {
            format = defaultDateFormat;
        }
        return format;
    }

    private static Integer getBigDecimalScale() {
        return bigDecimalScale.get();
    }

    public static void setDateFormat(String format) {
        dateFormat.set(format);
    }

    public static void setBigDecimalScale(int scale) {
        bigDecimalScale.set(scale);
    }

    public static void reset() {
        dateFormat.remove();
        bigDecimalScale.remove();
    }

    public static <T> T convert(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        if (targetClass.isInstance(source)) {
            return (T)source;
        }
        if (source.equals("")) {
            return null;
        }
        if (targetClass == Boolean.TYPE || targetClass == Boolean.class) {
            if (source instanceof Boolean) {
                return (T)source;
            }
            if (source instanceof Number) {
                return (T)Boolean.valueOf(((Number)source).intValue() != 0);
            }
            if (source instanceof String) {
                return (T)Boolean.valueOf((String)source);
            }
        } else if (targetClass == Character.TYPE || targetClass == Character.class) {
            if (source instanceof Character) {
                return (T)source;
            }
            if (source instanceof String) {
                if (((String)source).length() == 0) {
                    return null;
                }
                return (T)Character.valueOf(((String)source).charAt(0));
            }
        } else if (targetClass == Byte.TYPE || targetClass == Byte.class) {
            if (source instanceof Number) {
                return (T)Byte.valueOf(((Number)source).byteValue());
            }
            if (source instanceof String) {
                return (T)Byte.valueOf((String)source);
            }
        } else if (targetClass == Short.TYPE || targetClass == Short.class) {
            if (source instanceof Number) {
                return (T)Short.valueOf(((Number)source).shortValue());
            }
            if (source instanceof String) {
                return (T)Short.valueOf((String)source);
            }
        } else if (targetClass == Integer.TYPE || targetClass == Integer.class) {
            if (source instanceof Number) {
                return (T)Integer.valueOf(((Number)source).intValue());
            }
            if (source instanceof String) {
                return (T)Integer.valueOf((String)source);
            }
        } else if (targetClass == Long.TYPE || targetClass == Long.class) {
            if (source instanceof Number) {
                return (T)Long.valueOf(((Number)source).longValue());
            }
            if (source instanceof String) {
                return (T)Long.valueOf((String)source);
            }
            if (source instanceof Date) {
                return (T)Long.valueOf(((Date)source).getTime());
            }
            if (source instanceof Calendar) {
                return (T)Long.valueOf(((Calendar)source).getTimeInMillis());
            }
            if (source instanceof LocalDate) {
                return (T)Long.valueOf(DateUtils.toInstant((LocalDate)source).toEpochMilli());
            }
            if (source instanceof LocalDateTime) {
                return (T)Long.valueOf(DateUtils.toInstant((LocalDateTime)source).toEpochMilli());
            }
            if (source instanceof Instant) {
                return (T)Long.valueOf(((Instant)source).toEpochMilli());
            }
        } else if (targetClass == Float.TYPE || targetClass == Float.class) {
            if (source instanceof Number) {
                return (T)Float.valueOf(((Number)source).floatValue());
            }
            if (source instanceof String) {
                return (T)Float.valueOf((String)source);
            }
        } else if (targetClass == Double.TYPE || targetClass == Double.class) {
            if (source instanceof Number) {
                return (T)Double.valueOf(((Number)source).doubleValue());
            }
            if (source instanceof String) {
                return (T)Double.valueOf((String)source);
            }
        } else if (targetClass == BigInteger.class) {
            if (source instanceof BigDecimal) {
                return (T)((BigDecimal)source).toBigInteger();
            }
            if (source instanceof Number) {
                return (T)BigInteger.valueOf(((Number)source).longValue());
            }
            if (source instanceof String) {
                return (T)new BigDecimal((String)source).toBigInteger();
            }
        } else if (targetClass == BigDecimal.class) {
            if (source instanceof Number || source instanceof String) {
                Integer scale = DTOUtils.getBigDecimalScale();
                if (scale == null) {
                    return (T)new BigDecimal(source.toString());
                }
                return (T)new BigDecimal(source.toString()).setScale((int)scale, RoundingMode.HALF_UP);
            }
        } else if (targetClass == Date.class) {
            if (source instanceof Calendar) {
                return (T)((Calendar)source).getTime();
            }
            if (source instanceof Long) {
                return (T)new Date((Long)source);
            }
            if (source instanceof String) {
                return (T)DateUtils.toDate((String)source);
            }
            if (source instanceof LocalDate) {
                return (T)DateUtils.toDate((LocalDate)source);
            }
            if (source instanceof LocalDateTime) {
                return (T)DateUtils.toDate((LocalDateTime)source);
            }
            if (source instanceof Instant) {
                return (T)Date.from((Instant)source);
            }
        } else if (targetClass == Calendar.class) {
            if (source instanceof Date) {
                return (T)DateUtils.toCalendar((Date)source);
            }
            if (source instanceof Long) {
                return (T)DateUtils.toCalendar((Long)source);
            }
            if (source instanceof String) {
                return (T)DateUtils.toCalendar((String)source);
            }
            if (source instanceof LocalDate) {
                return (T)DateUtils.toCalendar((LocalDate)source);
            }
            if (source instanceof LocalDateTime) {
                return (T)DateUtils.toCalendar((LocalDateTime)source);
            }
            if (source instanceof Instant) {
                return (T)DateUtils.toCalendar((Instant)source);
            }
        } else if (targetClass == LocalDate.class) {
            if (source instanceof Long) {
                return (T)DateUtils.toLocalDate((Long)source);
            }
            if (source instanceof Date) {
                return (T)DateUtils.toLocalDate((Date)source);
            }
            if (source instanceof Calendar) {
                return (T)DateUtils.toLocalDate(((Calendar)source).getTime());
            }
            if (source instanceof String) {
                return (T)DateUtils.toLocalDate((String)source);
            }
            if (source instanceof LocalDateTime) {
                return (T)((LocalDateTime)source).toLocalDate();
            }
            if (source instanceof Instant) {
                return (T)DateUtils.toLocalDate((Instant)source);
            }
        } else if (targetClass == LocalTime.class) {
            if (source instanceof Long) {
                return (T)DateUtils.toLocalTime((Long)source);
            }
            if (source instanceof Date) {
                return (T)DateUtils.toLocalTime((Date)source);
            }
            if (source instanceof Calendar) {
                return (T)DateUtils.toLocalTime(((Calendar)source).getTime());
            }
            if (source instanceof String) {
                return (T)DateUtils.toLocalTime((String)source);
            }
            if (source instanceof LocalDateTime) {
                return (T)((LocalDateTime)source).toLocalTime();
            }
            if (source instanceof Instant) {
                return (T)DateUtils.toLocalTime((Instant)source);
            }
        } else if (targetClass == LocalDateTime.class) {
            if (source instanceof Long) {
                return (T)DateUtils.toLocalDateTime((Long)source);
            }
            if (source instanceof Date) {
                return (T)DateUtils.toLocalDateTime((Date)source);
            }
            if (source instanceof Calendar) {
                return (T)DateUtils.toLocalDateTime(((Calendar)source).getTime());
            }
            if (source instanceof String) {
                return (T)DateUtils.toLocalDateTime((String)source);
            }
            if (source instanceof LocalDate) {
                return (T)DateUtils.toLocalDateTime((LocalDate)source);
            }
            if (source instanceof Instant) {
                return (T)DateUtils.toLocalDateTime((Instant)source);
            }
        } else if (targetClass == Instant.class) {
            if (source instanceof Long) {
                return (T)Instant.ofEpochMilli((Long)source);
            }
            if (source instanceof Date) {
                return (T)((Date)source).toInstant();
            }
            if (source instanceof Calendar) {
                return (T)((Calendar)source).getTime().toInstant();
            }
            if (source instanceof String) {
                return (T)DateUtils.toInstant((String)source);
            }
            if (source instanceof LocalDate) {
                return (T)DateUtils.toInstant((LocalDate)source);
            }
            if (source instanceof LocalDateTime) {
                return (T)DateUtils.toInstant((LocalDateTime)source);
            }
        } else {
            if (targetClass == String.class) {
                if (source instanceof Date) {
                    return (T)DateUtils.toString((Date)source, DTOUtils.getDateFormat());
                }
                if (source instanceof Calendar) {
                    return (T)DateUtils.toString(((Calendar)source).getTime(), DTOUtils.getDateFormat());
                }
                if (source instanceof LocalTime) {
                    return (T)DateUtils.toTimeString((LocalTime)source);
                }
                if (source instanceof LocalDateTime) {
                    return (T)DateUtils.toString((LocalDateTime)source, DTOUtils.getDateFormat());
                }
                if (source instanceof Instant) {
                    return (T)DateUtils.toString((Instant)source, DTOUtils.getDateFormat());
                }
                if (source instanceof BigDecimal) {
                    Integer scale = DTOUtils.getBigDecimalScale();
                    if (scale == null) {
                        return (T)((BigDecimal)source).toPlainString();
                    }
                    return (T)((BigDecimal)source).setScale((int)scale, RoundingMode.HALF_UP).toPlainString();
                }
                return (T)source.toString();
            }
            if (Enum.class.isAssignableFrom(targetClass)) {
                if (source instanceof Enum) {
                    return Enum.valueOf(targetClass, ((Enum)source).name());
                }
                if (source instanceof String) {
                    return Enum.valueOf(targetClass, (String)source);
                }
            }
        }
        return null;
    }

    public static <T> T map(Object source, T target) {
        if (source instanceof Map) {
            return DTOUtils.map((Map)source, target, true);
        }
        return DTOUtils.map(source, target, true);
    }

    private static <T> T map(Object source, T target, boolean reset) {
        try {
            Field[] fields;
            if (source == null) {
                T t = target;
                return t;
            }
            if (target == null) {
                T t = target;
                return t;
            }
            for (Field field : fields = ObjectUtils.getAllFields(target.getClass())) {
                Field sourceField;
                if (Modifier.isFinal(field.getModifiers()) || (sourceField = ObjectUtils.getField(source.getClass(), field.getName())) == null) continue;
                sourceField.setAccessible(true);
                Object value = sourceField.get(source);
                value = DTOUtils.convert(value, field.getType());
                if (value == null) continue;
                field.setAccessible(true);
                field.set(target, value);
            }
            T t = target;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reset) {
                DTOUtils.reset();
            }
        }
    }

    private static <T> T map(Map<?, ?> source, T target, boolean reset) {
        try {
            Field[] fields;
            if (source == null) {
                T t = target;
                return t;
            }
            if (target == null) {
                T t = target;
                return t;
            }
            for (Field field : fields = ObjectUtils.getAllFields(target.getClass())) {
                if (Modifier.isFinal(field.getModifiers())) continue;
                Object value = source.get(field.getName());
                if ((value = DTOUtils.convert(value, field.getType())) == null) continue;
                field.setAccessible(true);
                field.set(target, value);
            }
            T t = target;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reset) {
                DTOUtils.reset();
            }
        }
    }

    public static <T> T map(Object source, Class<T> targetClass) {
        return DTOUtils.map(source, targetClass, true);
    }

    private static <T> T map(Object source, Class<T> targetClass, boolean reset) {
        try {
            T target = targetClass.newInstance();
            if (source instanceof Map) {
                DTOUtils.map((Map)source, target, reset);
            } else {
                DTOUtils.map(source, target, reset);
            }
            return target;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> map(List<?> sourceList, Class<T> targetClass) {
        try {
            ArrayList<T> list = new ArrayList<T>(sourceList.size());
            for (Object source : sourceList) {
                list.add(DTOUtils.map(source, targetClass, false));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            DTOUtils.reset();
        }
    }

    public static Map<String, Object> map(Object source) {
        return DTOUtils.map(source, false, true);
    }

    public static Map<String, Object> map(Object source, boolean toString) {
        return DTOUtils.map(source, toString, true);
    }

    private static Map<String, Object> map(Object source, boolean toString, boolean reset) {
        try {
            Field[] fields;
            if (source == null) {
                Map<String, Object> map = null;
                return map;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields = ObjectUtils.getAllFields(source.getClass())) {
                field.setAccessible(true);
                Object value = field.get(source);
                if (toString) {
                    value = DTOUtils.convert(value, String.class);
                }
                if (value == null) continue;
                map.put(field.getName(), value);
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reset) {
                DTOUtils.reset();
            }
        }
    }

    public static List<Map<String, Object>> map(List<?> sourceList) {
        return DTOUtils.map(sourceList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> map(List<?> sourceList, boolean toString) {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sourceList.size());
            for (Object source : sourceList) {
                list.add(DTOUtils.map(source, toString, false));
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            DTOUtils.reset();
        }
    }

    public static boolean checkNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    public static boolean checkNullFields(Object object) {
        return DTOUtils.checkNullFields(object, false);
    }

    public static boolean checkNullFields(Object object, boolean superclass) {
        try {
            Field[] fields = superclass ? ObjectUtils.getAllFields(object.getClass()) : object.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(object);
                if (value != null) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static void assertNotNull(Object ... objects) {
        if (!DTOUtils.checkNull(objects)) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertNoNullFields(Object object) {
        if (!DTOUtils.checkNullFields(object, false)) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertNoNullFields(Object object, boolean superclass) {
        if (!DTOUtils.checkNullFields(object, superclass)) {
            throw new IllegalArgumentException();
        }
    }

    public static String underscoreToCamelCase(String name) {
        Matcher matcher = Pattern.compile("_[a-z]").matcher(name);
        StringBuilder builder = new StringBuilder(name);
        int i = 0;
        while (matcher.find()) {
            builder.replace(matcher.start() - i, matcher.end() - i, matcher.group().substring(1).toUpperCase());
            ++i;
        }
        if (Character.isUpperCase(builder.charAt(0))) {
            builder.replace(0, 1, String.valueOf(Character.toLowerCase(builder.charAt(0))));
        }
        return builder.toString();
    }

    public static <V> Map<String, V> camelCaseMap(Map<String, V> map) {
        HashMap<String, V> camelHumpMap = new HashMap<String, V>();
        Iterator<Map.Entry<String, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String camelHumpKey;
            Map.Entry<String, V> entry = iterator.next();
            String key = entry.getKey();
            if (key.equals(camelHumpKey = DTOUtils.underscoreToCamelCase(key.toLowerCase()))) continue;
            camelHumpMap.put(camelHumpKey, entry.getValue());
            iterator.remove();
        }
        map.putAll(camelHumpMap);
        return map;
    }

    public static <V> List<Map<String, V>> camelCaseMap(List<Map<String, V>> mapList) {
        for (Map<String, V> map : mapList) {
            DTOUtils.camelCaseMap(map);
        }
        return mapList;
    }
}

