/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    private static SerializeConfig mapping = new SerializeConfig();

    public static String toJSON(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object object, boolean prettyFormat) {
        if (prettyFormat) {
            return JSON.toJSONString((Object)object, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)object, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object object, String dateFormat) {
        SerializeConfig mapping = new SerializeConfig();
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer(dateFormat));
        return JSON.toJSONString((Object)object, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object object, String dateFormat, boolean prettyFormat) {
        SerializeConfig mapping = new SerializeConfig();
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer(dateFormat));
        if (prettyFormat) {
            return JSON.toJSONString((Object)object, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)object, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Object toObject(String json) {
        return JSON.parse((String)json);
    }

    public static <T> T toObject(String json, Class<T> targetClass) {
        return (T)JSON.parseObject((String)json, targetClass);
    }

    public static <T> T toObject(Map<?, ?> map, Class<T> targetClass) {
        String json = JSONUtils.toJSON(map);
        return JSONUtils.toObject(json, targetClass);
    }

    public static Map<String, Object> toMap(String json) {
        return JSON.parseObject((String)json);
    }

    public static Map<String, Object> toMap(Object object) {
        return (Map)JSON.toJSON((Object)object);
    }

    public static <T> List<T> toList(String json, Class<T> targetClass) {
        return JSON.parseArray((String)json, targetClass);
    }

    public static List<Object> toList(String json) {
        return JSON.parseArray((String)json);
    }

    static {
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
    }
}

