/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class MessageDigestUtils {
    private static String byte2Hex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int bLen = bytes.length;
        StringBuilder sb = new StringBuilder(bLen * 2);
        for (int i = 0; i < bLen; ++i) {
            int intbyte;
            for (intbyte = bytes[i]; intbyte < 0; intbyte += 256) {
            }
            if (intbyte < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intbyte, 16));
        }
        return sb.toString();
    }

    public static MessageDigest getDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String digest(String algorithmName, byte[] bytes, int iterations) {
        if (bytes == null) {
            return null;
        }
        if (iterations < 1) {
            throw new IllegalArgumentException();
        }
        MessageDigest digest = MessageDigestUtils.getDigest(algorithmName);
        for (int i = 0; i < iterations; ++i) {
            bytes = digest.digest(bytes);
        }
        return MessageDigestUtils.byte2Hex(bytes);
    }

    public static String md5(byte[] bytes, int iterations) {
        return MessageDigestUtils.digest("MD5", bytes, iterations);
    }

    public static String md5(byte[] bytes) {
        return MessageDigestUtils.md5(bytes, 1);
    }

    public static String md5(String message, int iterations) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.md5(message.getBytes(StandardCharsets.UTF_8), iterations);
    }

    public static String md5(String message) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.md5(message.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1(byte[] bytes, int iterations) {
        return MessageDigestUtils.digest("SHA1", bytes, iterations);
    }

    public static String sha1(byte[] bytes) {
        return MessageDigestUtils.sha1(bytes, 1);
    }

    public static String sha1(String message, int iterations) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.sha1(message.getBytes(StandardCharsets.UTF_8), iterations);
    }

    public static String sha1(String message) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.sha1(message.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha256(byte[] bytes, int iterations) {
        return MessageDigestUtils.digest("SHA-256", bytes, iterations);
    }

    public static String sha256(byte[] bytes) {
        return MessageDigestUtils.sha256(bytes, 1);
    }

    public static String sha256(String message, int iterations) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.sha256(message.getBytes(StandardCharsets.UTF_8), iterations);
    }

    public static String sha256(String message) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.sha256(message.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha512(byte[] bytes, int iterations) {
        return MessageDigestUtils.digest("SHA-512", bytes, iterations);
    }

    public static String sha512(byte[] bytes) {
        return MessageDigestUtils.sha512(bytes, 1);
    }

    public static String sha512(String message, int iterations) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.sha512(message.getBytes(StandardCharsets.UTF_8), iterations);
    }

    public static String sha512(String message) {
        if (message == null) {
            return null;
        }
        return MessageDigestUtils.sha512(message.getBytes(StandardCharsets.UTF_8));
    }
}

