/*
 * Decompiled with CFR 0.152.
 */
package com.github.woshikid.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtils {
    public static String toXml(Object object, String encoding, boolean fragment) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            marshaller.setProperty("jaxb.fragment", (Object)fragment);
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toXml(Object object, String encoding) {
        return XmlUtils.toXml(object, encoding, false);
    }

    public static String toXml(Document document, String encoding) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", encoding);
            ByteArrayOutputStream cache = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(cache));
            return cache.toString(encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String xml, Class<T> targetClass) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(Document document, Class<T> targetClass) {
        String xml = XmlUtils.toXml(document, "UTF-8");
        return XmlUtils.toObject(xml, targetClass);
    }

    public static Object toObject(Element element) {
        int i;
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<Node> children = new ArrayList<Node>();
        for (i = 0; i < nodeList.getLength(); ++i) {
            children.add(nodeList.item(i));
        }
        if (children.size() > 1) {
            for (i = children.size() - 1; i >= 0; --i) {
                if (((Node)children.get(i)).getNodeType() == 1) continue;
                children.remove(i);
            }
        }
        if (children.size() == 0) {
            return "";
        }
        if (children.size() == 1) {
            Node node = (Node)children.get(0);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(child.getTagName(), XmlUtils.toObject(child));
                return map;
            }
            return node.getTextContent();
        }
        Element child0 = (Element)children.get(0);
        Element child1 = (Element)children.get(1);
        if (child0.getTagName().equals(child1.getTagName())) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Node node : children) {
                Element child = (Element)node;
                list.add(XmlUtils.toObject(child));
            }
            return list;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Node node : children) {
            Element child = (Element)node;
            map.put(child.getTagName(), XmlUtils.toObject(child));
        }
        return map;
    }

    public static Object toObject(Document document) {
        return XmlUtils.toObject(document.getDocumentElement());
    }

    public static Object toObject(String xml) {
        Document document = XmlUtils.toDocument(xml);
        return XmlUtils.toObject(document);
    }

    public static Element toElement(Element element, Map<String, ?> map) {
        Document document = element.getOwnerDocument();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            Element child = document.createElement(key);
            if (value instanceof Map) {
                XmlUtils.toElement(child, (Map)value);
            } else if (value instanceof List) {
                if (key.endsWith("s")) {
                    key = key.substring(0, key.length() - 1);
                }
                XmlUtils.toElement(child, (List)value, key);
            } else {
                child.setTextContent(String.valueOf(value));
            }
            element.appendChild(child);
        }
        return element;
    }

    public static Element toElement(Element element, List<?> list, String tagName) {
        Document document = element.getOwnerDocument();
        for (Object value : list) {
            Element child = document.createElement(tagName);
            if (value instanceof Map) {
                XmlUtils.toElement(child, (Map)value);
            } else if (value instanceof List) {
                XmlUtils.toElement(child, (List)value, tagName);
            } else {
                child.setTextContent(String.valueOf(value));
            }
            element.appendChild(child);
        }
        return element;
    }

    public static Document toDocument(Map<String, ?> map, String rootName) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement(rootName);
            document.appendChild(XmlUtils.toElement(root, map));
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDocument(List<?> list, String rootName, String tagName) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement(rootName);
            document.appendChild(XmlUtils.toElement(root, list, tagName));
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDocument(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDocument(InputStream in) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDocument(byte[] data) {
        return XmlUtils.toDocument(new ByteArrayInputStream(data));
    }

    public static Document toDocument(Object object) {
        String xml = XmlUtils.toXml(object, "UTF-8");
        return XmlUtils.toDocument(xml);
    }

    public static class DateAdapter
    extends XmlAdapter<String, Date> {
        private SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public String marshal(Date date) {
            return this.formater.format(date);
        }

        public Date unmarshal(String source) throws ParseException {
            return this.formater.parse(source);
        }
    }
}

