/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StackUtils {
    public static Class<?> callerClass(Class<?> referenceClass) {
        List<String> classesInStack = StackUtils.distinctClassesInStack();
        int referenceIndex = classesInStack.indexOf(referenceClass.getName());
        String callerClassName = classesInStack.get(referenceIndex + 1);
        try {
            return Class.forName(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Unexpected exception", e);
        }
    }

    private static List<String> distinctClassesInStack() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(e -> e.getClassName()).distinct().collect(Collectors.toList());
    }

    public static Optional<String> callerMethod(Class<?> referenceClass) {
        String referenceClassName = referenceClass.getName();
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(e -> e.getClassName().equals(referenceClassName)).filter(e -> !e.getMethodName().startsWith("lambda$")).map(StackTraceElement::getMethodName).findFirst();
    }
}

