/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.files;

import com.github.writethemfirst.approvals.utils.FileUtils;
import java.nio.file.Path;
import java.util.stream.Stream;

public class ApprovalFiles {
    public final Path approved;
    public final Path received;

    private ApprovalFiles(Path approved, Path received) {
        this.approved = approved;
        this.received = received;
    }

    public static ApprovalFiles build(Path folder, String methodName, String extension) {
        return new ApprovalFiles(ApprovalFiles.buildApprovalFilePath(folder, methodName, "approved" + extension), ApprovalFiles.buildApprovalFilePath(folder, methodName, "received" + extension));
    }

    private static Path buildApprovalFilePath(Path folder, String methodName, String extension) {
        return folder.resolve(String.format("%s.%s", methodName.replaceAll(" ", "_"), extension));
    }

    private boolean areRegularFiles() {
        return this.approved.toFile().isFile() && this.received.toFile().isFile();
    }

    private ApprovalFiles associateMatchingReceivedFile(Path approvedFile) {
        if (this.areRegularFiles()) {
            return this;
        }
        Path approvedRelativePath = this.approved.relativize(approvedFile);
        Path receivedFile = this.received.resolve(approvedRelativePath);
        return new ApprovalFiles(approvedFile, receivedFile);
    }

    private ApprovalFiles associateMatchingApprovedFile(Path receivedFile) {
        if (this.areRegularFiles()) {
            return this;
        }
        Path receivedRelativePath = this.received.relativize(receivedFile);
        Path approvedFile = this.approved.resolve(receivedRelativePath);
        return new ApprovalFiles(approvedFile, receivedFile);
    }

    public boolean haveSameContent() {
        if (!this.areRegularFiles()) {
            return false;
        }
        String receivedContent = FileUtils.silentRead(this.received);
        String approvedContent = FileUtils.silentRead(this.approved);
        return receivedContent.equals(approvedContent);
    }

    public Stream<ApprovalFiles> listChildrenApprovalFiles() {
        if (this.areRegularFiles()) {
            return Stream.empty();
        }
        return Stream.concat(FileUtils.listFiles(this.approved).map(this::associateMatchingReceivedFile), FileUtils.listFiles(this.received).map(this::associateMatchingApprovedFile)).distinct();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalFiles that = (ApprovalFiles)o;
        return this.approved.equals(that.approved) && this.received.equals(that.received);
    }

    public int hashCode() {
        int result = this.approved.hashCode();
        result = 31 * result + this.received.hashCode();
        return result;
    }
}

