/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters.windows;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.reporters.windows.Command;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;

public class CommandReporter
implements Reporter {
    private final Command command;
    private final String[] arguments;
    public static final String DEFAULT_ARGUMENTS = "%received% %approved%";

    public CommandReporter(Command command) {
        this(command, DEFAULT_ARGUMENTS);
    }

    public CommandReporter(Command command, String arguments) {
        this(command, arguments.split(" "));
    }

    private CommandReporter(Command command, String ... arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    @Override
    public void mismatch(Path approved, Path received) {
        if (this.command.isAvailable()) {
            try {
                this.command.execute(this.actualArguments(approved, received));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isAvailable() {
        return this.command.isAvailable();
    }

    String[] actualArguments(Path approved, Path received) {
        return (String[])Arrays.stream(this.arguments).map(elt -> this.prepareCommandElement(approved, received, (String)elt)).toArray(String[]::new);
    }

    private String prepareCommandElement(Path approved, Path received, String elt) {
        return elt.replace("%approved%", approved.toString()).replace("%received%", received.toString());
    }
}

