/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.stream.Stream;

public class FileUtils {
    public static String silentRead(Path file) {
        try {
            return new String(Files.readAllBytes(file));
        }
        catch (IOException e) {
            System.err.println(String.format("Can't read the file located at <%s>.", file));
            return "";
        }
    }

    public static void createFileIfNeeded(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can't create an empty file at <%s>.", file), e);
            }
        }
    }

    public static void silentRemove(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            System.err.println(String.format("Can't remove the file located at <%s>.", file));
        }
    }

    public static void silentRecursiveRemove(Path path) {
        FileUtils.silentRecursiveRemove(path.toFile());
    }

    public static void silentRecursiveRemove(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            Arrays.stream(children).forEach(FileUtils::silentRecursiveRemove);
        }
        file.delete();
    }

    public static void write(String content, Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println(String.format("Can't create directories for the files located at <%s>.", file));
            throw new RuntimeException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.write(content);
        }
        catch (IOException e) {
            String message = String.format("Can't write the file located at <%s> because of <%s>.", file.toAbsolutePath(), e.getMessage());
            throw new RuntimeException(message, e);
        }
    }

    public static void copy(Path sourceFile, Path destinationFile) {
        FileUtils.write(FileUtils.silentRead(sourceFile), destinationFile);
    }

    public static void copyToFolder(Path sourceFile, Path destinationFolder) {
        Path destinationFile = destinationFolder.resolve(sourceFile.getFileName());
        FileUtils.copy(sourceFile, destinationFile);
    }

    public static Stream<Path> listFiles(Path baseDirectory) {
        int MAX_DEPTH = 5;
        try {
            return baseDirectory.toFile().isDirectory() ? Files.find(baseDirectory, 5, ($, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]) : Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can't browse directory at <%s> for files.", baseDirectory), e);
        }
    }
}

