/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import com.github.writethemfirst.approvals.utils.functions.Function1;
import com.github.writethemfirst.approvals.utils.functions.Function2;
import com.github.writethemfirst.approvals.utils.functions.Function3;
import com.github.writethemfirst.approvals.utils.functions.Function4;
import com.github.writethemfirst.approvals.utils.functions.Function5;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;

public class FunctionUtils {
    private static final Object UNSPECIFIED_ENTRY = new Object();
    private static final Iterable<Object> UNSPECIFIED = Collections.singletonList(UNSPECIFIED_ENTRY);

    public static <IN1> String applyCombinations(Iterable<IN1> args1, Function1<IN1, ?> function) {
        return FunctionUtils.applyCombinations(args1, UNSPECIFIED, (arg1, arg2) -> function.apply(arg1));
    }

    public static <IN1, IN2> String applyCombinations(Iterable<IN1> args1, Iterable<IN2> args2, Function2<IN1, IN2, ?> function) {
        return FunctionUtils.applyCombinations(args1, args2, UNSPECIFIED, (arg1, arg2, arg3) -> function.apply(arg1, arg2));
    }

    public static <IN1, IN2, IN3> String applyCombinations(Iterable<IN1> args1, Iterable<IN2> args2, Iterable<IN3> args3, Function3<IN1, IN2, IN3, ?> function) {
        return FunctionUtils.applyCombinations(args1, args2, args3, UNSPECIFIED, (arg1, arg2, arg3, arg4) -> function.apply(arg1, arg2, arg3));
    }

    public static <IN1, IN2, IN3, IN4> String applyCombinations(Iterable<IN1> args1, Iterable<IN2> args2, Iterable<IN3> args3, Iterable<IN4> args4, Function4<IN1, IN2, IN3, IN4, ?> function) {
        return FunctionUtils.applyCombinations(args1, args2, args3, args4, UNSPECIFIED, (arg1, arg2, arg3, arg4, arg5) -> function.apply(arg1, arg2, arg3, arg4));
    }

    public static <IN1, IN2, IN3, IN4, IN5> String applyCombinations(Iterable<IN1> args1, Iterable<IN2> args2, Iterable<IN3> args3, Iterable<IN4> args4, Iterable<IN5> args5, Function5<IN1, IN2, IN3, IN4, IN5, ?> function) {
        StringBuilder results = new StringBuilder();
        for (IN1 arg1 : args1) {
            for (IN2 arg2 : args2) {
                for (IN3 arg3 : args3) {
                    for (IN4 arg4 : args4) {
                        for (IN5 arg5 : args5) {
                            try {
                                results.append(function.apply(arg1, arg2, arg3, arg4, arg5));
                            }
                            catch (Exception e) {
                                results.append(e);
                            }
                            results.append(FunctionUtils.buildArgumentsString(" <== , ", ", ", "\n", arg1, arg2, arg3, arg4, arg5));
                        }
                    }
                }
            }
        }
        return results.toString();
    }

    private static String buildArgumentsString(String prefix, String delimiter, String suffix, Object ... arguments) {
        return Arrays.stream(arguments).filter(o -> o != UNSPECIFIED_ENTRY).map(Object::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }
}

