/*
 * Decompiled with CFR 0.152.
 */
package java2slice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java2slice.ClassInspector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Java2SliceMain {
    private static Logger LOGGER = Logger.getLogger(Java2SliceMain.class.getName());
    private static boolean verbose = false;

    private static String classToIceType(Class<?> clss) {
        if (String.class.isAssignableFrom(clss)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(clss)) {
            return "int";
        }
        if (BigInteger.class.isAssignableFrom(clss)) {
            return "long";
        }
        if (Long.class.isAssignableFrom(clss)) {
            return "long";
        }
        if (BigDecimal.class.isAssignableFrom(clss)) {
            return "double";
        }
        if (Double.class.isAssignableFrom(clss)) {
            return "double";
        }
        if (Boolean.class.isAssignableFrom(clss)) {
            return "bool";
        }
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "bool";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "double";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "int";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "long";
        }
        return clss.getName().replace(".", "::") + "Ice";
    }

    private static String classToIceType(ClassInspector.ClassInfo clssInfo) throws ClassNotFoundException {
        Class clss = clssInfo.getPropertyClass();
        if (List.class.isAssignableFrom(clss)) {
            Class<?> genericParamClass = clssInfo.getGenericParamClasses().get(0);
            return Java2SliceMain.classToIceType(genericParamClass) + "Sequence";
        }
        return Java2SliceMain.classToIceType(clss);
    }

    private static void printHelpAndExit(Options options, String[] args) {
        Java2SliceMain.info("args = " + Arrays.toString(args));
        new HelpFormatter().printHelp("java -jar target/java2slice-1.5-SNAPSHOT-jar-with-dependencies.jar  [OPTION]... [FILE]...", options, false);
        System.exit(1);
    }

    private static void info(String msgString) {
        LOGGER.info(msgString);
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println("Running Java2SliceMain");
        System.out.println("args = " + Arrays.toString(args));
        String currentDirectory = System.getProperty("user.dir");
        System.out.println("currentDirectory = " + currentDirectory);
        Options options = new Options();
        try {
            options.addOption(Option.builder((String)"?").desc("Print this message").longOpt("help").build());
            options.addOption(Option.builder((String)"v").desc("enable verbose output").longOpt("verbose").build());
            options.addOption(Option.builder().desc("output slice file").required().hasArg().longOpt("out-slice").build());
            options.addOption(Option.builder().desc("output converters directory").hasArg().longOpt("out-converters-dir").build());
            CommandLine line = new DefaultParser().parse(options, args);
            verbose = line.hasOption("verbose");
            if (verbose && !LOGGER.isLoggable(Level.INFO)) {
                LOGGER.setLevel(Level.INFO);
            }
            if (line.hasOption("help")) {
                Java2SliceMain.printHelpAndExit(options, args);
            }
            Object[] jars = line.getArgs();
            String jarpath = "";
            for (int i = 0; i < jars.length; ++i) {
                String jar = jars[i];
                jarpath = jarpath + jar + File.pathSeparator;
            }
            jarpath = jarpath + File.pathSeparator + Objects.toString(System.getenv("CLASSPATH"), "");
            Java2SliceMain.info("currentDirectory = " + currentDirectory);
            Java2SliceMain.info("args = " + Arrays.toString(args));
            String[] path = jarpath.split(File.pathSeparator);
            Object[] jarUrls = new URL[path.length];
            for (int i = 0; i < jarUrls.length; ++i) {
                if (path[i].startsWith("file:")) {
                    try {
                        jarUrls[i] = new URI(path[i]).toURL();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jarUrls[i] = new File(path[i]).getCanonicalFile().toURI().toURL();
            }
            String jarUrlsDeepString = Arrays.deepToString(jarUrls);
            System.out.println("jarUrlsDeepString = " + jarUrlsDeepString);
            Java2SliceMain.info("urls = " + jarUrlsDeepString);
            URLClassLoader loader = new URLClassLoader((URL[])jarUrls);
            ClassInspector inspector = new ClassInspector(loader);
            File outSliceFile = new File(line.getOptionValue("out-slice")).getCanonicalFile();
            System.out.println("outSliceFile = " + outSliceFile);
            if (verbose) {
                Java2SliceMain.info("outtSliceFile = " + outSliceFile);
                Java2SliceMain.info("jars = " + Arrays.toString(jars));
            }
            List<Class> classes = Java2SliceMain.findClasses((String[])jars, loader);
            outSliceFile.getParentFile().mkdirs();
            Java2SliceMain.writeSliceFile(outSliceFile, classes, inspector);
            File convertersDir = new File(line.getOptionValue("out-converters-dir"));
            if (verbose) {
                Java2SliceMain.info("convertersDir=" + convertersDir);
            }
            File toFile = new File(convertersDir, "converters/toice/ToIceConverters.java").getCanonicalFile();
            toFile.getParentFile().mkdirs();
            if (verbose) {
                Java2SliceMain.info("toFile=" + toFile);
            }
            Java2SliceMain.writeToIceConverters(toFile, classes, inspector);
            File fromFile = new File(convertersDir, "converters/fromice/FromIceConverters.java").getCanonicalFile();
            fromFile.getParentFile().mkdirs();
            if (verbose) {
                Java2SliceMain.info("fromFile=" + fromFile);
            }
            Java2SliceMain.writeFromIceConverters(fromFile, classes, inspector);
        }
        catch (IOException | ClassNotFoundException | ParseException ex) {
            Logger.getLogger(Java2SliceMain.class.getName()).log(Level.SEVERE, null, ex);
            Java2SliceMain.printHelpAndExit(options, args);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Java2SliceMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Java2SliceMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Java2SliceMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(Java2SliceMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(Java2SliceMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Java2SliceMain done.");
        System.out.println("");
    }

    private static List<Class> findClasses(String[] jars, URLClassLoader loader) throws ClassNotFoundException, IOException {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (int jarindex = 0; jarindex < jars.length; ++jarindex) {
            String jar = jars[jarindex];
            if (verbose) {
                Java2SliceMain.info("jar = " + (String)jar);
            }
            if (null == jar || jar.length() <= 0) continue;
            Path jarPath = FileSystems.getDefault().getPath(jar, new String[0]).toAbsolutePath();
            if (verbose) {
                Java2SliceMain.info("jarPath = " + jarPath);
            }
            ZipInputStream zip = new ZipInputStream(Files.newInputStream(jarPath, StandardOpenOption.READ));
            if (verbose) {
                Java2SliceMain.info("zip = " + zip);
            }
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (verbose) {
                    ZipEntry entryToPrint = entry;
                    Java2SliceMain.info("entry = " + entryToPrint);
                }
                String entryName = entry.getName();
                if (verbose) {
                    Java2SliceMain.info("entryName = " + entryName);
                }
                if (!entry.isDirectory() && !entryName.startsWith("META-INF") && entryName.endsWith(".class")) {
                    String fullClassName = entryName.substring(0, entryName.length() - ".class".length()).replace("/", ".");
                    if (verbose) {
                        Java2SliceMain.info("clssName=" + fullClassName);
                    }
                    Class<?> clss = loader.loadClass(fullClassName);
                    if (verbose) {
                        Java2SliceMain.info("clss=" + clss);
                    }
                    if (clss.isAnnotation() || clss.isInterface() || clss.isLocalClass() || clss.isSynthetic() || Enum.class.equals(clss)) {
                        if (verbose) {
                            Java2SliceMain.info("skipping " + clss);
                        }
                    } else {
                        classes.add(clss);
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        if (verbose) {
            ArrayList<Class> classesToPrint = classes;
            Java2SliceMain.info("classes " + classesToPrint);
        }
        ArrayList newOrderClasses = new ArrayList();
        for (Class clss : classes) {
            if (Enum.class.equals((Object)clss) || newOrderClasses.contains(clss)) continue;
            Stack stack = new Stack();
            for (Class superClass = clss.getSuperclass(); null != superClass && !newOrderClasses.contains(superClass) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
                stack.push(superClass);
            }
            while (!stack.empty()) {
                newOrderClasses.add(stack.pop());
            }
            newOrderClasses.add(clss);
        }
        classes = newOrderClasses;
        if (verbose) {
            ArrayList<Class> classesToPrint = classes;
            Java2SliceMain.info("newOrderClasses " + classesToPrint);
        }
        return classes;
    }

    private static void writeSliceFile(File outSliceFile, List<Class> classes, ClassInspector inspector) throws IllegalAccessException, IllegalArgumentException, ClassNotFoundException, SecurityException, InvocationTargetException, NoSuchMethodException, FileNotFoundException {
        try (PrintWriter slicePw = new PrintWriter(outSliceFile);){
            Object pkg;
            int j;
            String tabs;
            Object clssName;
            Object[] pkgs;
            Map<String, ClassInspector.ClassInfo> propsMap;
            Class clss;
            int i;
            slicePw.println("module java2slice {");
            for (i = 0; i < classes.size(); ++i) {
                clss = classes.get(i);
                propsMap = inspector.getProperties(clss);
                if (!verbose) continue;
                Java2SliceMain.info("propsMap = " + propsMap);
            }
            for (i = 0; i < classes.size(); ++i) {
                clss = classes.get(i);
                if (Enum.class.equals((Object)clss)) continue;
                propsMap = inspector.getProperties(clss);
                if (verbose) {
                    Java2SliceMain.info("propsMap = " + propsMap);
                }
                pkgs = clss.getName().split("[.]+");
                if (verbose) {
                    Java2SliceMain.info("pkgs = " + Arrays.toString(pkgs));
                }
                clssName = pkgs[pkgs.length - 1];
                if (verbose) {
                    Java2SliceMain.info("clssName=" + (String)clssName);
                }
                tabs = "\t";
                for (j = 0; j < pkgs.length - 1; ++j) {
                    pkg = pkgs[j];
                    slicePw.println(tabs + "module " + (String)pkg + " {");
                    tabs = tabs + "\t";
                }
                if (clss.isEnum()) {
                    Java2SliceMain.printSliceEnumValues(slicePw, tabs, (String)clssName, clss);
                } else {
                    slicePw.println(tabs + "class " + (String)clssName + "Ice;");
                    if (inspector.getSeqenceClassesNeeded().contains(clss)) {
                        slicePw.println(tabs + "sequence<" + (String)clssName + "Ice> " + (String)clssName + "IceSequence;");
                    }
                }
                for (j = 0; j < pkgs.length - 1; ++j) {
                    tabs = tabs.substring(1);
                    slicePw.println(tabs + "};");
                }
            }
            for (i = 0; i < classes.size(); ++i) {
                clss = classes.get(i);
                if (Enum.class.equals((Object)clss) || clss.isEnum()) continue;
                propsMap = inspector.getProperties(clss);
                if (verbose) {
                    Java2SliceMain.info("propsMap = " + propsMap);
                }
                pkgs = clss.getName().split("[.]+");
                if (verbose) {
                    Java2SliceMain.info("pkgs = " + Arrays.toString(pkgs));
                }
                clssName = pkgs[pkgs.length - 1];
                if (verbose) {
                    Java2SliceMain.info("clssName=" + (String)clssName);
                }
                tabs = "\t";
                for (j = 0; j < pkgs.length - 1; ++j) {
                    pkg = pkgs[j];
                    slicePw.println(tabs + "module " + (String)pkg + " {");
                    tabs = tabs + "\t";
                }
                if (!Objects.equals(Object.class, clss.getSuperclass())) {
                    slicePw.println(tabs + "class " + (String)clssName + "Ice  extends " + clss.getSuperclass().getName().replace(".", "::") + "Ice {");
                } else {
                    slicePw.println(tabs + "class " + (String)clssName + "Ice {");
                }
                tabs = tabs + "\t";
                for (Map.Entry<String, ClassInspector.ClassInfo> e : propsMap.entrySet()) {
                    Class propClass = e.getValue().getPropertyClass();
                    if (List.class.isAssignableFrom(propClass)) {
                        Method[] ma = clss.getMethods();
                        for (int j2 = 0; j2 < ma.length; ++j2) {
                            Method method = ma[j2];
                            String propname = e.getKey().substring(0, 1).toUpperCase() + e.getKey().substring(1);
                            if (!method.getName().startsWith("get" + propname)) continue;
                            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
                        }
                    }
                    if (Java2SliceMain.isRefToPrimitive(propClass)) {
                        slicePw.println(tabs + "bool " + e.getKey() + "IsNull;");
                    }
                    slicePw.println(tabs + Java2SliceMain.classToIceType(e.getValue()) + " " + e.getKey() + ";");
                }
                tabs = tabs.substring(1);
                slicePw.println(tabs + "};");
                for (j = 0; j < pkgs.length - 1; ++j) {
                    tabs = tabs.substring(1);
                    slicePw.println(tabs + "};");
                }
            }
            slicePw.println("};");
        }
    }

    private static void writeToIceConverters(File toFile, List<Class> classes, ClassInspector inspector) throws ClassNotFoundException, FileNotFoundException {
        try (PrintWriter toFilePw = new PrintWriter(toFile);){
            Map<String, ClassInspector.ClassInfo> propsMap;
            Class clss;
            toFilePw.println("package converters.toice;");
            toFilePw.println();
            toFilePw.println("import java.math.BigInteger;");
            toFilePw.println("import java.math.BigDecimal;");
            toFilePw.println("import java.util.List;");
            toFilePw.println("import java.util.ArrayList;");
            for (int i = 0; i < classes.size(); ++i) {
                clss = classes.get(i);
                if (Enum.class == clss) {
                    if (!verbose) continue;
                    Java2SliceMain.info("Skipping enum class :  " + clss);
                    continue;
                }
                propsMap = inspector.getProperties(clss);
                if (verbose) {
                    Java2SliceMain.info("propsMap = " + propsMap);
                }
                Object[] pkgs = clss.getName().split("[.]+");
                if (verbose) {
                    Java2SliceMain.info("pkgs = " + Arrays.toString(pkgs));
                }
                String clssName = pkgs[pkgs.length - 1];
                if (verbose) {
                    Java2SliceMain.info("clssName=" + clssName);
                }
                if (pkgs.length > 1) {
                    toFilePw.println("import " + clss.getCanonicalName() + ";");
                }
                toFilePw.println("import java2slice." + clss.getCanonicalName() + "Ice;");
            }
            toFilePw.println();
            toFilePw.println("public class ToIceConverters {");
            for (Class<?> seqClass : inspector.getSeqenceClassesNeeded()) {
                if (verbose) {
                    Java2SliceMain.info("seqClass = " + seqClass);
                }
                String clssName = Java2SliceMain.splitClassName(seqClass);
                toFilePw.println("\tpublic static " + clssName + "Ice[] listOf" + clssName + "ToIce(List<" + clssName + "> in) {");
                toFilePw.println("\t\t" + clssName + "Ice newArray[]= new " + clssName + "Ice[in.size()];");
                toFilePw.println("\t\tfor(int i = 0; i < in.size(); i++) {");
                toFilePw.println("\t\t\tnewArray[i] = toIce(in.get(i));");
                toFilePw.println("\t\t}");
                toFilePw.println("\t\treturn  newArray;");
                toFilePw.println("\t}");
            }
            for (int i = 0; i < classes.size(); ++i) {
                clss = classes.get(i);
                if (Enum.class == clss) {
                    if (!verbose) continue;
                    Java2SliceMain.info("Skipping enum class :  " + clss);
                    continue;
                }
                propsMap = inspector.getProperties(clss);
                if (verbose) {
                    Java2SliceMain.info("propsMap = " + propsMap);
                }
                String clssName = Java2SliceMain.splitClassName(clss);
                String toFileTabs = "\t\t";
                toFilePw.println();
                toFilePw.println("\tpublic static " + clssName + "Ice toIce(" + clssName + " in) {");
                toFilePw.println(toFileTabs + "if(null == in) {");
                toFilePw.println(toFileTabs + "\t return null;");
                toFilePw.println(toFileTabs + "}");
                if (clss.isEnum()) {
                    toFilePw.println(toFileTabs + "return " + clssName + "Ice.valueOf(in.ordinal());");
                } else {
                    List<Class> derivedClasses = Java2SliceMain.getDerivedClasses(clss, classes);
                    if (derivedClasses.size() < 2 && !Modifier.isAbstract(clss.getModifiers())) {
                        toFilePw.println(toFileTabs + "return ((in!=null)?toIce(in, new " + clssName + "Ice()):null);");
                    } else {
                        boolean addelse = false;
                        for (Class dc : derivedClasses) {
                            if (Modifier.isAbstract(dc.getModifiers())) continue;
                            String dcClssName = Java2SliceMain.splitClassName(dc);
                            toFilePw.println(toFileTabs + (addelse ? "else " : "") + "if(in instanceof " + dcClssName + ") {");
                            toFilePw.println(toFileTabs + "\treturn toIce((" + dcClssName + ")in, new " + dcClssName + "Ice());");
                            toFilePw.println(toFileTabs + "}");
                            addelse = true;
                        }
                        toFilePw.println(toFileTabs + "throw new IllegalArgumentException(in+\" is not of recognized type\");");
                    }
                    toFilePw.println("\t}");
                    toFilePw.println();
                    toFilePw.println("\tpublic static " + clssName + "Ice toIce(" + clssName + " in," + clssName + "Ice out) {");
                    toFilePw.println(toFileTabs + "if(null == in) {");
                    toFilePw.println(toFileTabs + "\t return null;");
                    toFilePw.println(toFileTabs + "}");
                    toFilePw.println(toFileTabs + "if(null == out) {");
                    toFilePw.println(toFileTabs + "\t return toIce(in);");
                    toFilePw.println(toFileTabs + "}");
                    if (!Objects.equals(Object.class, clss.getSuperclass())) {
                        String superclassName = clss.getSuperclass().getName();
                        int lastp = superclassName.lastIndexOf(46);
                        if (lastp > 0) {
                            superclassName = superclassName.substring(lastp + 1);
                        }
                        toFilePw.println(toFileTabs + "out = (" + clssName + "Ice) toIce((" + superclassName + ")in,(" + superclassName + "Ice)out);");
                    }
                    for (Map.Entry<String, ClassInspector.ClassInfo> e : propsMap.entrySet()) {
                        String propname = e.getKey().substring(0, 1).toUpperCase() + e.getKey().substring(1);
                        Class propClass = e.getValue().getPropertyClass();
                        boolean checkNull = Java2SliceMain.isRefToPrimitive(propClass);
                        if (checkNull) {
                            if (Boolean.class.isAssignableFrom(propClass)) {
                                toFilePw.println(toFileTabs + "out." + e.getKey() + "IsNull = (null == in.is" + propname + "());");
                            } else {
                                toFilePw.println(toFileTabs + "out." + e.getKey() + "IsNull = (null == in.get" + propname + "());");
                            }
                            toFilePw.println(toFileTabs + "if(!out." + e.getKey() + "IsNull) {");
                            toFileTabs = toFileTabs + "\t";
                        }
                        if (BigInteger.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.get" + propname + "().longValue();");
                        } else if (Integer.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.get" + propname + "();");
                        } else if (BigDecimal.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.get" + propname + "().doubleValue();");
                        } else if (Double.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.get" + propname + "().doubleValue();");
                        } else if (Boolean.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.is" + propname + "().booleanValue();");
                        } else if (Boolean.TYPE.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.is" + propname + "();");
                        } else if (String.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.get" + propname + "();");
                        } else if (List.class.isAssignableFrom(propClass)) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  listOf" + Java2SliceMain.splitClassName(e.getValue().getGenericParamClasses().get(0)) + "ToIce(in.get" + propname + "());");
                        } else if (propClass.isEnum()) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  toIce(in.get" + propname + "());");
                        } else if (propClass.isPrimitive()) {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  in.get" + propname + "();");
                        } else {
                            toFilePw.println(toFileTabs + "out." + e.getKey() + " =  toIce(in.get" + propname + "());");
                        }
                        if (!checkNull) continue;
                        toFileTabs = toFileTabs.substring(1);
                        toFilePw.println(toFileTabs + "}");
                    }
                    toFilePw.println(toFileTabs + "return out;");
                }
                toFileTabs = toFileTabs.substring(1);
                toFilePw.println(toFileTabs + "}");
            }
            toFilePw.println("}");
        }
    }

    private static boolean isRefToPrimitive(Class c) {
        return BigDecimal.class.isAssignableFrom(c) || BigInteger.class.isAssignableFrom(c) || Double.class.isAssignableFrom(c) || Integer.class.isAssignableFrom(c) || Boolean.class.equals((Object)c) || String.class.isAssignableFrom(c);
    }

    private static void writeFromIceConverters(File fromFile, List<Class> classes, ClassInspector inspector) throws ClassNotFoundException, FileNotFoundException {
        try (PrintWriter fromFilePw = new PrintWriter(fromFile);){
            String clssName;
            fromFilePw.println("package converters.fromice;");
            fromFilePw.println();
            fromFilePw.println("import java.math.BigInteger;");
            fromFilePw.println("import java.math.BigDecimal;");
            fromFilePw.println("import java.util.List;");
            fromFilePw.println("import java.util.ArrayList;");
            for (int i = 0; i < classes.size(); ++i) {
                Class clss = classes.get(i);
                if (Enum.class.equals((Object)clss)) continue;
                Map<String, ClassInspector.ClassInfo> propsMap = inspector.getProperties(clss);
                if (verbose) {
                    Java2SliceMain.info("propsMap = " + propsMap);
                }
                Object[] pkgs = clss.getName().split("[.]+");
                if (verbose) {
                    Java2SliceMain.info("pkgs = " + Arrays.toString(pkgs));
                }
                clssName = pkgs[pkgs.length - 1];
                if (verbose) {
                    Java2SliceMain.info("clssName=" + clssName);
                }
                if (pkgs.length > 1) {
                    fromFilePw.println("import " + clss.getCanonicalName() + ";");
                }
                fromFilePw.println("import java2slice." + clss.getCanonicalName() + "Ice;");
            }
            fromFilePw.println();
            fromFilePw.println("public class FromIceConverters  {");
            for (Class<?> seqClass : inspector.getSeqenceClassesNeeded()) {
                if (verbose) {
                    Java2SliceMain.info("seqClass = " + seqClass);
                }
                String clssName2 = Java2SliceMain.splitClassName(seqClass);
                fromFilePw.println("\tpublic static List<" + clssName2 + "> fromIce(" + clssName2 + "Ice []in) {");
                fromFilePw.println("\t\tList<" + clssName2 + "> newList= new ArrayList<>();");
                fromFilePw.println("\t\tfor(int i = 0; i < in.length; i++) {");
                fromFilePw.println("\t\t\tnewList.add(fromIce(in[i]));");
                fromFilePw.println("\t\t}");
                fromFilePw.println("\t\treturn  newList;");
                fromFilePw.println("\t}");
            }
            for (int i = 0; i < classes.size(); ++i) {
                String fromFileTabs = "\t\t";
                Class clss = classes.get(i);
                if (clss.equals(Enum.class)) continue;
                Map<String, ClassInspector.ClassInfo> propsMap = inspector.getProperties(clss);
                if (verbose) {
                    Java2SliceMain.info("propsMap = " + propsMap);
                }
                clssName = Java2SliceMain.splitClassName(clss);
                if (clss.isEnum()) {
                    fromFilePw.println("\tpublic static " + clssName + " fromIce(" + clssName + "Ice in) {");
                    fromFilePw.println("\t\treturn " + clssName + ".values()[in.value()];");
                    fromFilePw.println("\t}");
                    continue;
                }
                fromFilePw.println();
                fromFilePw.println("\tpublic static " + clssName + " fromIce(" + clssName + "Ice in) {");
                List<Class> derivedClasses = Java2SliceMain.getDerivedClasses(clss, classes);
                if (derivedClasses.size() < 2 && !Modifier.isAbstract(clss.getModifiers())) {
                    fromFilePw.println(fromFileTabs + "return ((in !=null)?fromIce(in, new " + clssName + "()):null);");
                } else {
                    boolean addelse = false;
                    for (Class dc : derivedClasses) {
                        if (Modifier.isAbstract(dc.getModifiers())) continue;
                        String dcClssName = Java2SliceMain.splitClassName(dc);
                        fromFilePw.println(fromFileTabs + (addelse ? "else " : "") + "if(in instanceof " + dcClssName + "Ice) {");
                        fromFilePw.println(fromFileTabs + "\treturn fromIce((" + dcClssName + "Ice)in,new " + dcClssName + "());");
                        fromFilePw.println(fromFileTabs + "}");
                        addelse = true;
                    }
                    fromFilePw.println(fromFileTabs + "throw new IllegalArgumentException(in+\" is not of recognized type\");");
                }
                fromFilePw.println("\t}");
                fromFilePw.println();
                fromFilePw.println("\tpublic static " + clssName + " fromIce(" + clssName + "Ice in," + clssName + " out) {");
                fromFilePw.println(fromFileTabs + "if(in == null) {");
                fromFilePw.println(fromFileTabs + "\treturn null;");
                fromFilePw.println(fromFileTabs + "}");
                fromFilePw.println(fromFileTabs + "if(out == null) {");
                fromFilePw.println(fromFileTabs + "\treturn fromIce(in);");
                fromFilePw.println(fromFileTabs + "}");
                if (!Objects.equals(Object.class, clss.getSuperclass())) {
                    String superclassName = clss.getSuperclass().getName();
                    int lastp = superclassName.lastIndexOf(46);
                    if (lastp > 0) {
                        superclassName = superclassName.substring(lastp + 1);
                    }
                    fromFilePw.println(fromFileTabs + "out = (" + clssName + ") fromIce((" + superclassName + "Ice)in,(" + superclassName + ")out);");
                }
                for (Map.Entry<String, ClassInspector.ClassInfo> e : propsMap.entrySet()) {
                    String propname = e.getKey().substring(0, 1).toUpperCase() + e.getKey().substring(1);
                    Class propClass = e.getValue().getPropertyClass();
                    boolean checkNull = Java2SliceMain.isRefToPrimitive(propClass);
                    if (checkNull) {
                        fromFilePw.println(fromFileTabs + "if(in." + e.getKey() + "IsNull) {");
                        fromFilePw.println(fromFileTabs + "\tout.set" + propname + "(null);");
                        fromFilePw.println(fromFileTabs + "} else {");
                        fromFileTabs = fromFileTabs + "\t";
                    }
                    if (BigInteger.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(BigInteger.valueOf(in." + e.getKey() + "));");
                    } else if (Integer.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(Integer.valueOf( (int) in." + e.getKey() + "));");
                    } else if (BigDecimal.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(BigDecimal.valueOf(in." + e.getKey() + "));");
                    } else if (Double.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(Double.valueOf(in." + e.getKey() + "));");
                    } else if (Boolean.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(in." + e.getKey() + ");");
                    } else if (List.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.get" + propname + "().clear();");
                        fromFilePw.println(fromFileTabs + "out.get" + propname + "().addAll(fromIce(in." + e.getKey() + "));");
                    } else if (String.class.isAssignableFrom(propClass)) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(in." + e.getKey() + ");");
                    } else if (propClass.isEnum()) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(fromIce(in." + e.getKey() + "));");
                    } else if (propClass.isPrimitive()) {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(in." + e.getKey() + ");");
                    } else {
                        fromFilePw.println(fromFileTabs + "out.set" + propname + "(fromIce(in." + e.getKey() + ",out.get" + propname + "()));");
                    }
                    if (!checkNull) continue;
                    fromFileTabs = fromFileTabs.substring(1);
                    fromFilePw.println(fromFileTabs + "}");
                }
                fromFilePw.println(fromFileTabs + "return out;");
                fromFileTabs = fromFileTabs.substring(1);
                fromFilePw.println("\t}");
            }
            fromFilePw.println("}");
        }
    }

    private static List<Class> getDerivedClasses(Class<?> clss, List<Class> fromClasses) {
        ArrayList<Class> derivedClassList = new ArrayList<Class>();
        for (Class c : fromClasses) {
            if (!clss.isAssignableFrom(c)) continue;
            derivedClassList.add(c);
        }
        ArrayList<Class> newOrderClasses = new ArrayList<Class>();
        for (Class c : derivedClassList) {
            if (newOrderClasses.contains(c)) continue;
            Stack stack = new Stack();
            for (Class<?> superClass = clss.getSuperclass(); null != superClass && !newOrderClasses.contains(superClass) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
                stack.push(superClass);
            }
            while (!stack.empty()) {
                Class clssFromStack = (Class)stack.pop();
                if (!clss.isAssignableFrom(clssFromStack)) continue;
                newOrderClasses.add(0, (Class)stack.pop());
            }
            if (!clss.isAssignableFrom(c)) continue;
            newOrderClasses.add(0, c);
        }
        if (verbose && !newOrderClasses.isEmpty()) {
            Java2SliceMain.info("getDerivedClasses(" + clss + ",...) returning " + newOrderClasses);
        }
        return newOrderClasses;
    }

    private static String splitClassName(Class clss) {
        Object[] pkgs = clss.getName().split("[.]+");
        if (verbose) {
            Java2SliceMain.info("pkgs = " + Arrays.toString(pkgs));
        }
        String clssName = pkgs[pkgs.length - 1];
        if (verbose) {
            Java2SliceMain.info("clssName=" + clssName);
        }
        return clssName;
    }

    private static void printSliceEnumValues(PrintWriter slicePw, String tabs, String clssName, Class clss) throws SecurityException, InvocationTargetException, IllegalAccessException, IllegalArgumentException, NoSuchMethodException {
        slicePw.println(tabs + "enum " + clssName + "Ice {");
        Method valuesMethod = clss.getMethod("values", new Class[0]);
        Object[] values = (Object[])valuesMethod.invoke(null, new Object[0]);
        for (int j = 0; j < values.length; ++j) {
            Object value = values[j];
            slicePw.println(tabs + "\t" + values[j].toString() + "=" + j + (j < values.length - 1 ? "," : ""));
        }
        slicePw.println(tabs + "};");
    }
}

