/*
 * Decompiled with CFR 0.152.
 */
package com.github.wshackle.java4cpp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class J4CppMain {
    public static String namespace = "JavaForCpp";
    private static Set<String> badNames = J4CppMain.getBadNames();
    public static boolean verbose = false;
    public static boolean main_completed = false;
    private static final String CLASSESPEROUTPUT = "classes-per-output";
    private static final int DEFAULT_LIMIT = 200;
    private static final String TAB_STRING = "    ";
    private static final String OBJECT_CLASS_FULL_NAME = "%OBJECT_CLASS_FULL_NAME%";
    private static final String METHOD_RETURN_GET = "%METHOD_RETURN_GET%";
    private static final String METHOD_RETURN_STORE = "%METHOD_RETURN_STORE%";
    private static final String CPP_EASY_STRING_ARRAY_METHODCPP = "cpp_easy_string_array_method.cpp";
    private static final String HEADER_CLASS_STARTH = "header_class_start.h";
    private static final String CPP_STATIC_METHODCPP = "cpp_static_method.cpp";
    private static final String JAR = "%JAR%";
    private static final String FULL_CLASS_JNI_SIGNATURE = "%FULL_CLASS_JNI_SIGNATURE%";
    private static final String METHOD_ONFAIL = "%METHOD_ONFAIL%";
    private static final String METHOD_ARGS = "%METHOD_ARGS%";
    private static final String METHOD_NAME = "%METHOD_NAME%";
    private static final String CONSTRUCTOR_ARGS = "%CONSTRUCTOR_ARGS%";
    private static final String JNI_SIGNATURE = "%JNI_SIGNATURE%";
    private static final String FULL_CLASS_NAME = "%FULL_CLASS_NAME%";
    private static final String CLASS_NAME = "%CLASS_NAME%";
    private static final String NAMESPACE = "%NAMESPACE%";
    private static final String HEADER_DEFINE = "%HEADER_DEFINE%";
    private static final String HEADER = "%HEADER%";
    private static final String[] emptypkgs = new String[0];
    private static final String TEMPLATE_COMMENT_MARK = "//%%%";
    private static final String HEADER_TEMPLATE_STARTH = "header_template_start.h";
    private static final String HEADER_TEMPLATE_ENDH = "header_template_end.h";
    private static final String CPP_TEMPLATE_STARTCPP = "cpp_template_start.cpp";
    private static final String CPP_TEMPLATE_ENDCPP = "cpp_template_end.cpp";
    private static final String CPP_START_CLASSCPP = "cpp_start_class.cpp";
    private static final String CPP_END_CLASSCPP = "cpp_end_class.cpp";
    private static final String CPP_NEWCPP = "cpp_new.cpp";
    private static final String CPP_METHODCPP = "cpp_method.cpp";

    private static String getCppPrimitiveType(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "jboolean";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "jbyte";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "jchar";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "jshort";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "jint";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "jlong";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "jfloat";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "jdouble";
        }
        if (Void.TYPE.isAssignableFrom(clss)) {
            return "void";
        }
        throw new IllegalArgumentException("getCppPrimitiveType() Class=" + clss + " not recognized.");
    }

    private static String getCppArrayType(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "jbooleanArray";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "jbyteArray";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "jcharArray";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "jshortArray";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "jintArray";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "jlongArray";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "jfloatArray";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "jdoubleArray";
        }
        return "jobjectArray";
    }

    private static String getCppEasyCallArrayType(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "jboolean *";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "jbyte *";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "jchar *";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "jshort *";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "jint *";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "jlong *";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "jfloat *";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "jdouble *";
        }
        return "jobject *";
    }

    private static String getModifiedClassName(Class cls) {
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (null != enclosingClass) {
            String en = enclosingClass.getCanonicalName();
            return en + cls.getCanonicalName().substring(en.length() + 1);
        }
        return cls.getCanonicalName();
    }

    private static String getCppRelativeName(Class<?> cls, Class<?> relClass) {
        String[] basepackages = J4CppMain.getModifiedClassName(cls).split("\\.");
        String[] packages = relClass.getCanonicalName().split("\\.");
        int i = 0;
        int index = 0;
        boolean match = true;
        for (i = 0; i < basepackages.length - 1 && i < packages.length - 1; ++i) {
            if (!packages[i].equals(basepackages[i])) {
                match = false;
                break;
            }
            index += packages[i].length() + 1;
        }
        if (match) {
            return J4CppMain.getModifiedClassName(cls).substring(index).replace(".", "::");
        }
        return "::" + namespace + "::" + J4CppMain.getModifiedClassName(cls).replace(".", "::");
    }

    private static String getCppType(Class<?> clss, Class<?> relClass) {
        if (clss.isArray()) {
            Class<?> componentType = clss.getComponentType();
            return J4CppMain.getCppArrayType(componentType);
        }
        if (clss.isPrimitive()) {
            return J4CppMain.getCppPrimitiveType(clss);
        }
        if (Void.class.isAssignableFrom(clss)) {
            return "void";
        }
        if (J4CppMain.isString(clss)) {
            return "jstring";
        }
        return J4CppMain.getCppRelativeName(clss, relClass);
    }

    private static String getEasyCallCppType(Class<?> clss, Class<?> relClass) {
        if (clss.isArray()) {
            Class<?> componentType = clss.getComponentType();
            return J4CppMain.getCppEasyCallArrayType(componentType);
        }
        if (clss.isPrimitive()) {
            return J4CppMain.getCppPrimitiveType(clss);
        }
        if (Void.class.isAssignableFrom(clss)) {
            return "void";
        }
        if (J4CppMain.isString(clss)) {
            return "const char *";
        }
        return J4CppMain.getCppRelativeName(clss, relClass);
    }

    private static String getCppModifiers(int modifiers) {
        String out = "";
        if (Modifier.isStatic(modifiers)) {
            out = out + "static ";
        }
        return out;
    }

    private static String addConstRefIndicator(Class c, String orig) {
        if (!(c.isPrimitive() || J4CppMain.isString(c) || c.isArray())) {
            return "const " + orig + " &";
        }
        return orig;
    }

    private static String classToParamNameDecl(Class<?> c, int index) {
        if (c.isArray()) {
            return J4CppMain.classToParamName(c.getComponentType()) + "Array_" + index;
        }
        return c.getSimpleName().substring(0, 1).toLowerCase() + c.getSimpleName().substring(1) + "_" + index;
    }

    private static String addCppJThis(Class c) {
        if (c.isPrimitive() || c.isArray() || J4CppMain.isString(c)) {
            return "";
        }
        return ".jthis";
    }

    private static String classToParamName(Class<?> c) {
        if (c.isArray()) {
            return J4CppMain.classToParamName(c.getComponentType()) + "Array";
        }
        return c.getSimpleName().substring(0, 1).toLowerCase() + c.getSimpleName().substring(1);
    }

    private static String classToJNISignature(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "Z";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "B";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "C";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "S";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "I";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "J";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "F";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "D";
        }
        if (Void.TYPE.isAssignableFrom(clss)) {
            return "V";
        }
        if (clss.isArray()) {
            return "[" + J4CppMain.classToJNISignature(clss.getComponentType());
        }
        if (null != clss.getEnclosingClass()) {
            String s = J4CppMain.classToJNISignature(clss.getEnclosingClass());
            String s1 = clss.getName();
            int dollarIndex = s1.indexOf(36);
            return s.substring(0, s.length() - 1) + s1.substring(dollarIndex) + ";";
        }
        return "L" + clss.getCanonicalName().replace(".", "/") + ";";
    }

    private static String getJNIParamSignature(Class<?>[] clsses) {
        return Stream.of(clsses).map(J4CppMain::classToJNISignature).collect(Collectors.joining(""));
    }

    private static String getCppParamNames(Class<?>[] clsses) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String name = J4CppMain.getParamName(clsse, i);
            sb.append(name);
            if (i >= clsses.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getCppParamNamesIn(Class<?>[] clsses) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String name = J4CppMain.getParamNameIn(clsse, i);
            sb.append(name);
            if (i >= clsses.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getParamName(Class<?> clsse, int i) {
        return J4CppMain.classToParamName(clsse) + "_" + i + J4CppMain.addCppJThis(clsse);
    }

    private static String getParamNameIn(Class<?> clsse, int i) {
        return J4CppMain.classToParamName(clsse) + "_" + i;
    }

    private static String getCppParamDeclarations(Class<?>[] clsses, Class<?> relClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String name = J4CppMain.addConstRefIndicator(clsse, J4CppMain.getCppType(clsse, relClass)) + " " + J4CppMain.classToParamNameDecl(clsse, i);
            sb.append(name);
            if (i >= clsses.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getEasyCallCppParamDeclarations(Class<?>[] clsses, Class<?> relClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String type = J4CppMain.getEasyCallCppType(clsse, relClass);
            sb.append(type);
            sb.append(' ');
            String name = "easyArg_" + i;
            sb.append(name);
            if (i < clsses.length - 1 || clsse.isArray()) {
                sb.append(',');
            }
            if (!clsse.isArray()) continue;
            sb.append("jsize ");
            sb.append(name);
            sb.append("_length");
            if (i >= clsses.length - 1) continue;
            sb.append(',');
        }
        sb.append(")");
        return sb.toString();
    }

    private static Set<String> getBadNames() {
        HashSet<String> badNamesSet = new HashSet<String>();
        badNamesSet.addAll(Arrays.asList("and", "and_eq", "bitand", "bitor", "compl", "not", "not_eq", "or", "not_eq", "or", "or_eq", "xor", "xor_eq", "delete", "namespace", "union", "cast"));
        return badNamesSet;
    }

    private static String fixMethodName(Method m) {
        Method method;
        int i;
        String mname = m.getName();
        Method[] ma = m.getDeclaringClass().getMethods();
        int index = 0;
        boolean index_incremented = false;
        boolean has_match = false;
        for (i = 0; i < ma.length; ++i) {
            method = ma[i];
            if (method.getParameterCount() > 0 && m.getParameterCount() > 0 && m.getParameterTypes()[0].isPrimitive() != method.getParameterTypes()[0].isPrimitive() || method.equals(m) || !m.getName().equals(method.getName()) || m.getParameterCount() != method.getParameterCount()) continue;
            has_match = true;
        }
        for (i = 0; i < ma.length && !(method = ma[i]).equals(m); ++i) {
            if (method.getParameterCount() != m.getParameterCount() || method.getParameterCount() > 0 && m.getParameterCount() > 0 && m.getParameterTypes()[0].isPrimitive() != method.getParameterTypes()[0].isPrimitive() || m.getParameterCount() >= 1 && String.class.isAssignableFrom(m.getParameterTypes()[0]) != String.class.isAssignableFrom(method.getParameterTypes()[0]) || !method.getName().equals(m.getName())) continue;
            ++index;
            index_incremented = true;
        }
        int start_index = 0;
        while (index_incremented) {
            index_incremented = false;
            for (int i2 = 0; i2 < ma.length; ++i2) {
                Method method2 = ma[i2];
                for (int j = start_index; j <= index; ++j) {
                    if (!method2.getName().equals(m.getName() + j) || m.getParameterCount() != method2.getParameterCount()) continue;
                    ++index;
                    index_incremented = true;
                }
            }
            start_index = index;
        }
        if (has_match) {
            mname = mname + index;
        }
        if (badNames.contains(mname)) {
            return mname + "Method";
        }
        return mname;
    }

    private static String getCppDeclaration(Method m, Class<?> relClass) {
        return J4CppMain.getCppModifiers(m.getModifiers()) + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + J4CppMain.fixMethodName(m) + J4CppMain.getCppParamDeclarations(m.getParameterTypes(), relClass) + ";";
    }

    private static String getNativeMethodCppDeclaration(Method m, Class<?> relClass) {
        return J4CppMain.getCppModifiers(m.getModifiers()) + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + J4CppMain.fixMethodName(m) + "Native" + J4CppMain.getCppParamDeclarations(m.getParameterTypes(), relClass) + ";";
    }

    private static String getCppFieldGetterDeclaration(Field f, Class<?> relClass) {
        return J4CppMain.getCppModifiers(f.getModifiers()) + J4CppMain.getCppType(f.getType(), relClass) + " " + "get" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "();";
    }

    private static String getCppFieldSetterDeclaration(Field f, Class<?> relClass) {
        return J4CppMain.getCppModifiers(f.getModifiers()) + "void set" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "(" + J4CppMain.addConstRefIndicator(f.getType(), J4CppMain.getCppType(f.getType(), relClass)) + " " + J4CppMain.classToParamNameDecl(f.getType(), 0) + ");";
    }

    private static String getCppFieldGetterDefinitionStart(String tabs, String clssOnlyName, Field f, Class<?> relClass) {
        return tabs + J4CppMain.getCppType(f.getType(), relClass) + " " + clssOnlyName + "::" + "get" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "() {";
    }

    private static String getCppFieldSetterDefinitionStart(String tabs, String clssOnlyName, Field f, Class<?> relClass) {
        return tabs + "void " + clssOnlyName + "::" + "set" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "(" + J4CppMain.addConstRefIndicator(f.getType(), J4CppMain.getCppType(f.getType(), relClass)) + " " + J4CppMain.classToParamNameDecl(f.getType(), 0) + ") {";
    }

    private static String getCppMethodDefinitionStart(String tabs, String clssOnlyName, Method m, Class<?> relClass) {
        return tabs + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + clssOnlyName + "::" + J4CppMain.fixMethodName(m) + J4CppMain.getCppParamDeclarations(m.getParameterTypes(), relClass) + " {";
    }

    private static String getEasyCallCppMethodDefinitionStart(String tabs, String clssOnlyName, Method m, Class<?> relClass) {
        return tabs + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + clssOnlyName + "::" + J4CppMain.fixMethodName(m) + J4CppMain.getEasyCallCppParamDeclarations(m.getParameterTypes(), relClass) + " {";
    }

    public static String getOnFailString(Class returnClass, Class relClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "return false;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "return (jbyte) -1;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "return (jchar) -1;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "return (jshort) -1;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "return (jint) -1;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "return (jlong) -1;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "return (jfloat) -1.0;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "return (jdouble) -1.0;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "return;";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "return;";
        }
        if (J4CppMain.isString(returnClass)) {
            return "return NULL;";
        }
        if (returnClass.isArray()) {
            return "return NULL;";
        }
        return "static " + J4CppMain.getCppRelativeName(returnClass, relClass) + " nullObject((jobject)NULL,false); return nullObject;";
    }

    private static boolean isString(Class returnClass) {
        return String.class.isAssignableFrom(returnClass);
    }

    private static boolean isPrimitiveArray(Class clss) {
        return clss.isArray() && clss.getComponentType().isPrimitive();
    }

    public static String getMethodReturnVarArrayType(Class returnClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jbooleanArray";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyteArray";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jcharArray";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshortArray";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jintArray";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlongArray";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloatArray";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdoubleArray";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jobjectArray";
        }
        return "jobjectArray";
    }

    public static String getMethodReturnVarType(Class returnClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnVarArrayType(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring";
        }
        return "jobject";
    }

    public static String getMethodReturnOutVarType(Class returnClass, Class relClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnVarArrayType(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring";
        }
        return J4CppMain.getCppType(returnClass, relClass);
    }

    public static String getMethodReturnArrayVarDeclare(Class returnClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jbooleanArray retVal=NULL;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyteArray retVal=NULL;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jcharArray retVal=NULL;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshortArray retVal=NULL;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jintArray retVal=NULL;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlongArray retVal=NULL;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloatArray retVal=NULL;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdoubleArray retVal=NULL;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jobjectArray retVal=NULL;";
        }
        return "jobjectArray retVal=NULL;";
    }

    public static String getMethodReturnVarDeclare(Class returnClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnArrayVarDeclare(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean retVal=false;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte retVal= (jbyte) -1;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar retVal= (jchar) -1;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort retVal=(jshort) -1;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint retVal= (jint) -1;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong retVal= (jlong) -1;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat retVal= (jfloat) -1.0;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble retVal= (jdouble) -1.0;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring retVal=NULL;";
        }
        return "jobject retVal=NULL;";
    }

    public static String getMethodReturnVarDeclareOut(Class returnClass, Class relClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnArrayVarDeclare(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean retVal=false;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte retVal= (jbyte) -1;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar retVal= (jchar) -1;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort retVal=(jshort) -1;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint retVal= (jint) -1;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong retVal= (jlong) -1;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat retVal= (jfloat) -1.0;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble retVal= (jdouble) -1.0;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring retVal=NULL;";
        }
        return J4CppMain.getCppType(returnClass, relClass) + " retVal((jobject)NULL,false);";
    }

    public static String getMethodCallString(Class returnClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "Boolean";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "Byte";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "Char";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "Short";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "Int";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "Long";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "Float";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "Double";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "Void";
        }
        return "Object";
    }

    private static String replaceVars(Map<String, String> map, String orig_str) {
        String key = null;
        String val = null;
        String str = orig_str;
        try {
            for (Map.Entry<String, String> e : map.entrySet()) {
                key = e.getKey();
                val = e.getValue();
                if (null == val) {
                    val = "";
                }
                str = str.replace(key, val);
            }
        }
        catch (Throwable t) {
            System.err.println("orig_str=" + orig_str);
            System.err.println("str=" + str);
            System.err.println("key=" + key);
            System.err.println("val=" + val);
            System.err.println("map=" + map);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        return str;
    }

    private static boolean isVoid(Class<?> clss) {
        return clss.equals(Void.class) || clss.equals(Void.TYPE);
    }

    private static boolean isArrayStringMethod(Method m) {
        Class<?>[] paramClasses = m.getParameterTypes();
        return paramClasses.length == 1 && paramClasses[0].isArray() && paramClasses[0].getComponentType().equals(String.class);
    }

    private static boolean checkClass(Class<?> clss, List<Class> classes) {
        boolean ret;
        Class<?> componentClass = clss.getComponentType();
        boolean bl = ret = J4CppMain.isString(clss) || clss.equals(Object.class) || clss.isPrimitive() || clss.isArray() && null != componentClass && !componentClass.isArray() && J4CppMain.checkClass(componentClass, classes) || classes.contains(clss);
        if (!ret && verbose) {
            if (clss.isArray()) {
                System.out.println("checkClass skipping " + clss + " component " + clss.getComponentType());
            } else {
                System.out.println("checkClass skipping " + clss);
            }
        }
        return ret;
    }

    private static boolean checkParameters(Class[] paramTypes, List<Class> classes) {
        for (Class paramType : paramTypes) {
            if (J4CppMain.checkClass(paramType, classes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkMethod(Method m, List<Class> classes) {
        if (m.getDeclaringClass().getName().equals(m.getName())) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " method same as classname.");
            }
            return false;
        }
        if (m.getDeclaringClass().getName().endsWith("." + m.getName())) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " method same as classname.");
            }
            return false;
        }
        if (m.isSynthetic()) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " isSynthetic.");
            }
            return false;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " not public");
            }
            return false;
        }
        if (!J4CppMain.checkClass(m.getReturnType(), classes)) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " return type not in classes list.");
            }
            return false;
        }
        boolean ret = J4CppMain.checkParameters(m.getParameterTypes(), classes);
        if (!ret && verbose) {
            System.out.println("checkMethod skipping " + m + " a parameter type is not in classes list");
        }
        return ret;
    }

    public static boolean isAddableClass(Class<?> clss, Set<Class> excludedClasses) {
        if (clss.isArray() || clss.isSynthetic() || clss.isAnnotation() || clss.isPrimitive()) {
            return false;
        }
        String canonicalName = null;
        try {
            canonicalName = clss.getCanonicalName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == canonicalName) {
            return false;
        }
        if (canonicalName.indexOf(36) >= 0) {
            return false;
        }
        String[] pkgNames = clss.getCanonicalName().split("\\.");
        for (int i = 0; i < pkgNames.length; ++i) {
            String pkgName = pkgNames[i];
            if (!badNames.contains(pkgName)) continue;
            return false;
        }
        Method[] ma = null;
        try {
            ma = clss.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == ma) {
            return false;
        }
        return !excludedClasses.contains(clss);
    }

    private static boolean isMethodToMakeEasy(Method m) {
        return !Modifier.isStatic(m.getModifiers()) && Arrays.stream(m.getParameterTypes()).anyMatch(t -> t.isArray() || J4CppMain.isString(t)) && Arrays.stream(m.getParameterTypes()).noneMatch(t -> t.isArray() && !t.getComponentType().isPrimitive());
    }

    private static boolean isConstructorToMakeEasy(Constructor c, Class relClss) {
        return Arrays.stream(c.getParameterTypes()).anyMatch(t -> t.isArray() || J4CppMain.isString(t)) && Arrays.stream(c.getParameterTypes()).noneMatch(t -> t.isArray() && !t.getComponentType().isPrimitive());
    }

    private static String getCppClassName(Class clss) {
        String clssName = clss.getCanonicalName();
        String[] pkgs = clssName.split("\\.");
        String clssOnlyName = pkgs[pkgs.length - 1];
        Class<?> enclosingClass = clss.getEnclosingClass();
        if (enclosingClass != null) {
            String enclosingClassName = enclosingClass.getCanonicalName();
            String[] enclosingPkgs = enclosingClassName.split("\\.");
            String enclosingName = enclosingPkgs[enclosingPkgs.length - 1];
            clssOnlyName = enclosingName + clssOnlyName;
        }
        return clssOnlyName;
    }

    private static String getEasyCallCppDeclaration(Method m, Class<?> relClass) {
        return J4CppMain.getCppModifiers(m.getModifiers()) + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + J4CppMain.fixMethodName(m) + J4CppMain.getEasyCallCppParamDeclarations(m.getParameterTypes(), relClass) + ";";
    }

    public static boolean hasNoArgConstructor(Constructor[] constructors) {
        for (Constructor c : constructors) {
            if (!Modifier.isProtected(c.getModifiers()) && !Modifier.isPublic(c.getModifiers()) || c.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean addGetterMethod(Field f, Class clss, List<Class> classes) {
        if (!Modifier.isPublic(f.getModifiers())) {
            return false;
        }
        if (!(f.getType().isPrimitive() || String.class.equals(f.getType()) || classes.contains(f.getType()))) {
            return false;
        }
        Method[] ma = clss.getMethods();
        for (int i = 0; i < ma.length; ++i) {
            Method method = ma[i];
            if (method.getName().equalsIgnoreCase(f.getName())) {
                return false;
            }
            if (method.getName().equalsIgnoreCase("get" + f.getName())) {
                return false;
            }
            if (!method.getName().equalsIgnoreCase("set" + f.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean addSetterMethod(Field f, Class clss, List<Class> classes) {
        if (!Modifier.isPublic(f.getModifiers())) {
            return false;
        }
        if (!(f.getType().isPrimitive() || String.class.equals(f.getType()) || classes.contains(f.getType()))) {
            return false;
        }
        if (Modifier.isFinal(f.getModifiers())) {
            return false;
        }
        Method[] ma = clss.getMethods();
        for (int i = 0; i < ma.length; ++i) {
            Method method = ma[i];
            if (method.getName().equalsIgnoreCase(f.getName())) {
                return false;
            }
            if (method.getName().equalsIgnoreCase("get" + f.getName())) {
                return false;
            }
            if (!method.getName().equalsIgnoreCase("set" + f.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getHomeDir() throws IOException {
        String userHomeProp = System.getProperty("user.home");
        if (verbose) {
            System.out.println("userDirProp = " + userHomeProp);
        }
        String homeDir = new File(userHomeProp).getCanonicalPath();
        if (verbose) {
            System.out.println("homeDir = " + homeDir);
        }
        return homeDir;
    }

    public static String getCurrentDir() throws IOException {
        String userDirProp = System.getProperty("user.dir");
        if (verbose) {
            System.out.println("userDirProp = " + userDirProp);
        }
        String currentDir = new File(userDirProp).getCanonicalPath();
        if (verbose) {
            System.out.println("currentDir = " + currentDir);
        }
        return currentDir.replace("\\", "\\\\");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        void var25_152;
        String clssName;
        void var25_150;
        Object e52;
        void var23_134;
        String header_file_base;
        Class<Object> superClass;
        URLClassLoader cl;
        main_completed = false;
        Options options = new Options();
        options.addOption(Option.builder("?").desc("Print this message").longOpt("help").build());
        options.addOption(Option.builder("n").hasArg().desc("C++ namespace for newly generated classes.").longOpt("namespace").build());
        options.addOption(Option.builder("c").hasArgs().desc("Single Java class to extract.").longOpt("classes").build());
        options.addOption(Option.builder("p").hasArgs().desc("Java Package prefix to extract").longOpt("packages").build());
        options.addOption(Option.builder("o").hasArg().desc("Output C++ source file.").longOpt("output").build());
        options.addOption(Option.builder("j").hasArg().desc("Input jar file").longOpt("jar").build());
        options.addOption(Option.builder("h").hasArg().desc("Output C++ header file.").longOpt("header").build());
        options.addOption(Option.builder("l").hasArg().desc("Maximum limit on classes to extract from jars.[default=200]").longOpt("limit").build());
        options.addOption(Option.builder("v").desc("enable verbose output").longOpt("verbose").build());
        options.addOption(Option.builder().hasArg().desc("Classes per output file.[default=10]").longOpt(CLASSESPEROUTPUT).build());
        options.addOption(Option.builder().hasArgs().desc("Comma seperated list of nativeclass=javaclass native where nativeclass will be generated as an extension/implementation of the java class.").longOpt("natives").build());
        options.addOption(Option.builder().hasArg().desc("library name for System.loadLibrary(...) for native extension classes").longOpt("loadlibname").build());
        String output = null;
        String header = null;
        String jar = null;
        HashSet<String> classnamesToFind = null;
        HashSet<String> packageprefixes = null;
        String loadlibname = null;
        HashMap<String, String> nativesNameMap = null;
        HashMap<String, Object> nativesClassMap = null;
        int limit = 200;
        int classes_per_file = 10;
        ArrayList<Class> classes = new ArrayList<Class>();
        String limitstring = Integer.toString(limit);
        try {
            System.out.println("args = " + Arrays.toString(args));
            CommandLine line = new DefaultParser().parse(options, args);
            loadlibname = line.getOptionValue("loadlibname");
            verbose = line.hasOption("verbose");
            if (line.hasOption(CLASSESPEROUTPUT)) {
                String cpoStr = line.getOptionValue(CLASSESPEROUTPUT);
                try {
                    int cpoI;
                    classes_per_file = cpoI = Integer.valueOf(cpoStr).intValue();
                }
                catch (Exception e3) {
                    System.err.println("Option for classes-per-output=\"" + cpoStr + "\"");
                    J4CppMain.printHelpAndExit(options, args);
                }
            }
            if (line.hasOption("natives")) {
                Object[] natives = line.getOptionValues("natives");
                if (verbose) {
                    System.out.println("natives = " + Arrays.toString(natives));
                }
                nativesNameMap = new HashMap<String, String>();
                nativesClassMap = new HashMap<String, Object>();
                for (int i2 = 0; i2 < natives.length; ++i2) {
                    void var20_38;
                    int eq_index = ((String)natives[i2]).indexOf(61);
                    String string = ((String)natives[i2]).substring(0, eq_index).trim();
                    String javaClassName = ((String)natives[i2]).substring(eq_index + 1).trim();
                    Object var20_39 = null;
                    try {
                        Class<?> clazz = Class.forName(javaClassName);
                    }
                    catch (ClassNotFoundException e4) {
                        System.err.println("Class for " + javaClassName + " not found. (It may be found later in jar if specified.)");
                    }
                    nativesNameMap.put(javaClassName, string);
                    if (var20_38 == null) continue;
                    nativesClassMap.put(string, var20_38);
                    if (classes.contains(var20_38)) continue;
                    classes.add((Class)var20_38);
                }
            }
            jar = line.getOptionValue("jar", jar);
            if (verbose) {
                System.out.println("jar = " + jar);
            }
            if (null != jar) {
                if (jar.startsWith("~/")) {
                    jar = new File(new File(J4CppMain.getHomeDir()), jar.substring(2)).getCanonicalPath();
                }
                if (jar.startsWith("./")) {
                    jar = new File(new File(J4CppMain.getCurrentDir()), jar.substring(2)).getCanonicalPath();
                }
                if (jar.startsWith("../")) {
                    jar = new File(new File(J4CppMain.getCurrentDir()).getParentFile(), jar.substring(3)).getCanonicalPath();
                }
            }
            if (line.hasOption("classes")) {
                classnamesToFind = new HashSet<String>();
                Object[] classStrings = line.getOptionValues("classes");
                if (verbose) {
                    System.out.println("classStrings = " + Arrays.toString(classStrings));
                }
                classnamesToFind.addAll(Arrays.asList(classStrings));
                if (verbose) {
                    System.out.println("classnamesToFind = " + classnamesToFind);
                }
            }
            namespace = line.getOptionValue("namespace", namespace);
            if (verbose) {
                System.out.println("namespace = " + namespace);
            }
            if (null != namespace) {
                output = namespace + ".cpp";
            }
            output = line.getOptionValue("output", output);
            if (verbose) {
                System.out.println("output = " + output);
            }
            if (null != output) {
                if (output.startsWith("~/")) {
                    output = System.getProperty("user.home") + output.substring(1);
                }
                header = output.substring(0, output.lastIndexOf(46)) + ".h";
            } else {
                output = "out.cpp";
            }
            header = line.getOptionValue("header", header);
            if (verbose) {
                System.out.println("header = " + header);
            }
            if (null != header) {
                if (header.startsWith("~/")) {
                    header = System.getProperty("user.home") + header.substring(1);
                }
            } else {
                header = "out.h";
            }
            if (line.hasOption("packages")) {
                packageprefixes = new HashSet<String>();
                packageprefixes.addAll(Arrays.asList(line.getOptionValues("packages")));
            }
            if (line.hasOption("limit")) {
                limitstring = line.getOptionValue("limit", Integer.toString(200));
                limit = Integer.valueOf(limitstring);
            }
            if (line.hasOption("help")) {
                J4CppMain.printHelpAndExit(options, args);
            }
        }
        catch (ParseException exp) {
            if (verbose) {
                System.out.println("Unexpected exception:" + exp.getMessage());
            }
            J4CppMain.printHelpAndExit(options, args);
        }
        HashSet<Class> excludedClasses = new HashSet<Class>();
        excludedClasses.add(Object.class);
        excludedClasses.add(String.class);
        excludedClasses.add(Void.TYPE);
        excludedClasses.add(Void.class);
        excludedClasses.add(Class.class);
        excludedClasses.add(Enum.class);
        TreeSet<String> packagesSet = new TreeSet<String>();
        if (null != jar && jar.length() > 0) {
            void var20_42;
            Path jarPath = FileSystems.getDefault().getPath(jar, new String[0]);
            ZipInputStream zip = new ZipInputStream(Files.newInputStream(jarPath, StandardOpenOption.READ));
            URL[] uRLArray = new URL[]{new URL("jar:file:" + jar + "!/")};
            cl = URLClassLoader.newInstance(uRLArray);
            ZipEntry zipEntry = zip.getNextEntry();
            while (var20_42 != null) {
                block240: {
                    if (!var20_42.isDirectory() && var20_42.getName().endsWith(".class")) {
                        String entryName = var20_42.getName();
                        if (verbose) {
                            System.out.println("entryName = " + entryName);
                        }
                        if (entryName.indexOf(36) < 0) {
                            String classFileName = var20_42.getName().replace('/', '.');
                            String string = classFileName.substring(0, classFileName.length() - ".class".length());
                            if (classnamesToFind != null && classnamesToFind.size() > 0 && !classnamesToFind.contains(string)) {
                                if (verbose) {
                                    System.out.println("skipping className=" + string + " because it does not found in=" + classnamesToFind);
                                }
                            } else {
                                try {
                                    Package package_;
                                    Class<?> clss = cl.loadClass(string);
                                    if (null != nativesClassMap && null != nativesNameMap && nativesNameMap.containsKey(string)) {
                                        nativesClassMap.put((String)nativesNameMap.get(string), clss);
                                        if (!classes.contains(clss)) {
                                            classes.add(clss);
                                        }
                                    }
                                    if (packageprefixes != null && packageprefixes.size() > 0) {
                                        if (null == clss.getPackage()) break block240;
                                        String string2 = clss.getPackage().getName();
                                        if (packageprefixes.stream().noneMatch(prefix -> pkgName.startsWith((String)prefix))) break block240;
                                    }
                                    if (null != (package_ = clss.getPackage())) {
                                        packagesSet.add(clss.getPackage().getName());
                                    }
                                    if (!classes.contains(clss) && J4CppMain.isAddableClass(clss, excludedClasses)) {
                                        classes.add(clss);
                                    }
                                }
                                catch (ClassNotFoundException | NoClassDefFoundError ex) {
                                    System.err.println("Caught " + ex.getClass().getName() + ":" + ex.getMessage() + " for className=" + string + ", entryName=" + entryName + ", jarPath=" + jarPath);
                                }
                            }
                        }
                    }
                }
                ZipEntry zipEntry2 = zip.getNextEntry();
            }
        }
        if (null != classnamesToFind) {
            if (verbose) {
                System.out.println("Checking classnames arguments");
            }
            for (String classname : classnamesToFind) {
                void var20_48;
                if (verbose) {
                    System.out.println("classname = " + classname);
                }
                if (null == classname || classname.length() <= 0) continue;
                URL uRL = new URL("file://" + System.getProperty("user.dir") + "/");
                if (verbose) {
                    System.out.println("url = " + uRL);
                }
                cl = URLClassLoader.newInstance(new URL[]{uRL});
                Class<?> clazz = cl.loadClass(classname);
                if (verbose) {
                    System.out.println("c = " + clazz);
                }
                if (null == clazz) {
                    Class<?> clazz2 = ClassLoader.getSystemClassLoader().loadClass(classname);
                }
                if (null == var20_48) continue;
                classes.add((Class)var20_48);
            }
            if (verbose) {
                System.out.println("Finished checking classnames arguments");
            }
        }
        if (!(classes != null && classes.size() >= 1 || null != nativesClassMap && nativesClassMap.keySet().size() >= 1)) {
            System.err.println("No Classes specified or found.");
            System.exit(1);
        }
        if (verbose) {
            System.out.println("Classes found = " + classes.size());
        }
        if (classes.size() > limit) {
            System.err.println("limit=" + limit);
            System.err.println("Too many classes please use -c or -p options to limit classes or -l to increase limit.");
            if (verbose) {
                System.out.println("packagesSet = " + packagesSet);
            }
            System.exit(1);
        }
        ArrayList newClasses = new ArrayList();
        for (Class clazz : classes) {
            for (superClass = clazz.getSuperclass(); null != superClass && !classes.contains(superClass) && !newClasses.contains(superClass) && J4CppMain.isAddableClass(superClass, excludedClasses); superClass = superClass.getSuperclass()) {
                newClasses.add(superClass);
            }
            for (Field field : clazz.getDeclaredFields()) {
                Class<?> fClass;
                if (!Modifier.isPublic(field.getModifiers()) || classes.contains(fClass = field.getType()) || newClasses.contains(fClass) || !J4CppMain.isAddableClass(fClass, excludedClasses)) continue;
                newClasses.add(fClass);
            }
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isSynthetic() || !Modifier.isPublic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
                Class<?> retType = method.getReturnType();
                if (verbose) {
                    System.out.println("Checking dependancies for Method = " + method);
                }
                if (!classes.contains(retType) && !newClasses.contains(retType) && J4CppMain.isAddableClass(retType, excludedClasses)) {
                    newClasses.add(retType);
                    for (superClass = retType.getSuperclass(); null != superClass && !classes.contains(superClass) && !newClasses.contains(superClass) && J4CppMain.isAddableClass(superClass, excludedClasses); superClass = superClass.getSuperclass()) {
                        newClasses.add(superClass);
                    }
                }
                for (Class<?> paramType : method.getParameterTypes()) {
                    if (classes.contains(paramType) || newClasses.contains(paramType) || !J4CppMain.isAddableClass(paramType, excludedClasses)) continue;
                    newClasses.add(paramType);
                    for (superClass = paramType.getSuperclass(); !(null == superClass || classes.contains(superClass) || newClasses.contains(superClass) || excludedClasses.contains(superClass)); superClass = superClass.getSuperclass()) {
                        newClasses.add(superClass);
                    }
                }
            }
        }
        if (null != nativesClassMap) {
            for (Class clazz : nativesClassMap.values()) {
                if (null == clazz) continue;
                for (superClass = clazz.getSuperclass(); !(null == superClass || classes.contains(superClass) || newClasses.contains(superClass) || excludedClasses.contains(superClass)); superClass = superClass.getSuperclass()) {
                    newClasses.add(superClass);
                }
            }
        }
        if (verbose) {
            System.out.println("Dependency classes needed = " + newClasses.size());
        }
        classes.addAll(newClasses);
        ArrayList newOrderClasses = new ArrayList();
        for (Class clss : classes) {
            void var20_54;
            if (newOrderClasses.contains(clss)) continue;
            Class clazz = clss.getSuperclass();
            Stack<void> stack = new Stack<void>();
            while (null != var20_54 && !newOrderClasses.contains(var20_54) && !var20_54.equals(Object.class)) {
                stack.push(var20_54);
                Class clazz3 = var20_54.getSuperclass();
            }
            while (!stack.empty()) {
                newOrderClasses.add(stack.pop());
            }
            newOrderClasses.add(clss);
        }
        classes = newOrderClasses;
        if (verbose) {
            System.out.println("Total number of classes = " + classes.size());
            System.out.println("classes = " + classes);
        }
        String string = header.substring(0, header.lastIndexOf(46)) + "_fwd.h";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(JAR, jar != null ? jar : "");
        map.put("%CLASSPATH_PREFIX%", J4CppMain.getCurrentDir() + (jar != null ? File.pathSeparator + jar : ""));
        map.put("%FORWARD_HEADER%", string);
        map.put(HEADER, header);
        map.put("%PATH_SEPERATOR%", File.pathSeparator);
        String string3 = "";
        String headerDefine = string.substring(Math.max(0, string.indexOf(File.separator))).replace(".", "_");
        map.put(HEADER_DEFINE, headerDefine);
        map.put(NAMESPACE, namespace);
        if (null != nativesClassMap) {
            for (Map.Entry entry : nativesClassMap.entrySet()) {
                Class javaClass = (Class)entry.getValue();
                String string4 = (String)entry.getKey();
                PrintWriter pw = new PrintWriter(new FileWriter(string4 + ".java"));
                Throwable throwable = null;
                try {
                    Method[] ma;
                    if (javaClass.isInterface()) {
                        pw.println("public class " + string4 + " implements " + javaClass.getCanonicalName() + ", AutoCloseable{");
                    } else {
                        pw.println("public class " + string4 + " extends " + javaClass.getCanonicalName() + " implements AutoCloseable{");
                    }
                    if (null != loadlibname && loadlibname.length() > 0) {
                        pw.println("    static {");
                        pw.println("        System.loadLibrary(\"" + loadlibname + "\");");
                        pw.println("    }");
                        pw.println();
                    }
                    pw.println("    public " + string4 + "() {");
                    pw.println("    }");
                    pw.println();
                    pw.println("    private long nativeAddress=0;");
                    pw.println("    private boolean nativeDeleteOnClose=false;");
                    pw.println();
                    pw.println("    protected " + string4 + "(final long nativeAddress) {");
                    pw.println("        this.nativeAddress = nativeAddress;");
                    pw.println("    }");
                    pw.println("    private native void nativeDelete();");
                    pw.println();
                    pw.println("    @Override");
                    pw.println("    public synchronized void  close() {");
                    pw.println("        nativeDelete();");
                    pw.println("    }");
                    pw.println();
                    pw.println("    protected void finalizer() {");
                    pw.println("        close();");
                    pw.println("    }");
                    pw.println();
                    for (Method m : ma = javaClass.getDeclaredMethods()) {
                        int modifiers = m.getModifiers();
                        if (!Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || m.isDefault() || m.isSynthetic()) continue;
                        pw.println();
                        pw.println("    @Override");
                        pw.println("    native public " + m.getReturnType().getCanonicalName() + " " + m.getName() + "(" + IntStream.range(0, m.getParameterCount()).mapToObj(i -> m.getParameterTypes()[i].getCanonicalName() + " param" + i).collect(Collectors.joining(",")) + ");");
                    }
                    pw.println("}");
                }
                catch (Throwable ma) {
                    throwable = ma;
                    throw ma;
                }
                finally {
                    if (pw == null) continue;
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable ma) {
                            throwable.addSuppressed(ma);
                        }
                        continue;
                    }
                    pw.close();
                }
            }
        }
        Throwable throwable = null;
        try (PrintWriter pw = new PrintWriter(new FileWriter(string));){
            void var20_58;
            void var25_147;
            String string5 = "";
            J4CppMain.processTemplate(pw, map, "header_fwd_template_start.h", string5);
            Class lastClass = null;
            boolean bl = false;
            while (var25_147 < classes.size()) {
                Class clss = (Class)classes.get((int)var25_147);
                String clssOnlyName = J4CppMain.getCppClassName(clss);
                String string7 = J4CppMain.openClassNamespace(clss, pw, (String)var20_58, lastClass);
                string7 = string7 + TAB_STRING;
                pw.println(string7 + "class " + clssOnlyName + ";");
                String string8 = string7.substring(0, string7.length() - 1);
                Class nextClass = var25_147 < classes.size() - 1 ? (Class)classes.get((int)(var25_147 + true)) : null;
                String string9 = J4CppMain.closeClassNamespace(clss, pw, string8, nextClass);
                lastClass = clss;
                ++var25_147;
            }
            J4CppMain.processTemplate(pw, map, "header_fwd_template_end.h", (String)var20_58);
        }
        catch (Throwable lastClass) {
            Throwable throwable2 = lastClass;
            throw lastClass;
        }
        headerDefine = header.substring(Math.max(0, header.indexOf(File.separator))).replace(".", "_");
        map.put(HEADER_DEFINE, headerDefine);
        map.put(NAMESPACE, namespace);
        if (classes_per_file < 1) {
            classes_per_file = classes.size();
        }
        int num_class_segments = classes.size() > 1 ? (classes.size() + classes_per_file - 1) / classes_per_file : 1;
        String string10 = "%d";
        if (num_class_segments > 10) {
            String string11 = "%02d";
        }
        if (num_class_segments > 100) {
            String string12 = "%03d";
        }
        if ((header_file_base = header).endsWith(".h")) {
            header_file_base = header_file_base.substring(0, header_file_base.length() - 2);
        } else if (header_file_base.endsWith(".hh")) {
            header_file_base = header_file_base.substring(0, header_file_base.length() - 3);
        } else if (header_file_base.endsWith(".hpp")) {
            header_file_base = header_file_base.substring(0, header_file_base.length() - 4);
        }
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(header));){
            String string13 = "";
            J4CppMain.processTemplate(printWriter, map, HEADER_TEMPLATE_STARTH, string13);
            for (int segment_index2 = 0; segment_index2 < num_class_segments; ++segment_index2) {
                String header_segment_file = header_file_base + String.format((String)var23_134, segment_index2) + ".h";
                printWriter.println("#include \"" + header_segment_file + "\"");
            }
            if (null != nativesClassMap) {
                String string14 = TAB_STRING;
                for (Object e52 : nativesClassMap.entrySet()) {
                    void var20_65;
                    Class javaClass = (Class)e52.getValue();
                    String nativeClassName = (String)e52.getKey();
                    printWriter.println();
                    printWriter.println((String)var20_65 + "class " + nativeClassName + "Context;");
                    printWriter.println();
                    map.put(CLASS_NAME, nativeClassName);
                    map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                    map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                    J4CppMain.processTemplate(printWriter, map, HEADER_CLASS_STARTH, (String)var20_65);
                    String string15 = (String)var20_65 + TAB_STRING;
                    printWriter.println(string15 + nativeClassName + "Context *context;");
                    printWriter.println(string15 + nativeClassName + "();");
                    printWriter.println(string15 + "~" + nativeClassName + "();");
                    Method[] methods = javaClass.getDeclaredMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        int n = method.getModifiers();
                        if (!Modifier.isPublic(n) || !Modifier.isAbstract(n) || !Modifier.isPublic(n) || Modifier.isStatic(n) || method.isDefault() || method.isSynthetic()) continue;
                        printWriter.println(string15 + J4CppMain.getNativeMethodCppDeclaration(method, javaClass));
                    }
                    printWriter.println(string15 + "void initContext(" + nativeClassName + "Context *ctx,bool isref);");
                    printWriter.println(string15 + "void deleteContext();");
                    String string16 = string15.substring(TAB_STRING.length());
                    printWriter.println(string16 + "}; // end class " + nativeClassName);
                }
            }
            String string17 = "";
            J4CppMain.processTemplate(printWriter, map, HEADER_TEMPLATE_ENDH, string17);
        }
        boolean bl = false;
        while (var25_150 < num_class_segments) {
            String header_segment_file = header_file_base + String.format((String)var23_134, (int)var25_150) + ".h";
            PrintWriter pw3 = new PrintWriter(new FileWriter(header_segment_file));
            e52 = null;
            try {
                String string18 = "";
                pw3.println("// Never include this file (" + header_segment_file + ") directly. include " + header + " instead.");
                pw3.println();
                Class lastClass = null;
                void start_segment_index = var25_150 * classes_per_file;
                int end_segment_index = Math.min((int)(var25_150 * classes_per_file + classes_per_file), classes.size());
                List classesSegList = classes.subList((int)start_segment_index, end_segment_index);
                pw3.println();
                pw3.println(string18 + "// start_segment_index = " + (int)start_segment_index);
                pw3.println(string18 + "// start_segment_index = " + end_segment_index);
                pw3.println(string18 + "// segment_index = " + (int)var25_150);
                pw3.println(string18 + "// classesSegList=" + classesSegList);
                pw3.println();
                for (int class_index = 0; class_index < classesSegList.size(); ++class_index) {
                    void var20_72;
                    Class clazz = (Class)classesSegList.get(class_index);
                    pw3.println();
                    pw3.println((String)var20_72 + "// class_index = " + class_index + " clss=" + clazz);
                    pw3.println();
                    clssName = clazz.getCanonicalName();
                    String string19 = J4CppMain.openClassNamespace(clazz, pw3, (String)var20_72, lastClass);
                    String clssOnlyName = J4CppMain.getCppClassName(clazz);
                    map.put(CLASS_NAME, clssOnlyName);
                    map.put("%BASE_CLASS_FULL_NAME%", J4CppMain.classToCppBase(clazz));
                    map.put(OBJECT_CLASS_FULL_NAME, J4CppMain.getCppRelativeName(Object.class, clazz));
                    String string20 = string19 + TAB_STRING;
                    J4CppMain.processTemplate(pw3, map, HEADER_CLASS_STARTH, string20);
                    String string21 = string20 + TAB_STRING;
                    Constructor[] constructors = clazz.getDeclaredConstructors();
                    if (!J4CppMain.hasNoArgConstructor(constructors)) {
                        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) {
                            pw3.println(string21 + "private:");
                            pw3.println(string21 + clssOnlyName + "() {};");
                            pw3.println(string21 + "public:");
                        } else {
                            if (constructors.length > 0) {
                                pw3.println(string21 + "protected:");
                            }
                            pw3.println(string21 + clssOnlyName + "();");
                            if (constructors.length > 0) {
                                pw3.println(string21 + "public:");
                            }
                        }
                    }
                    for (Constructor c : constructors) {
                        if (c.getParameterCount() == 0 && Modifier.isProtected(c.getModifiers())) {
                            pw3.println(string21 + "protected:");
                            pw3.println(string21 + clssOnlyName + "();");
                            pw3.println(string21 + "public:");
                        }
                        if (J4CppMain.checkConstructor(c, clazz, classes) || c.getParameterCount() == 1 && clazz.isAssignableFrom(c.getParameterTypes()[0]) || !Modifier.isPublic(c.getModifiers()) || c.getParameterTypes().length == 1 && c.getParameterTypes()[0].getName().equals(clazz.getName()) || !J4CppMain.checkParameters(c.getParameterTypes(), classes)) continue;
                        pw3.println(string21 + clssOnlyName + J4CppMain.getCppParamDeclarations(c.getParameterTypes(), clazz) + ";");
                        if (!J4CppMain.isConstructorToMakeEasy(c, clazz)) continue;
                        pw3.println(string21 + clssOnlyName + J4CppMain.getEasyCallCppParamDeclarations(c.getParameterTypes(), clazz) + ";");
                    }
                    pw3.println(string21 + "~" + clssOnlyName + "();");
                    Field[] fa = clazz.getDeclaredFields();
                    for (int findex = 0; findex < fa.length; ++findex) {
                        Field field = fa[findex];
                        if (J4CppMain.addGetterMethod(field, clazz, classes)) {
                            pw3.println(string21 + J4CppMain.getCppFieldGetterDeclaration(field, clazz));
                        }
                        if (!J4CppMain.addSetterMethod(field, clazz, classes)) continue;
                        pw3.println(string21 + J4CppMain.getCppFieldSetterDeclaration(field, clazz));
                    }
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        if (!J4CppMain.checkMethod(method, classes)) continue;
                        if ((method.getModifiers() & 1) == 1) {
                            pw3.println(string21 + J4CppMain.getCppDeclaration(method, clazz));
                        }
                        if (J4CppMain.isArrayStringMethod(method)) {
                            pw3.println(string21 + J4CppMain.getCppModifiers(method.getModifiers()) + J4CppMain.getCppType(method.getReturnType(), clazz) + " " + J4CppMain.fixMethodName(method) + "(int argc,const char **argv);");
                        }
                        if (!J4CppMain.isMethodToMakeEasy(method)) continue;
                        pw3.println(string21 + J4CppMain.getEasyCallCppDeclaration(method, clazz));
                    }
                    String string22 = string21.substring(TAB_STRING.length());
                    pw3.println(string22 + "}; // end class " + clssOnlyName);
                    String string23 = string22.substring(0, string22.length() - 1);
                    Class nextClass = class_index < classesSegList.size() - 1 ? (Class)classesSegList.get(class_index + 1) : null;
                    String string24 = J4CppMain.closeClassNamespace(clazz, pw3, string23, nextClass);
                    pw3.println();
                    lastClass = clazz;
                }
            }
            catch (Throwable lastClass) {
                e52 = lastClass;
                throw lastClass;
            }
            finally {
                if (pw3 != null) {
                    if (e52 != null) {
                        try {
                            pw3.close();
                        }
                        catch (Throwable lastClass) {
                            ((Throwable)e52).addSuppressed(lastClass);
                        }
                    } else {
                        pw3.close();
                    }
                }
            }
            ++var25_150;
        }
        boolean bl2 = false;
        while (var25_152 < num_class_segments) {
            Serializable lastClass;
            String output_segment_file = output;
            if (output_segment_file.endsWith(".cpp")) {
                output_segment_file = output_segment_file.substring(0, output_segment_file.length() - 4);
            } else if (output_segment_file.endsWith(".cc")) {
                output_segment_file = output_segment_file.substring(0, output_segment_file.length() - 3);
            }
            output_segment_file = output_segment_file + "" + String.format((String)var23_134, (int)var25_152) + ".cpp";
            PrintWriter pw4 = new PrintWriter(new FileWriter(output_segment_file));
            e52 = null;
            try {
                String retStore;
                void var20_81;
                String string25 = "";
                if (var25_152 < true) {
                    J4CppMain.processTemplate(pw4, map, "cpp_template_start_first.cpp", string25);
                } else {
                    J4CppMain.processTemplate(pw4, map, CPP_TEMPLATE_STARTCPP, string25);
                }
                void start_segment_index = var25_152 * classes_per_file;
                int end_segment_index = Math.min((int)(var25_152 * classes_per_file + classes_per_file), classes.size());
                List classesSegList = classes.subList((int)start_segment_index, end_segment_index);
                pw4.println();
                pw4.println(string25 + "// start_segment_index = " + (int)start_segment_index);
                pw4.println(string25 + "// start_segment_index = " + end_segment_index);
                pw4.println(string25 + "// segment_index = " + (int)var25_152);
                pw4.println(string25 + "// classesSegList=" + classesSegList);
                pw4.println();
                lastClass = null;
                for (int class_index = 0; class_index < classesSegList.size(); ++class_index) {
                    void var20_86;
                    void var20_83;
                    Class<?>[] paramClasses;
                    Class clazz = (Class)classesSegList.get(class_index);
                    pw4.println();
                    pw4.println((String)var20_81 + "// class_index = " + class_index + " clss=" + clazz);
                    pw4.println();
                    clssName = clazz.getCanonicalName();
                    String string26 = J4CppMain.openClassNamespace(clazz, pw4, (String)var20_81, lastClass);
                    String clssOnlyName = J4CppMain.getCppClassName(clazz);
                    map.put(CLASS_NAME, clssOnlyName);
                    map.put("%BASE_CLASS_FULL_NAME%", J4CppMain.classToCppBase(clazz));
                    map.put(FULL_CLASS_NAME, clssName);
                    String fcjs = J4CppMain.classToJNISignature(clazz);
                    fcjs = fcjs.substring(1, fcjs.length() - 1);
                    map.put(FULL_CLASS_JNI_SIGNATURE, fcjs);
                    if (verbose) {
                        System.out.println("fcjs = " + fcjs);
                    }
                    map.put(OBJECT_CLASS_FULL_NAME, J4CppMain.getCppRelativeName(Object.class, clazz));
                    map.put("%INITIALIZE_CONTEXT%", "");
                    map.put("%INITIALIZE_CONTEXT_REF%", "");
                    J4CppMain.processTemplate(pw4, map, CPP_START_CLASSCPP, string26);
                    Constructor[] constructors = clazz.getDeclaredConstructors();
                    if (!(J4CppMain.hasNoArgConstructor(constructors) || Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface())) {
                        pw4.println(string26 + clssOnlyName + "::" + clssOnlyName + "() : " + J4CppMain.classToCppBase(clazz) + "((jobject)NULL,false) {");
                        map.put(JNI_SIGNATURE, "()V");
                        map.put(CONSTRUCTOR_ARGS, "");
                        J4CppMain.processTemplate(pw4, map, CPP_NEWCPP, string26);
                        pw4.println(string26 + "}");
                        pw4.println();
                    }
                    for (Constructor c : constructors) {
                        String callString;
                        String parmName;
                        Class<?> paramClasse;
                        int paramIndex;
                        if (J4CppMain.checkConstructor(c, clazz, classes)) continue;
                        paramClasses = c.getParameterTypes();
                        pw4.println((String)var20_83 + clssOnlyName + "::" + clssOnlyName + J4CppMain.getCppParamDeclarations(paramClasses, clazz) + " : " + J4CppMain.classToCppBase(clazz) + "((jobject)NULL,false) {");
                        String string27 = (String)var20_83 + TAB_STRING;
                        map.put(JNI_SIGNATURE, "(" + J4CppMain.getJNIParamSignature(paramClasses) + ")V");
                        map.put(CONSTRUCTOR_ARGS, (paramClasses.length > 0 ? "," : "") + J4CppMain.getCppParamNames(paramClasses));
                        J4CppMain.processTemplate(pw4, map, CPP_NEWCPP, string27);
                        String string28 = string27.substring(0, string27.length() - 1);
                        pw4.println(string28 + "}");
                        pw4.println();
                        if (!J4CppMain.isConstructorToMakeEasy(c, clazz)) continue;
                        pw4.println(string28 + clssOnlyName + "::" + clssOnlyName + J4CppMain.getEasyCallCppParamDeclarations(c.getParameterTypes(), clazz) + " : " + J4CppMain.classToCppBase(clazz) + "((jobject)NULL,false) {");
                        J4CppMain.processTemplate(pw4, map, "cpp_start_easy_constructor.cpp", string28);
                        for (paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            paramClasse = paramClasses[paramIndex];
                            parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw4.println(string28 + "jstring " + parmName + " = env->NewStringUTF(easyArg_" + paramIndex + ");");
                                continue;
                            }
                            if (J4CppMain.isPrimitiveArray(paramClasse)) {
                                callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                                pw4.println(string28 + J4CppMain.getCppArrayType(paramClasse.getComponentType()) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= env->New" + callString + "Array(easyArg_" + paramIndex + "_length);");
                                pw4.println(string28 + "env->Set" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                                continue;
                            }
                            pw4.println(string28 + J4CppMain.getCppType(paramClasse, clazz) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= easyArg_" + paramIndex + ";");
                        }
                        J4CppMain.processTemplate(pw4, map, "cpp_new_easy_internals.cpp", string28);
                        for (paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            paramClasse = paramClasses[paramIndex];
                            parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw4.println(string28 + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                                pw4.println(string28 + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                                pw4.println(string28 + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                                pw4.println(string28 + "}");
                                continue;
                            }
                            if (!J4CppMain.isPrimitiveArray(paramClasse)) continue;
                            callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                            pw4.println(string28 + "env->Get" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                            pw4.println(string28 + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                            pw4.println(string28 + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                            pw4.println(string28 + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                            pw4.println(string28 + "}");
                        }
                        J4CppMain.processTemplate(pw4, map, "cpp_end_easy_constructor.cpp", string28);
                        pw4.println(string28 + "}");
                    }
                    pw4.println();
                    pw4.println((String)var20_83 + "// Destructor for " + clssName);
                    pw4.println((String)var20_83 + clssOnlyName + "::~" + clssOnlyName + "() {");
                    pw4.println((String)var20_83 + "\t// Place-holder for later extensibility.");
                    pw4.println((String)var20_83 + "}");
                    pw4.println();
                    Field[] fa = clazz.getDeclaredFields();
                    for (int findex = 0; findex < fa.length; ++findex) {
                        Class<Object> returnClass;
                        Field field = fa[findex];
                        if (J4CppMain.addGetterMethod(field, clazz, classes)) {
                            pw4.println();
                            pw4.println((String)var20_83 + "// Field getter for " + field.getName());
                            pw4.println(J4CppMain.getCppFieldGetterDefinitionStart((String)var20_83, clssOnlyName, field, clazz));
                            map.put("%FIELD_NAME%", field.getName());
                            map.put(JNI_SIGNATURE, J4CppMain.classToJNISignature(field.getType()));
                            returnClass = field.getType();
                            map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                            map.put(METHOD_ARGS, "");
                            map.put("%METHOD_RETURN%", J4CppMain.isVoid(returnClass) ? "" : "return");
                            map.put("%METHOD_CALL_TYPE%", J4CppMain.getMethodCallString(returnClass));
                            map.put("%METHOD_RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                            map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                            String retStore2 = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                            map.put(METHOD_RETURN_STORE, retStore2);
                            map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet((String)var20_83, returnClass, clazz));
                            if (Modifier.isStatic(field.getModifiers())) {
                                J4CppMain.processTemplate(pw4, map, "cpp_static_getfield.cpp", (String)var20_83);
                            } else {
                                J4CppMain.processTemplate(pw4, map, "cpp_getfield.cpp", (String)var20_83);
                            }
                            pw4.println((String)var20_83 + "}");
                        }
                        if (!J4CppMain.addSetterMethod(field, clazz, classes)) continue;
                        pw4.println();
                        pw4.println((String)var20_83 + "// Field setter for " + field.getName());
                        pw4.println(J4CppMain.getCppFieldSetterDefinitionStart((String)var20_83, clssOnlyName, field, clazz));
                        map.put("%FIELD_NAME%", field.getName());
                        map.put(JNI_SIGNATURE, J4CppMain.classToJNISignature(field.getType()));
                        returnClass = Void.TYPE;
                        map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                        paramClasses = new Class[]{field.getType()};
                        String methodArgs = J4CppMain.getCppParamNames(paramClasses);
                        map.put(METHOD_ARGS, (paramClasses.length > 0 ? "," : "") + methodArgs);
                        map.put("%METHOD_RETURN%", J4CppMain.isVoid(returnClass) ? "" : "return");
                        map.put("%METHOD_CALL_TYPE%", J4CppMain.getMethodCallString(field.getType()));
                        map.put("%METHOD_RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                        retStore = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                        map.put(METHOD_RETURN_STORE, retStore);
                        map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet((String)var20_83, returnClass, clazz));
                        if (Modifier.isStatic(field.getModifiers())) {
                            J4CppMain.processTemplate(pw4, map, "cpp_static_setfield.cpp", (String)var20_83);
                        } else {
                            J4CppMain.processTemplate(pw4, map, "cpp_setfield.cpp", (String)var20_83);
                        }
                        pw4.println((String)var20_83 + "}");
                    }
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        if (!J4CppMain.checkMethod(method, classes)) continue;
                        pw4.println();
                        pw4.println(J4CppMain.getCppMethodDefinitionStart((String)var20_86, clssOnlyName, method, clazz));
                        map.put(METHOD_NAME, method.getName());
                        if (J4CppMain.fixMethodName(method).contains("equals2") && verbose) {
                            System.out.println("debug me");
                        }
                        map.put("%JAVA_METHOD_NAME%", method.getName());
                        paramClasses = method.getParameterTypes();
                        String methodArgs = J4CppMain.getCppParamNames(paramClasses);
                        map.put(METHOD_ARGS, (paramClasses.length > 0 ? "," : "") + methodArgs);
                        Class<?> returnClass = method.getReturnType();
                        map.put(JNI_SIGNATURE, "(" + J4CppMain.getJNIParamSignature(paramClasses) + ")" + J4CppMain.classToJNISignature(returnClass));
                        map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                        map.put("%METHOD_RETURN%", J4CppMain.isVoid(returnClass) ? "" : "return");
                        map.put("%METHOD_CALL_TYPE%", J4CppMain.getMethodCallString(returnClass));
                        map.put("%METHOD_RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                        String retStore3 = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                        map.put(METHOD_RETURN_STORE, retStore3);
                        map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet((String)var20_86, returnClass, clazz));
                        String string29 = (String)var20_86 + TAB_STRING;
                        if (!Modifier.isStatic(method.getModifiers())) {
                            J4CppMain.processTemplate(pw4, map, CPP_METHODCPP, string29);
                        } else {
                            J4CppMain.processTemplate(pw4, map, CPP_STATIC_METHODCPP, string29);
                        }
                        String string30 = string29.substring(0, string29.length() - TAB_STRING.length());
                        pw4.println(string30 + "}");
                        if (J4CppMain.isArrayStringMethod(method)) {
                            map.put(METHOD_RETURN_STORE, J4CppMain.isVoid(returnClass) ? "" : J4CppMain.getCppType(returnClass, clazz) + " returnVal=");
                            map.put(METHOD_RETURN_GET, J4CppMain.isVoid(returnClass) ? "return ;" : "return returnVal;");
                            J4CppMain.processTemplate(pw4, map, CPP_EASY_STRING_ARRAY_METHODCPP, string30);
                            continue;
                        }
                        if (!J4CppMain.isMethodToMakeEasy(method)) continue;
                        pw4.println();
                        pw4.println(string30 + "// Easy call alternative for " + method.getName());
                        pw4.println(J4CppMain.getEasyCallCppMethodDefinitionStart(string30, clssOnlyName, method, clazz));
                        String string31 = string30 + TAB_STRING;
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclareOut(returnClass, clazz));
                        J4CppMain.processTemplate(pw4, map, "cpp_start_easy_method.cpp", string31);
                        for (int paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            Class<?> paramClasse = paramClasses[paramIndex];
                            String parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw4.println(string31 + "jstring " + parmName + " = env->NewStringUTF(easyArg_" + paramIndex + ");");
                                continue;
                            }
                            if (J4CppMain.isPrimitiveArray(paramClasse)) {
                                String callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                                pw4.println(string31 + J4CppMain.getCppArrayType(paramClasse.getComponentType()) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= env->New" + callString + "Array(easyArg_" + paramIndex + "_length);");
                                pw4.println(string31 + "env->Set" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                                continue;
                            }
                            pw4.println(string31 + J4CppMain.getCppType(paramClasse, clazz) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= easyArg_" + paramIndex + ";");
                        }
                        String methodArgsIn = J4CppMain.getCppParamNamesIn(paramClasses);
                        String retStoreOut = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnOutVarType(returnClass, clazz) + ") ";
                        pw4.println(string31 + retStoreOut + J4CppMain.fixMethodName(method) + "(" + methodArgsIn + ");");
                        for (int paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            Class<?> paramClasse = paramClasses[paramIndex];
                            String parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw4.println(string31 + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                                pw4.println(string31 + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                                pw4.println(string31 + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                                pw4.println(string31 + "}");
                                continue;
                            }
                            if (!J4CppMain.isPrimitiveArray(paramClasse)) continue;
                            String callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                            pw4.println(string31 + "env->Get" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                            pw4.println(string31 + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                            pw4.println(string31 + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                            pw4.println(string31 + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                            pw4.println(string31 + "}");
                        }
                        J4CppMain.processTemplate(pw4, map, "cpp_end_easy_method.cpp", string31);
                        if (!J4CppMain.isVoid(returnClass)) {
                            pw4.println(string31 + "return retVal;");
                        }
                        String string32 = string31.substring(TAB_STRING.length());
                        pw4.println(string32 + "}");
                        pw4.println();
                    }
                    J4CppMain.processTemplate(pw4, map, CPP_END_CLASSCPP, (String)var20_86);
                    String string33 = var20_86.substring(0, var20_86.length() - 1);
                    Class nextClass = class_index < classesSegList.size() - 1 ? (Class)classesSegList.get(class_index + 1) : null;
                    String string34 = J4CppMain.closeClassNamespace(clazz, pw4, string33, nextClass);
                    lastClass = clazz;
                }
                if (var25_152 < true) {
                    void var20_93;
                    if (null != nativesClassMap) {
                        for (Map.Entry entry : nativesClassMap.entrySet()) {
                            Class javaClass = (Class)entry.getValue();
                            String nativeClassName = (String)entry.getKey();
                            map.put(CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_JNI_SIGNATURE, nativeClassName);
                            map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                            map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                            map.put("%INITIALIZE_CONTEXT%", "context=NULL; initContext(NULL,false);");
                            map.put("%INITIALIZE_CONTEXT_REF%", "context=NULL; initContext(objref.context,true);");
                            String string35 = (String)var20_93 + TAB_STRING;
                            J4CppMain.processTemplate(pw4, map, CPP_START_CLASSCPP, string35);
                            pw4.println();
                            pw4.println(string35 + nativeClassName + "::" + nativeClassName + "() : " + J4CppMain.getModifiedClassName(javaClass).replace(".", "::") + "((jobject)NULL,false) {");
                            String string36 = string35 + TAB_STRING;
                            pw4.println(string36 + "context=NULL;");
                            pw4.println(string36 + "initContext(NULL,false);");
                            map.put(JNI_SIGNATURE, "()V");
                            map.put(CONSTRUCTOR_ARGS, "");
                            J4CppMain.processTemplate(pw4, map, "cpp_new_native.cpp", string36);
                            String string37 = string36.substring(TAB_STRING.length());
                            pw4.println(string37 + "}");
                            pw4.println();
                            pw4.println(string37 + "// Destructor for " + nativeClassName);
                            pw4.println(string37 + nativeClassName + "::~" + nativeClassName + "() {");
                            pw4.println(string37 + TAB_STRING + "if(NULL != context) {");
                            pw4.println(string37 + TAB_STRING + TAB_STRING + "deleteContext();");
                            pw4.println(string37 + TAB_STRING + "}");
                            pw4.println(string37 + TAB_STRING + "context=NULL;");
                            pw4.println(string37 + "}");
                            pw4.println();
                            String string38 = string37.substring(TAB_STRING.length());
                            J4CppMain.processTemplate(pw4, map, CPP_END_CLASSCPP, string38);
                        }
                    }
                    J4CppMain.processTemplate(pw4, map, "cpp_template_end_first.cpp", (String)var20_93);
                    String string39 = "";
                    if (null != nativesClassMap) {
                        void var20_106;
                        void var20_100;
                        Method[] methods;
                        pw4.println("using namespace " + namespace + ";");
                        pw4.println("#ifdef __cplusplus");
                        pw4.println("extern \"C\" {");
                        pw4.println("#endif");
                        int max_method_count = 0;
                        String string40 = "";
                        for (Map.Entry e7 : nativesClassMap.entrySet()) {
                            void var20_101;
                            Class javaClass = (Class)e7.getValue();
                            String nativeClassName = (String)e7.getKey();
                            map.put(CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_NAME, nativeClassName);
                            map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                            map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                            map.put(FULL_CLASS_JNI_SIGNATURE, nativeClassName);
                            map.put(METHOD_ONFAIL, "return;");
                            methods = javaClass.getDeclaredMethods();
                            if (max_method_count < methods.length) {
                                max_method_count = methods.length;
                            }
                            for (int j = 0; j < methods.length; ++j) {
                                Method method = methods[j];
                                int modifiers = method.getModifiers();
                                if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isDefault() || method.isSynthetic()) continue;
                                Class<?>[] paramClasses = method.getParameterTypes();
                                String methodArgs = J4CppMain.getCppParamNames(paramClasses);
                                map.put(METHOD_ARGS, methodArgs);
                                map.put(METHOD_NAME, method.getName());
                                Class<?> returnClass = method.getReturnType();
                                retStore = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                                map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, javaClass));
                                map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                                map.put(METHOD_RETURN_STORE, retStore);
                                map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet((String)var20_101, returnClass, javaClass));
                                pw4.println();
                                String paramDecls = J4CppMain.getCppParamDeclarations(paramClasses, javaClass);
                                String argsToAdd = method.getParameterCount() > 0 ? "," + paramDecls.substring(1, paramDecls.length() - 1) : "";
                                pw4.println("JNIEXPORT " + J4CppMain.getCppType(returnClass, javaClass) + " JNICALL Java_" + nativeClassName + "_" + method.getName() + "(JNIEnv *env, jobject jthis" + argsToAdd + ") {");
                                String string41 = TAB_STRING;
                                J4CppMain.processTemplate(pw4, map, "cpp_native_wrap.cpp", string41);
                                String string42 = string41.substring(TAB_STRING.length());
                                pw4.println("}");
                                pw4.println();
                            }
                            pw4.println("JNIEXPORT void JNICALL Java_" + nativeClassName + "_nativeDelete(JNIEnv *env, jobject jthis) {");
                            String string43 = (String)var20_101 + TAB_STRING;
                            map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(Void.TYPE, javaClass));
                            J4CppMain.processTemplate(pw4, map, "cpp_native_delete.cpp", string43);
                            String string44 = string43.substring(TAB_STRING.length());
                            pw4.println(string44 + "}");
                            pw4.println();
                        }
                        pw4.println("#ifdef __cplusplus");
                        pw4.println("} // end extern \"C\"");
                        pw4.println("#endif");
                        map.put("%MAX_METHOD_COUNT%", Integer.toString(max_method_count + 1));
                        J4CppMain.processTemplate(pw4, map, "cpp_start_register_native.cpp", (String)var20_100);
                        for (Map.Entry e : nativesClassMap.entrySet()) {
                            Class javaClass = (Class)e.getValue();
                            String nativeClassName = (String)e.getKey();
                            map.put(CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_NAME, nativeClassName);
                            map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                            map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                            J4CppMain.processTemplate(pw4, map, "cpp_start_register_native_class.cpp", (String)var20_106);
                            String string45 = (String)var20_106 + TAB_STRING;
                            methods = javaClass.getDeclaredMethods();
                            int method_number = 0;
                            for (int j = 0; j < methods.length; ++j) {
                                Method method = methods[j];
                                int modifiers = method.getModifiers();
                                if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isDefault() || method.isSynthetic()) continue;
                                map.put("%METHOD_NUMBER%", Integer.toString(method_number));
                                map.put(METHOD_NAME, method.getName());
                                map.put(JNI_SIGNATURE, "(" + J4CppMain.getJNIParamSignature(method.getParameterTypes()) + ")" + J4CppMain.classToJNISignature(method.getReturnType()));
                                J4CppMain.processTemplate(pw4, map, "cpp_register_native_item.cpp", string45);
                                ++method_number;
                            }
                            map.put("%METHOD_NUMBER%", Integer.toString(method_number));
                            map.put(METHOD_NAME, "nativeDelete");
                            map.put(JNI_SIGNATURE, "()V");
                            J4CppMain.processTemplate(pw4, map, "cpp_register_native_item.cpp", string45);
                            map.put("%NUM_NATIVE_METHODS%", Integer.toString(method_number));
                            J4CppMain.processTemplate(pw4, map, "cpp_end_register_native_class.cpp", string45);
                            String string46 = string45.substring(TAB_STRING.length());
                        }
                        J4CppMain.processTemplate(pw4, map, "cpp_end_register_native.cpp", (String)var20_106);
                    } else {
                        pw4.println("// No Native classes : registerNativMethods not needed.");
                        pw4.println("static void registerNativeMethods(JNIEnv *env) {}");
                    }
                } else {
                    J4CppMain.processTemplate(pw4, map, CPP_TEMPLATE_ENDCPP, (String)var20_81);
                }
            }
            catch (Throwable start_segment_index) {
                e52 = start_segment_index;
                throw start_segment_index;
            }
            finally {
                if (pw4 != null) {
                    if (e52 != null) {
                        try {
                            pw4.close();
                        }
                        catch (Throwable start_segment_index) {
                            ((Throwable)e52).addSuppressed(start_segment_index);
                        }
                    } else {
                        pw4.close();
                    }
                }
            }
            if (null != nativesClassMap) {
                String string47 = "";
                for (Map.Entry e : nativesClassMap.entrySet()) {
                    File nativeClassCppFile;
                    String nativeClassName = (String)e.getKey();
                    File nativeClassHeaderFile = new File(namespace.toLowerCase() + "_" + nativeClassName.toLowerCase() + ".h");
                    map.put("%NATIVE_CLASS_HEADER%", nativeClassHeaderFile.getName());
                    map.put(CLASS_NAME, nativeClassName);
                    if (nativeClassHeaderFile.exists()) {
                        if (verbose) {
                            System.out.println("skipping " + nativeClassHeaderFile.getCanonicalPath() + " since it already exists.");
                        }
                    } else {
                        lastClass = null;
                        try (PrintWriter pw5 = new PrintWriter(new FileWriter(nativeClassHeaderFile));){
                            J4CppMain.processTemplate(pw5, map, "header_native_imp.h", string47);
                        }
                        catch (Throwable throwable3) {
                            lastClass = throwable3;
                            throw throwable3;
                        }
                    }
                    if ((nativeClassCppFile = new File(namespace.toLowerCase() + "_" + nativeClassName.toLowerCase() + ".cpp")).exists()) {
                        if (!verbose) continue;
                        System.out.println("skipping " + nativeClassCppFile.getCanonicalPath() + " since it already exists.");
                        continue;
                    }
                    PrintWriter pw6 = new PrintWriter(new FileWriter(nativeClassCppFile));
                    Throwable throwable4 = null;
                    try {
                        J4CppMain.processTemplate(pw6, map, "cpp_native_imp_start.cpp", string47);
                        Class clazz = (Class)e.getValue();
                        Method[] methods = clazz.getDeclaredMethods();
                        boolean method_number = false;
                        for (int j = 0; j < methods.length; ++j) {
                            Method method = methods[j];
                            int modifiers = method.getModifiers();
                            if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isDefault() || method.isSynthetic()) continue;
                            Class<?>[] paramClasses = method.getParameterTypes();
                            String paramDecls = J4CppMain.getCppParamDeclarations(paramClasses, clazz);
                            String methodArgs = method.getParameterCount() > 0 ? paramDecls.substring(1, paramDecls.length() - 1) : "";
                            map.put(METHOD_ARGS, methodArgs);
                            map.put(METHOD_NAME, method.getName());
                            Class<?> returnClass = method.getReturnType();
                            String retStore = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                            map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                            map.put("%RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                            map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                            map.put(METHOD_RETURN_STORE, retStore);
                            map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet(string47, returnClass, clazz));
                            J4CppMain.processTemplate(pw6, map, "cpp_native_imp_stub.cpp", string47);
                        }
                        J4CppMain.processTemplate(pw6, map, "cpp_native_imp_end.cpp", string47);
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (pw6 == null) continue;
                        if (throwable4 != null) {
                            try {
                                pw6.close();
                            }
                            catch (Throwable throwable6) {
                                throwable4.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        pw6.close();
                    }
                }
            }
            ++var25_152;
        }
        main_completed = true;
    }

    private static boolean checkConstructor(Constructor c, Class clss, List<Class> classes) {
        Constructor<?> constructor;
        if (!(Modifier.isPublic(c.getModifiers()) || c.getParameterCount() == 0 && Modifier.isProtected(c.getModifiers()))) {
            return true;
        }
        Constructor<?>[] ca = clss.getDeclaredConstructors();
        for (int i = 0; i < ca.length && !(constructor = ca[i]).equals(c); ++i) {
            if (constructor.getParameterCount() != c.getParameterCount() || c.getParameterCount() >= 1 && String.class.isAssignableFrom(c.getParameterTypes()[0]) != String.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return true;
        }
        if (c.getParameterCount() == 1 && clss.isAssignableFrom(c.getParameterTypes()[0])) {
            return true;
        }
        return !J4CppMain.checkParameters(c.getParameterTypes(), classes);
    }

    private static String getMethodReturnGet(String tabs, Class returnClass, Class relClass) {
        if (!(returnClass.isArray() || returnClass.isPrimitive() || J4CppMain.isString(returnClass))) {
            tabs = tabs + TAB_STRING;
            return tabs + "\n" + tabs + "jobjectRefType ref = env->GetObjectRefType(retVal);\n" + tabs + "if(GetDebugJ4Cpp()) DebugPrintJObject(__FILE__,__LINE__,\"retVal=\",retVal);" + tabs + J4CppMain.getCppRelativeName(returnClass, relClass) + " retObject(retVal,false);\n" + tabs + "return retObject;";
        }
        return J4CppMain.isVoid(returnClass) ? "" : "return retVal;";
    }

    private static String classToCppBase(Class clss) {
        Class<Object> superClass = clss.getSuperclass();
        if (superClass == null) {
            superClass = Object.class;
        }
        return J4CppMain.getCppRelativeName(superClass, clss);
    }

    private static boolean pkgMatch(String[] pkgs1, String[] pkgs2, int level) {
        if (pkgs1.length < level + 1) {
            return false;
        }
        if (pkgs2.length < level + 1) {
            return false;
        }
        for (int i = 0; i <= level; ++i) {
            String pkgFrom1 = pkgs1[i];
            String pkgFrom2 = pkgs2[i];
            if (pkgFrom1.equals(pkgFrom2)) continue;
            return false;
        }
        return true;
    }

    private static String closeClassNamespace(Class clss, PrintWriter pw, String tabs, Class nextClass) {
        String pkg;
        String[] pkgs = J4CppMain.classToPackages(clss);
        String[] nextPkgs = J4CppMain.classToPackages(nextClass);
        boolean line_printed = false;
        if (pkgs.length < 1) {
            return tabs;
        }
        for (int i = pkgs.length - 1; i >= 0 && (pkg = pkgs[i]).length() >= 1; --i) {
            if (!J4CppMain.pkgMatch(pkgs, nextPkgs, i)) {
                pw.println(tabs + "} // end namespace " + pkg);
                line_printed = true;
            }
            tabs = tabs.substring(0, tabs.length() - 1);
        }
        if (line_printed) {
            pw.println();
        }
        return tabs;
    }

    private static String[] classToPackages(Class clss) {
        return Optional.ofNullable(clss).map(Class::getPackage).map(Package::getName).map(s -> s.split("\\.")).orElse(emptypkgs);
    }

    private static String openClassNamespace(Class clss, PrintWriter pw, String tabs, Class lastClass) {
        String[] pkgs = J4CppMain.classToPackages(clss);
        String[] lastpkgs = J4CppMain.classToPackages(lastClass);
        for (int i = 0; i < pkgs.length; ++i) {
            String pkg = pkgs[i];
            if (J4CppMain.pkgMatch(pkgs, lastpkgs, i)) continue;
            tabs = tabs + TAB_STRING;
            pw.println(tabs + "namespace " + pkg + "{");
        }
        return tabs;
    }

    private static void processTemplate(PrintWriter pw, Map<String, String> map, String resourceName, String tabs) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resourceName), StandardCharsets.UTF_8));){
            br.lines().filter(s -> !s.trim().startsWith(TEMPLATE_COMMENT_MARK)).map(l -> l.replace("\t", TAB_STRING)).forEach(l -> pw.println(tabs + J4CppMain.replaceVars(map, l)));
        }
    }

    private static void printHelpAndExit(Options options, String[] args) {
        System.out.println("args = " + Arrays.toString(args));
        new HelpFormatter().printHelp("java4cpp", options);
        System.exit(1);
    }
}

