/*
 * Decompiled with CFR 0.152.
 */
package com.github.wshackle.java4cpp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class J4CppMain {
    public static String namespace = "JavaForCpp";
    private static Set<String> badNames = J4CppMain.getBadNames();
    private static boolean fixMultipleOverrides = Boolean.getBoolean("fixMultipleOverrides");
    public static boolean verbose = false;
    public static boolean main_completed = false;
    private static final String CLASSESPEROUTPUT = "classes-per-output";
    private static final int DEFAULT_LIMIT = 200;
    private static final String TAB_STRING = "    ";
    private static final String OBJECT_CLASS_FULL_NAME = "%OBJECT_CLASS_FULL_NAME%";
    private static final String METHOD_RETURN_GET = "%METHOD_RETURN_GET%";
    private static final String METHOD_RETURN_STORE = "%METHOD_RETURN_STORE%";
    private static final String CPP_EASY_STRING_ARRAY_METHODCPP = "cpp_easy_string_array_method.cpp";
    private static final String HEADER_CLASS_STARTH = "header_class_start.h";
    private static final String CPP_STATIC_METHODCPP = "cpp_static_method.cpp";
    private static final String JAR = "%JAR%";
    private static final String FULL_CLASS_JNI_SIGNATURE = "%FULL_CLASS_JNI_SIGNATURE%";
    private static final String METHOD_ONFAIL = "%METHOD_ONFAIL%";
    private static final String METHOD_ARGS = "%METHOD_ARGS%";
    private static final String METHOD_NAME = "%METHOD_NAME%";
    private static final String CONSTRUCTOR_ARGS = "%CONSTRUCTOR_ARGS%";
    private static final String JNI_SIGNATURE = "%JNI_SIGNATURE%";
    private static final String FULL_CLASS_NAME = "%FULL_CLASS_NAME%";
    private static final String CLASS_NAME = "%CLASS_NAME%";
    private static final String NAMESPACE = "%NAMESPACE%";
    private static final String HEADER_DEFINE = "%HEADER_DEFINE%";
    private static final String HEADER = "%HEADER%";
    private static final String[] emptypkgs = new String[0];
    private static final String TEMPLATE_COMMENT_MARK = "//%%%";
    private static final String HEADER_TEMPLATE_STARTH = "header_template_start.h";
    private static final String HEADER_TEMPLATE_ENDH = "header_template_end.h";
    private static final String CPP_TEMPLATE_STARTCPP = "cpp_template_start.cpp";
    private static final String CPP_TEMPLATE_ENDCPP = "cpp_template_end.cpp";
    private static final String CPP_START_CLASSCPP = "cpp_start_class.cpp";
    private static final String CPP_END_CLASSCPP = "cpp_end_class.cpp";
    private static final String CPP_NEWCPP = "cpp_new.cpp";
    private static final String CPP_METHODCPP = "cpp_method.cpp";

    private static String getCppPrimitiveType(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "jboolean";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "jbyte";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "jchar";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "jshort";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "jint";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "jlong";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "jfloat";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "jdouble";
        }
        if (Void.TYPE.isAssignableFrom(clss)) {
            return "void";
        }
        throw new IllegalArgumentException("getCppPrimitiveType() Class=" + clss + " not recognized.");
    }

    private static String getCppArrayType(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "jbooleanArray";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "jbyteArray";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "jcharArray";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "jshortArray";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "jintArray";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "jlongArray";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "jfloatArray";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "jdoubleArray";
        }
        return "jobjectArray";
    }

    private static String getCppEasyCallArrayType(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "jboolean *";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "jbyte *";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "jchar *";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "jshort *";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "jint *";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "jlong *";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "jfloat *";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "jdouble *";
        }
        return "jobject *";
    }

    private static String getModifiedClassName(Class cls) {
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (null != enclosingClass) {
            String en = enclosingClass.getCanonicalName();
            return en + cls.getCanonicalName().substring(en.length() + 1);
        }
        return cls.getCanonicalName();
    }

    private static String getCppRelativeName(Class<?> cls, Class<?> relClass) {
        String[] basepackages = J4CppMain.getModifiedClassName(cls).split("\\.");
        String[] packages = relClass.getCanonicalName().split("\\.");
        int i = 0;
        int index = 0;
        boolean match = true;
        for (i = 0; i < basepackages.length - 1 && i < packages.length - 1; ++i) {
            if (!packages[i].equals(basepackages[i])) {
                match = false;
                break;
            }
            index += packages[i].length() + 1;
        }
        if (match) {
            return J4CppMain.getModifiedClassName(cls).substring(index).replace(".", "::");
        }
        return "::" + namespace + "::" + J4CppMain.getModifiedClassName(cls).replace(".", "::");
    }

    private static String getCppType(Class<?> clss, Class<?> relClass) {
        if (clss.isArray()) {
            Class<?> componentType = clss.getComponentType();
            return J4CppMain.getCppArrayType(componentType);
        }
        if (clss.isPrimitive()) {
            return J4CppMain.getCppPrimitiveType(clss);
        }
        if (Void.class.isAssignableFrom(clss)) {
            return "void";
        }
        if (J4CppMain.isString(clss)) {
            return "jstring";
        }
        return J4CppMain.getCppRelativeName(clss, relClass);
    }

    private static String getEasyCallCppType(Class<?> clss, Class<?> relClass) {
        if (clss.isArray()) {
            Class<?> componentType = clss.getComponentType();
            return J4CppMain.getCppEasyCallArrayType(componentType);
        }
        if (clss.isPrimitive()) {
            return J4CppMain.getCppPrimitiveType(clss);
        }
        if (Void.class.isAssignableFrom(clss)) {
            return "void";
        }
        if (J4CppMain.isString(clss)) {
            return "const char *";
        }
        return J4CppMain.getCppRelativeName(clss, relClass);
    }

    private static String getCppModifiers(int modifiers) {
        String out = "";
        if (Modifier.isStatic(modifiers)) {
            out = out + "static ";
        }
        return out;
    }

    private static String addConstRefIndicator(Class c, String orig) {
        if (!(c.isPrimitive() || J4CppMain.isString(c) || c.isArray())) {
            return "const " + orig + " &";
        }
        return orig;
    }

    private static String classToParamNameDecl(Class<?> c, int index) {
        if (c.isArray()) {
            return J4CppMain.classToParamName(c.getComponentType()) + "Array_" + index;
        }
        return c.getSimpleName().substring(0, 1).toLowerCase() + c.getSimpleName().substring(1) + "_" + index;
    }

    private static String addCppJThis(Class c) {
        if (c.isPrimitive() || c.isArray() || J4CppMain.isString(c)) {
            return "";
        }
        return ".jthis";
    }

    private static String classToParamName(Class<?> c) {
        if (c.isArray()) {
            return J4CppMain.classToParamName(c.getComponentType()) + "Array";
        }
        return c.getSimpleName().substring(0, 1).toLowerCase() + c.getSimpleName().substring(1);
    }

    private static String classToJNISignature(Class<?> clss) {
        if (Boolean.TYPE.isAssignableFrom(clss)) {
            return "Z";
        }
        if (Byte.TYPE.isAssignableFrom(clss)) {
            return "B";
        }
        if (Character.TYPE.isAssignableFrom(clss)) {
            return "C";
        }
        if (Short.TYPE.isAssignableFrom(clss)) {
            return "S";
        }
        if (Integer.TYPE.isAssignableFrom(clss)) {
            return "I";
        }
        if (Long.TYPE.isAssignableFrom(clss)) {
            return "J";
        }
        if (Float.TYPE.isAssignableFrom(clss)) {
            return "F";
        }
        if (Double.TYPE.isAssignableFrom(clss)) {
            return "D";
        }
        if (Void.TYPE.isAssignableFrom(clss)) {
            return "V";
        }
        if (clss.isArray()) {
            return "[" + J4CppMain.classToJNISignature(clss.getComponentType());
        }
        if (null != clss.getEnclosingClass()) {
            String s = J4CppMain.classToJNISignature(clss.getEnclosingClass());
            String s1 = clss.getName();
            int dollarIndex = s1.indexOf(36);
            return s.substring(0, s.length() - 1) + s1.substring(dollarIndex) + ";";
        }
        return "L" + clss.getCanonicalName().replace(".", "/") + ";";
    }

    private static String getJNIParamSignature(Class<?>[] clsses) {
        String s = "";
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            s = s + J4CppMain.classToJNISignature(clsse);
        }
        return s;
    }

    private static String getCppParamNames(Class<?>[] clsses) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String name = J4CppMain.getParamName(clsse, i);
            sb.append(name);
            if (i >= clsses.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getCppParamNamesIn(Class<?>[] clsses) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String name = J4CppMain.getParamNameIn(clsse, i);
            sb.append(name);
            if (i >= clsses.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getParamName(Class<?> clsse, int i) {
        return J4CppMain.classToParamName(clsse) + "_" + i + J4CppMain.addCppJThis(clsse);
    }

    private static String getParamNameIn(Class<?> clsse, int i) {
        return J4CppMain.classToParamName(clsse) + "_" + i;
    }

    private static String getCppParamDeclarations(Class<?>[] clsses, Class<?> relClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String name = J4CppMain.addConstRefIndicator(clsse, J4CppMain.getCppType(clsse, relClass)) + " " + J4CppMain.classToParamNameDecl(clsse, i);
            sb.append(name);
            if (i >= clsses.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getEasyCallCppParamDeclarations(Class<?>[] clsses, Class<?> relClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < clsses.length; ++i) {
            Class<?> clsse = clsses[i];
            String type = J4CppMain.getEasyCallCppType(clsse, relClass);
            sb.append(type);
            sb.append(' ');
            String name = "easyArg_" + i;
            sb.append(name);
            if (i < clsses.length - 1 || clsse.isArray()) {
                sb.append(',');
            }
            if (!clsse.isArray()) continue;
            sb.append("jsize ");
            sb.append(name);
            sb.append("_length");
            if (i >= clsses.length - 1) continue;
            sb.append(',');
        }
        sb.append(")");
        return sb.toString();
    }

    private static Set<String> getBadNames() {
        HashSet<String> badNamesSet = new HashSet<String>();
        badNamesSet.addAll(Arrays.asList("and", "and_eq", "bitand", "bitor", "compl", "not", "not_eq", "or", "not_eq", "or", "or_eq", "xor", "xor_eq", "delete", "namespace", "union", "cast"));
        return badNamesSet;
    }

    private static String fixMethodName(Method m) {
        String mname = m.getName();
        if (fixMultipleOverrides) {
            Method method;
            int i;
            Method[] ma = m.getDeclaringClass().getMethods();
            int index = 0;
            boolean index_incremented = false;
            boolean has_match = false;
            Arrays.sort(ma, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return Arrays.toString(o1.getParameterTypes()).compareTo(Arrays.toString(o2.getParameterTypes()));
                }
            });
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            for (i = 0; i < ma.length; ++i) {
                method = ma[i];
                if (method.getParameterTypes().length > 0 && m.getParameterTypes().length > 0 && m.getParameterTypes()[0].isPrimitive() != method.getParameterTypes()[0].isPrimitive() || method.equals(m) || !m.getName().equals(method.getName()) || m.getParameterTypes().length != method.getParameterTypes().length) continue;
                has_match = true;
                matchingMethods.add(method);
            }
            for (i = 0; i < ma.length && !(method = ma[i]).equals(m); ++i) {
                if (method.getParameterTypes().length != m.getParameterTypes().length || method.getParameterTypes().length > 0 && m.getParameterTypes().length > 0 && m.getParameterTypes()[0].isPrimitive() != method.getParameterTypes()[0].isPrimitive() || m.getParameterTypes().length >= 1 && String.class.isAssignableFrom(m.getParameterTypes()[0]) != String.class.isAssignableFrom(method.getParameterTypes()[0]) || !method.getName().equals(m.getName())) continue;
                ++index;
                index_incremented = true;
            }
            int start_index = 0;
            while (index_incremented) {
                index_incremented = false;
                for (int i2 = 0; i2 < ma.length; ++i2) {
                    Method method2 = ma[i2];
                    for (int j = start_index; j <= index; ++j) {
                        if (!method2.getName().equals(m.getName() + j) || m.getParameterTypes().length != method2.getParameterTypes().length) continue;
                        ++index;
                        index_incremented = true;
                    }
                }
                start_index = index;
            }
            if (has_match) {
                String paramstring = "";
                Class<?>[] paramclasses = m.getParameterTypes();
                for (int i3 = 0; i3 < paramclasses.length; ++i3) {
                    paramstring = paramstring + J4CppMain.classToMethodAppendage(paramclasses[i3]);
                }
                if ((mname = mname + paramstring).contains(";")) {
                    System.out.println("paramclasses = " + paramclasses);
                }
            }
        }
        if (badNames.contains(mname)) {
            return mname + "Method";
        }
        return mname;
    }

    private static String classToMethodAppendage(Class clzz) {
        return clzz.getName().replace("Ljava.lang", "").replace("Ljava.io", "").replace("Ljava.util", "").replace("Ljava.net", "").replace("Ljava.math", "").replace("java.lang", "").replace("java.io", "").replace("java.util", "").replace("java.net", "").replace("java.math", "").replaceAll("[.\\[\\]\\$_;]+", "");
    }

    private static String getCppDeclaration(Method m, Class<?> relClass) {
        return J4CppMain.getCppModifiers(m.getModifiers()) + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + J4CppMain.fixMethodName(m) + J4CppMain.getCppParamDeclarations(m.getParameterTypes(), relClass) + ";";
    }

    private static String getNativeMethodCppDeclaration(Method m, Class<?> relClass) {
        return J4CppMain.getCppModifiers(m.getModifiers()) + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + J4CppMain.fixMethodName(m) + "Native" + J4CppMain.getCppParamDeclarations(m.getParameterTypes(), relClass) + ";";
    }

    private static String getCppFieldGetterDeclaration(Field f, Class<?> relClass) {
        return J4CppMain.getCppModifiers(f.getModifiers()) + J4CppMain.getCppType(f.getType(), relClass) + " " + "get" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "();";
    }

    private static String getCppFieldSetterDeclaration(Field f, Class<?> relClass) {
        return J4CppMain.getCppModifiers(f.getModifiers()) + "void set" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "(" + J4CppMain.addConstRefIndicator(f.getType(), J4CppMain.getCppType(f.getType(), relClass)) + " " + J4CppMain.classToParamNameDecl(f.getType(), 0) + ");";
    }

    private static String getCppFieldGetterDefinitionStart(String tabs, String clssOnlyName, Field f, Class<?> relClass) {
        return tabs + J4CppMain.getCppType(f.getType(), relClass) + " " + clssOnlyName + "::" + "get" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "() {";
    }

    private static String getCppFieldSetterDefinitionStart(String tabs, String clssOnlyName, Field f, Class<?> relClass) {
        return tabs + "void " + clssOnlyName + "::" + "set" + f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1) + "(" + J4CppMain.addConstRefIndicator(f.getType(), J4CppMain.getCppType(f.getType(), relClass)) + " " + J4CppMain.classToParamNameDecl(f.getType(), 0) + ") {";
    }

    private static String getCppMethodDefinitionStart(String tabs, String clssOnlyName, Method m, Class<?> relClass) {
        return tabs + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + clssOnlyName + "::" + J4CppMain.fixMethodName(m) + J4CppMain.getCppParamDeclarations(m.getParameterTypes(), relClass) + " {";
    }

    private static String getEasyCallCppMethodDefinitionStart(String tabs, String clssOnlyName, Method m, Class<?> relClass) {
        return tabs + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + clssOnlyName + "::" + J4CppMain.fixMethodName(m) + J4CppMain.getEasyCallCppParamDeclarations(m.getParameterTypes(), relClass) + " {";
    }

    public static String getOnFailString(Class returnClass, Class relClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "return false;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "return (jbyte) -1;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "return (jchar) -1;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "return (jshort) -1;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "return (jint) -1;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "return (jlong) -1;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "return (jfloat) -1.0;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "return (jdouble) -1.0;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "return;";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "return;";
        }
        if (J4CppMain.isString(returnClass)) {
            return "return NULL;";
        }
        if (returnClass.isArray()) {
            return "return NULL;";
        }
        return "static " + J4CppMain.getCppRelativeName(returnClass, relClass) + " nullObject((jobject)NULL,false); return nullObject;";
    }

    private static boolean isString(Class returnClass) {
        return String.class.isAssignableFrom(returnClass);
    }

    private static boolean isPrimitiveArray(Class clss) {
        return clss.isArray() && clss.getComponentType().isPrimitive();
    }

    public static String getMethodReturnVarArrayType(Class returnClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jbooleanArray";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyteArray";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jcharArray";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshortArray";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jintArray";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlongArray";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloatArray";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdoubleArray";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jobjectArray";
        }
        return "jobjectArray";
    }

    public static String getMethodReturnVarType(Class returnClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnVarArrayType(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring";
        }
        return "jobject";
    }

    public static String getMethodReturnOutVarType(Class returnClass, Class relClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnVarArrayType(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring";
        }
        return J4CppMain.getCppType(returnClass, relClass);
    }

    public static String getMethodReturnArrayVarDeclare(Class returnClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jbooleanArray retVal=NULL;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyteArray retVal=NULL;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jcharArray retVal=NULL;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshortArray retVal=NULL;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jintArray retVal=NULL;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlongArray retVal=NULL;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloatArray retVal=NULL;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdoubleArray retVal=NULL;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jobjectArray retVal=NULL;";
        }
        return "jobjectArray retVal=NULL;";
    }

    public static String getMethodReturnVarDeclare(Class returnClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnArrayVarDeclare(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean retVal=false;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte retVal= (jbyte) -1;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar retVal= (jchar) -1;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort retVal=(jshort) -1;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint retVal= (jint) -1;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong retVal= (jlong) -1;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat retVal= (jfloat) -1.0;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble retVal= (jdouble) -1.0;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring retVal=NULL;";
        }
        return "jobject retVal=NULL;";
    }

    public static String getMethodReturnVarDeclareOut(Class returnClass, Class relClass) {
        if (returnClass.isArray()) {
            return J4CppMain.getMethodReturnArrayVarDeclare(returnClass.getComponentType());
        }
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "jboolean retVal=false;";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "jbyte retVal= (jbyte) -1;";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "jchar retVal= (jchar) -1;";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "jshort retVal=(jshort) -1;";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "jint retVal= (jint) -1;";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "jlong retVal= (jlong) -1;";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "jfloat retVal= (jfloat) -1.0;";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "jdouble retVal= (jdouble) -1.0;";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "";
        }
        if (Void.class.isAssignableFrom(returnClass)) {
            return "";
        }
        if (J4CppMain.isString(returnClass)) {
            return "jstring retVal=NULL;";
        }
        return J4CppMain.getCppType(returnClass, relClass) + " retVal((jobject)NULL,false);";
    }

    public static String getMethodCallString(Class returnClass) {
        if (Boolean.TYPE.isAssignableFrom(returnClass)) {
            return "Boolean";
        }
        if (Byte.TYPE.isAssignableFrom(returnClass)) {
            return "Byte";
        }
        if (Character.TYPE.isAssignableFrom(returnClass)) {
            return "Char";
        }
        if (Short.TYPE.isAssignableFrom(returnClass)) {
            return "Short";
        }
        if (Integer.TYPE.isAssignableFrom(returnClass)) {
            return "Int";
        }
        if (Long.TYPE.isAssignableFrom(returnClass)) {
            return "Long";
        }
        if (Float.TYPE.isAssignableFrom(returnClass)) {
            return "Float";
        }
        if (Double.TYPE.isAssignableFrom(returnClass)) {
            return "Double";
        }
        if (Void.TYPE.isAssignableFrom(returnClass)) {
            return "Void";
        }
        return "Object";
    }

    private static String replaceVars(Map<String, String> map, String orig_str) {
        String key = null;
        String val = null;
        String str = orig_str;
        try {
            for (Map.Entry<String, String> e : map.entrySet()) {
                key = e.getKey();
                val = e.getValue();
                if (null == val) {
                    val = "";
                }
                str = str.replace(key, val);
            }
        }
        catch (Throwable t) {
            System.err.println("orig_str=" + orig_str);
            System.err.println("str=" + str);
            System.err.println("key=" + key);
            System.err.println("val=" + val);
            System.err.println("map=" + map);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        return str;
    }

    private static boolean isVoid(Class<?> clss) {
        return clss.equals(Void.class) || clss.equals(Void.TYPE);
    }

    private static boolean isArrayStringMethod(Method m) {
        Class<?>[] paramClasses = m.getParameterTypes();
        return paramClasses.length == 1 && paramClasses[0].isArray() && paramClasses[0].getComponentType().equals(String.class);
    }

    private static boolean checkClass(Class<?> clss, List<Class> classes) {
        boolean ret;
        Class<?> componentClass = clss.getComponentType();
        boolean bl = ret = J4CppMain.isString(clss) || clss.equals(Object.class) || clss.isPrimitive() || clss.isArray() && null != componentClass && !componentClass.isArray() && J4CppMain.checkClass(componentClass, classes) || classes.contains(clss);
        if (!ret && verbose) {
            if (clss.isArray()) {
                System.out.println("checkClass skipping " + clss + " component " + clss.getComponentType());
            } else {
                System.out.println("checkClass skipping " + clss);
            }
        }
        return ret;
    }

    private static boolean checkParameters(Class[] paramTypes, List<Class> classes) {
        for (Class paramType : paramTypes) {
            if (J4CppMain.checkClass(paramType, classes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkMethod(Method m, List<Class> classes) {
        if (m.getDeclaringClass().getName().equals(m.getName())) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " method same as classname.");
            }
            return false;
        }
        if (m.getDeclaringClass().getName().endsWith("." + m.getName())) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " method same as classname.");
            }
            return false;
        }
        if (m.isSynthetic()) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " isSynthetic.");
            }
            return false;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " not public");
            }
            return false;
        }
        if (!J4CppMain.checkClass(m.getReturnType(), classes)) {
            if (verbose) {
                System.out.println("checkMethod skipping " + m + " return type not in classes list.");
            }
            return false;
        }
        boolean ret = J4CppMain.checkParameters(m.getParameterTypes(), classes);
        if (!ret && verbose) {
            System.out.println("checkMethod skipping " + m + " a parameter type is not in classes list");
        }
        return ret;
    }

    public static boolean isAddableClass(Class<?> clss, Set<Class> excludedClasses) {
        if (clss.isArray() || clss.isSynthetic() || clss.isAnnotation() || clss.isPrimitive()) {
            return false;
        }
        String canonicalName = null;
        try {
            canonicalName = clss.getCanonicalName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == canonicalName) {
            return false;
        }
        if (canonicalName.indexOf(36) >= 0) {
            return false;
        }
        String[] pkgNames = clss.getCanonicalName().split("\\.");
        for (int i = 0; i < pkgNames.length; ++i) {
            String pkgName = pkgNames[i];
            if (!badNames.contains(pkgName)) continue;
            return false;
        }
        Method[] ma = null;
        try {
            ma = clss.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == ma) {
            return false;
        }
        return !excludedClasses.contains(clss);
    }

    private static boolean isMethodToMakeEasy(Method m) {
        Class<?> type;
        int i;
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] types = m.getParameterTypes();
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (!type.isArray() || type.getComponentType().isPrimitive()) continue;
            return false;
        }
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (!type.isArray() && !J4CppMain.isString(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConstructorToMakeEasy(Constructor c, Class relClss) {
        Class<?> type;
        int i;
        Class<?>[] types = c.getParameterTypes();
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (!type.isArray() || type.getComponentType().isPrimitive()) continue;
            return false;
        }
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (!type.isArray() && !J4CppMain.isString(type)) continue;
            return true;
        }
        return false;
    }

    private static String getCppClassName(Class clss) {
        String clssName = clss.getCanonicalName();
        String[] pkgs = clssName.split("\\.");
        String clssOnlyName = pkgs[pkgs.length - 1];
        Class<?> enclosingClass = clss.getEnclosingClass();
        if (enclosingClass != null) {
            String enclosingClassName = enclosingClass.getCanonicalName();
            String[] enclosingPkgs = enclosingClassName.split("\\.");
            String enclosingName = enclosingPkgs[enclosingPkgs.length - 1];
            clssOnlyName = enclosingName + clssOnlyName;
        }
        return clssOnlyName;
    }

    private static String getEasyCallCppDeclaration(Method m, Class<?> relClass) {
        return J4CppMain.getCppModifiers(m.getModifiers()) + J4CppMain.getCppType(m.getReturnType(), relClass) + " " + J4CppMain.fixMethodName(m) + J4CppMain.getEasyCallCppParamDeclarations(m.getParameterTypes(), relClass) + ";";
    }

    public static boolean hasNoArgConstructor(Constructor[] constructors) {
        for (Constructor c : constructors) {
            if (!Modifier.isProtected(c.getModifiers()) && !Modifier.isPublic(c.getModifiers()) || c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean addGetterMethod(Field f, Class clss, List<Class> classes) {
        if (!Modifier.isPublic(f.getModifiers())) {
            return false;
        }
        if (!(f.getType().isPrimitive() || String.class.equals(f.getType()) || classes.contains(f.getType()))) {
            return false;
        }
        Method[] ma = clss.getMethods();
        for (int i = 0; i < ma.length; ++i) {
            Method method = ma[i];
            if (method.getName().equalsIgnoreCase(f.getName())) {
                return false;
            }
            if (method.getName().equalsIgnoreCase("get" + f.getName())) {
                return false;
            }
            if (!method.getName().equalsIgnoreCase("set" + f.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean addSetterMethod(Field f, Class clss, List<Class> classes) {
        if (!Modifier.isPublic(f.getModifiers())) {
            return false;
        }
        if (!(f.getType().isPrimitive() || String.class.equals(f.getType()) || classes.contains(f.getType()))) {
            return false;
        }
        if (Modifier.isFinal(f.getModifiers())) {
            return false;
        }
        Method[] ma = clss.getMethods();
        for (int i = 0; i < ma.length; ++i) {
            Method method = ma[i];
            if (method.getName().equalsIgnoreCase(f.getName())) {
                return false;
            }
            if (method.getName().equalsIgnoreCase("get" + f.getName())) {
                return false;
            }
            if (!method.getName().equalsIgnoreCase("set" + f.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getHomeDir() throws IOException {
        String userHomeProp = System.getProperty("user.home");
        if (verbose) {
            System.out.println("userDirProp = " + userHomeProp);
        }
        String homeDir = new File(userHomeProp).getCanonicalPath();
        if (verbose) {
            System.out.println("homeDir = " + homeDir);
        }
        return homeDir;
    }

    public static String getCurrentDir() throws IOException {
        String userDirProp = System.getProperty("user.dir");
        if (verbose) {
            System.out.println("userDirProp = " + userDirProp);
        }
        String currentDir = new File(userDirProp).getCanonicalPath();
        if (verbose) {
            System.out.println("currentDir = " + currentDir);
        }
        return currentDir.replace("\\", "\\\\");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int segment_index;
        Object e82;
        String header_file_base;
        Class<Object> superClass;
        int matchFound22;
        File f;
        main_completed = false;
        Options options = new Options();
        options.addOption(Option.builder("?").desc("Print this message").longOpt("help").build());
        options.addOption(Option.builder("n").hasArg().desc("C++ namespace for newly generated classes.").longOpt("namespace").build());
        options.addOption(Option.builder("c").hasArgs().desc("Single Java class to extract.").longOpt("classes").build());
        options.addOption(Option.builder("p").hasArgs().desc("Java Package prefix to extract").longOpt("packages").build());
        options.addOption(Option.builder("o").hasArg().desc("Output C++ source file.").longOpt("output").build());
        options.addOption(Option.builder("j").hasArg().desc("Input jar file").longOpt("jar").build());
        options.addOption(Option.builder("h").hasArg().desc("Output C++ header file.").longOpt("header").build());
        options.addOption(Option.builder("l").hasArg().desc("Maximum limit on classes to extract from jars.[default=200]").longOpt("limit").build());
        options.addOption(Option.builder("v").desc("enable verbose output").longOpt("verbose").build());
        options.addOption(Option.builder().hasArg().desc("Classes per output file.[default=10]").longOpt(CLASSESPEROUTPUT).build());
        options.addOption(Option.builder().hasArgs().desc("Comma seperated list of nativeclass=javaclass native where nativeclass will be generated as an extension/implementation of the java class.").longOpt("natives").build());
        options.addOption(Option.builder().hasArg().desc("library name for System.loadLibrary(...) for native extension classes").longOpt("loadlibname").build());
        String output = null;
        String header = null;
        String jar = null;
        HashSet<String> classnamesToFind = null;
        HashSet<String> packageprefixes = null;
        String loadlibname = null;
        HashMap<String, String> nativesNameMap = null;
        HashMap nativesClassMap = null;
        int limit = 200;
        int classes_per_file = 10;
        ArrayList<Class> classes = new ArrayList<Class>();
        String limitstring = Integer.toString(limit);
        try {
            System.out.println("args = " + Arrays.toString(args));
            CommandLine line = new DefaultParser().parse(options, args);
            loadlibname = line.getOptionValue("loadlibname");
            verbose = line.hasOption("verbose");
            if (line.hasOption(CLASSESPEROUTPUT)) {
                String cpoStr = line.getOptionValue(CLASSESPEROUTPUT);
                try {
                    int cpoI;
                    classes_per_file = cpoI = Integer.valueOf(cpoStr).intValue();
                }
                catch (Exception e2) {
                    System.err.println("Option for classes-per-output=\"" + cpoStr + "\"");
                    J4CppMain.printHelpAndExit(options, args);
                }
            }
            if (line.hasOption("natives")) {
                Object[] natives = line.getOptionValues("natives");
                if (verbose) {
                    System.out.println("natives = " + Arrays.toString(natives));
                }
                nativesNameMap = new HashMap<String, String>();
                nativesClassMap = new HashMap();
                for (int i = 0; i < natives.length; ++i) {
                    int eq_index = ((String)natives[i]).indexOf(61);
                    String nativeClassName = ((String)natives[i]).substring(0, eq_index).trim();
                    String string = ((String)natives[i]).substring(eq_index + 1).trim();
                    Class<?> javaClass = null;
                    try {
                        javaClass = Class.forName(string);
                    }
                    catch (ClassNotFoundException e3) {
                        System.err.println("Class for " + string + " not found. (It may be found later in jar if specified.)");
                    }
                    nativesNameMap.put(string, nativeClassName);
                    if (javaClass == null) continue;
                    nativesClassMap.put(nativeClassName, javaClass);
                    if (classes.contains(javaClass)) continue;
                    classes.add(javaClass);
                }
            }
            jar = line.getOptionValue("jar", jar);
            if (verbose) {
                System.out.println("jar = " + jar);
            }
            if (null != jar) {
                if (jar.startsWith("~/")) {
                    jar = new File(new File(J4CppMain.getHomeDir()), jar.substring(2)).getCanonicalPath();
                }
                if (jar.startsWith("./")) {
                    jar = new File(new File(J4CppMain.getCurrentDir()), jar.substring(2)).getCanonicalPath();
                }
                if (jar.startsWith("../")) {
                    jar = new File(new File(J4CppMain.getCurrentDir()).getParentFile(), jar.substring(3)).getCanonicalPath();
                }
            }
            if (line.hasOption("classes")) {
                classnamesToFind = new HashSet<String>();
                Object[] classStrings = line.getOptionValues("classes");
                if (verbose) {
                    System.out.println("classStrings = " + Arrays.toString(classStrings));
                }
                classnamesToFind.addAll(Arrays.asList(classStrings));
                if (verbose) {
                    System.out.println("classnamesToFind = " + classnamesToFind);
                }
            }
            namespace = line.getOptionValue("namespace", namespace);
            if (verbose) {
                System.out.println("namespace = " + namespace);
            }
            if (null != namespace) {
                output = namespace + ".cpp";
            }
            output = line.getOptionValue("output", output);
            if (verbose) {
                System.out.println("output = " + output);
            }
            if (null != output) {
                if (output.startsWith("~/")) {
                    output = System.getProperty("user.home") + output.substring(1);
                }
                header = output.substring(0, output.lastIndexOf(46)) + ".h";
            } else {
                output = "out.cpp";
            }
            header = line.getOptionValue("header", header);
            if (verbose) {
                System.out.println("header = " + header);
            }
            if (null != header) {
                if (header.startsWith("~/")) {
                    header = System.getProperty("user.home") + header.substring(1);
                }
            } else {
                header = "out.h";
            }
            if (line.hasOption("packages")) {
                packageprefixes = new HashSet<String>();
                packageprefixes.addAll(Arrays.asList(line.getOptionValues("packages")));
            }
            if (line.hasOption("limit")) {
                limitstring = line.getOptionValue("limit", Integer.toString(200));
                limit = Integer.valueOf(limitstring);
            }
            if (line.hasOption("help")) {
                J4CppMain.printHelpAndExit(options, args);
            }
        }
        catch (ParseException exp) {
            if (verbose) {
                System.out.println("Unexpected exception:" + exp.getMessage());
            }
            J4CppMain.printHelpAndExit(options, args);
        }
        HashSet<Class> excludedClasses = new HashSet<Class>();
        HashSet<String> foundClassNames = new HashSet<String>();
        excludedClasses.add(Object.class);
        excludedClasses.add(String.class);
        excludedClasses.add(Void.TYPE);
        excludedClasses.add(Void.class);
        excludedClasses.add(Class.class);
        excludedClasses.add(Enum.class);
        TreeSet<String> packagesSet = new TreeSet<String>();
        ArrayList<URL> urlsList = new ArrayList<URL>();
        String cp = System.getProperty("java.class.path");
        if (verbose) {
            System.out.println("System.getProperty(\"java.class.path\") = " + cp);
        }
        if (null != cp) {
            for (String cpe : cp.split(File.pathSeparator)) {
                if (verbose) {
                    System.out.println("class path element = " + cpe);
                }
                if ((f = new File(cpe)).isDirectory()) {
                    urlsList.add(new URL("file:" + f.getCanonicalPath() + File.separator));
                    continue;
                }
                if (!cpe.endsWith(".jar")) continue;
                urlsList.add(new URL("jar:file:" + f.getCanonicalPath() + "!/"));
            }
        }
        cp = System.getenv("CLASSPATH");
        if (verbose) {
            System.out.println("System.getenv(\"CLASSPATH\") = " + cp);
        }
        if (null != cp) {
            for (String cpe : cp.split(File.pathSeparator)) {
                if (verbose) {
                    System.out.println("class path element = " + cpe);
                }
                if ((f = new File(cpe)).isDirectory()) {
                    urlsList.add(new URL("file:" + f.getCanonicalPath() + File.separator));
                    continue;
                }
                if (!cpe.endsWith(".jar")) continue;
                urlsList.add(new URL("jar:file:" + f.getCanonicalPath() + "!/"));
            }
        }
        if (verbose) {
            System.out.println("urlsList = " + urlsList);
        }
        if (null != jar && jar.length() > 0) {
            Path path = FileSystems.getDefault().getPath(jar, new String[0]);
            ZipInputStream zip = new ZipInputStream(Files.newInputStream(path, StandardOpenOption.READ));
            URL jarUrl = new URL("jar:file:" + path.toFile().getCanonicalPath() + "!/");
            urlsList.add(jarUrl);
            Object[] urls = urlsList.toArray(new URL[urlsList.size()]);
            if (verbose) {
                System.out.println("urls = " + Arrays.toString(urls));
            }
            URLClassLoader cl = URLClassLoader.newInstance((URL[])urls);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                block265: {
                    String entryName = entry.getName();
                    if (verbose) {
                        System.out.println("entryName = " + entryName);
                    }
                    if (!entry.isDirectory() && entryName.endsWith(".class") && entryName.indexOf(36) < 0) {
                        String classFileName = entry.getName().replace('/', '.');
                        String className = classFileName.substring(0, classFileName.length() - ".class".length());
                        if (classnamesToFind != null && classnamesToFind.size() > 0 && !classnamesToFind.contains(className)) {
                            if (verbose) {
                                System.out.println("skipping className=" + className + " because it does not found in=" + classnamesToFind);
                            }
                        } else {
                            try {
                                Package p;
                                Class<?> clss = cl.loadClass(className);
                                if (null != nativesClassMap && null != nativesNameMap && nativesNameMap.containsKey(className)) {
                                    nativesClassMap.put((String)nativesNameMap.get(className), clss);
                                    if (!classes.contains(clss)) {
                                        classes.add(clss);
                                    }
                                }
                                if (packageprefixes != null && packageprefixes.size() > 0) {
                                    if (null == clss.getPackage()) break block265;
                                    String pkgName = clss.getPackage().getName();
                                    matchFound22 = 0;
                                    for (String string : packageprefixes) {
                                        if (!pkgName.startsWith(string)) continue;
                                        matchFound22 = 1;
                                        break;
                                    }
                                    if (matchFound22 == 0) break block265;
                                }
                                if (null != (p = clss.getPackage())) {
                                    packagesSet.add(clss.getPackage().getName());
                                }
                                if (!classes.contains(clss) && J4CppMain.isAddableClass(clss, excludedClasses)) {
                                    if (null != classnamesToFind && classnamesToFind.contains(className) && !foundClassNames.contains(className)) {
                                        foundClassNames.add(className);
                                        if (verbose) {
                                            System.out.println("foundClassNames = " + foundClassNames);
                                        }
                                    }
                                    classes.add(clss);
                                }
                            }
                            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                                System.err.println("Caught " + ex.getClass().getName() + ":" + ex.getMessage() + " for className=" + className + ", entryName=" + entryName + ", jarPath=" + path);
                            }
                        }
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        if (null != classnamesToFind) {
            if (verbose) {
                System.out.println("Checking classnames arguments");
            }
            for (String classname : classnamesToFind) {
                Class<?> c;
                block266: {
                    if (verbose) {
                        System.out.println("classname = " + classname);
                    }
                    if (foundClassNames.contains(classname)) {
                        if (!verbose) continue;
                        System.out.println("foundClassNames.contains(" + classname + ")");
                        continue;
                    }
                    try {
                        if (classes.contains(Class.forName(classname))) {
                            if (!verbose) continue;
                            System.out.println("Classes list already contains:  " + classname);
                            continue;
                        }
                    }
                    catch (Exception jarUrl) {
                        // empty catch block
                    }
                    if (null == classname || classname.length() <= 0) continue;
                    urlsList.add(new URL("file://" + System.getProperty("user.dir") + "/"));
                    Object[] urls = urlsList.toArray(new URL[urlsList.size()]);
                    if (verbose) {
                        System.out.println("urls = " + Arrays.toString(urls));
                    }
                    URLClassLoader cl = URLClassLoader.newInstance((URL[])urls);
                    c = null;
                    try {
                        c = cl.loadClass(classname);
                    }
                    catch (ClassNotFoundException e4) {
                        System.err.println("Class " + classname + " not found ");
                    }
                    if (verbose) {
                        System.out.println("c = " + c);
                    }
                    if (null == c) {
                        try {
                            c = ClassLoader.getSystemClassLoader().loadClass(classname);
                        }
                        catch (ClassNotFoundException e5) {
                            if (!verbose) break block266;
                            System.out.println("System ClassLoader failed to find " + classname);
                        }
                    }
                }
                if (null != c) {
                    classes.add(c);
                    continue;
                }
                System.err.println("Class " + classname + " not found");
            }
            if (verbose) {
                System.out.println("Finished checking classnames arguments");
            }
        }
        if (!(classes != null && classes.size() >= 1 || null != nativesClassMap && nativesClassMap.keySet().size() >= 1)) {
            System.err.println("No Classes specified or found.");
            System.exit(1);
        }
        if (verbose) {
            System.out.println("Classes found = " + classes.size());
        }
        if (classes.size() > limit) {
            System.err.println("limit=" + limit);
            System.err.println("Too many classes please use -c or -p options to limit classes or -l to increase limit.");
            if (verbose) {
                System.out.println("packagesSet = " + packagesSet);
            }
            System.exit(1);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Class clss : classes) {
            Class<?>[] fClass;
            for (superClass = clss.getSuperclass(); null != superClass && !classes.contains(superClass) && !arrayList.contains(superClass) && J4CppMain.isAddableClass(superClass, excludedClasses); superClass = superClass.getSuperclass()) {
                arrayList.add(superClass);
            }
            try {
                Field[] fa;
                Field[] e5 = fa = clss.getDeclaredFields();
                int entryName = e5.length;
                for (int classFileName = 0; classFileName < entryName; ++classFileName) {
                    Field f2 = e5[classFileName];
                    if (!Modifier.isPublic(f2.getModifiers()) || classes.contains(fClass = f2.getType()) || arrayList.contains(fClass) || !J4CppMain.isAddableClass(fClass, excludedClasses)) continue;
                    arrayList.add(fClass);
                }
            }
            catch (NoClassDefFoundError e6) {
                e6.printStackTrace();
            }
            for (Method m : clss.getDeclaredMethods()) {
                if (m.isSynthetic() || !Modifier.isPublic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers())) continue;
                Class<?> retType = m.getReturnType();
                if (verbose) {
                    System.out.println("Checking dependancies for Method = " + m);
                }
                if (!classes.contains(retType) && !arrayList.contains(retType) && J4CppMain.isAddableClass(retType, excludedClasses)) {
                    arrayList.add(retType);
                    for (superClass = retType.getSuperclass(); null != superClass && !classes.contains(superClass) && !arrayList.contains(superClass) && J4CppMain.isAddableClass(superClass, excludedClasses); superClass = superClass.getSuperclass()) {
                        arrayList.add(superClass);
                    }
                }
                fClass = m.getParameterTypes();
                int p = fClass.length;
                for (matchFound22 = 0; matchFound22 < p; ++matchFound22) {
                    Class<?> paramType = fClass[matchFound22];
                    if (classes.contains(paramType) || arrayList.contains(paramType) || !J4CppMain.isAddableClass(paramType, excludedClasses)) continue;
                    arrayList.add(paramType);
                    for (superClass = paramType.getSuperclass(); !(null == superClass || classes.contains(superClass) || arrayList.contains(superClass) || excludedClasses.contains(superClass)); superClass = superClass.getSuperclass()) {
                        arrayList.add(superClass);
                    }
                }
            }
        }
        if (null != nativesClassMap) {
            for (Class clss : nativesClassMap.values()) {
                if (null == clss) continue;
                for (superClass = clss.getSuperclass(); !(null == superClass || classes.contains(superClass) || arrayList.contains(superClass) || excludedClasses.contains(superClass)); superClass = superClass.getSuperclass()) {
                    arrayList.add(superClass);
                }
            }
        }
        if (verbose) {
            System.out.println("Dependency classes needed = " + arrayList.size());
        }
        classes.addAll(arrayList);
        ArrayList newOrderClasses = new ArrayList();
        for (Class clss : classes) {
            if (newOrderClasses.contains(clss)) continue;
            Stack stack = new Stack();
            for (Class superClass2 = clss.getSuperclass(); null != superClass2 && !newOrderClasses.contains(superClass2) && !superClass2.equals(Object.class); superClass2 = superClass2.getSuperclass()) {
                stack.push(superClass2);
            }
            while (!stack.empty()) {
                newOrderClasses.add(stack.pop());
            }
            newOrderClasses.add(clss);
        }
        classes = newOrderClasses;
        if (verbose) {
            System.out.println("Total number of classes = " + classes.size());
            System.out.println("classes = " + classes);
        }
        String forward_header = header.substring(0, header.lastIndexOf(46)) + "_fwd.h";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(JAR, jar != null ? jar : "");
        map.put("%CLASSPATH_PREFIX%", J4CppMain.getCurrentDir() + (jar != null ? File.pathSeparator + new File(jar).getCanonicalPath().replace("\\", "\\\\") : ""));
        map.put("%FORWARD_HEADER%", forward_header);
        map.put(HEADER, header);
        map.put("%PATH_SEPERATOR%", File.pathSeparator);
        String tabs = "";
        String headerDefine = forward_header.substring(Math.max(0, forward_header.indexOf(File.separator))).replace(".", "_");
        map.put(HEADER_DEFINE, headerDefine);
        map.put(NAMESPACE, namespace);
        if (null != nativesClassMap) {
            for (Map.Entry e7 : nativesClassMap.entrySet()) {
                Class javaClass = (Class)e7.getValue();
                String nativeClassName = (String)e7.getKey();
                PrintWriter pw = new PrintWriter(new FileWriter(nativeClassName + ".java"));
                Throwable matchFound22 = null;
                try {
                    Method[] ma;
                    if (javaClass.isInterface()) {
                        pw.println("public class " + nativeClassName + " implements " + javaClass.getCanonicalName() + ", AutoCloseable{");
                    } else {
                        pw.println("public class " + nativeClassName + " extends " + javaClass.getCanonicalName() + " implements AutoCloseable{");
                    }
                    if (null != loadlibname && loadlibname.length() > 0) {
                        pw.println("    static {");
                        pw.println("        System.loadLibrary(\"" + loadlibname + "\");");
                        pw.println("    }");
                        pw.println();
                    }
                    pw.println("    public " + nativeClassName + "() {");
                    pw.println("    }");
                    pw.println();
                    pw.println("    private long nativeAddress=0;");
                    pw.println("    private boolean nativeDeleteOnClose=false;");
                    pw.println();
                    pw.println("    protected " + nativeClassName + "(final long nativeAddress) {");
                    pw.println("        this.nativeAddress = nativeAddress;");
                    pw.println("    }");
                    pw.println("    private native void nativeDelete();");
                    pw.println();
                    pw.println("    @Override");
                    pw.println("    public synchronized void  close() {");
                    pw.println("        nativeDelete();");
                    pw.println("    }");
                    pw.println();
                    pw.println("    protected void finalizer() {");
                    pw.println("        close();");
                    pw.println("    }");
                    pw.println();
                    for (Method m : ma = javaClass.getDeclaredMethods()) {
                        void var37_132;
                        int modifiers = m.getModifiers();
                        if (!Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || m.isSynthetic()) continue;
                        pw.println();
                        pw.println("    @Override");
                        String string = "";
                        for (int i = 0; i < m.getParameterTypes().length; ++i) {
                            String string2 = (String)var37_132 + m.getParameterTypes()[i].getCanonicalName() + " param" + i;
                            if (i >= m.getParameterTypes().length - 1) continue;
                            String string3 = string2 + ",";
                        }
                        pw.println("    native public " + m.getReturnType().getCanonicalName() + " " + m.getName() + "(" + (String)var37_132 + ");");
                    }
                    pw.println("}");
                }
                catch (Throwable ma) {
                    matchFound22 = ma;
                    throw ma;
                }
                finally {
                    if (pw == null) continue;
                    if (matchFound22 != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable ma) {
                            matchFound22.addSuppressed(ma);
                        }
                        continue;
                    }
                    pw.close();
                }
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(forward_header));){
            tabs = "";
            J4CppMain.processTemplate(pw, map, "header_fwd_template_start.h", tabs);
            Class lastClass = null;
            for (int class_index = 0; class_index < classes.size(); ++class_index) {
                Class clss = (Class)classes.get(class_index);
                String clssOnlyName = J4CppMain.getCppClassName(clss);
                tabs = J4CppMain.openClassNamespace(clss, pw, tabs, lastClass);
                tabs = tabs + TAB_STRING;
                pw.println(tabs + "class " + clssOnlyName + ";");
                tabs = tabs.substring(0, tabs.length() - 1);
                Class nextClass = class_index < classes.size() - 1 ? (Class)classes.get(class_index + 1) : null;
                tabs = J4CppMain.closeClassNamespace(clss, pw, tabs, nextClass);
                lastClass = clss;
            }
            J4CppMain.processTemplate(pw, map, "header_fwd_template_end.h", tabs);
        }
        headerDefine = header.substring(Math.max(0, header.indexOf(File.separator))).replace(".", "_");
        map.put(HEADER_DEFINE, headerDefine);
        map.put(NAMESPACE, namespace);
        if (classes_per_file < 1) {
            classes_per_file = classes.size();
        }
        int num_class_segments = classes.size() > 1 ? (classes.size() + classes_per_file - 1) / classes_per_file : 1;
        String fmt = "%d";
        if (num_class_segments > 10) {
            fmt = "%02d";
        }
        if (num_class_segments > 100) {
            fmt = "%03d";
        }
        if ((header_file_base = header).endsWith(".h")) {
            header_file_base = header_file_base.substring(0, header_file_base.length() - 2);
        } else if (header_file_base.endsWith(".hh")) {
            header_file_base = header_file_base.substring(0, header_file_base.length() - 3);
        } else if (header_file_base.endsWith(".hpp")) {
            header_file_base = header_file_base.substring(0, header_file_base.length() - 4);
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(header));){
            tabs = "";
            J4CppMain.processTemplate(pw, map, HEADER_TEMPLATE_STARTH, tabs);
            for (int segment_index2 = 0; segment_index2 < num_class_segments; ++segment_index2) {
                String header_segment_file = header_file_base + String.format(fmt, segment_index2) + ".h";
                pw.println("#include \"" + header_segment_file + "\"");
            }
            if (null != nativesClassMap) {
                tabs = TAB_STRING;
                for (Object e82 : nativesClassMap.entrySet()) {
                    Class clazz = (Class)e82.getValue();
                    String nativeClassName = (String)e82.getKey();
                    pw.println();
                    pw.println(tabs + "class " + nativeClassName + "Context;");
                    pw.println();
                    map.put(CLASS_NAME, nativeClassName);
                    map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(clazz).replace(".", "::"));
                    map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                    J4CppMain.processTemplate(pw, map, HEADER_CLASS_STARTH, tabs);
                    tabs = tabs + TAB_STRING;
                    pw.println(tabs + nativeClassName + "Context *context;");
                    pw.println(tabs + nativeClassName + "();");
                    pw.println(tabs + "~" + nativeClassName + "();");
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        int n = method.getModifiers();
                        if (!Modifier.isPublic(n) || !Modifier.isAbstract(n) || !Modifier.isPublic(n) || Modifier.isStatic(n) || method.isSynthetic()) continue;
                        pw.println(tabs + J4CppMain.getNativeMethodCppDeclaration(method, clazz));
                    }
                    pw.println(tabs + "void initContext(" + nativeClassName + "Context *ctx,bool isref);");
                    pw.println(tabs + "void deleteContext();");
                    tabs = tabs.substring(TAB_STRING.length());
                    pw.println(tabs + "}; // end class " + nativeClassName);
                }
            }
            tabs = "";
            J4CppMain.processTemplate(pw, map, HEADER_TEMPLATE_ENDH, tabs);
        }
        for (segment_index = 0; segment_index < num_class_segments; ++segment_index) {
            String header_segment_file = header_file_base + String.format(fmt, segment_index) + ".h";
            PrintWriter pw = new PrintWriter(new FileWriter(header_segment_file));
            e82 = null;
            try {
                tabs = "";
                pw.println("// Never include this file (" + header_segment_file + ") directly. include " + header + " instead.");
                pw.println();
                Object var32_99 = null;
                int start_segment_index = segment_index * classes_per_file;
                int end_segment_index = Math.min(segment_index * classes_per_file + classes_per_file, classes.size());
                List classesSegList = classes.subList(start_segment_index, end_segment_index);
                pw.println();
                pw.println(tabs + "// start_segment_index = " + start_segment_index);
                pw.println(tabs + "// start_segment_index = " + end_segment_index);
                pw.println(tabs + "// segment_index = " + segment_index);
                pw.println(tabs + "// classesSegList=" + classesSegList);
                pw.println();
                for (int class_index = 0; class_index < classesSegList.size(); ++class_index) {
                    void var32_100;
                    Class clazz = (Class)classesSegList.get(class_index);
                    pw.println();
                    pw.println(tabs + "// class_index = " + class_index + " clss=" + clazz);
                    pw.println();
                    String clssName = clazz.getCanonicalName();
                    tabs = J4CppMain.openClassNamespace(clazz, pw, tabs, (Class)var32_100);
                    String clssOnlyName = J4CppMain.getCppClassName(clazz);
                    map.put(CLASS_NAME, clssOnlyName);
                    map.put("%BASE_CLASS_FULL_NAME%", J4CppMain.classToCppBase(clazz));
                    map.put(OBJECT_CLASS_FULL_NAME, J4CppMain.getCppRelativeName(Object.class, clazz));
                    tabs = tabs + TAB_STRING;
                    J4CppMain.processTemplate(pw, map, HEADER_CLASS_STARTH, tabs);
                    tabs = tabs + TAB_STRING;
                    Constructor[] constructors = clazz.getDeclaredConstructors();
                    if (!J4CppMain.hasNoArgConstructor(constructors)) {
                        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) {
                            pw.println(tabs + "protected:");
                            pw.println(tabs + clssOnlyName + "() {};");
                            pw.println(tabs + "public:");
                        } else {
                            if (constructors.length > 0) {
                                pw.println(tabs + "protected:");
                            }
                            pw.println(tabs + clssOnlyName + "();");
                            if (constructors.length > 0) {
                                pw.println(tabs + "public:");
                            }
                        }
                    }
                    for (Constructor c : constructors) {
                        if (c.getParameterTypes().length == 0 && Modifier.isProtected(c.getModifiers())) {
                            pw.println(tabs + "protected:");
                            pw.println(tabs + clssOnlyName + "();");
                            pw.println(tabs + "public:");
                        }
                        if (J4CppMain.checkConstructor(c, clazz, classes) || c.getParameterTypes().length == 1 && clazz.isAssignableFrom(c.getParameterTypes()[0]) || !Modifier.isPublic(c.getModifiers()) || c.getParameterTypes().length == 1 && c.getParameterTypes()[0].getName().equals(clazz.getName()) || !J4CppMain.checkParameters(c.getParameterTypes(), classes)) continue;
                        pw.println(tabs + clssOnlyName + J4CppMain.getCppParamDeclarations(c.getParameterTypes(), clazz) + ";");
                        if (!J4CppMain.isConstructorToMakeEasy(c, clazz)) continue;
                        pw.println(tabs + clssOnlyName + J4CppMain.getEasyCallCppParamDeclarations(c.getParameterTypes(), clazz) + ";");
                    }
                    pw.println(tabs + "~" + clssOnlyName + "();");
                    Field[] fa = clazz.getDeclaredFields();
                    for (int findex = 0; findex < fa.length; ++findex) {
                        Field field = fa[findex];
                        if (J4CppMain.addGetterMethod(field, clazz, classes)) {
                            pw.println(tabs + J4CppMain.getCppFieldGetterDeclaration(field, clazz));
                        }
                        if (!J4CppMain.addSetterMethod(field, clazz, classes)) continue;
                        pw.println(tabs + J4CppMain.getCppFieldSetterDeclaration(field, clazz));
                    }
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        if (!J4CppMain.checkMethod(method, classes)) continue;
                        if ((method.getModifiers() & 1) == 1) {
                            pw.println(tabs + J4CppMain.getCppDeclaration(method, clazz));
                        }
                        if (J4CppMain.isArrayStringMethod(method)) {
                            pw.println(tabs + J4CppMain.getCppModifiers(method.getModifiers()) + J4CppMain.getCppType(method.getReturnType(), clazz) + " " + J4CppMain.fixMethodName(method) + "(int argc,const char **argv);");
                        }
                        if (!J4CppMain.isMethodToMakeEasy(method)) continue;
                        pw.println(tabs + J4CppMain.getEasyCallCppDeclaration(method, clazz));
                    }
                    tabs = tabs.substring(TAB_STRING.length());
                    pw.println(tabs + "}; // end class " + clssOnlyName);
                    tabs = tabs.substring(0, tabs.length() - 1);
                    Class nextClass = class_index < classesSegList.size() - 1 ? (Class)classesSegList.get(class_index + 1) : null;
                    tabs = J4CppMain.closeClassNamespace(clazz, pw, tabs, nextClass);
                    pw.println();
                    Class clazz2 = clazz;
                }
                continue;
            }
            catch (Throwable throwable) {
                e82 = throwable;
                throw throwable;
            }
            finally {
                if (pw != null) {
                    if (e82 != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)e82).addSuppressed(throwable);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
        for (segment_index = 0; segment_index < num_class_segments; ++segment_index) {
            Serializable lastClass;
            String output_segment_file = output;
            if (output_segment_file.endsWith(".cpp")) {
                output_segment_file = output_segment_file.substring(0, output_segment_file.length() - 4);
            } else if (output_segment_file.endsWith(".cc")) {
                output_segment_file = output_segment_file.substring(0, output_segment_file.length() - 3);
            }
            output_segment_file = output_segment_file + "" + String.format(fmt, segment_index) + ".cpp";
            PrintWriter pw = new PrintWriter(new FileWriter(output_segment_file));
            e82 = null;
            try {
                String retStore;
                tabs = "";
                if (segment_index < 1) {
                    J4CppMain.processTemplate(pw, map, "cpp_template_start_first.cpp", tabs);
                } else {
                    J4CppMain.processTemplate(pw, map, CPP_TEMPLATE_STARTCPP, tabs);
                }
                int n = segment_index * classes_per_file;
                int end_segment_index = Math.min(segment_index * classes_per_file + classes_per_file, classes.size());
                List classesSegList = classes.subList(n, end_segment_index);
                pw.println();
                pw.println(tabs + "// start_segment_index = " + n);
                pw.println(tabs + "// start_segment_index = " + end_segment_index);
                pw.println(tabs + "// segment_index = " + segment_index);
                pw.println(tabs + "// classesSegList=" + classesSegList);
                pw.println();
                lastClass = null;
                for (int class_index = 0; class_index < classesSegList.size(); ++class_index) {
                    Class<?>[] paramClasses;
                    Class clazz = (Class)classesSegList.get(class_index);
                    pw.println();
                    pw.println(tabs + "// class_index = " + class_index + " clss=" + clazz);
                    pw.println();
                    String clssName = clazz.getCanonicalName();
                    tabs = J4CppMain.openClassNamespace(clazz, pw, tabs, lastClass);
                    String clssOnlyName = J4CppMain.getCppClassName(clazz);
                    map.put(CLASS_NAME, clssOnlyName);
                    map.put("%BASE_CLASS_FULL_NAME%", J4CppMain.classToCppBase(clazz));
                    map.put(FULL_CLASS_NAME, clssName);
                    String fcjs = J4CppMain.classToJNISignature(clazz);
                    fcjs = fcjs.substring(1, fcjs.length() - 1);
                    map.put(FULL_CLASS_JNI_SIGNATURE, fcjs);
                    if (verbose) {
                        System.out.println("fcjs = " + fcjs);
                    }
                    map.put(OBJECT_CLASS_FULL_NAME, J4CppMain.getCppRelativeName(Object.class, clazz));
                    map.put("%INITIALIZE_CONTEXT%", "");
                    map.put("%INITIALIZE_CONTEXT_REF%", "");
                    J4CppMain.processTemplate(pw, map, CPP_START_CLASSCPP, tabs);
                    Constructor[] constructors = clazz.getDeclaredConstructors();
                    if (!(J4CppMain.hasNoArgConstructor(constructors) || Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface())) {
                        pw.println(tabs + clssOnlyName + "::" + clssOnlyName + "() : " + J4CppMain.classToCppBase(clazz) + "((jobject)NULL,false) {");
                        map.put(JNI_SIGNATURE, "()V");
                        map.put(CONSTRUCTOR_ARGS, "");
                        J4CppMain.processTemplate(pw, map, CPP_NEWCPP, tabs);
                        pw.println(tabs + "}");
                        pw.println();
                    }
                    for (Constructor c : constructors) {
                        String callString;
                        String parmName;
                        Class<?> paramClasse;
                        int paramIndex;
                        if (J4CppMain.checkConstructor(c, clazz, classes)) continue;
                        paramClasses = c.getParameterTypes();
                        pw.println(tabs + clssOnlyName + "::" + clssOnlyName + J4CppMain.getCppParamDeclarations(paramClasses, clazz) + " : " + J4CppMain.classToCppBase(clazz) + "((jobject)NULL,false) {");
                        tabs = tabs + TAB_STRING;
                        map.put(JNI_SIGNATURE, "(" + J4CppMain.getJNIParamSignature(paramClasses) + ")V");
                        map.put(CONSTRUCTOR_ARGS, (paramClasses.length > 0 ? "," : "") + J4CppMain.getCppParamNames(paramClasses));
                        J4CppMain.processTemplate(pw, map, CPP_NEWCPP, tabs);
                        tabs = tabs.substring(0, tabs.length() - 1);
                        pw.println(tabs + "}");
                        pw.println();
                        if (!J4CppMain.isConstructorToMakeEasy(c, clazz)) continue;
                        pw.println(tabs + clssOnlyName + "::" + clssOnlyName + J4CppMain.getEasyCallCppParamDeclarations(c.getParameterTypes(), clazz) + " : " + J4CppMain.classToCppBase(clazz) + "((jobject)NULL,false) {");
                        J4CppMain.processTemplate(pw, map, "cpp_start_easy_constructor.cpp", tabs);
                        for (paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            paramClasse = paramClasses[paramIndex];
                            parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw.println(tabs + "jstring " + parmName + " = env->NewStringUTF(easyArg_" + paramIndex + ");");
                                continue;
                            }
                            if (J4CppMain.isPrimitiveArray(paramClasse)) {
                                callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                                pw.println(tabs + J4CppMain.getCppArrayType(paramClasse.getComponentType()) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= env->New" + callString + "Array(easyArg_" + paramIndex + "_length);");
                                pw.println(tabs + "env->Set" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                                continue;
                            }
                            pw.println(tabs + J4CppMain.getCppType(paramClasse, clazz) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= easyArg_" + paramIndex + ";");
                        }
                        J4CppMain.processTemplate(pw, map, "cpp_new_easy_internals.cpp", tabs);
                        for (paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            paramClasse = paramClasses[paramIndex];
                            parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw.println(tabs + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                                pw.println(tabs + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                                pw.println(tabs + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                                pw.println(tabs + "}");
                                continue;
                            }
                            if (!J4CppMain.isPrimitiveArray(paramClasse)) continue;
                            callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                            pw.println(tabs + "env->Get" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                            pw.println(tabs + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                            pw.println(tabs + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                            pw.println(tabs + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                            pw.println(tabs + "}");
                        }
                        J4CppMain.processTemplate(pw, map, "cpp_end_easy_constructor.cpp", tabs);
                        pw.println(tabs + "}");
                    }
                    pw.println();
                    pw.println(tabs + "// Destructor for " + clssName);
                    pw.println(tabs + clssOnlyName + "::~" + clssOnlyName + "() {");
                    pw.println(tabs + "\t// Place-holder for later extensibility.");
                    pw.println(tabs + "}");
                    pw.println();
                    Field[] fa = clazz.getDeclaredFields();
                    for (int findex = 0; findex < fa.length; ++findex) {
                        Class<Object> returnClass;
                        Field field = fa[findex];
                        if (J4CppMain.addGetterMethod(field, clazz, classes)) {
                            pw.println();
                            pw.println(tabs + "// Field getter for " + field.getName());
                            pw.println(J4CppMain.getCppFieldGetterDefinitionStart(tabs, clssOnlyName, field, clazz));
                            map.put("%FIELD_NAME%", field.getName());
                            map.put(JNI_SIGNATURE, J4CppMain.classToJNISignature(field.getType()));
                            returnClass = field.getType();
                            map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                            map.put(METHOD_ARGS, "");
                            map.put("%METHOD_RETURN%", J4CppMain.isVoid(returnClass) ? "" : "return");
                            map.put("%METHOD_CALL_TYPE%", J4CppMain.getMethodCallString(returnClass));
                            map.put("%METHOD_RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                            map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                            String retStore2 = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                            map.put(METHOD_RETURN_STORE, retStore2);
                            map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet(tabs, returnClass, clazz));
                            if (Modifier.isStatic(field.getModifiers())) {
                                J4CppMain.processTemplate(pw, map, "cpp_static_getfield.cpp", tabs);
                            } else {
                                J4CppMain.processTemplate(pw, map, "cpp_getfield.cpp", tabs);
                            }
                            pw.println(tabs + "}");
                        }
                        if (!J4CppMain.addSetterMethod(field, clazz, classes)) continue;
                        pw.println();
                        pw.println(tabs + "// Field setter for " + field.getName());
                        pw.println(J4CppMain.getCppFieldSetterDefinitionStart(tabs, clssOnlyName, field, clazz));
                        map.put("%FIELD_NAME%", field.getName());
                        map.put(JNI_SIGNATURE, J4CppMain.classToJNISignature(field.getType()));
                        returnClass = Void.TYPE;
                        map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                        paramClasses = new Class[]{field.getType()};
                        String methodArgs = J4CppMain.getCppParamNames(paramClasses);
                        map.put(METHOD_ARGS, (paramClasses.length > 0 ? "," : "") + methodArgs);
                        map.put("%METHOD_RETURN%", J4CppMain.isVoid(returnClass) ? "" : "return");
                        map.put("%METHOD_CALL_TYPE%", J4CppMain.getMethodCallString(field.getType()));
                        map.put("%METHOD_RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                        retStore = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                        map.put(METHOD_RETURN_STORE, retStore);
                        map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet(tabs, returnClass, clazz));
                        if (Modifier.isStatic(field.getModifiers())) {
                            J4CppMain.processTemplate(pw, map, "cpp_static_setfield.cpp", tabs);
                        } else {
                            J4CppMain.processTemplate(pw, map, "cpp_setfield.cpp", tabs);
                        }
                        pw.println(tabs + "}");
                    }
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        if (!J4CppMain.checkMethod(method, classes)) continue;
                        pw.println();
                        pw.println(J4CppMain.getCppMethodDefinitionStart(tabs, clssOnlyName, method, clazz));
                        map.put(METHOD_NAME, method.getName());
                        if (J4CppMain.fixMethodName(method).contains("equals2") && verbose) {
                            System.out.println("debug me");
                        }
                        map.put("%JAVA_METHOD_NAME%", method.getName());
                        paramClasses = method.getParameterTypes();
                        String methodArgs = J4CppMain.getCppParamNames(paramClasses);
                        map.put(METHOD_ARGS, (paramClasses.length > 0 ? "," : "") + methodArgs);
                        Class<?> returnClass = method.getReturnType();
                        map.put(JNI_SIGNATURE, "(" + J4CppMain.getJNIParamSignature(paramClasses) + ")" + J4CppMain.classToJNISignature(returnClass));
                        map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                        map.put("%METHOD_RETURN%", J4CppMain.isVoid(returnClass) ? "" : "return");
                        map.put("%METHOD_CALL_TYPE%", J4CppMain.getMethodCallString(returnClass));
                        map.put("%METHOD_RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                        String retStore3 = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                        map.put(METHOD_RETURN_STORE, retStore3);
                        map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet(tabs, returnClass, clazz));
                        tabs = tabs + TAB_STRING;
                        if (!Modifier.isStatic(method.getModifiers())) {
                            J4CppMain.processTemplate(pw, map, CPP_METHODCPP, tabs);
                        } else {
                            J4CppMain.processTemplate(pw, map, CPP_STATIC_METHODCPP, tabs);
                        }
                        tabs = tabs.substring(0, tabs.length() - TAB_STRING.length());
                        pw.println(tabs + "}");
                        if (J4CppMain.isArrayStringMethod(method)) {
                            map.put(METHOD_RETURN_STORE, J4CppMain.isVoid(returnClass) ? "" : J4CppMain.getCppType(returnClass, clazz) + " returnVal=");
                            map.put(METHOD_RETURN_GET, J4CppMain.isVoid(returnClass) ? "return ;" : "return returnVal;");
                            J4CppMain.processTemplate(pw, map, CPP_EASY_STRING_ARRAY_METHODCPP, tabs);
                            continue;
                        }
                        if (!J4CppMain.isMethodToMakeEasy(method)) continue;
                        pw.println();
                        pw.println(tabs + "// Easy call alternative for " + method.getName());
                        pw.println(J4CppMain.getEasyCallCppMethodDefinitionStart(tabs, clssOnlyName, method, clazz));
                        tabs = tabs + TAB_STRING;
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclareOut(returnClass, clazz));
                        J4CppMain.processTemplate(pw, map, "cpp_start_easy_method.cpp", tabs);
                        for (int paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            Class<?> paramClasse = paramClasses[paramIndex];
                            String parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw.println(tabs + "jstring " + parmName + " = env->NewStringUTF(easyArg_" + paramIndex + ");");
                                continue;
                            }
                            if (J4CppMain.isPrimitiveArray(paramClasse)) {
                                String callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                                pw.println(tabs + J4CppMain.getCppArrayType(paramClasse.getComponentType()) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= env->New" + callString + "Array(easyArg_" + paramIndex + "_length);");
                                pw.println(tabs + "env->Set" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                                continue;
                            }
                            pw.println(tabs + J4CppMain.getCppType(paramClasse, clazz) + " " + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + "= easyArg_" + paramIndex + ";");
                        }
                        String methodArgsIn = J4CppMain.getCppParamNamesIn(paramClasses);
                        String retStoreOut = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnOutVarType(returnClass, clazz) + ") ";
                        pw.println(tabs + retStoreOut + J4CppMain.fixMethodName(method) + "(" + methodArgsIn + ");");
                        for (int paramIndex = 0; paramIndex < paramClasses.length; ++paramIndex) {
                            Class<?> paramClasse = paramClasses[paramIndex];
                            String parmName = J4CppMain.getParamNameIn(paramClasse, paramIndex);
                            if (J4CppMain.isString(paramClasse)) {
                                pw.println(tabs + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                                pw.println(tabs + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                                pw.println(tabs + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                                pw.println(tabs + "}");
                                continue;
                            }
                            if (!J4CppMain.isPrimitiveArray(paramClasse)) continue;
                            String callString = J4CppMain.getMethodCallString(paramClasse.getComponentType());
                            pw.println(tabs + "env->Get" + callString + "ArrayRegion(" + J4CppMain.classToParamNameDecl(paramClasse, paramIndex) + ",0,easyArg_" + paramIndex + "_length,easyArg_" + paramIndex + ");");
                            pw.println(tabs + "jobjectRefType ref_" + paramIndex + " = env->GetObjectRefType(" + parmName + ");");
                            pw.println(tabs + "if(ref_" + paramIndex + " == JNIGlobalRefType) {");
                            pw.println(tabs + TAB_STRING + "env->DeleteGlobalRef(" + parmName + ");");
                            pw.println(tabs + "}");
                        }
                        J4CppMain.processTemplate(pw, map, "cpp_end_easy_method.cpp", tabs);
                        if (!J4CppMain.isVoid(returnClass)) {
                            pw.println(tabs + "return retVal;");
                        }
                        tabs = tabs.substring(TAB_STRING.length());
                        pw.println(tabs + "}");
                        pw.println();
                    }
                    J4CppMain.processTemplate(pw, map, CPP_END_CLASSCPP, tabs);
                    tabs = tabs.substring(0, tabs.length() - 1);
                    Class nextClass = class_index < classesSegList.size() - 1 ? (Class)classesSegList.get(class_index + 1) : null;
                    tabs = J4CppMain.closeClassNamespace(clazz, pw, tabs, nextClass);
                    lastClass = clazz;
                }
                if (segment_index < 1) {
                    if (null != nativesClassMap) {
                        for (Map.Entry entry : nativesClassMap.entrySet()) {
                            Class javaClass = (Class)entry.getValue();
                            String nativeClassName = (String)entry.getKey();
                            map.put(CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_JNI_SIGNATURE, nativeClassName);
                            map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                            map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                            map.put("%INITIALIZE_CONTEXT%", "context=NULL; initContext(NULL,false);");
                            map.put("%INITIALIZE_CONTEXT_REF%", "context=NULL; initContext(objref.context,true);");
                            tabs = tabs + TAB_STRING;
                            J4CppMain.processTemplate(pw, map, CPP_START_CLASSCPP, tabs);
                            pw.println();
                            pw.println(tabs + nativeClassName + "::" + nativeClassName + "() : " + J4CppMain.getModifiedClassName(javaClass).replace(".", "::") + "((jobject)NULL,false) {");
                            tabs = tabs + TAB_STRING;
                            pw.println(tabs + "context=NULL;");
                            pw.println(tabs + "initContext(NULL,false);");
                            map.put(JNI_SIGNATURE, "()V");
                            map.put(CONSTRUCTOR_ARGS, "");
                            J4CppMain.processTemplate(pw, map, "cpp_new_native.cpp", tabs);
                            tabs = tabs.substring(TAB_STRING.length());
                            pw.println(tabs + "}");
                            pw.println();
                            pw.println(tabs + "// Destructor for " + nativeClassName);
                            pw.println(tabs + nativeClassName + "::~" + nativeClassName + "() {");
                            pw.println(tabs + TAB_STRING + "if(NULL != context) {");
                            pw.println(tabs + TAB_STRING + TAB_STRING + "deleteContext();");
                            pw.println(tabs + TAB_STRING + "}");
                            pw.println(tabs + TAB_STRING + "context=NULL;");
                            pw.println(tabs + "}");
                            pw.println();
                            tabs = tabs.substring(TAB_STRING.length());
                            J4CppMain.processTemplate(pw, map, CPP_END_CLASSCPP, tabs);
                        }
                    }
                    J4CppMain.processTemplate(pw, map, "cpp_template_end_first.cpp", tabs);
                    tabs = "";
                    if (null != nativesClassMap) {
                        Method[] methods;
                        pw.println("using namespace " + namespace + ";");
                        pw.println("#ifdef __cplusplus");
                        pw.println("extern \"C\" {");
                        pw.println("#endif");
                        int max_method_count = 0;
                        tabs = "";
                        for (Map.Entry e10 : nativesClassMap.entrySet()) {
                            Class javaClass = (Class)e10.getValue();
                            String nativeClassName = (String)e10.getKey();
                            map.put(CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_NAME, nativeClassName);
                            map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                            map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                            map.put(FULL_CLASS_JNI_SIGNATURE, nativeClassName);
                            map.put(METHOD_ONFAIL, "return;");
                            methods = javaClass.getDeclaredMethods();
                            if (max_method_count < methods.length) {
                                max_method_count = methods.length;
                            }
                            for (int j = 0; j < methods.length; ++j) {
                                Method method = methods[j];
                                int modifiers = method.getModifiers();
                                if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isSynthetic()) continue;
                                Class<?>[] paramClasses = method.getParameterTypes();
                                String methodArgs = J4CppMain.getCppParamNames(paramClasses);
                                map.put(METHOD_ARGS, methodArgs);
                                map.put(METHOD_NAME, method.getName());
                                Class<?> returnClass = method.getReturnType();
                                retStore = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                                map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, javaClass));
                                map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                                map.put(METHOD_RETURN_STORE, retStore);
                                map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet(tabs, returnClass, javaClass));
                                pw.println();
                                String paramDecls = J4CppMain.getCppParamDeclarations(paramClasses, javaClass);
                                String argsToAdd = method.getParameterTypes().length > 0 ? "," + paramDecls.substring(1, paramDecls.length() - 1) : "";
                                pw.println("JNIEXPORT " + J4CppMain.getCppType(returnClass, javaClass) + " JNICALL Java_" + nativeClassName + "_" + method.getName() + "(JNIEnv *env, jobject jthis" + argsToAdd + ") {");
                                tabs = TAB_STRING;
                                J4CppMain.processTemplate(pw, map, "cpp_native_wrap.cpp", tabs);
                                tabs = tabs.substring(TAB_STRING.length());
                                pw.println("}");
                                pw.println();
                            }
                            pw.println("JNIEXPORT void JNICALL Java_" + nativeClassName + "_nativeDelete(JNIEnv *env, jobject jthis) {");
                            tabs = tabs + TAB_STRING;
                            map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(Void.TYPE, javaClass));
                            J4CppMain.processTemplate(pw, map, "cpp_native_delete.cpp", tabs);
                            tabs = tabs.substring(TAB_STRING.length());
                            pw.println(tabs + "}");
                            pw.println();
                        }
                        pw.println("#ifdef __cplusplus");
                        pw.println("} // end extern \"C\"");
                        pw.println("#endif");
                        map.put("%MAX_METHOD_COUNT%", Integer.toString(max_method_count + 1));
                        J4CppMain.processTemplate(pw, map, "cpp_start_register_native.cpp", tabs);
                        for (Map.Entry e : nativesClassMap.entrySet()) {
                            Class javaClass = (Class)e.getValue();
                            String nativeClassName = (String)e.getKey();
                            map.put(CLASS_NAME, nativeClassName);
                            map.put(FULL_CLASS_NAME, nativeClassName);
                            map.put("%BASE_CLASS_FULL_NAME%", "::" + namespace + "::" + J4CppMain.getModifiedClassName(javaClass).replace(".", "::"));
                            map.put(OBJECT_CLASS_FULL_NAME, "::" + namespace + "::java::lang::Object");
                            J4CppMain.processTemplate(pw, map, "cpp_start_register_native_class.cpp", tabs);
                            tabs = tabs + TAB_STRING;
                            methods = javaClass.getDeclaredMethods();
                            int method_number = 0;
                            for (int j = 0; j < methods.length; ++j) {
                                Method method = methods[j];
                                int modifiers = method.getModifiers();
                                if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isSynthetic()) continue;
                                map.put("%METHOD_NUMBER%", Integer.toString(method_number));
                                map.put(METHOD_NAME, method.getName());
                                map.put(JNI_SIGNATURE, "(" + J4CppMain.getJNIParamSignature(method.getParameterTypes()) + ")" + J4CppMain.classToJNISignature(method.getReturnType()));
                                J4CppMain.processTemplate(pw, map, "cpp_register_native_item.cpp", tabs);
                                ++method_number;
                            }
                            map.put("%METHOD_NUMBER%", Integer.toString(method_number));
                            map.put(METHOD_NAME, "nativeDelete");
                            map.put(JNI_SIGNATURE, "()V");
                            J4CppMain.processTemplate(pw, map, "cpp_register_native_item.cpp", tabs);
                            map.put("%NUM_NATIVE_METHODS%", Integer.toString(method_number));
                            J4CppMain.processTemplate(pw, map, "cpp_end_register_native_class.cpp", tabs);
                            tabs = tabs.substring(TAB_STRING.length());
                        }
                        J4CppMain.processTemplate(pw, map, "cpp_end_register_native.cpp", tabs);
                    } else {
                        pw.println("// No Native classes : registerNativMethods not needed.");
                        pw.println("static void registerNativeMethods(JNIEnv *env) {}");
                    }
                } else {
                    J4CppMain.processTemplate(pw, map, CPP_TEMPLATE_ENDCPP, tabs);
                }
            }
            catch (Throwable throwable) {
                e82 = throwable;
                throw throwable;
            }
            finally {
                if (pw != null) {
                    if (e82 != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)e82).addSuppressed(throwable);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
            if (null == nativesClassMap) continue;
            tabs = "";
            for (Map.Entry e : nativesClassMap.entrySet()) {
                File nativeClassCppFile;
                String string = (String)e.getKey();
                File nativeClassHeaderFile = new File(namespace.toLowerCase() + "_" + string.toLowerCase() + ".h");
                map.put("%NATIVE_CLASS_HEADER%", nativeClassHeaderFile.getName());
                map.put(CLASS_NAME, string);
                if (nativeClassHeaderFile.exists()) {
                    if (verbose) {
                        System.out.println("skipping " + nativeClassHeaderFile.getCanonicalPath() + " since it already exists.");
                    }
                } else {
                    lastClass = null;
                    try (PrintWriter pw2 = new PrintWriter(new FileWriter(nativeClassHeaderFile));){
                        J4CppMain.processTemplate(pw2, map, "header_native_imp.h", tabs);
                    }
                    catch (Throwable throwable) {
                        lastClass = throwable;
                        throw throwable;
                    }
                }
                if ((nativeClassCppFile = new File(namespace.toLowerCase() + "_" + string.toLowerCase() + ".cpp")).exists()) {
                    if (!verbose) continue;
                    System.out.println("skipping " + nativeClassCppFile.getCanonicalPath() + " since it already exists.");
                    continue;
                }
                PrintWriter pw3 = new PrintWriter(new FileWriter(nativeClassCppFile));
                Throwable throwable = null;
                try {
                    J4CppMain.processTemplate(pw3, map, "cpp_native_imp_start.cpp", tabs);
                    Class clazz = (Class)e.getValue();
                    Method[] methods = clazz.getDeclaredMethods();
                    boolean method_number = false;
                    for (int j = 0; j < methods.length; ++j) {
                        Method method = methods[j];
                        int modifiers = method.getModifiers();
                        if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isSynthetic()) continue;
                        Class<?>[] paramClasses = method.getParameterTypes();
                        String paramDecls = J4CppMain.getCppParamDeclarations(paramClasses, clazz);
                        String methodArgs = method.getParameterTypes().length > 0 ? paramDecls.substring(1, paramDecls.length() - 1) : "";
                        map.put(METHOD_ARGS, methodArgs);
                        map.put(METHOD_NAME, method.getName());
                        Class<?> returnClass = method.getReturnType();
                        String retStore = J4CppMain.isVoid(returnClass) ? "" : "retVal= (" + J4CppMain.getMethodReturnVarType(returnClass) + ") ";
                        map.put(METHOD_ONFAIL, J4CppMain.getOnFailString(returnClass, clazz));
                        map.put("%RETURN_TYPE%", J4CppMain.getCppType(returnClass, clazz));
                        map.put("%RETURN_VAR_DECLARE%", J4CppMain.getMethodReturnVarDeclare(returnClass));
                        map.put(METHOD_RETURN_STORE, retStore);
                        map.put(METHOD_RETURN_GET, J4CppMain.getMethodReturnGet(tabs, returnClass, clazz));
                        J4CppMain.processTemplate(pw3, map, "cpp_native_imp_stub.cpp", tabs);
                    }
                    J4CppMain.processTemplate(pw3, map, "cpp_native_imp_end.cpp", tabs);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pw3 == null) continue;
                    if (throwable != null) {
                        try {
                            pw3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pw3.close();
                }
            }
        }
        main_completed = true;
    }

    private static boolean checkConstructor(Constructor c, Class clss, List<Class> classes) {
        Constructor<?> constructor;
        if (!(Modifier.isPublic(c.getModifiers()) || c.getParameterTypes().length == 0 && Modifier.isProtected(c.getModifiers()))) {
            return true;
        }
        Constructor<?>[] ca = clss.getDeclaredConstructors();
        for (int i = 0; i < ca.length && !(constructor = ca[i]).equals(c); ++i) {
            if (constructor.getParameterTypes().length != c.getParameterTypes().length || c.getParameterTypes().length >= 1 && String.class.isAssignableFrom(c.getParameterTypes()[0]) != String.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return true;
        }
        if (c.getParameterTypes().length == 1 && clss.isAssignableFrom(c.getParameterTypes()[0])) {
            return true;
        }
        return !J4CppMain.checkParameters(c.getParameterTypes(), classes);
    }

    private static String getMethodReturnGet(String tabs, Class returnClass, Class relClass) {
        if (!(returnClass.isArray() || returnClass.isPrimitive() || J4CppMain.isString(returnClass))) {
            tabs = tabs + TAB_STRING;
            return tabs + "\n" + tabs + "jobjectRefType ref = env->GetObjectRefType(retVal);\n" + tabs + "if(GetDebugJ4Cpp()) DebugPrintJObject(__FILE__,__LINE__,\"retVal=\",retVal);" + tabs + J4CppMain.getCppRelativeName(returnClass, relClass) + " retObject(retVal,false);\n" + tabs + "return retObject;";
        }
        return J4CppMain.isVoid(returnClass) ? "" : "return retVal;";
    }

    private static String classToCppBase(Class clss) {
        Class<Object> superClass = clss.getSuperclass();
        if (superClass == null) {
            superClass = Object.class;
        }
        return J4CppMain.getCppRelativeName(superClass, clss);
    }

    private static boolean pkgMatch(String[] pkgs1, String[] pkgs2, int level) {
        if (pkgs1.length < level + 1) {
            return false;
        }
        if (pkgs2.length < level + 1) {
            return false;
        }
        for (int i = 0; i <= level; ++i) {
            String pkgFrom1 = pkgs1[i];
            String pkgFrom2 = pkgs2[i];
            if (pkgFrom1.equals(pkgFrom2)) continue;
            return false;
        }
        return true;
    }

    private static String closeClassNamespace(Class clss, PrintWriter pw, String tabs, Class nextClass) {
        String pkg;
        String[] pkgs = J4CppMain.classToPackages(clss);
        String[] nextPkgs = J4CppMain.classToPackages(nextClass);
        boolean line_printed = false;
        if (pkgs.length < 1) {
            return tabs;
        }
        for (int i = pkgs.length - 1; i >= 0 && (pkg = pkgs[i]).length() >= 1; --i) {
            if (!J4CppMain.pkgMatch(pkgs, nextPkgs, i)) {
                pw.println(tabs + "} // end namespace " + pkg);
                line_printed = true;
            }
            tabs = tabs.substring(0, tabs.length() - 1);
        }
        if (line_printed) {
            pw.println();
        }
        return tabs;
    }

    private static String[] classToPackages(Class clss) {
        if (null != clss && null != clss.getPackage() && null != clss.getPackage().getName()) {
            return clss.getPackage().getName().split("\\.");
        }
        return emptypkgs;
    }

    private static String openClassNamespace(Class clss, PrintWriter pw, String tabs, Class lastClass) {
        String[] pkgs = J4CppMain.classToPackages(clss);
        String[] lastpkgs = J4CppMain.classToPackages(lastClass);
        for (int i = 0; i < pkgs.length; ++i) {
            String pkg = pkgs[i];
            if (J4CppMain.pkgMatch(pkgs, lastpkgs, i)) continue;
            tabs = tabs + TAB_STRING;
            pw.println(tabs + "namespace " + pkg + "{");
        }
        return tabs;
    }

    private static void processTemplate(PrintWriter pw, Map<String, String> map, String resourceName, String tabs) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resourceName), StandardCharsets.UTF_8));){
            String s = null;
            while (null != (s = br.readLine())) {
                if (s.trim().startsWith(TEMPLATE_COMMENT_MARK)) continue;
                s = s.replace("\t", TAB_STRING);
                pw.println(tabs + J4CppMain.replaceVars(map, s));
            }
        }
    }

    private static void printHelpAndExit(Options options, String[] args) {
        System.out.println("args = " + Arrays.toString(args));
        new HelpFormatter().printHelp("java4cpp", options);
        System.exit(1);
    }
}

