/*
 * Decompiled with CFR 0.152.
 */
package com.github.wslf.github.fileapi;

import com.github.wslf.github.Credentials;
import com.github.wslf.github.fileapi.RequestProcessor;
import com.github.wslf.github.fileapi.requests.CreateFileRequest;
import com.github.wslf.github.fileapi.requests.DeleteFileRequest;
import com.github.wslf.github.fileapi.requests.GetFileRequest;
import com.github.wslf.github.fileapi.requests.UpdateFileRequest;
import com.github.wslf.github.fileapi.responses.GetFileResponse;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import javax.annotation.Nullable;

public class FileAPI {
    private final RequestProcessor requestProcessor = new RequestProcessor();
    private static final Gson GSON = new GsonBuilder().create();

    public boolean createFile(Credentials credentials, String repositoryName, String filePath, String content, String commitMessage) throws IOException {
        return this.createFile(credentials, repositoryName, filePath, content, commitMessage, null);
    }

    public boolean createFile(Credentials credentials, String repositoryName, String filePath, String content, String commitMessage, String branch) throws IOException {
        CreateFileRequest createFileRequest = new CreateFileRequest(credentials, repositoryName, filePath, commitMessage, content, branch);
        HttpResponse response = this.requestProcessor.sendPutRequest(createFileRequest);
        return response.isSuccessStatusCode();
    }

    public GetFileResponse getFile(Credentials credentials, String repositoryName, String filePath, @Nullable String ref) throws IOException {
        GetFileRequest getFileRequest = new GetFileRequest(credentials, repositoryName, filePath, ref);
        HttpResponse httpResponse = this.requestProcessor.sendRequest(getFileRequest, "GET");
        return (GetFileResponse)GSON.fromJson(httpResponse.parseAsString(), GetFileResponse.class);
    }

    public String getFileContent(Credentials credentials, String repositoryName, String filePath, @Nullable String ref) throws IOException {
        GetFileResponse getFileResponse = this.getFile(credentials, repositoryName, filePath, ref);
        return getFileResponse.getContent();
    }

    public String getFileSHA(Credentials credentials, String repositoryName, String filePath, @Nullable String ref) throws IOException {
        GetFileResponse getFileResponse = this.getFile(credentials, repositoryName, filePath, ref);
        return getFileResponse.getSha();
    }

    public boolean deleteFile(Credentials credentials, String repositoryName, String filePath, String commitMessage, @Nullable String branch) throws IOException {
        String sha = this.getFileSHA(credentials, repositoryName, filePath, branch);
        DeleteFileRequest deleteFileRequest = new DeleteFileRequest(credentials, repositoryName, filePath, commitMessage, sha, branch);
        HttpResponse httpResponse = this.requestProcessor.sendRequest(deleteFileRequest, "DELETE");
        return httpResponse.isSuccessStatusCode();
    }

    public boolean updateFile(Credentials credentials, String repositoryName, String filePath, String content, String commitMessage, String branch) throws IOException {
        String sha = this.getFileSHA(credentials, repositoryName, filePath, branch);
        UpdateFileRequest createFileRequest = new UpdateFileRequest(credentials, repositoryName, filePath, commitMessage, sha, content, branch);
        HttpResponse response = this.requestProcessor.sendPutRequest(createFileRequest);
        return response.isSuccessStatusCode();
    }

    public boolean exists(Credentials credentials, String repositoryName, String filePath, @Nullable String ref) throws IOException {
        boolean exists = true;
        try {
            this.getFile(credentials, repositoryName, filePath, ref);
        }
        catch (HttpResponseException ex) {
            if (ex.getStatusCode() == 404 && "Not Found".equals(ex.getStatusMessage())) {
                exists = false;
            }
            throw ex;
        }
        return exists;
    }

    public boolean createOrUpdateFile(Credentials credentials, String repositoryName, String filePath, String content, String commitMessage, String branch) throws IOException {
        if (this.exists(credentials, repositoryName, filePath, branch)) {
            return this.updateFile(credentials, repositoryName, filePath, content, commitMessage, branch);
        }
        return this.createFile(credentials, repositoryName, filePath, content, commitMessage, branch);
    }
}

