/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

/** User */
public class User {
  StringUtil util = new StringUtil();

  @JsonProperty("UserID")
  private UUID userID;

  @JsonProperty("EmailAddress")
  private String emailAddress;

  @JsonProperty("FirstName")
  private String firstName;

  @JsonProperty("LastName")
  private String lastName;

  @JsonProperty("UpdatedDateUTC")
  private String updatedDateUTC;

  @JsonProperty("IsSubscriber")
  private Boolean isSubscriber;
  /**
   * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD,
   * FINANCIALADVISER, etc)
   */
  public enum OrganisationRoleEnum {
    /** READONLY */
    READONLY("READONLY"),

    /** INVOICEONLY */
    INVOICEONLY("INVOICEONLY"),

    /** STANDARD */
    STANDARD("STANDARD"),

    /** FINANCIALADVISER */
    FINANCIALADVISER("FINANCIALADVISER"),

    /** MANAGEDCLIENT */
    MANAGEDCLIENT("MANAGEDCLIENT"),

    /** CASHBOOKCLIENT */
    CASHBOOKCLIENT("CASHBOOKCLIENT"),

    /** UNKNOWN */
    UNKNOWN("UNKNOWN"),

    /** REMOVED */
    REMOVED("REMOVED");

    private String value;

    OrganisationRoleEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static OrganisationRoleEnum fromValue(String value) {
      for (OrganisationRoleEnum b : OrganisationRoleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("OrganisationRole")
  private OrganisationRoleEnum organisationRole;
  /**
   * Xero identifier
   *
   * @param userID UUID
   * @return User
   */
  public User userID(UUID userID) {
    this.userID = userID;
    return this;
  }

  /**
   * Xero identifier
   *
   * @return userID
   */
  @ApiModelProperty(value = "Xero identifier")
  /**
   * Xero identifier
   *
   * @return userID UUID
   */
  public UUID getUserID() {
    return userID;
  }

  /**
   * Xero identifier
   *
   * @param userID UUID
   */
  public void setUserID(UUID userID) {
    this.userID = userID;
  }

  /**
   * Email address of user
   *
   * @param emailAddress String
   * @return User
   */
  public User emailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * Email address of user
   *
   * @return emailAddress
   */
  @ApiModelProperty(value = "Email address of user")
  /**
   * Email address of user
   *
   * @return emailAddress String
   */
  public String getEmailAddress() {
    return emailAddress;
  }

  /**
   * Email address of user
   *
   * @param emailAddress String
   */
  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }

  /**
   * First name of user
   *
   * @param firstName String
   * @return User
   */
  public User firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * First name of user
   *
   * @return firstName
   */
  @ApiModelProperty(value = "First name of user")
  /**
   * First name of user
   *
   * @return firstName String
   */
  public String getFirstName() {
    return firstName;
  }

  /**
   * First name of user
   *
   * @param firstName String
   */
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * Last name of user
   *
   * @param lastName String
   * @return User
   */
  public User lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * Last name of user
   *
   * @return lastName
   */
  @ApiModelProperty(value = "Last name of user")
  /**
   * Last name of user
   *
   * @return lastName String
   */
  public String getLastName() {
    return lastName;
  }

  /**
   * Last name of user
   *
   * @param lastName String
   */
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /**
   * Timestamp of last change to user
   *
   * @return updatedDateUTC
   */
  @ApiModelProperty(example = "/Date(1573755038314)/", value = "Timestamp of last change to user")
  /**
   * Timestamp of last change to user
   *
   * @return updatedDateUTC String
   */
  public String getUpdatedDateUTC() {
    return updatedDateUTC;
  }
  /**
   * Timestamp of last change to user
   *
   * @return OffsetDateTime
   */
  public OffsetDateTime getUpdatedDateUTCAsDate() {
    if (this.updatedDateUTC != null) {
      try {
        return util.convertStringToOffsetDateTime(this.updatedDateUTC);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Boolean to indicate if user is the subscriber
   *
   * @param isSubscriber Boolean
   * @return User
   */
  public User isSubscriber(Boolean isSubscriber) {
    this.isSubscriber = isSubscriber;
    return this;
  }

  /**
   * Boolean to indicate if user is the subscriber
   *
   * @return isSubscriber
   */
  @ApiModelProperty(value = "Boolean to indicate if user is the subscriber")
  /**
   * Boolean to indicate if user is the subscriber
   *
   * @return isSubscriber Boolean
   */
  public Boolean getIsSubscriber() {
    return isSubscriber;
  }

  /**
   * Boolean to indicate if user is the subscriber
   *
   * @param isSubscriber Boolean
   */
  public void setIsSubscriber(Boolean isSubscriber) {
    this.isSubscriber = isSubscriber;
  }

  /**
   * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD,
   * FINANCIALADVISER, etc)
   *
   * @param organisationRole OrganisationRoleEnum
   * @return User
   */
  public User organisationRole(OrganisationRoleEnum organisationRole) {
    this.organisationRole = organisationRole;
    return this;
  }

  /**
   * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD,
   * FINANCIALADVISER, etc)
   *
   * @return organisationRole
   */
  @ApiModelProperty(
      value =
          "User role that defines permissions in Xero and via API (READONLY, INVOICEONLY,"
              + " STANDARD, FINANCIALADVISER, etc)")
  /**
   * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD,
   * FINANCIALADVISER, etc)
   *
   * @return organisationRole OrganisationRoleEnum
   */
  public OrganisationRoleEnum getOrganisationRole() {
    return organisationRole;
  }

  /**
   * User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD,
   * FINANCIALADVISER, etc)
   *
   * @param organisationRole OrganisationRoleEnum
   */
  public void setOrganisationRole(OrganisationRoleEnum organisationRole) {
    this.organisationRole = organisationRole;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.userID, user.userID)
        && Objects.equals(this.emailAddress, user.emailAddress)
        && Objects.equals(this.firstName, user.firstName)
        && Objects.equals(this.lastName, user.lastName)
        && Objects.equals(this.updatedDateUTC, user.updatedDateUTC)
        && Objects.equals(this.isSubscriber, user.isSubscriber)
        && Objects.equals(this.organisationRole, user.organisationRole);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        userID, emailAddress, firstName, lastName, updatedDateUTC, isSubscriber, organisationRole);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    sb.append("    userID: ").append(toIndentedString(userID)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    isSubscriber: ").append(toIndentedString(isSubscriber)).append("\n");
    sb.append("    organisationRole: ").append(toIndentedString(organisationRole)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
