/*
 * Xero AppStore API
 * These endpoints are for Xero Partners to interact with the App Store Billing platform
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.appstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDateTime;

/** Data transfer object for public create usage end point */
@ApiModel(description = "Data transfer object for public create usage end point")
public class CreateUsageRecord {
  StringUtil util = new StringUtil();

  @JsonProperty("quantity")
  private Integer quantity;

  @JsonProperty("timestamp")
  private LocalDateTime timestamp;
  /**
   * The initial quantity for the usage record. Must be a whole number that is greater than or equal
   * to 0
   *
   * @param quantity Integer
   * @return CreateUsageRecord
   */
  public CreateUsageRecord quantity(Integer quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * The initial quantity for the usage record. Must be a whole number that is greater than or equal
   * to 0
   *
   * @return quantity
   */
  @ApiModelProperty(
      required = true,
      value =
          "The initial quantity for the usage record. Must be a whole number that is greater than"
              + " or equal to 0")
  /**
   * The initial quantity for the usage record. Must be a whole number that is greater than or equal
   * to 0
   *
   * @return quantity Integer
   */
  public Integer getQuantity() {
    return quantity;
  }

  /**
   * The initial quantity for the usage record. Must be a whole number that is greater than or equal
   * to 0
   *
   * @param quantity Integer
   */
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  /**
   * DateTime in UTC of when the the product was consumed/used
   *
   * @param timestamp LocalDateTime
   * @return CreateUsageRecord
   */
  public CreateUsageRecord timestamp(LocalDateTime timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * DateTime in UTC of when the the product was consumed/used
   *
   * @return timestamp
   */
  @ApiModelProperty(
      required = true,
      value = "DateTime in UTC of when the the product was consumed/used")
  /**
   * DateTime in UTC of when the the product was consumed/used
   *
   * @return timestamp LocalDateTime
   */
  public LocalDateTime getTimestamp() {
    return timestamp;
  }

  /**
   * DateTime in UTC of when the the product was consumed/used
   *
   * @param timestamp LocalDateTime
   */
  public void setTimestamp(LocalDateTime timestamp) {
    this.timestamp = timestamp;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateUsageRecord createUsageRecord = (CreateUsageRecord) o;
    return Objects.equals(this.quantity, createUsageRecord.quantity)
        && Objects.equals(this.timestamp, createUsageRecord.timestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity, timestamp);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateUsageRecord {\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
