/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

/** CurrentStatementResponse */
public class CurrentStatementResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("endDate")
  private LocalDate endDate;

  @JsonProperty("startBalance")
  private Double startBalance;

  @JsonProperty("endBalance")
  private Double endBalance;

  @JsonProperty("importedDateTimeUtc")
  private OffsetDateTime importedDateTimeUtc;

  @JsonProperty("importSourceType")
  private String importSourceType;
  /**
   * Looking at the most recent bank statement, this field indicates the first date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @param startDate LocalDate
   * @return CurrentStatementResponse
   */
  public CurrentStatementResponse startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the first date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @return startDate
   */
  @ApiModelProperty(
      value =
          "Looking at the most recent bank statement, this field indicates the first date which"
              + " transactions on this statement pertain to. This date is represented in ISO 8601"
              + " format.")
  /**
   * Looking at the most recent bank statement, this field indicates the first date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the first date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the last date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @param endDate LocalDate
   * @return CurrentStatementResponse
   */
  public CurrentStatementResponse endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the last date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @return endDate
   */
  @ApiModelProperty(
      value =
          "Looking at the most recent bank statement, this field indicates the last date which"
              + " transactions on this statement pertain to. This date is represented in ISO 8601"
              + " format.")
  /**
   * Looking at the most recent bank statement, this field indicates the last date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the last date which
   * transactions on this statement pertain to. This date is represented in ISO 8601 format.
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the balance before the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @param startBalance Double
   * @return CurrentStatementResponse
   */
  public CurrentStatementResponse startBalance(Double startBalance) {
    this.startBalance = startBalance;
    return this;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the balance before the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @return startBalance
   */
  @ApiModelProperty(
      value =
          "Looking at the most recent bank statement, this field indicates the balance before the"
              + " transactions on the statement are applied (note, this is not always populated by"
              + " the bank in every single instance (~10%)).")
  /**
   * Looking at the most recent bank statement, this field indicates the balance before the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @return startBalance Double
   */
  public Double getStartBalance() {
    return startBalance;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the balance before the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @param startBalance Double
   */
  public void setStartBalance(Double startBalance) {
    this.startBalance = startBalance;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the balance after the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @param endBalance Double
   * @return CurrentStatementResponse
   */
  public CurrentStatementResponse endBalance(Double endBalance) {
    this.endBalance = endBalance;
    return this;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the balance after the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @return endBalance
   */
  @ApiModelProperty(
      value =
          "Looking at the most recent bank statement, this field indicates the balance after the"
              + " transactions on the statement are applied (note, this is not always populated by"
              + " the bank in every single instance (~10%)).")
  /**
   * Looking at the most recent bank statement, this field indicates the balance after the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @return endBalance Double
   */
  public Double getEndBalance() {
    return endBalance;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the balance after the
   * transactions on the statement are applied (note, this is not always populated by the bank in
   * every single instance (~10%)).
   *
   * @param endBalance Double
   */
  public void setEndBalance(Double endBalance) {
    this.endBalance = endBalance;
  }

  /**
   * Looking at the most recent bank statement, this field indicates when the document was imported
   * into Xero. This date is represented in ISO 8601 format.
   *
   * @param importedDateTimeUtc OffsetDateTime
   * @return CurrentStatementResponse
   */
  public CurrentStatementResponse importedDateTimeUtc(OffsetDateTime importedDateTimeUtc) {
    this.importedDateTimeUtc = importedDateTimeUtc;
    return this;
  }

  /**
   * Looking at the most recent bank statement, this field indicates when the document was imported
   * into Xero. This date is represented in ISO 8601 format.
   *
   * @return importedDateTimeUtc
   */
  @ApiModelProperty(
      value =
          "Looking at the most recent bank statement, this field indicates when the document was"
              + " imported into Xero.  This date is represented in ISO 8601 format.")
  /**
   * Looking at the most recent bank statement, this field indicates when the document was imported
   * into Xero. This date is represented in ISO 8601 format.
   *
   * @return importedDateTimeUtc OffsetDateTime
   */
  public OffsetDateTime getImportedDateTimeUtc() {
    return importedDateTimeUtc;
  }

  /**
   * Looking at the most recent bank statement, this field indicates when the document was imported
   * into Xero. This date is represented in ISO 8601 format.
   *
   * @param importedDateTimeUtc OffsetDateTime
   */
  public void setImportedDateTimeUtc(OffsetDateTime importedDateTimeUtc) {
    this.importedDateTimeUtc = importedDateTimeUtc;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the source of the data (direct
   * bank feed, file upload, or manual keying).
   *
   * @param importSourceType String
   * @return CurrentStatementResponse
   */
  public CurrentStatementResponse importSourceType(String importSourceType) {
    this.importSourceType = importSourceType;
    return this;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the source of the data (direct
   * bank feed, file upload, or manual keying).
   *
   * @return importSourceType
   */
  @ApiModelProperty(
      value =
          "Looking at the most recent bank statement, this field indicates the source of the data"
              + " (direct bank feed, file upload, or manual keying).")
  /**
   * Looking at the most recent bank statement, this field indicates the source of the data (direct
   * bank feed, file upload, or manual keying).
   *
   * @return importSourceType String
   */
  public String getImportSourceType() {
    return importSourceType;
  }

  /**
   * Looking at the most recent bank statement, this field indicates the source of the data (direct
   * bank feed, file upload, or manual keying).
   *
   * @param importSourceType String
   */
  public void setImportSourceType(String importSourceType) {
    this.importSourceType = importSourceType;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CurrentStatementResponse currentStatementResponse = (CurrentStatementResponse) o;
    return Objects.equals(this.startDate, currentStatementResponse.startDate)
        && Objects.equals(this.endDate, currentStatementResponse.endDate)
        && Objects.equals(this.startBalance, currentStatementResponse.startBalance)
        && Objects.equals(this.endBalance, currentStatementResponse.endBalance)
        && Objects.equals(this.importedDateTimeUtc, currentStatementResponse.importedDateTimeUtc)
        && Objects.equals(this.importSourceType, currentStatementResponse.importSourceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        startDate, endDate, startBalance, endBalance, importedDateTimeUtc, importSourceType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CurrentStatementResponse {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    startBalance: ").append(toIndentedString(startBalance)).append("\n");
    sb.append("    endBalance: ").append(toIndentedString(endBalance)).append("\n");
    sb.append("    importedDateTimeUtc: ")
        .append(toIndentedString(importedDateTimeUtc))
        .append("\n");
    sb.append("    importSourceType: ").append(toIndentedString(importSourceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
