/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

/** LockHistoryModel */
public class LockHistoryModel {
  StringUtil util = new StringUtil();

  @JsonProperty("hardLockDate")
  private LocalDate hardLockDate;

  @JsonProperty("softLockDate")
  private LocalDate softLockDate;

  @JsonProperty("updatedDateUtc")
  private OffsetDateTime updatedDateUtc;
  /**
   * Date the account hard lock was set
   *
   * @param hardLockDate LocalDate
   * @return LockHistoryModel
   */
  public LockHistoryModel hardLockDate(LocalDate hardLockDate) {
    this.hardLockDate = hardLockDate;
    return this;
  }

  /**
   * Date the account hard lock was set
   *
   * @return hardLockDate
   */
  @ApiModelProperty(value = "Date the account hard lock was set")
  /**
   * Date the account hard lock was set
   *
   * @return hardLockDate LocalDate
   */
  public LocalDate getHardLockDate() {
    return hardLockDate;
  }

  /**
   * Date the account hard lock was set
   *
   * @param hardLockDate LocalDate
   */
  public void setHardLockDate(LocalDate hardLockDate) {
    this.hardLockDate = hardLockDate;
  }

  /**
   * Date the account soft lock was set
   *
   * @param softLockDate LocalDate
   * @return LockHistoryModel
   */
  public LockHistoryModel softLockDate(LocalDate softLockDate) {
    this.softLockDate = softLockDate;
    return this;
  }

  /**
   * Date the account soft lock was set
   *
   * @return softLockDate
   */
  @ApiModelProperty(value = "Date the account soft lock was set")
  /**
   * Date the account soft lock was set
   *
   * @return softLockDate LocalDate
   */
  public LocalDate getSoftLockDate() {
    return softLockDate;
  }

  /**
   * Date the account soft lock was set
   *
   * @param softLockDate LocalDate
   */
  public void setSoftLockDate(LocalDate softLockDate) {
    this.softLockDate = softLockDate;
  }

  /**
   * The system date time that the lock was updated
   *
   * @param updatedDateUtc OffsetDateTime
   * @return LockHistoryModel
   */
  public LockHistoryModel updatedDateUtc(OffsetDateTime updatedDateUtc) {
    this.updatedDateUtc = updatedDateUtc;
    return this;
  }

  /**
   * The system date time that the lock was updated
   *
   * @return updatedDateUtc
   */
  @ApiModelProperty(value = "The system date time that the lock was updated")
  /**
   * The system date time that the lock was updated
   *
   * @return updatedDateUtc OffsetDateTime
   */
  public OffsetDateTime getUpdatedDateUtc() {
    return updatedDateUtc;
  }

  /**
   * The system date time that the lock was updated
   *
   * @param updatedDateUtc OffsetDateTime
   */
  public void setUpdatedDateUtc(OffsetDateTime updatedDateUtc) {
    this.updatedDateUtc = updatedDateUtc;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LockHistoryModel lockHistoryModel = (LockHistoryModel) o;
    return Objects.equals(this.hardLockDate, lockHistoryModel.hardLockDate)
        && Objects.equals(this.softLockDate, lockHistoryModel.softLockDate)
        && Objects.equals(this.updatedDateUtc, lockHistoryModel.updatedDateUtc);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hardLockDate, softLockDate, updatedDateUtc);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LockHistoryModel {\n");
    sb.append("    hardLockDate: ").append(toIndentedString(hardLockDate)).append("\n");
    sb.append("    softLockDate: ").append(toIndentedString(softLockDate)).append("\n");
    sb.append("    updatedDateUtc: ").append(toIndentedString(updatedDateUtc)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
