/*
 * Xero Payroll AU API
 * This is the Xero Payroll API for orgs in Australia region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** TaxLine */
public class TaxLine {
  StringUtil util = new StringUtil();

  @JsonProperty("PayslipTaxLineID")
  private UUID payslipTaxLineID;

  @JsonProperty("Amount")
  private Double amount;

  @JsonProperty("TaxTypeName")
  private String taxTypeName;

  @JsonProperty("Description")
  private String description;

  @JsonProperty("ManualTaxType")
  private ManualTaxType manualTaxType;

  @JsonProperty("LiabilityAccount")
  private String liabilityAccount;
  /**
   * Xero identifier for payslip tax line ID.
   *
   * @param payslipTaxLineID UUID
   * @return TaxLine
   */
  public TaxLine payslipTaxLineID(UUID payslipTaxLineID) {
    this.payslipTaxLineID = payslipTaxLineID;
    return this;
  }

  /**
   * Xero identifier for payslip tax line ID.
   *
   * @return payslipTaxLineID
   */
  @ApiModelProperty(
      example = "e0eb6747-7c17-4075-b804-989f8d4e5d39",
      value = "Xero identifier for payslip tax line ID.")
  /**
   * Xero identifier for payslip tax line ID.
   *
   * @return payslipTaxLineID UUID
   */
  public UUID getPayslipTaxLineID() {
    return payslipTaxLineID;
  }

  /**
   * Xero identifier for payslip tax line ID.
   *
   * @param payslipTaxLineID UUID
   */
  public void setPayslipTaxLineID(UUID payslipTaxLineID) {
    this.payslipTaxLineID = payslipTaxLineID;
  }

  /**
   * The tax line amount
   *
   * @param amount Double
   * @return TaxLine
   */
  public TaxLine amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The tax line amount
   *
   * @return amount
   */
  @ApiModelProperty(example = "50.0", value = "The tax line amount")
  /**
   * The tax line amount
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * The tax line amount
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * Name of the tax type.
   *
   * @param taxTypeName String
   * @return TaxLine
   */
  public TaxLine taxTypeName(String taxTypeName) {
    this.taxTypeName = taxTypeName;
    return this;
  }

  /**
   * Name of the tax type.
   *
   * @return taxTypeName
   */
  @ApiModelProperty(example = "Manual Adjustment", value = "Name of the tax type.")
  /**
   * Name of the tax type.
   *
   * @return taxTypeName String
   */
  public String getTaxTypeName() {
    return taxTypeName;
  }

  /**
   * Name of the tax type.
   *
   * @param taxTypeName String
   */
  public void setTaxTypeName(String taxTypeName) {
    this.taxTypeName = taxTypeName;
  }

  /**
   * Description of the tax line.
   *
   * @param description String
   * @return TaxLine
   */
  public TaxLine description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of the tax line.
   *
   * @return description
   */
  @ApiModelProperty(value = "Description of the tax line.")
  /**
   * Description of the tax line.
   *
   * @return description String
   */
  public String getDescription() {
    return description;
  }

  /**
   * Description of the tax line.
   *
   * @param description String
   */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * manualTaxType
   *
   * @param manualTaxType ManualTaxType
   * @return TaxLine
   */
  public TaxLine manualTaxType(ManualTaxType manualTaxType) {
    this.manualTaxType = manualTaxType;
    return this;
  }

  /**
   * Get manualTaxType
   *
   * @return manualTaxType
   */
  @ApiModelProperty(value = "")
  /**
   * manualTaxType
   *
   * @return manualTaxType ManualTaxType
   */
  public ManualTaxType getManualTaxType() {
    return manualTaxType;
  }

  /**
   * manualTaxType
   *
   * @param manualTaxType ManualTaxType
   */
  public void setManualTaxType(ManualTaxType manualTaxType) {
    this.manualTaxType = manualTaxType;
  }

  /**
   * The tax line liability account code. For posted pay run you should be able to see liability
   * account code
   *
   * @param liabilityAccount String
   * @return TaxLine
   */
  public TaxLine liabilityAccount(String liabilityAccount) {
    this.liabilityAccount = liabilityAccount;
    return this;
  }

  /**
   * The tax line liability account code. For posted pay run you should be able to see liability
   * account code
   *
   * @return liabilityAccount
   */
  @ApiModelProperty(
      example = "620",
      value =
          "The tax line liability account code. For posted pay run you should be able to see"
              + " liability account code")
  /**
   * The tax line liability account code. For posted pay run you should be able to see liability
   * account code
   *
   * @return liabilityAccount String
   */
  public String getLiabilityAccount() {
    return liabilityAccount;
  }

  /**
   * The tax line liability account code. For posted pay run you should be able to see liability
   * account code
   *
   * @param liabilityAccount String
   */
  public void setLiabilityAccount(String liabilityAccount) {
    this.liabilityAccount = liabilityAccount;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxLine taxLine = (TaxLine) o;
    return Objects.equals(this.payslipTaxLineID, taxLine.payslipTaxLineID)
        && Objects.equals(this.amount, taxLine.amount)
        && Objects.equals(this.taxTypeName, taxLine.taxTypeName)
        && Objects.equals(this.description, taxLine.description)
        && Objects.equals(this.manualTaxType, taxLine.manualTaxType)
        && Objects.equals(this.liabilityAccount, taxLine.liabilityAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        payslipTaxLineID, amount, taxTypeName, description, manualTaxType, liabilityAccount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxLine {\n");
    sb.append("    payslipTaxLineID: ").append(toIndentedString(payslipTaxLineID)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    taxTypeName: ").append(toIndentedString(taxTypeName)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    manualTaxType: ").append(toIndentedString(manualTaxType)).append("\n");
    sb.append("    liabilityAccount: ").append(toIndentedString(liabilityAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
