/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 9.1.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethods;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Accounts;
import com.xero.models.accounting.Actions;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Allocations;
import com.xero.models.accounting.Attachments;
import com.xero.models.accounting.BankTransactions;
import com.xero.models.accounting.BankTransfers;
import com.xero.models.accounting.BatchPaymentDelete;
import com.xero.models.accounting.BatchPaymentDeleteByUrlParam;
import com.xero.models.accounting.BatchPayments;
import com.xero.models.accounting.BrandingThemes;
import com.xero.models.accounting.Budgets;
import com.xero.models.accounting.CISOrgSettings;
import com.xero.models.accounting.CISSettings;
import com.xero.models.accounting.ContactGroups;
import com.xero.models.accounting.Contacts;
import com.xero.models.accounting.CreditNotes;
import com.xero.models.accounting.Currencies;
import com.xero.models.accounting.Currency;
import com.xero.models.accounting.Employees;
import com.xero.models.accounting.ExpenseClaims;
import com.xero.models.accounting.HistoryRecords;
import com.xero.models.accounting.ImportSummaryObject;
import com.xero.models.accounting.InvoiceReminders;
import com.xero.models.accounting.Invoices;
import com.xero.models.accounting.Items;
import com.xero.models.accounting.Journals;
import com.xero.models.accounting.LinkedTransaction;
import com.xero.models.accounting.LinkedTransactions;
import com.xero.models.accounting.ManualJournals;
import com.xero.models.accounting.OnlineInvoices;
import com.xero.models.accounting.Organisations;
import com.xero.models.accounting.Overpayments;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.PaymentDelete;
import com.xero.models.accounting.PaymentServices;
import com.xero.models.accounting.Payments;
import com.xero.models.accounting.Prepayments;
import com.xero.models.accounting.PurchaseOrders;
import com.xero.models.accounting.Quotes;
import com.xero.models.accounting.Receipts;
import com.xero.models.accounting.RepeatingInvoices;
import com.xero.models.accounting.ReportWithRows;
import com.xero.models.accounting.Reports;
import com.xero.models.accounting.RequestEmpty;
import com.xero.models.accounting.Setup;
import com.xero.models.accounting.TaxRates;
import com.xero.models.accounting.TrackingCategories;
import com.xero.models.accounting.TrackingCategory;
import com.xero.models.accounting.TrackingOption;
import com.xero.models.accounting.TrackingOptions;
import com.xero.models.accounting.Users;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

/** AccountingApi has methods for interacting with all endpoints in the API set */
public class AccountingApi {
  private ApiClient apiClient;
  private static AccountingApi instance = null;
  private String userAgent = "Default";
  private String version = "12.1.0";
  static final Logger logger = LoggerFactory.getLogger(AccountingApi.class);

  /** AccountingApi */
  public AccountingApi() {
    this(new ApiClient());
  }

  /**
   * AccountingApi getInstance
   *
   * @param apiClient ApiClient pass into the new instance of this class
   * @return instance of this class
   */
  public static AccountingApi getInstance(ApiClient apiClient) {
    if (instance == null) {
      instance = new AccountingApi(apiClient);
    }
    return instance;
  }

  /**
   * AccountingApi
   *
   * @param apiClient ApiClient pass into the new instance of this class
   */
  public AccountingApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * get ApiClient
   *
   * @return apiClient the current ApiClient
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /**
   * set ApiClient
   *
   * @param apiClient ApiClient pass into the new instance of this class
   */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * set user agent
   *
   * @param userAgent string to override the user agent
   */
  public void setUserAgent(String userAgent) {
    this.userAgent = userAgent;
  }

  /**
   * get user agent
   *
   * @return String of user agent
   */
  public String getUserAgent() {
    return this.userAgent + " [Xero-Java-" + this.version + "]";
  }

  /**
   * Creates a new chart of accounts
   *
   * <p><b>200</b> - Success - created new Account and return response of type Accounts array with
   * new Account
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param account Account object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Accounts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Accounts createAccount(
      String accessToken, String xeroTenantId, Account account, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Accounts> typeRef = new TypeReference<Accounts>() {};
      HttpResponse response =
          createAccountForHttpResponse(accessToken, xeroTenantId, account, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createAccount -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Accounts", object.getMessage(), e);
        }
        handler.validationError("Accounts", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new chart of accounts
   *
   * <p><b>200</b> - Success - created new Account and return response of type Accounts array with
   * new Account
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param account Account object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createAccountForHttpResponse(
      String accessToken, String xeroTenantId, Account account, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createAccount");
    } // verify the required parameter 'account' is set
    if (account == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'account' when calling createAccount");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createAccount");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Accounts");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(account);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createAccountAttachmentByFileName to allow byte[] or File type to be passed
  // as body
  /**
   * Creates an attachment on a specific account
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createAccountAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID accountID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createAccountAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, accountID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createAccountAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment on a specific account
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createAccountAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID accountID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createAccountAttachmentByFileName");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling"
              + " createAccountAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createAccountAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createAccountAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createAccountAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an attachment on a specific account
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createAccountAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID accountID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createAccountAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, accountID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createAccountAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment on a specific account
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createAccountAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID accountID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createAccountAttachmentByFileName");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling"
              + " createAccountAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createAccountAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createAccountAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createAccountAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createBankTransactionAttachmentByFileName to allow byte[] or File type to
  // be passed as body
  /**
   * Creates an attachment for a specific bank transaction by filename
   *
   * <p><b>200</b> - Success - return response of Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createBankTransactionAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createBankTransactionAttachmentByFileNameForHttpResponse(
              accessToken,
              xeroTenantId,
              bankTransactionID,
              fileName,
              body,
              idempotencyKey,
              mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransactionAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment for a specific bank transaction by filename
   *
   * <p><b>200</b> - Success - return response of Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createBankTransactionAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBankTransactionAttachmentByFileName");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " createBankTransactionAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createBankTransactionAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createBankTransactionAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBankTransactionAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an attachment for a specific bank transaction by filename
   *
   * <p><b>200</b> - Success - return response of Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createBankTransactionAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createBankTransactionAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, bankTransactionID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransactionAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment for a specific bank transaction by filename
   *
   * <p><b>200</b> - Success - return response of Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBankTransactionAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBankTransactionAttachmentByFileName");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " createBankTransactionAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createBankTransactionAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createBankTransactionAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBankTransactionAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific bank transactions
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createBankTransactionHistoryRecord(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createBankTransactionHistoryRecordForHttpResponse(
              accessToken, xeroTenantId, bankTransactionID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransactionHistoryRecord -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific bank transactions
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBankTransactionHistoryRecordForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBankTransactionHistoryRecord");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " createBankTransactionHistoryRecord");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling"
              + " createBankTransactionHistoryRecord");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBankTransactionHistoryRecord");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more spent or received money transaction
   *
   * <p><b>200</b> - Success - return response of type BankTransactions array with new
   * BankTransaction
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactions BankTransactions with an array of BankTransaction objects in body of
   *     request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return BankTransactions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BankTransactions createBankTransactions(
      String accessToken,
      String xeroTenantId,
      BankTransactions bankTransactions,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>() {};
      HttpResponse response =
          createBankTransactionsForHttpResponse(
              accessToken, xeroTenantId, bankTransactions, summarizeErrors, unitdp, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransactions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("BankTransactions", object.getMessage(), e);
        }
        handler.validationError("BankTransactions", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more spent or received money transaction
   *
   * <p><b>200</b> - Success - return response of type BankTransactions array with new
   * BankTransaction
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactions BankTransactions with an array of BankTransaction objects in body of
   *     request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBankTransactionsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      BankTransactions bankTransactions,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createBankTransactions");
    } // verify the required parameter 'bankTransactions' is set
    if (bankTransactions == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactions' when calling createBankTransactions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createBankTransactions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransactions");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(bankTransactions);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a bank transfer
   *
   * <p><b>200</b> - Success - return response of BankTransfers array of one BankTransfer
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransfers BankTransfers with array of BankTransfer objects in request body
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return BankTransfers
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BankTransfers createBankTransfer(
      String accessToken, String xeroTenantId, BankTransfers bankTransfers, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>() {};
      HttpResponse response =
          createBankTransferForHttpResponse(
              accessToken, xeroTenantId, bankTransfers, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransfer -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("BankTransfers", object.getMessage(), e);
        }
        handler.validationError("BankTransfers", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a bank transfer
   *
   * <p><b>200</b> - Success - return response of BankTransfers array of one BankTransfer
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransfers BankTransfers with array of BankTransfer objects in request body
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBankTransferForHttpResponse(
      String accessToken, String xeroTenantId, BankTransfers bankTransfers, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createBankTransfer");
    } // verify the required parameter 'bankTransfers' is set
    if (bankTransfers == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransfers' when calling createBankTransfer");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createBankTransfer");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransfers");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(bankTransfers);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createBankTransferAttachmentByFileName to allow byte[] or File type to be
  // passed as body
  /**
   * <b>200</b> - Success - return response of Attachments array of 0 to N Attachment for a Bank
   * Transfer
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createBankTransferAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createBankTransferAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, bankTransferID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransferAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * <b>200</b> - Success - return response of Attachments array of 0 to N Attachment for a Bank
   * Transfer
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createBankTransferAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBankTransferAttachmentByFileName");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling"
              + " createBankTransferAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createBankTransferAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createBankTransferAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBankTransferAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * <b>200</b> - Success - return response of Attachments array of 0 to N Attachment for a Bank
   * Transfer
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createBankTransferAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createBankTransferAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, bankTransferID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransferAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * <b>200</b> - Success - return response of Attachments array of 0 to N Attachment for a Bank
   * Transfer
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBankTransferAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBankTransferAttachmentByFileName");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling"
              + " createBankTransferAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createBankTransferAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createBankTransferAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBankTransferAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific bank transfer
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createBankTransferHistoryRecord(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createBankTransferHistoryRecordForHttpResponse(
              accessToken, xeroTenantId, bankTransferID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBankTransferHistoryRecord -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific bank transfer
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBankTransferHistoryRecordForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBankTransferHistoryRecord");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling"
              + " createBankTransferHistoryRecord");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling"
              + " createBankTransferHistoryRecord");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBankTransferHistoryRecord");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or many batch payments for invoices
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array of BatchPayment objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPayments BatchPayments with an array of Payments in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return BatchPayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BatchPayments createBatchPayment(
      String accessToken,
      String xeroTenantId,
      BatchPayments batchPayments,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>() {};
      HttpResponse response =
          createBatchPaymentForHttpResponse(
              accessToken, xeroTenantId, batchPayments, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBatchPayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("BatchPayments", object.getMessage(), e);
        }
        handler.validationError("BatchPayments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or many batch payments for invoices
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array of BatchPayment objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPayments BatchPayments with an array of Payments in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBatchPaymentForHttpResponse(
      String accessToken,
      String xeroTenantId,
      BatchPayments batchPayments,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createBatchPayment");
    } // verify the required parameter 'batchPayments' is set
    if (batchPayments == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPayments' when calling createBatchPayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createBatchPayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(batchPayments);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific batch payment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createBatchPaymentHistoryRecord(
      String accessToken,
      String xeroTenantId,
      UUID batchPaymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createBatchPaymentHistoryRecordForHttpResponse(
              accessToken, xeroTenantId, batchPaymentID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBatchPaymentHistoryRecord -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific batch payment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBatchPaymentHistoryRecordForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID batchPaymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBatchPaymentHistoryRecord");
    } // verify the required parameter 'batchPaymentID' is set
    if (batchPaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPaymentID' when calling"
              + " createBatchPaymentHistoryRecord");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling"
              + " createBatchPaymentHistoryRecord");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBatchPaymentHistoryRecord");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BatchPaymentID", batchPaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new custom payment service for a specific branding theme
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array with newly created
   * PaymentService
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param brandingThemeID Unique identifier for a Branding Theme
   * @param paymentServices PaymentServices array with PaymentService object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return PaymentServices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaymentServices createBrandingThemePaymentServices(
      String accessToken,
      String xeroTenantId,
      UUID brandingThemeID,
      PaymentServices paymentServices,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>() {};
      HttpResponse response =
          createBrandingThemePaymentServicesForHttpResponse(
              accessToken, xeroTenantId, brandingThemeID, paymentServices, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createBrandingThemePaymentServices -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("PaymentServices", object.getMessage(), e);
        }
        handler.validationError("PaymentServices", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new custom payment service for a specific branding theme
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array with newly created
   * PaymentService
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param brandingThemeID Unique identifier for a Branding Theme
   * @param paymentServices PaymentServices array with PaymentService object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createBrandingThemePaymentServicesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID brandingThemeID,
      PaymentServices paymentServices,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createBrandingThemePaymentServices");
    } // verify the required parameter 'brandingThemeID' is set
    if (brandingThemeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'brandingThemeID' when calling"
              + " createBrandingThemePaymentServices");
    } // verify the required parameter 'paymentServices' is set
    if (paymentServices == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentServices' when calling"
              + " createBrandingThemePaymentServices");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createBrandingThemePaymentServices");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BrandingThemeID", brandingThemeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BrandingThemes/{BrandingThemeID}/PaymentServices");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(paymentServices);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createContactAttachmentByFileName to allow byte[] or File type to be passed
  // as body
  /**
   * <b>200</b> - Success - return response of type Attachments array with an newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createContactAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createContactAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, contactID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createContactAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * <b>200</b> - Success - return response of type Attachments array with an newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createContactAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createContactAttachmentByFileName");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling"
              + " createContactAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createContactAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createContactAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createContactAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * <b>200</b> - Success - return response of type Attachments array with an newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createContactAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createContactAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, contactID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createContactAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * <b>200</b> - Success - return response of type Attachments array with an newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createContactAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createContactAttachmentByFileName");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling"
              + " createContactAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createContactAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createContactAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createContactAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a contact group
   *
   * <p><b>200</b> - Success - return response of type Contact Groups array of newly created Contact
   * Group
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroups ContactGroups with an array of names in request body
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return ContactGroups
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ContactGroups createContactGroup(
      String accessToken, String xeroTenantId, ContactGroups contactGroups, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>() {};
      HttpResponse response =
          createContactGroupForHttpResponse(
              accessToken, xeroTenantId, contactGroups, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createContactGroup -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("ContactGroups", object.getMessage(), e);
        }
        handler.validationError("ContactGroups", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a contact group
   *
   * <p><b>200</b> - Success - return response of type Contact Groups array of newly created Contact
   * Group
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroups ContactGroups with an array of names in request body
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createContactGroupForHttpResponse(
      String accessToken, String xeroTenantId, ContactGroups contactGroups, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createContactGroup");
    } // verify the required parameter 'contactGroups' is set
    if (contactGroups == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactGroups' when calling createContactGroup");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createContactGroup");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/ContactGroups");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(contactGroups);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates contacts to a specific contact group
   *
   * <p><b>200</b> - Success - return response of type Contacts array of added Contacts
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param contacts Contacts with array of contacts specifying the ContactID to be added to
   *     ContactGroup in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Contacts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Contacts createContactGroupContacts(
      String accessToken,
      String xeroTenantId,
      UUID contactGroupID,
      Contacts contacts,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Contacts> typeRef = new TypeReference<Contacts>() {};
      HttpResponse response =
          createContactGroupContactsForHttpResponse(
              accessToken, xeroTenantId, contactGroupID, contacts, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createContactGroupContacts -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Contacts", object.getMessage(), e);
        }
        handler.validationError("Contacts", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates contacts to a specific contact group
   *
   * <p><b>200</b> - Success - return response of type Contacts array of added Contacts
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param contacts Contacts with array of contacts specifying the ContactID to be added to
   *     ContactGroup in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createContactGroupContactsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID contactGroupID,
      Contacts contacts,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createContactGroupContacts");
    } // verify the required parameter 'contactGroupID' is set
    if (contactGroupID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactGroupID' when calling"
              + " createContactGroupContacts");
    } // verify the required parameter 'contacts' is set
    if (contacts == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contacts' when calling createContactGroupContacts");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createContactGroupContacts");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactGroupID", contactGroupID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}/Contacts");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(contacts);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new history record for a specific contact
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createContactHistory(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createContactHistoryForHttpResponse(
              accessToken, xeroTenantId, contactID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createContactHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new history record for a specific contact
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createContactHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createContactHistory");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling createContactHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createContactHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createContactHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts/{ContactID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates multiple contacts (bulk) in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Contacts array with newly created Contact
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contacts Contacts with an array of Contact objects to create in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Contacts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Contacts createContacts(
      String accessToken,
      String xeroTenantId,
      Contacts contacts,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Contacts> typeRef = new TypeReference<Contacts>() {};
      HttpResponse response =
          createContactsForHttpResponse(
              accessToken, xeroTenantId, contacts, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createContacts -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Contacts", object.getMessage(), e);
        }
        handler.validationError("Contacts", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates multiple contacts (bulk) in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Contacts array with newly created Contact
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contacts Contacts with an array of Contact objects to create in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createContactsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Contacts contacts,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createContacts");
    } // verify the required parameter 'contacts' is set
    if (contacts == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contacts' when calling createContacts");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createContacts");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(contacts);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates allocation for a specific credit note
   *
   * <p><b>200</b> - Success - return response of type Allocations array with newly created
   * Allocation for specific Credit Note
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param allocations Allocations with array of Allocation object in body of request.
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Allocations
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Allocations createCreditNoteAllocation(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      Allocations allocations,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Allocations> typeRef = new TypeReference<Allocations>() {};
      HttpResponse response =
          createCreditNoteAllocationForHttpResponse(
              accessToken,
              xeroTenantId,
              creditNoteID,
              allocations,
              summarizeErrors,
              idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createCreditNoteAllocation -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Allocations", object.getMessage(), e);
        }
        handler.validationError("Allocations", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates allocation for a specific credit note
   *
   * <p><b>200</b> - Success - return response of type Allocations array with newly created
   * Allocation for specific Credit Note
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param allocations Allocations with array of Allocation object in body of request.
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createCreditNoteAllocationForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      Allocations allocations,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createCreditNoteAllocation");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling createCreditNoteAllocation");
    } // verify the required parameter 'allocations' is set
    if (allocations == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'allocations' when calling createCreditNoteAllocation");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createCreditNoteAllocation");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Allocations");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(allocations);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createCreditNoteAttachmentByFileName to allow byte[] or File type to be
  // passed as body
  /**
   * Creates an attachment for a specific credit note
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for specific Credit Note
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createCreditNoteAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      String fileName,
      byte[] body,
      Boolean includeOnline,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createCreditNoteAttachmentByFileNameForHttpResponse(
              accessToken,
              xeroTenantId,
              creditNoteID,
              fileName,
              body,
              includeOnline,
              idempotencyKey,
              mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createCreditNoteAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment for a specific credit note
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for specific Credit Note
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createCreditNoteAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      String fileName,
      byte[] body,
      Boolean includeOnline,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createCreditNoteAttachmentByFileName");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling"
              + " createCreditNoteAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createCreditNoteAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createCreditNoteAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createCreditNoteAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}");
    if (includeOnline != null) {
      String key = "IncludeOnline";
      Object value = includeOnline;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an attachment for a specific credit note
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for specific Credit Note
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createCreditNoteAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      String fileName,
      File body,
      Boolean includeOnline,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createCreditNoteAttachmentByFileNameForHttpResponse(
              accessToken,
              xeroTenantId,
              creditNoteID,
              fileName,
              body,
              includeOnline,
              idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createCreditNoteAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment for a specific credit note
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for specific Credit Note
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createCreditNoteAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      String fileName,
      File body,
      Boolean includeOnline,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createCreditNoteAttachmentByFileName");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling"
              + " createCreditNoteAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createCreditNoteAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createCreditNoteAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createCreditNoteAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}");
    if (includeOnline != null) {
      String key = "IncludeOnline";
      Object value = includeOnline;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records of a specific credit note
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createCreditNoteHistory(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createCreditNoteHistoryForHttpResponse(
              accessToken, xeroTenantId, creditNoteID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createCreditNoteHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records of a specific credit note
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createCreditNoteHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createCreditNoteHistory");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling createCreditNoteHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createCreditNoteHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createCreditNoteHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new credit note
   *
   * <p><b>200</b> - Success - return response of type Credit Notes array of newly created
   * CreditNote
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNotes Credit Notes with array of CreditNote object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return CreditNotes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public CreditNotes createCreditNotes(
      String accessToken,
      String xeroTenantId,
      CreditNotes creditNotes,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>() {};
      HttpResponse response =
          createCreditNotesForHttpResponse(
              accessToken, xeroTenantId, creditNotes, summarizeErrors, unitdp, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createCreditNotes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("CreditNotes", object.getMessage(), e);
        }
        handler.validationError("CreditNotes", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new credit note
   *
   * <p><b>200</b> - Success - return response of type Credit Notes array of newly created
   * CreditNote
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNotes Credit Notes with array of CreditNote object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createCreditNotesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      CreditNotes creditNotes,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createCreditNotes");
    } // verify the required parameter 'creditNotes' is set
    if (creditNotes == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNotes' when calling createCreditNotes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createCreditNotes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(creditNotes);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Create a new currency for a Xero organisation
   *
   * <p><b>200</b> - Unsupported - return response incorrect exception, API is not able to create
   * new Currency
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param currency Currency object in the body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Currencies
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Currencies createCurrency(
      String accessToken, String xeroTenantId, Currency currency, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Currencies> typeRef = new TypeReference<Currencies>() {};
      HttpResponse response =
          createCurrencyForHttpResponse(accessToken, xeroTenantId, currency, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createCurrency -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Currencies", object.getMessage(), e);
        }
        handler.validationError("Currencies", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Create a new currency for a Xero organisation
   *
   * <p><b>200</b> - Unsupported - return response incorrect exception, API is not able to create
   * new Currency
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param currency Currency object in the body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createCurrencyForHttpResponse(
      String accessToken, String xeroTenantId, Currency currency, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createCurrency");
    } // verify the required parameter 'currency' is set
    if (currency == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'currency' when calling createCurrency");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createCurrency");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Currencies");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(currency);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates new employees used in Xero payrun This endpoint is deprecated and will be removed April
   * 28, 2026
   *
   * <p><b>200</b> - Success - return response of type Employees array with new Employee
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employees Employees with array of Employee object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Employees
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Employees createEmployees(
      String accessToken,
      String xeroTenantId,
      Employees employees,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Employees> typeRef = new TypeReference<Employees>() {};
      HttpResponse response =
          createEmployeesForHttpResponse(
              accessToken, xeroTenantId, employees, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployees -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Employees", object.getMessage(), e);
        }
        handler.validationError("Employees", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates new employees used in Xero payrun This endpoint is deprecated and will be removed April
   * 28, 2026
   *
   * <p><b>200</b> - Success - return response of type Employees array with new Employee
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employees Employees with array of Employee object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Employees employees,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployees");
    } // verify the required parameter 'employees' is set
    if (employees == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employees' when calling createEmployees");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployees");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employees);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific expense claim
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaimID Unique identifier for a ExpenseClaim
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createExpenseClaimHistory(
      String accessToken,
      String xeroTenantId,
      UUID expenseClaimID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createExpenseClaimHistoryForHttpResponse(
              accessToken, xeroTenantId, expenseClaimID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createExpenseClaimHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific expense claim
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaimID Unique identifier for a ExpenseClaim
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createExpenseClaimHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID expenseClaimID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createExpenseClaimHistory");
    } // verify the required parameter 'expenseClaimID' is set
    if (expenseClaimID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'expenseClaimID' when calling createExpenseClaimHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createExpenseClaimHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createExpenseClaimHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ExpenseClaimID", expenseClaimID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates expense claims
   *
   * <p><b>200</b> - Success - return response of type ExpenseClaims array with newly created
   * ExpenseClaim
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaims ExpenseClaims with array of ExpenseClaim object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return ExpenseClaims
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ExpenseClaims createExpenseClaims(
      String accessToken, String xeroTenantId, ExpenseClaims expenseClaims, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>() {};
      HttpResponse response =
          createExpenseClaimsForHttpResponse(
              accessToken, xeroTenantId, expenseClaims, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createExpenseClaims -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("ExpenseClaims", object.getMessage(), e);
        }
        handler.validationError("ExpenseClaims", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates expense claims
   *
   * <p><b>200</b> - Success - return response of type ExpenseClaims array with newly created
   * ExpenseClaim
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaims ExpenseClaims with array of ExpenseClaim object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createExpenseClaimsForHttpResponse(
      String accessToken, String xeroTenantId, ExpenseClaims expenseClaims, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createExpenseClaims");
    } // verify the required parameter 'expenseClaims' is set
    if (expenseClaims == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'expenseClaims' when calling createExpenseClaims");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createExpenseClaims");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/ExpenseClaims");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(expenseClaims);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createInvoiceAttachmentByFileName to allow byte[] or File type to be passed
  // as body
  /**
   * Creates an attachment for a specific invoice or purchase bill by filename
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createInvoiceAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      String fileName,
      byte[] body,
      Boolean includeOnline,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createInvoiceAttachmentByFileNameForHttpResponse(
              accessToken,
              xeroTenantId,
              invoiceID,
              fileName,
              body,
              includeOnline,
              idempotencyKey,
              mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createInvoiceAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment for a specific invoice or purchase bill by filename
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createInvoiceAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      String fileName,
      byte[] body,
      Boolean includeOnline,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createInvoiceAttachmentByFileName");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling"
              + " createInvoiceAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createInvoiceAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createInvoiceAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createInvoiceAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}");
    if (includeOnline != null) {
      String key = "IncludeOnline";
      Object value = includeOnline;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an attachment for a specific invoice or purchase bill by filename
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createInvoiceAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      String fileName,
      File body,
      Boolean includeOnline,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createInvoiceAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, invoiceID, fileName, body, includeOnline, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createInvoiceAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment for a specific invoice or purchase bill by filename
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param includeOnline Allows an attachment to be seen by the end customer within their online
   *     invoice
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createInvoiceAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      String fileName,
      File body,
      Boolean includeOnline,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createInvoiceAttachmentByFileName");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling"
              + " createInvoiceAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createInvoiceAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createInvoiceAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createInvoiceAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}");
    if (includeOnline != null) {
      String key = "IncludeOnline";
      Object value = includeOnline;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific invoice
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createInvoiceHistory(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createInvoiceHistoryForHttpResponse(
              accessToken, xeroTenantId, invoiceID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createInvoiceHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific invoice
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createInvoiceHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createInvoiceHistory");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling createInvoiceHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createInvoiceHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createInvoiceHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more sales invoices or purchase bills
   *
   * <p><b>200</b> - Success - return response of type Invoices array with newly created Invoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoices Invoices with an array of invoice objects in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Invoices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Invoices createInvoices(
      String accessToken,
      String xeroTenantId,
      Invoices invoices,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Invoices> typeRef = new TypeReference<Invoices>() {};
      HttpResponse response =
          createInvoicesForHttpResponse(
              accessToken, xeroTenantId, invoices, summarizeErrors, unitdp, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createInvoices -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Invoices", object.getMessage(), e);
        }
        handler.validationError("Invoices", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more sales invoices or purchase bills
   *
   * <p><b>200</b> - Success - return response of type Invoices array with newly created Invoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoices Invoices with an array of invoice objects in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createInvoicesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Invoices invoices,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createInvoices");
    } // verify the required parameter 'invoices' is set
    if (invoices == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoices' when calling createInvoices");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createInvoices");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(invoices);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific item
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createItemHistory(
      String accessToken,
      String xeroTenantId,
      UUID itemID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createItemHistoryForHttpResponse(
              accessToken, xeroTenantId, itemID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createItemHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific item
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createItemHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID itemID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createItemHistory");
    } // verify the required parameter 'itemID' is set
    if (itemID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'itemID' when calling createItemHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createItemHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createItemHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ItemID", itemID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Items/{ItemID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more items
   *
   * <p><b>200</b> - Success - return response of type Items array with newly created Item
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param items Items with an array of Item objects in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Items
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Items createItems(
      String accessToken,
      String xeroTenantId,
      Items items,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Items> typeRef = new TypeReference<Items>() {};
      HttpResponse response =
          createItemsForHttpResponse(
              accessToken, xeroTenantId, items, summarizeErrors, unitdp, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createItems -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Items", object.getMessage(), e);
        }
        handler.validationError("Items", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more items
   *
   * <p><b>200</b> - Success - return response of type Items array with newly created Item
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param items Items with an array of Item objects in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createItemsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Items items,
      Boolean summarizeErrors,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createItems");
    } // verify the required parameter 'items' is set
    if (items == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'items' when calling createItems");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createItems");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Items");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(items);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates linked transactions (billable expenses)
   *
   * <p><b>200</b> - Success - return response of type LinkedTransactions array with newly created
   * LinkedTransaction
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param linkedTransaction LinkedTransaction object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return LinkedTransactions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LinkedTransactions createLinkedTransaction(
      String accessToken,
      String xeroTenantId,
      LinkedTransaction linkedTransaction,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>() {};
      HttpResponse response =
          createLinkedTransactionForHttpResponse(
              accessToken, xeroTenantId, linkedTransaction, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createLinkedTransaction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("LinkedTransactions", object.getMessage(), e);
        }
        handler.validationError("LinkedTransactions", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates linked transactions (billable expenses)
   *
   * <p><b>200</b> - Success - return response of type LinkedTransactions array with newly created
   * LinkedTransaction
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param linkedTransaction LinkedTransaction object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createLinkedTransactionForHttpResponse(
      String accessToken,
      String xeroTenantId,
      LinkedTransaction linkedTransaction,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createLinkedTransaction");
    } // verify the required parameter 'linkedTransaction' is set
    if (linkedTransaction == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'linkedTransaction' when calling"
              + " createLinkedTransaction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createLinkedTransaction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/LinkedTransactions");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(linkedTransaction);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createManualJournalAttachmentByFileName to allow byte[] or File type to be
  // passed as body
  /**
   * Creates a specific attachment for a specific manual journal by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with a newly created
   * Attachment for a ManualJournals
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createManualJournalAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createManualJournalAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, manualJournalID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createManualJournalAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a specific attachment for a specific manual journal by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with a newly created
   * Attachment for a ManualJournals
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createManualJournalAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createManualJournalAttachmentByFileName");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling"
              + " createManualJournalAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createManualJournalAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createManualJournalAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createManualJournalAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a specific attachment for a specific manual journal by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with a newly created
   * Attachment for a ManualJournals
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createManualJournalAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createManualJournalAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, manualJournalID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createManualJournalAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a specific attachment for a specific manual journal by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with a newly created
   * Attachment for a ManualJournals
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createManualJournalAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createManualJournalAttachmentByFileName");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling"
              + " createManualJournalAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createManualJournalAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createManualJournalAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createManualJournalAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific manual journal
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createManualJournalHistoryRecord(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createManualJournalHistoryRecordForHttpResponse(
              accessToken, xeroTenantId, manualJournalID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createManualJournalHistoryRecord -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific manual journal
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createManualJournalHistoryRecordForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createManualJournalHistoryRecord");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling"
              + " createManualJournalHistoryRecord");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling"
              + " createManualJournalHistoryRecord");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createManualJournalHistoryRecord");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more manual journals
   *
   * <p><b>200</b> - Success - return response of type ManualJournals array with newly created
   * ManualJournal
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournals ManualJournals array with ManualJournal object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return ManualJournals
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ManualJournals createManualJournals(
      String accessToken,
      String xeroTenantId,
      ManualJournals manualJournals,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>() {};
      HttpResponse response =
          createManualJournalsForHttpResponse(
              accessToken, xeroTenantId, manualJournals, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createManualJournals -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("ManualJournals", object.getMessage(), e);
        }
        handler.validationError("ManualJournals", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more manual journals
   *
   * <p><b>200</b> - Success - return response of type ManualJournals array with newly created
   * ManualJournal
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournals ManualJournals array with ManualJournal object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createManualJournalsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      ManualJournals manualJournals,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createManualJournals");
    } // verify the required parameter 'manualJournals' is set
    if (manualJournals == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournals' when calling createManualJournals");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createManualJournals");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/ManualJournals");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(manualJournals);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a single allocation for a specific overpayment
   *
   * <p><b>200</b> - Success - return response of type Allocations array with all Allocation for
   * Overpayments
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param allocations Allocations array with Allocation object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Allocations
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Allocations createOverpaymentAllocations(
      String accessToken,
      String xeroTenantId,
      UUID overpaymentID,
      Allocations allocations,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Allocations> typeRef = new TypeReference<Allocations>() {};
      HttpResponse response =
          createOverpaymentAllocationsForHttpResponse(
              accessToken,
              xeroTenantId,
              overpaymentID,
              allocations,
              summarizeErrors,
              idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createOverpaymentAllocations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Allocations", object.getMessage(), e);
        }
        handler.validationError("Allocations", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a single allocation for a specific overpayment
   *
   * <p><b>200</b> - Success - return response of type Allocations array with all Allocation for
   * Overpayments
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param allocations Allocations array with Allocation object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createOverpaymentAllocationsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID overpaymentID,
      Allocations allocations,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createOverpaymentAllocations");
    } // verify the required parameter 'overpaymentID' is set
    if (overpaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'overpaymentID' when calling"
              + " createOverpaymentAllocations");
    } // verify the required parameter 'allocations' is set
    if (allocations == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'allocations' when calling createOverpaymentAllocations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createOverpaymentAllocations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("OverpaymentID", overpaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/Allocations");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(allocations);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific overpayment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error - API is not able to create
   * HistoryRecord for Overpayments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createOverpaymentHistory(
      String accessToken,
      String xeroTenantId,
      UUID overpaymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createOverpaymentHistoryForHttpResponse(
              accessToken, xeroTenantId, overpaymentID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createOverpaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific overpayment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error - API is not able to create
   * HistoryRecord for Overpayments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createOverpaymentHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID overpaymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createOverpaymentHistory");
    } // verify the required parameter 'overpaymentID' is set
    if (overpaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'overpaymentID' when calling createOverpaymentHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createOverpaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createOverpaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("OverpaymentID", overpaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a single payment for invoice or credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for newly created Payment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payment Request body with a single Payment object
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Payments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Payments createPayment(
      String accessToken, String xeroTenantId, Payment payment, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Payments> typeRef = new TypeReference<Payments>() {};
      HttpResponse response =
          createPaymentForHttpResponse(accessToken, xeroTenantId, payment, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Payments", object.getMessage(), e);
        }
        handler.validationError("Payments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a single payment for invoice or credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for newly created Payment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payment Request body with a single Payment object
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPaymentForHttpResponse(
      String accessToken, String xeroTenantId, Payment payment, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPayment");
    } // verify the required parameter 'payment' is set
    if (payment == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payment' when calling createPayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Payments");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(payment);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific payment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error - API is not able to create
   * HistoryRecord for Payments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createPaymentHistory(
      String accessToken,
      String xeroTenantId,
      UUID paymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createPaymentHistoryForHttpResponse(
              accessToken, xeroTenantId, paymentID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific payment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error - API is not able to create
   * HistoryRecord for Payments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPaymentHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID paymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPaymentHistory");
    } // verify the required parameter 'paymentID' is set
    if (paymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentID' when calling createPaymentHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createPaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PaymentID", paymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Payments/{PaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a payment service
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array for newly created
   * PaymentService
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentServices PaymentServices array with PaymentService object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return PaymentServices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaymentServices createPaymentService(
      String accessToken,
      String xeroTenantId,
      PaymentServices paymentServices,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>() {};
      HttpResponse response =
          createPaymentServiceForHttpResponse(
              accessToken, xeroTenantId, paymentServices, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPaymentService -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("PaymentServices", object.getMessage(), e);
        }
        handler.validationError("PaymentServices", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a payment service
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array for newly created
   * PaymentService
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentServices PaymentServices array with PaymentService object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPaymentServiceForHttpResponse(
      String accessToken,
      String xeroTenantId,
      PaymentServices paymentServices,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPaymentService");
    } // verify the required parameter 'paymentServices' is set
    if (paymentServices == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentServices' when calling createPaymentService");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPaymentService");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PaymentServices");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(paymentServices);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates multiple payments for invoices or credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for newly created Payment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payments Payments array with Payment object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Payments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Payments createPayments(
      String accessToken,
      String xeroTenantId,
      Payments payments,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Payments> typeRef = new TypeReference<Payments>() {};
      HttpResponse response =
          createPaymentsForHttpResponse(
              accessToken, xeroTenantId, payments, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPayments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Payments", object.getMessage(), e);
        }
        handler.validationError("Payments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates multiple payments for invoices or credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for newly created Payment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payments Payments array with Payment object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPaymentsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Payments payments,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPayments");
    } // verify the required parameter 'payments' is set
    if (payments == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payments' when calling createPayments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPayments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Payments");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(payments);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Allows you to create an Allocation for prepayments
   *
   * <p><b>200</b> - Success - return response of type Allocations array of Allocation for all
   * Prepayment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param allocations Allocations with an array of Allocation object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Allocations
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Allocations createPrepaymentAllocations(
      String accessToken,
      String xeroTenantId,
      UUID prepaymentID,
      Allocations allocations,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Allocations> typeRef = new TypeReference<Allocations>() {};
      HttpResponse response =
          createPrepaymentAllocationsForHttpResponse(
              accessToken,
              xeroTenantId,
              prepaymentID,
              allocations,
              summarizeErrors,
              idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPrepaymentAllocations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Allocations", object.getMessage(), e);
        }
        handler.validationError("Allocations", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Allows you to create an Allocation for prepayments
   *
   * <p><b>200</b> - Success - return response of type Allocations array of Allocation for all
   * Prepayment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param allocations Allocations with an array of Allocation object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPrepaymentAllocationsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID prepaymentID,
      Allocations allocations,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPrepaymentAllocations");
    } // verify the required parameter 'prepaymentID' is set
    if (prepaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'prepaymentID' when calling createPrepaymentAllocations");
    } // verify the required parameter 'allocations' is set
    if (allocations == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'allocations' when calling createPrepaymentAllocations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPrepaymentAllocations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PrepaymentID", prepaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/Allocations");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(allocations);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific prepayment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - Unsupported - return response incorrect exception, API is not able to create
   * HistoryRecord for Expense Claims
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createPrepaymentHistory(
      String accessToken,
      String xeroTenantId,
      UUID prepaymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createPrepaymentHistoryForHttpResponse(
              accessToken, xeroTenantId, prepaymentID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPrepaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific prepayment
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - Unsupported - return response incorrect exception, API is not able to create
   * HistoryRecord for Expense Claims
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPrepaymentHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID prepaymentID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPrepaymentHistory");
    } // verify the required parameter 'prepaymentID' is set
    if (prepaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'prepaymentID' when calling createPrepaymentHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createPrepaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPrepaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PrepaymentID", prepaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createPurchaseOrderAttachmentByFileName to allow byte[] or File type to be
  // passed as body
  /**
   * Creates attachment for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createPurchaseOrderAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createPurchaseOrderAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, purchaseOrderID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPurchaseOrderAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates attachment for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createPurchaseOrderAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates attachment for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createPurchaseOrderAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createPurchaseOrderAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, purchaseOrderID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPurchaseOrderAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates attachment for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPurchaseOrderAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createPurchaseOrderAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific purchase orders
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createPurchaseOrderHistory(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createPurchaseOrderHistoryForHttpResponse(
              accessToken, xeroTenantId, purchaseOrderID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPurchaseOrderHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific purchase orders
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPurchaseOrderHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPurchaseOrderHistory");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling"
              + " createPurchaseOrderHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling"
              + " createPurchaseOrderHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPurchaseOrderHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more purchase orders
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array for specified
   * PurchaseOrder
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrders PurchaseOrders with an array of PurchaseOrder object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return PurchaseOrders
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PurchaseOrders createPurchaseOrders(
      String accessToken,
      String xeroTenantId,
      PurchaseOrders purchaseOrders,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>() {};
      HttpResponse response =
          createPurchaseOrdersForHttpResponse(
              accessToken, xeroTenantId, purchaseOrders, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPurchaseOrders -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("PurchaseOrders", object.getMessage(), e);
        }
        handler.validationError("PurchaseOrders", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more purchase orders
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array for specified
   * PurchaseOrder
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrders PurchaseOrders with an array of PurchaseOrder object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPurchaseOrdersForHttpResponse(
      String accessToken,
      String xeroTenantId,
      PurchaseOrders purchaseOrders,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPurchaseOrders");
    } // verify the required parameter 'purchaseOrders' is set
    if (purchaseOrders == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrders' when calling createPurchaseOrders");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPurchaseOrders");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(purchaseOrders);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createQuoteAttachmentByFileName to allow byte[] or File type to be passed
  // as body
  /**
   * Creates attachment for a specific quote
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createQuoteAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID quoteID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createQuoteAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, quoteID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createQuoteAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates attachment for a specific quote
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createQuoteAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID quoteID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createQuoteAttachmentByFileName");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling createQuoteAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling createQuoteAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createQuoteAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createQuoteAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates attachment for a specific quote
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createQuoteAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID quoteID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createQuoteAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, quoteID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createQuoteAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates attachment for a specific quote
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createQuoteAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID quoteID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createQuoteAttachmentByFileName");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling createQuoteAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling createQuoteAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createQuoteAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createQuoteAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific quote
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createQuoteHistory(
      String accessToken,
      String xeroTenantId,
      UUID quoteID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createQuoteHistoryForHttpResponse(
              accessToken, xeroTenantId, quoteID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createQuoteHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific quote
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createQuoteHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID quoteID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createQuoteHistory");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling createQuoteHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createQuoteHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createQuoteHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Create one or more quotes
   *
   * <p><b>200</b> - Success - return response of type Quotes with array with newly created Quote
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quotes Quotes with an array of Quote object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Quotes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Quotes createQuotes(
      String accessToken,
      String xeroTenantId,
      Quotes quotes,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Quotes> typeRef = new TypeReference<Quotes>() {};
      HttpResponse response =
          createQuotesForHttpResponse(
              accessToken, xeroTenantId, quotes, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createQuotes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Quotes", object.getMessage(), e);
        }
        handler.validationError("Quotes", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Create one or more quotes
   *
   * <p><b>200</b> - Success - return response of type Quotes with array with newly created Quote
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quotes Quotes with an array of Quote object in body of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createQuotesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Quotes quotes,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createQuotes");
    } // verify the required parameter 'quotes' is set
    if (quotes == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quotes' when calling createQuotes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createQuotes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(quotes);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates draft expense claim receipts for any user
   *
   * <p><b>200</b> - Success - return response of type Receipts array for newly created Receipt
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receipts Receipts with an array of Receipt object in body of request
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Receipts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Receipts createReceipt(
      String accessToken,
      String xeroTenantId,
      Receipts receipts,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Receipts> typeRef = new TypeReference<Receipts>() {};
      HttpResponse response =
          createReceiptForHttpResponse(accessToken, xeroTenantId, receipts, unitdp, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createReceipt -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Receipts", object.getMessage(), e);
        }
        handler.validationError("Receipts", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates draft expense claim receipts for any user
   *
   * <p><b>200</b> - Success - return response of type Receipts array for newly created Receipt
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receipts Receipts with an array of Receipt object in body of request
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createReceiptForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Receipts receipts,
      Integer unitdp,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createReceipt");
    } // verify the required parameter 'receipts' is set
    if (receipts == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receipts' when calling createReceipt");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createReceipt");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Receipts");
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(receipts);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createReceiptAttachmentByFileName to allow byte[] or File type to be passed
  // as body
  /**
   * Creates an attachment on a specific expense claim receipts by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for a specified Receipt
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createReceiptAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createReceiptAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, receiptID, fileName, body, idempotencyKey, mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createReceiptAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment on a specific expense claim receipts by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for a specified Receipt
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createReceiptAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createReceiptAttachmentByFileName");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling"
              + " createReceiptAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createReceiptAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createReceiptAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createReceiptAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an attachment on a specific expense claim receipts by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for a specified Receipt
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createReceiptAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createReceiptAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, receiptID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createReceiptAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment on a specific expense claim receipts by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with newly created
   * Attachment for a specified Receipt
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createReceiptAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createReceiptAttachmentByFileName");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling"
              + " createReceiptAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createReceiptAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling createReceiptAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createReceiptAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific receipt
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - Unsupported - return response incorrect exception, API is not able to create
   * HistoryRecord for Receipts
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createReceiptHistory(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createReceiptHistoryForHttpResponse(
              accessToken, xeroTenantId, receiptID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createReceiptHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific receipt
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - Unsupported - return response incorrect exception, API is not able to create
   * HistoryRecord for Receipts
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createReceiptHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createReceiptHistory");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling createReceiptHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling createReceiptHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createReceiptHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Receipts/{ReceiptID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  // Overload params for createRepeatingInvoiceAttachmentByFileName to allow byte[] or File type to
  // be passed as body
  /**
   * Creates an attachment from a specific repeating invoices by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with updated Attachment for
   * a specified Repeating Invoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoiceID Unique identifier for a Repeating Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public Attachments createRepeatingInvoiceAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID repeatingInvoiceID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createRepeatingInvoiceAttachmentByFileNameForHttpResponse(
              accessToken,
              xeroTenantId,
              repeatingInvoiceID,
              fileName,
              body,
              idempotencyKey,
              mimeType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createRepeatingInvoiceAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment from a specific repeating invoices by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with updated Attachment for
   * a specified Repeating Invoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoiceID Unique identifier for a Repeating Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param mimeType The type of file being attached
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HttpResponse createRepeatingInvoiceAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID repeatingInvoiceID,
      String fileName,
      byte[] body,
      String idempotencyKey,
      String mimeType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    } // verify the required parameter 'repeatingInvoiceID' is set
    if (repeatingInvoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'repeatingInvoiceID' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    ByteArrayContent content = null;

    content = new ByteArrayContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an attachment from a specific repeating invoices by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with updated Attachment for
   * a specified Repeating Invoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoiceID Unique identifier for a Repeating Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments createRepeatingInvoiceAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID repeatingInvoiceID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          createRepeatingInvoiceAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, repeatingInvoiceID, fileName, body, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createRepeatingInvoiceAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an attachment from a specific repeating invoices by file name
   *
   * <p><b>200</b> - Success - return response of type Attachments array with updated Attachment for
   * a specified Repeating Invoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoiceID Unique identifier for a Repeating Invoice
   * @param fileName Name of the attachment
   * @param body Byte array of file in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createRepeatingInvoiceAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID repeatingInvoiceID,
      String fileName,
      File body,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    } // verify the required parameter 'repeatingInvoiceID' is set
    if (repeatingInvoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'repeatingInvoiceID' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    } // verify the required parameter 'body' is set
    if (body == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'body' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createRepeatingInvoiceAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }
    java.nio.file.Path bodyPath = body.toPath();
    String mimeType = java.nio.file.Files.probeContentType(bodyPath);
    HttpContent content = null;
    content = new FileContent(mimeType, body);
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a history record for a specific repeating invoice
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoiceID Unique identifier for a Repeating Invoice
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords createRepeatingInvoiceHistory(
      String accessToken,
      String xeroTenantId,
      UUID repeatingInvoiceID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          createRepeatingInvoiceHistoryForHttpResponse(
              accessToken, xeroTenantId, repeatingInvoiceID, historyRecords, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createRepeatingInvoiceHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("HistoryRecords", object.getMessage(), e);
        }
        handler.validationError("HistoryRecords", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a history record for a specific repeating invoice
   *
   * <p><b>200</b> - Success - return response of type HistoryRecords array of HistoryRecord objects
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoiceID Unique identifier for a Repeating Invoice
   * @param historyRecords HistoryRecords containing an array of HistoryRecord objects in body of
   *     request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createRepeatingInvoiceHistoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID repeatingInvoiceID,
      HistoryRecords historyRecords,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createRepeatingInvoiceHistory");
    } // verify the required parameter 'repeatingInvoiceID' is set
    if (repeatingInvoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'repeatingInvoiceID' when calling"
              + " createRepeatingInvoiceHistory");
    } // verify the required parameter 'historyRecords' is set
    if (historyRecords == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'historyRecords' when calling"
              + " createRepeatingInvoiceHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createRepeatingInvoiceHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(historyRecords);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more repeating invoice templates
   *
   * <p><b>200</b> - Success - return response of type RepeatingInvoices array with newly created
   * RepeatingInvoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoices RepeatingInvoices with an array of repeating invoice objects in body
   *     of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return RepeatingInvoices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public RepeatingInvoices createRepeatingInvoices(
      String accessToken,
      String xeroTenantId,
      RepeatingInvoices repeatingInvoices,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<RepeatingInvoices> typeRef = new TypeReference<RepeatingInvoices>() {};
      HttpResponse response =
          createRepeatingInvoicesForHttpResponse(
              accessToken, xeroTenantId, repeatingInvoices, summarizeErrors, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createRepeatingInvoices -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("RepeatingInvoices", object.getMessage(), e);
        }
        handler.validationError("RepeatingInvoices", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more repeating invoice templates
   *
   * <p><b>200</b> - Success - return response of type RepeatingInvoices array with newly created
   * RepeatingInvoice
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param repeatingInvoices RepeatingInvoices with an array of repeating invoice objects in body
   *     of request
   * @param summarizeErrors If false return 200 OK and mix of successfully created objects and any
   *     with validation errors
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createRepeatingInvoicesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      RepeatingInvoices repeatingInvoices,
      Boolean summarizeErrors,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createRepeatingInvoices");
    } // verify the required parameter 'repeatingInvoices' is set
    if (repeatingInvoices == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'repeatingInvoices' when calling"
              + " createRepeatingInvoices");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createRepeatingInvoices");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/RepeatingInvoices");
    if (summarizeErrors != null) {
      String key = "summarizeErrors";
      Object value = summarizeErrors;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(repeatingInvoices);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates one or more tax rates
   *
   * <p><b>200</b> - Success - return response of type TaxRates array newly created TaxRate
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param taxRates TaxRates array with TaxRate object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return TaxRates
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TaxRates createTaxRates(
      String accessToken, String xeroTenantId, TaxRates taxRates, String idempotencyKey)
      throws IOException {
    try {
      TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>() {};
      HttpResponse response =
          createTaxRatesForHttpResponse(accessToken, xeroTenantId, taxRates, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createTaxRates -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("TaxRates", object.getMessage(), e);
        }
        handler.validationError("TaxRates", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates one or more tax rates
   *
   * <p><b>200</b> - Success - return response of type TaxRates array newly created TaxRate
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param taxRates TaxRates array with TaxRate object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createTaxRatesForHttpResponse(
      String accessToken, String xeroTenantId, TaxRates taxRates, String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createTaxRates");
    } // verify the required parameter 'taxRates' is set
    if (taxRates == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'taxRates' when calling createTaxRates");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createTaxRates");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/TaxRates");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(taxRates);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Create tracking categories
   *
   * <p><b>200</b> - Success - return response of type TrackingCategories array of newly created
   * TrackingCategory
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategory TrackingCategory object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return TrackingCategories
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TrackingCategories createTrackingCategory(
      String accessToken,
      String xeroTenantId,
      TrackingCategory trackingCategory,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>() {};
      HttpResponse response =
          createTrackingCategoryForHttpResponse(
              accessToken, xeroTenantId, trackingCategory, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createTrackingCategory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("TrackingCategories", object.getMessage(), e);
        }
        handler.validationError("TrackingCategories", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Create tracking categories
   *
   * <p><b>200</b> - Success - return response of type TrackingCategories array of newly created
   * TrackingCategory
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategory TrackingCategory object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createTrackingCategoryForHttpResponse(
      String accessToken,
      String xeroTenantId,
      TrackingCategory trackingCategory,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createTrackingCategory");
    } // verify the required parameter 'trackingCategory' is set
    if (trackingCategory == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'trackingCategory' when calling createTrackingCategory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createTrackingCategory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/TrackingCategories");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(trackingCategory);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates options for a specific tracking category
   *
   * <p><b>200</b> - Success - return response of type TrackingOptions array of options for a
   * specified category
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategoryID Unique identifier for a TrackingCategory
   * @param trackingOption TrackingOption object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return TrackingOptions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TrackingOptions createTrackingOptions(
      String accessToken,
      String xeroTenantId,
      UUID trackingCategoryID,
      TrackingOption trackingOption,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<TrackingOptions> typeRef = new TypeReference<TrackingOptions>() {};
      HttpResponse response =
          createTrackingOptionsForHttpResponse(
              accessToken, xeroTenantId, trackingCategoryID, trackingOption, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createTrackingOptions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("TrackingOptions", object.getMessage(), e);
        }
        handler.validationError("TrackingOptions", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates options for a specific tracking category
   *
   * <p><b>200</b> - Success - return response of type TrackingOptions array of options for a
   * specified category
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategoryID Unique identifier for a TrackingCategory
   * @param trackingOption TrackingOption object in body of request
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createTrackingOptionsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID trackingCategoryID,
      TrackingOption trackingOption,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createTrackingOptions");
    } // verify the required parameter 'trackingCategoryID' is set
    if (trackingCategoryID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'trackingCategoryID' when calling createTrackingOptions");
    } // verify the required parameter 'trackingOption' is set
    if (trackingOption == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'trackingOption' when calling createTrackingOptions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createTrackingOptions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TrackingCategoryID", trackingCategoryID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/TrackingCategories/{TrackingCategoryID}/Options");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(trackingOption);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a chart of accounts
   *
   * <p><b>200</b> - Success - delete existing Account and return response of type Accounts array
   * with deleted Account
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param accessToken Authorization token for user set in header of each request
   * @return Accounts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Accounts deleteAccount(String accessToken, String xeroTenantId, UUID accountID)
      throws IOException {
    try {
      TypeReference<Accounts> typeRef = new TypeReference<Accounts>() {};
      HttpResponse response = deleteAccountForHttpResponse(accessToken, xeroTenantId, accountID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteAccount -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Accounts", object.getMessage(), e);
        }
        handler.validationError("Accounts", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes a chart of accounts
   *
   * <p><b>200</b> - Success - delete existing Account and return response of type Accounts array
   * with deleted Account
   *
   * <p><b>400</b> - Validation Error - some data was incorrect returns response of type Error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteAccountForHttpResponse(
      String accessToken, String xeroTenantId, UUID accountID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteAccount");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling deleteAccount");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteAccount");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Accounts/{AccountID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates a specific batch payment for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array for updated BatchPayment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentDelete The batchPaymentDelete parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return BatchPayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BatchPayments deleteBatchPayment(
      String accessToken,
      String xeroTenantId,
      BatchPaymentDelete batchPaymentDelete,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>() {};
      HttpResponse response =
          deleteBatchPaymentForHttpResponse(
              accessToken, xeroTenantId, batchPaymentDelete, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteBatchPayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("BatchPayments", object.getMessage(), e);
        }
        handler.validationError("BatchPayments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates a specific batch payment for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array for updated BatchPayment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentDelete The batchPaymentDelete parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteBatchPaymentForHttpResponse(
      String accessToken,
      String xeroTenantId,
      BatchPaymentDelete batchPaymentDelete,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteBatchPayment");
    } // verify the required parameter 'batchPaymentDelete' is set
    if (batchPaymentDelete == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPaymentDelete' when calling deleteBatchPayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteBatchPayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(batchPaymentDelete);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates a specific batch payment for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array for updated BatchPayment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param batchPaymentDeleteByUrlParam The batchPaymentDeleteByUrlParam parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return BatchPayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BatchPayments deleteBatchPaymentByUrlParam(
      String accessToken,
      String xeroTenantId,
      UUID batchPaymentID,
      BatchPaymentDeleteByUrlParam batchPaymentDeleteByUrlParam,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>() {};
      HttpResponse response =
          deleteBatchPaymentByUrlParamForHttpResponse(
              accessToken,
              xeroTenantId,
              batchPaymentID,
              batchPaymentDeleteByUrlParam,
              idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteBatchPaymentByUrlParam -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates a specific batch payment for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array for updated BatchPayment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param batchPaymentDeleteByUrlParam The batchPaymentDeleteByUrlParam parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteBatchPaymentByUrlParamForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID batchPaymentID,
      BatchPaymentDeleteByUrlParam batchPaymentDeleteByUrlParam,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " deleteBatchPaymentByUrlParam");
    } // verify the required parameter 'batchPaymentID' is set
    if (batchPaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPaymentID' when calling"
              + " deleteBatchPaymentByUrlParam");
    } // verify the required parameter 'batchPaymentDeleteByUrlParam' is set
    if (batchPaymentDeleteByUrlParam == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPaymentDeleteByUrlParam' when calling"
              + " deleteBatchPaymentByUrlParam");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteBatchPaymentByUrlParam");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BatchPaymentID", batchPaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(batchPaymentDeleteByUrlParam);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a specific contact from a contact group using a unique contact Id
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public void deleteContactGroupContact(
      String accessToken, String xeroTenantId, UUID contactGroupID, UUID contactID)
      throws IOException {
    try {
      deleteContactGroupContactForHttpResponse(
          accessToken, xeroTenantId, contactGroupID, contactID);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteContactGroupContact -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
  }

  /**
   * Deletes a specific contact from a contact group using a unique contact Id
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteContactGroupContactForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactGroupID, UUID contactID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteContactGroupContact");
    } // verify the required parameter 'contactGroupID' is set
    if (contactGroupID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactGroupID' when calling deleteContactGroupContact");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling deleteContactGroupContact");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteContactGroupContact");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactGroupID", contactGroupID);
    uriVariables.put("ContactID", contactID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}/Contacts/{ContactID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes all contacts from a specific contact group
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param accessToken Authorization token for user set in header of each request
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public void deleteContactGroupContacts(
      String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
    try {
      deleteContactGroupContactsForHttpResponse(accessToken, xeroTenantId, contactGroupID);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteContactGroupContacts -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
  }

  /**
   * Deletes all contacts from a specific contact group
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteContactGroupContactsForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteContactGroupContacts");
    } // verify the required parameter 'contactGroupID' is set
    if (contactGroupID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactGroupID' when calling"
              + " deleteContactGroupContacts");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteContactGroupContacts");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactGroupID", contactGroupID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}/Contacts");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes an Allocation from a Credit Note
   *
   * <p><b>200</b> - Success - return response of type Allocation with the isDeleted flag as true
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param allocationID Unique identifier for Allocation object
   * @param accessToken Authorization token for user set in header of each request
   * @return Allocation
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Allocation deleteCreditNoteAllocations(
      String accessToken, String xeroTenantId, UUID creditNoteID, UUID allocationID)
      throws IOException {
    try {
      TypeReference<Allocation> typeRef = new TypeReference<Allocation>() {};
      HttpResponse response =
          deleteCreditNoteAllocationsForHttpResponse(
              accessToken, xeroTenantId, creditNoteID, allocationID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteCreditNoteAllocations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes an Allocation from a Credit Note
   *
   * <p><b>200</b> - Success - return response of type Allocation with the isDeleted flag as true
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param allocationID Unique identifier for Allocation object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteCreditNoteAllocationsForHttpResponse(
      String accessToken, String xeroTenantId, UUID creditNoteID, UUID allocationID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteCreditNoteAllocations");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling deleteCreditNoteAllocations");
    } // verify the required parameter 'allocationID' is set
    if (allocationID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'allocationID' when calling deleteCreditNoteAllocations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteCreditNoteAllocations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);
    uriVariables.put("AllocationID", allocationID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Allocations/{AllocationID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a specific item
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param accessToken Authorization token for user set in header of each request
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public void deleteItem(String accessToken, String xeroTenantId, UUID itemID) throws IOException {
    try {
      deleteItemForHttpResponse(accessToken, xeroTenantId, itemID);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteItem -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
  }

  /**
   * Deletes a specific item
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteItemForHttpResponse(
      String accessToken, String xeroTenantId, UUID itemID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteItem");
    } // verify the required parameter 'itemID' is set
    if (itemID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'itemID' when calling deleteItem");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteItem");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ItemID", itemID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Items/{ItemID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a specific linked transactions (billable expenses)
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param linkedTransactionID Unique identifier for a LinkedTransaction
   * @param accessToken Authorization token for user set in header of each request
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public void deleteLinkedTransaction(
      String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
    try {
      deleteLinkedTransactionForHttpResponse(accessToken, xeroTenantId, linkedTransactionID);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteLinkedTransaction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
  }

  /**
   * Deletes a specific linked transactions (billable expenses)
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param linkedTransactionID Unique identifier for a LinkedTransaction
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteLinkedTransactionForHttpResponse(
      String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteLinkedTransaction");
    } // verify the required parameter 'linkedTransactionID' is set
    if (linkedTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'linkedTransactionID' when calling"
              + " deleteLinkedTransaction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteLinkedTransaction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("LinkedTransactionID", linkedTransactionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/LinkedTransactions/{LinkedTransactionID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes an Allocation from an overpayment
   *
   * <p><b>200</b> - Success - return response of type Allocation with the isDeleted flag as true
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param allocationID Unique identifier for Allocation object
   * @param accessToken Authorization token for user set in header of each request
   * @return Allocation
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Allocation deleteOverpaymentAllocations(
      String accessToken, String xeroTenantId, UUID overpaymentID, UUID allocationID)
      throws IOException {
    try {
      TypeReference<Allocation> typeRef = new TypeReference<Allocation>() {};
      HttpResponse response =
          deleteOverpaymentAllocationsForHttpResponse(
              accessToken, xeroTenantId, overpaymentID, allocationID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteOverpaymentAllocations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes an Allocation from an overpayment
   *
   * <p><b>200</b> - Success - return response of type Allocation with the isDeleted flag as true
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param allocationID Unique identifier for Allocation object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteOverpaymentAllocationsForHttpResponse(
      String accessToken, String xeroTenantId, UUID overpaymentID, UUID allocationID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " deleteOverpaymentAllocations");
    } // verify the required parameter 'overpaymentID' is set
    if (overpaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'overpaymentID' when calling"
              + " deleteOverpaymentAllocations");
    } // verify the required parameter 'allocationID' is set
    if (allocationID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'allocationID' when calling"
              + " deleteOverpaymentAllocations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteOverpaymentAllocations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("OverpaymentID", overpaymentID);
    uriVariables.put("AllocationID", allocationID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/Allocations/{AllocationID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates a specific payment for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for updated Payment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param paymentDelete The paymentDelete parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return Payments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Payments deletePayment(
      String accessToken,
      String xeroTenantId,
      UUID paymentID,
      PaymentDelete paymentDelete,
      String idempotencyKey)
      throws IOException {
    try {
      TypeReference<Payments> typeRef = new TypeReference<Payments>() {};
      HttpResponse response =
          deletePaymentForHttpResponse(
              accessToken, xeroTenantId, paymentID, paymentDelete, idempotencyKey);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deletePayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Payments", object.getMessage(), e);
        }
        handler.validationError("Payments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates a specific payment for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for updated Payment
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param paymentDelete The paymentDelete parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deletePaymentForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID paymentID,
      PaymentDelete paymentDelete,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deletePayment");
    } // verify the required parameter 'paymentID' is set
    if (paymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentID' when calling deletePayment");
    } // verify the required parameter 'paymentDelete' is set
    if (paymentDelete == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentDelete' when calling deletePayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deletePayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PaymentID", paymentID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Payments/{PaymentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(paymentDelete);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes an Allocation from a Prepayment
   *
   * <p><b>200</b> - Success - return response of type Allocation with the isDeleted flag as true
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param allocationID Unique identifier for Allocation object
   * @param accessToken Authorization token for user set in header of each request
   * @return Allocation
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Allocation deletePrepaymentAllocations(
      String accessToken, String xeroTenantId, UUID prepaymentID, UUID allocationID)
      throws IOException {
    try {
      TypeReference<Allocation> typeRef = new TypeReference<Allocation>() {};
      HttpResponse response =
          deletePrepaymentAllocationsForHttpResponse(
              accessToken, xeroTenantId, prepaymentID, allocationID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deletePrepaymentAllocations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes an Allocation from a Prepayment
   *
   * <p><b>200</b> - Success - return response of type Allocation with the isDeleted flag as true
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param allocationID Unique identifier for Allocation object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deletePrepaymentAllocationsForHttpResponse(
      String accessToken, String xeroTenantId, UUID prepaymentID, UUID allocationID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deletePrepaymentAllocations");
    } // verify the required parameter 'prepaymentID' is set
    if (prepaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'prepaymentID' when calling deletePrepaymentAllocations");
    } // verify the required parameter 'allocationID' is set
    if (allocationID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'allocationID' when calling deletePrepaymentAllocations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deletePrepaymentAllocations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PrepaymentID", prepaymentID);
    uriVariables.put("AllocationID", allocationID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/Allocations/{AllocationID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a specific tracking category
   *
   * <p><b>200</b> - Success - return response of type TrackingCategories array of deleted
   * TrackingCategory
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategoryID Unique identifier for a TrackingCategory
   * @param accessToken Authorization token for user set in header of each request
   * @return TrackingCategories
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TrackingCategories deleteTrackingCategory(
      String accessToken, String xeroTenantId, UUID trackingCategoryID) throws IOException {
    try {
      TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>() {};
      HttpResponse response =
          deleteTrackingCategoryForHttpResponse(accessToken, xeroTenantId, trackingCategoryID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteTrackingCategory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes a specific tracking category
   *
   * <p><b>200</b> - Success - return response of type TrackingCategories array of deleted
   * TrackingCategory
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategoryID Unique identifier for a TrackingCategory
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteTrackingCategoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID trackingCategoryID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteTrackingCategory");
    } // verify the required parameter 'trackingCategoryID' is set
    if (trackingCategoryID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'trackingCategoryID' when calling"
              + " deleteTrackingCategory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteTrackingCategory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TrackingCategoryID", trackingCategoryID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/TrackingCategories/{TrackingCategoryID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a specific option for a specific tracking category
   *
   * <p><b>200</b> - Success - return response of type TrackingOptions array of remaining options
   * for a specified category
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategoryID Unique identifier for a TrackingCategory
   * @param trackingOptionID Unique identifier for a Tracking Option
   * @param accessToken Authorization token for user set in header of each request
   * @return TrackingOptions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TrackingOptions deleteTrackingOptions(
      String accessToken, String xeroTenantId, UUID trackingCategoryID, UUID trackingOptionID)
      throws IOException {
    try {
      TypeReference<TrackingOptions> typeRef = new TypeReference<TrackingOptions>() {};
      HttpResponse response =
          deleteTrackingOptionsForHttpResponse(
              accessToken, xeroTenantId, trackingCategoryID, trackingOptionID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteTrackingOptions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes a specific option for a specific tracking category
   *
   * <p><b>200</b> - Success - return response of type TrackingOptions array of remaining options
   * for a specified category
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param trackingCategoryID Unique identifier for a TrackingCategory
   * @param trackingOptionID Unique identifier for a Tracking Option
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteTrackingOptionsForHttpResponse(
      String accessToken, String xeroTenantId, UUID trackingCategoryID, UUID trackingOptionID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteTrackingOptions");
    } // verify the required parameter 'trackingCategoryID' is set
    if (trackingCategoryID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'trackingCategoryID' when calling deleteTrackingOptions");
    } // verify the required parameter 'trackingOptionID' is set
    if (trackingOptionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'trackingOptionID' when calling deleteTrackingOptions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteTrackingOptions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TrackingCategoryID", trackingCategoryID);
    uriVariables.put("TrackingOptionID", trackingOptionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Sends a copy of a specific invoice to related contact via email
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param requestEmpty The requestEmpty parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public void emailInvoice(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      RequestEmpty requestEmpty,
      String idempotencyKey)
      throws IOException {
    try {
      emailInvoiceForHttpResponse(
          accessToken, xeroTenantId, invoiceID, requestEmpty, idempotencyKey);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : emailInvoice -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("", object.getMessage(), e);
        }
        handler.validationError("", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
  }

  /**
   * Sends a copy of a specific invoice to related contact via email
   *
   * <p><b>204</b> - Success - return response 204 no content
   *
   * <p><b>400</b> - A failed request due to validation error
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param requestEmpty The requestEmpty parameter
   * @param idempotencyKey This allows you to safely retry requests without the risk of duplicate
   *     processing. 128 character max.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse emailInvoiceForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      RequestEmpty requestEmpty,
      String idempotencyKey)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling emailInvoice");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling emailInvoice");
    } // verify the required parameter 'requestEmpty' is set
    if (requestEmpty == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'requestEmpty' when calling emailInvoice");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling emailInvoice");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("Idempotency-Key", idempotencyKey);
    headers.setAccept("application/json");
    headers.setContentType("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}/Email");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(requestEmpty);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a single chart of accounts by using a unique account Id
   *
   * <p><b>200</b> - Success - return response of type Accounts array with one Account
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param accessToken Authorization token for user set in header of each request
   * @return Accounts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Accounts getAccount(String accessToken, String xeroTenantId, UUID accountID)
      throws IOException {
    try {
      TypeReference<Accounts> typeRef = new TypeReference<Accounts>() {};
      HttpResponse response = getAccountForHttpResponse(accessToken, xeroTenantId, accountID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getAccount -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a single chart of accounts by using a unique account Id
   *
   * <p><b>200</b> - Success - return response of type Accounts array with one Account
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getAccountForHttpResponse(
      String accessToken, String xeroTenantId, UUID accountID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getAccount");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling getAccount");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getAccount");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Accounts/{AccountID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves an attachment for a specific account by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Account as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getAccountAttachmentByFileName(
      String accessToken, String xeroTenantId, UUID accountID, String fileName, String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getAccountAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, accountID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getAccountAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves an attachment for a specific account by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Account as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getAccountAttachmentByFileNameForHttpResponse(
      String accessToken, String xeroTenantId, UUID accountID, String fileName, String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getAccountAttachmentByFileName");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling getAccountAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling getAccountAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getAccountAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getAccountAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific account using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Account as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getAccountAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID accountID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getAccountAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, accountID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getAccountAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific account using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Account as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getAccountAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID accountID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getAccountAttachmentById");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling getAccountAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling getAccountAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getAccountAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getAccountAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific accounts by using a unique account Id
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getAccountAttachments(String accessToken, String xeroTenantId, UUID accountID)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getAccountAttachmentsForHttpResponse(accessToken, xeroTenantId, accountID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getAccountAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific accounts by using a unique account Id
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accountID Unique identifier for Account object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getAccountAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID accountID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getAccountAttachments");
    } // verify the required parameter 'accountID' is set
    if (accountID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accountID' when calling getAccountAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getAccountAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("AccountID", accountID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves the full chart of accounts
   *
   * <p><b>200</b> - Success - return response of type Accounts array with 0 to n Account
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return Accounts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Accounts getAccounts(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    try {
      TypeReference<Accounts> typeRef = new TypeReference<Accounts>() {};
      HttpResponse response =
          getAccountsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getAccounts -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves the full chart of accounts
   *
   * <p><b>200</b> - Success - return response of type Accounts array with 0 to n Account
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getAccountsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getAccounts");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getAccounts");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Accounts");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a single spent or received money transaction by using a unique bank transaction Id
   *
   * <p><b>200</b> - Success - return response of type BankTransactions array with a specific
   * BankTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return BankTransactions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BankTransactions getBankTransaction(
      String accessToken, String xeroTenantId, UUID bankTransactionID, Integer unitdp)
      throws IOException {
    try {
      TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>() {};
      HttpResponse response =
          getBankTransactionForHttpResponse(accessToken, xeroTenantId, bankTransactionID, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransaction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a single spent or received money transaction by using a unique bank transaction Id
   *
   * <p><b>200</b> - Success - return response of type BankTransactions array with a specific
   * BankTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransactionForHttpResponse(
      String accessToken, String xeroTenantId, UUID bankTransactionID, Integer unitdp)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransaction");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling getBankTransaction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransaction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}");
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific bank transaction by filename
   *
   * <p><b>200</b> - Success - return response of attachment for BankTransaction as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getBankTransactionAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      String fileName,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getBankTransactionAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, bankTransactionID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransactionAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific bank transaction by filename
   *
   * <p><b>200</b> - Success - return response of attachment for BankTransaction as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransactionAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      String fileName,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getBankTransactionAttachmentByFileName");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " getBankTransactionAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " getBankTransactionAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getBankTransactionAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getBankTransactionAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for BankTransaction as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getBankTransactionAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getBankTransactionAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, bankTransactionID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransactionAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for BankTransaction as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransactionAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransactionID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getBankTransactionAttachmentById");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " getBankTransactionAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling"
              + " getBankTransactionAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getBankTransactionAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getBankTransactionAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves any attachments from a specific bank transactions
   *
   * <p><b>200</b> - Success - return response of type Attachments array with 0 to n Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getBankTransactionAttachments(
      String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getBankTransactionAttachmentsForHttpResponse(
              accessToken, xeroTenantId, bankTransactionID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransactionAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves any attachments from a specific bank transactions
   *
   * <p><b>200</b> - Success - return response of type Attachments array with 0 to n Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransactionAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getBankTransactionAttachments");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " getBankTransactionAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getBankTransactionAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves any spent or received money transactions
   *
   * <p><b>200</b> - Success - return response of type BankTransactions array with 0 to n
   * BankTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page Up to 100 bank transactions will be returned in a single API call with line items
   *     details
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return BankTransactions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BankTransactions getBankTransactions(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>() {};
      HttpResponse response =
          getBankTransactionsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransactions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves any spent or received money transactions
   *
   * <p><b>200</b> - Success - return response of type BankTransactions array with 0 to n
   * BankTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page Up to 100 bank transactions will be returned in a single API call with line items
   *     details
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransactionsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransactions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransactions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransactions");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history from a specific bank transaction using a unique bank transaction Id
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getBankTransactionsHistory(
      String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getBankTransactionsHistoryForHttpResponse(accessToken, xeroTenantId, bankTransactionID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransactionsHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history from a specific bank transaction using a unique bank transaction Id
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransactionID Xero generated unique identifier for a bank transaction
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransactionsHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransactionsHistory");
    } // verify the required parameter 'bankTransactionID' is set
    if (bankTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransactionID' when calling"
              + " getBankTransactionsHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransactionsHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransactionID", bankTransactionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves specific bank transfers by using a unique bank transfer Id
   *
   * <p><b>200</b> - Success - return response of BankTransfers array with one BankTransfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param accessToken Authorization token for user set in header of each request
   * @return BankTransfers
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BankTransfers getBankTransfer(String accessToken, String xeroTenantId, UUID bankTransferID)
      throws IOException {
    try {
      TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>() {};
      HttpResponse response =
          getBankTransferForHttpResponse(accessToken, xeroTenantId, bankTransferID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransfer -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves specific bank transfers by using a unique bank transfer Id
   *
   * <p><b>200</b> - Success - return response of BankTransfers array with one BankTransfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransferForHttpResponse(
      String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransfer");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling getBankTransfer");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransfer");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransfers/{BankTransferID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment on a specific bank transfer by file name
   *
   * <p><b>200</b> - Success - return response of binary data from the Attachment to a Bank Transfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getBankTransferAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      String fileName,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getBankTransferAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, bankTransferID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransferAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment on a specific bank transfer by file name
   *
   * <p><b>200</b> - Success - return response of binary data from the Attachment to a Bank Transfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransferAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      String fileName,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getBankTransferAttachmentByFileName");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling"
              + " getBankTransferAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " getBankTransferAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getBankTransferAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getBankTransferAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific bank transfer using a unique attachment ID
   *
   * <p><b>200</b> - Success - return response of binary data from the Attachment to a Bank Transfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getBankTransferAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getBankTransferAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, bankTransferID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransferAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific bank transfer using a unique attachment ID
   *
   * <p><b>200</b> - Success - return response of binary data from the Attachment to a Bank Transfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransferAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID bankTransferID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getBankTransferAttachmentById");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling"
              + " getBankTransferAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling"
              + " getBankTransferAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getBankTransferAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getBankTransferAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments from a specific bank transfer
   *
   * <p><b>200</b> - Success - return response of Attachments array of 0 to N Attachment for a Bank
   * Transfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getBankTransferAttachments(
      String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getBankTransferAttachmentsForHttpResponse(accessToken, xeroTenantId, bankTransferID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransferAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments from a specific bank transfer
   *
   * <p><b>200</b> - Success - return response of Attachments array of 0 to N Attachment for a Bank
   * Transfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransferAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransferAttachments");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling"
              + " getBankTransferAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransferAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history from a specific bank transfer using a unique bank transfer Id
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getBankTransferHistory(
      String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getBankTransferHistoryForHttpResponse(accessToken, xeroTenantId, bankTransferID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransferHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history from a specific bank transfer using a unique bank transfer Id
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param bankTransferID Xero generated unique identifier for a bank transfer
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransferHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransferHistory");
    } // verify the required parameter 'bankTransferID' is set
    if (bankTransferID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'bankTransferID' when calling getBankTransferHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransferHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BankTransferID", bankTransferID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves all bank transfers
   *
   * <p><b>200</b> - Success - return response of BankTransfers array of 0 to N BankTransfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return BankTransfers
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BankTransfers getBankTransfers(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    try {
      TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>() {};
      HttpResponse response =
          getBankTransfersForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBankTransfers -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves all bank transfers
   *
   * <p><b>200</b> - Success - return response of BankTransfers array of 0 to N BankTransfer
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBankTransfersForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBankTransfers");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBankTransfers");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BankTransfers");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific batch payment using a unique batch payment Id
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array with matching batch
   * payment Id
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param accessToken Authorization token for user set in header of each request
   * @return BatchPayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BatchPayments getBatchPayment(String accessToken, String xeroTenantId, UUID batchPaymentID)
      throws IOException {
    try {
      TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>() {};
      HttpResponse response =
          getBatchPaymentForHttpResponse(accessToken, xeroTenantId, batchPaymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBatchPayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific batch payment using a unique batch payment Id
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array with matching batch
   * payment Id
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBatchPaymentForHttpResponse(
      String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBatchPayment");
    } // verify the required parameter 'batchPaymentID' is set
    if (batchPaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPaymentID' when calling getBatchPayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBatchPayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BatchPaymentID", batchPaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history from a specific batch payment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getBatchPaymentHistory(
      String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getBatchPaymentHistoryForHttpResponse(accessToken, xeroTenantId, batchPaymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBatchPaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history from a specific batch payment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param batchPaymentID Unique identifier for BatchPayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBatchPaymentHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBatchPaymentHistory");
    } // verify the required parameter 'batchPaymentID' is set
    if (batchPaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'batchPaymentID' when calling getBatchPaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBatchPaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BatchPaymentID", batchPaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves either one or many batch payments for invoices
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array of BatchPayment objects
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return BatchPayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BatchPayments getBatchPayments(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    try {
      TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>() {};
      HttpResponse response =
          getBatchPaymentsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBatchPayments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves either one or many batch payments for invoices
   *
   * <p><b>200</b> - Success - return response of type BatchPayments array of BatchPayment objects
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBatchPaymentsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBatchPayments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBatchPayments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BatchPayments");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific branding theme using a unique branding theme Id
   *
   * <p><b>200</b> - Success - return response of type BrandingThemes with one BrandingTheme
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param brandingThemeID Unique identifier for a Branding Theme
   * @param accessToken Authorization token for user set in header of each request
   * @return BrandingThemes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BrandingThemes getBrandingTheme(
      String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
    try {
      TypeReference<BrandingThemes> typeRef = new TypeReference<BrandingThemes>() {};
      HttpResponse response =
          getBrandingThemeForHttpResponse(accessToken, xeroTenantId, brandingThemeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBrandingTheme -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific branding theme using a unique branding theme Id
   *
   * <p><b>200</b> - Success - return response of type BrandingThemes with one BrandingTheme
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param brandingThemeID Unique identifier for a Branding Theme
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBrandingThemeForHttpResponse(
      String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBrandingTheme");
    } // verify the required parameter 'brandingThemeID' is set
    if (brandingThemeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'brandingThemeID' when calling getBrandingTheme");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBrandingTheme");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BrandingThemeID", brandingThemeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/BrandingThemes/{BrandingThemeID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves the payment services for a specific branding theme
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array with 0 to N
   * PaymentService
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param brandingThemeID Unique identifier for a Branding Theme
   * @param accessToken Authorization token for user set in header of each request
   * @return PaymentServices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaymentServices getBrandingThemePaymentServices(
      String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
    try {
      TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>() {};
      HttpResponse response =
          getBrandingThemePaymentServicesForHttpResponse(
              accessToken, xeroTenantId, brandingThemeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBrandingThemePaymentServices -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves the payment services for a specific branding theme
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array with 0 to N
   * PaymentService
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param brandingThemeID Unique identifier for a Branding Theme
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBrandingThemePaymentServicesForHttpResponse(
      String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getBrandingThemePaymentServices");
    } // verify the required parameter 'brandingThemeID' is set
    if (brandingThemeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'brandingThemeID' when calling"
              + " getBrandingThemePaymentServices");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getBrandingThemePaymentServices");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BrandingThemeID", brandingThemeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/BrandingThemes/{BrandingThemeID}/PaymentServices");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves all the branding themes
   *
   * <p><b>200</b> - Success - return response of type BrandingThemes
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return BrandingThemes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public BrandingThemes getBrandingThemes(String accessToken, String xeroTenantId)
      throws IOException {
    try {
      TypeReference<BrandingThemes> typeRef = new TypeReference<BrandingThemes>() {};
      HttpResponse response = getBrandingThemesForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBrandingThemes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves all the branding themes
   *
   * <p><b>200</b> - Success - return response of type BrandingThemes
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBrandingThemesForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBrandingThemes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBrandingThemes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/BrandingThemes");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific budget, which includes budget lines
   *
   * <p><b>200</b> - Success - return response of type Invoices array with specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param budgetID Unique identifier for Budgets
   * @param dateTo Filter by start date
   * @param dateFrom Filter by end date
   * @param accessToken Authorization token for user set in header of each request
   * @return Budgets
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Budgets getBudget(
      String accessToken, String xeroTenantId, UUID budgetID, LocalDate dateTo, LocalDate dateFrom)
      throws IOException {
    try {
      TypeReference<Budgets> typeRef = new TypeReference<Budgets>() {};
      HttpResponse response =
          getBudgetForHttpResponse(accessToken, xeroTenantId, budgetID, dateTo, dateFrom);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBudget -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific budget, which includes budget lines
   *
   * <p><b>200</b> - Success - return response of type Invoices array with specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param budgetID Unique identifier for Budgets
   * @param dateTo Filter by start date
   * @param dateFrom Filter by end date
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBudgetForHttpResponse(
      String accessToken, String xeroTenantId, UUID budgetID, LocalDate dateTo, LocalDate dateFrom)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBudget");
    } // verify the required parameter 'budgetID' is set
    if (budgetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'budgetID' when calling getBudget");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBudget");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("BudgetID", budgetID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Budgets/{BudgetID}");
    if (dateTo != null) {
      String key = "DateTo";
      Object value = dateTo;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (dateFrom != null) {
      String key = "DateFrom";
      Object value = dateFrom;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieve a list of budgets
   *
   * <p><b>200</b> - Success - return response of type Budgets array with 0 to N Budgets
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ids Filter by BudgetID. Allows you to retrieve a specific individual budget.
   * @param dateTo Filter by start date
   * @param dateFrom Filter by end date
   * @param accessToken Authorization token for user set in header of each request
   * @return Budgets
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Budgets getBudgets(
      String accessToken, String xeroTenantId, List<UUID> ids, LocalDate dateTo, LocalDate dateFrom)
      throws IOException {
    try {
      TypeReference<Budgets> typeRef = new TypeReference<Budgets>() {};
      HttpResponse response =
          getBudgetsForHttpResponse(accessToken, xeroTenantId, ids, dateTo, dateFrom);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getBudgets -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieve a list of budgets
   *
   * <p><b>200</b> - Success - return response of type Budgets array with 0 to N Budgets
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ids Filter by BudgetID. Allows you to retrieve a specific individual budget.
   * @param dateTo Filter by start date
   * @param dateFrom Filter by end date
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getBudgetsForHttpResponse(
      String accessToken, String xeroTenantId, List<UUID> ids, LocalDate dateTo, LocalDate dateFrom)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getBudgets");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getBudgets");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Budgets");
    if (ids != null) {
      String key = "IDs";
      Object value = ids;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (dateTo != null) {
      String key = "DateTo";
      Object value = dateTo;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (dateFrom != null) {
      String key = "DateFrom";
      Object value = dateFrom;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific contacts in a Xero organisation using a unique contact Id
   *
   * <p><b>200</b> - Success - return response of type Contacts array with a unique Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return Contacts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Contacts getContact(String accessToken, String xeroTenantId, UUID contactID)
      throws IOException {
    try {
      TypeReference<Contacts> typeRef = new TypeReference<Contacts>() {};
      HttpResponse response = getContactForHttpResponse(accessToken, xeroTenantId, contactID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContact -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific contacts in a Xero organisation using a unique contact Id
   *
   * <p><b>200</b> - Success - return response of type Contacts array with a unique Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContact");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling getContact");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContact");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts/{ContactID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific contact by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Contact as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getContactAttachmentByFileName(
      String accessToken, String xeroTenantId, UUID contactID, String fileName, String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getContactAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, contactID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific contact by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Contact as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactAttachmentByFileNameForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactID, String fileName, String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getContactAttachmentByFileName");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling getContactAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling getContactAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getContactAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getContactAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific contact using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Contact as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getContactAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getContactAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, contactID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific contact using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Contact as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID contactID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactAttachmentById");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling getContactAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling getContactAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getContactAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific contact in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Attachments array with 0 to N Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getContactAttachments(String accessToken, String xeroTenantId, UUID contactID)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getContactAttachmentsForHttpResponse(accessToken, xeroTenantId, contactID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400) {
        TypeReference<com.xero.models.accounting.Error> errorTypeRef =
            new TypeReference<com.xero.models.accounting.Error>() {};
        com.xero.models.accounting.Error object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        if (object.getElements() == null || object.getElements().isEmpty()) {
          handler.validationError("Attachments", object.getMessage(), e);
        }
        handler.validationError("Attachments", object, e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific contact in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Attachments array with 0 to N Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactAttachments");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling getContactAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific contact by contact number in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Contacts array with a unique Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactNumber This field is read only on the Xero contact screen, used to identify
   *     contacts in external systems (max length &#x3D; 50).
   * @param accessToken Authorization token for user set in header of each request
   * @return Contacts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Contacts getContactByContactNumber(
      String accessToken, String xeroTenantId, String contactNumber) throws IOException {
    try {
      TypeReference<Contacts> typeRef = new TypeReference<Contacts>() {};
      HttpResponse response =
          getContactByContactNumberForHttpResponse(accessToken, xeroTenantId, contactNumber);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactByContactNumber -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific contact by contact number in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Contacts array with a unique Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactNumber This field is read only on the Xero contact screen, used to identify
   *     contacts in external systems (max length &#x3D; 50).
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactByContactNumberForHttpResponse(
      String accessToken, String xeroTenantId, String contactNumber) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactByContactNumber");
    } // verify the required parameter 'contactNumber' is set
    if (contactNumber == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactNumber' when calling getContactByContactNumber");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactByContactNumber");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactNumber", contactNumber);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts/{ContactNumber}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves CIS settings for a specific contact in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type CISSettings for a specific Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return CISSettings
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public CISSettings getContactCISSettings(String accessToken, String xeroTenantId, UUID contactID)
      throws IOException {
    try {
      TypeReference<CISSettings> typeRef = new TypeReference<CISSettings>() {};
      HttpResponse response =
          getContactCISSettingsForHttpResponse(accessToken, xeroTenantId, contactID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactCISSettings -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves CIS settings for a specific contact in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type CISSettings for a specific Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactCISSettingsForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactCISSettings");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling getContactCISSettings");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactCISSettings");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts/{ContactID}/CISSettings");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific contact group by using a unique contact group Id
   *
   * <p><b>200</b> - Success - return response of type Contact Groups array with a specific Contact
   * Group
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param accessToken Authorization token for user set in header of each request
   * @return ContactGroups
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ContactGroups getContactGroup(String accessToken, String xeroTenantId, UUID contactGroupID)
      throws IOException {
    try {
      TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>() {};
      HttpResponse response =
          getContactGroupForHttpResponse(accessToken, xeroTenantId, contactGroupID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactGroup -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific contact group by using a unique contact group Id
   *
   * <p><b>200</b> - Success - return response of type Contact Groups array with a specific Contact
   * Group
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactGroupID Unique identifier for a Contact Group
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactGroupForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactGroup");
    } // verify the required parameter 'contactGroupID' is set
    if (contactGroupID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactGroupID' when calling getContactGroup");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactGroup");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactGroupID", contactGroupID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves the contact Id and name of each contact group
   *
   * <p><b>200</b> - Success - return response of type Contact Groups array of Contact Group
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return ContactGroups
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ContactGroups getContactGroups(
      String accessToken, String xeroTenantId, String where, String order) throws IOException {
    try {
      TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>() {};
      HttpResponse response =
          getContactGroupsForHttpResponse(accessToken, xeroTenantId, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactGroups -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves the contact Id and name of each contact group
   *
   * <p><b>200</b> - Success - return response of type Contact Groups array of Contact Group
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactGroupsForHttpResponse(
      String accessToken, String xeroTenantId, String where, String order) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactGroups");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactGroups");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/ContactGroups");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records for a specific contact
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getContactHistory(String accessToken, String xeroTenantId, UUID contactID)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getContactHistoryForHttpResponse(accessToken, xeroTenantId, contactID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContactHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records for a specific contact
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param contactID Unique identifier for a Contact
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID contactID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContactHistory");
    } // verify the required parameter 'contactID' is set
    if (contactID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contactID' when calling getContactHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContactHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ContactID", contactID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts/{ContactID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves all contacts in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Contacts array with 0 to N Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param ids Filter by a comma separated list of ContactIDs. Allows you to retrieve a specific
   *     set of contacts in a single call.
   * @param page e.g. page&#x3D;1 - Up to 100 contacts will be returned in a single API call.
   * @param includeArchived e.g. includeArchived&#x3D;true - Contacts with a status of ARCHIVED will
   *     be included in the response
   * @param summaryOnly Use summaryOnly&#x3D;true in GET Contacts and Invoices endpoint to retrieve
   *     a smaller version of the response object. This returns only lightweight fields, excluding
   *     computation-heavy fields from the response, making the API calls quick and efficient.
   * @param searchTerm Search parameter that performs a case-insensitive text search across the
   *     Name, FirstName, LastName, ContactNumber and EmailAddress fields.
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return Contacts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Contacts getContacts(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      List<UUID> ids,
      Integer page,
      Boolean includeArchived,
      Boolean summaryOnly,
      String searchTerm,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<Contacts> typeRef = new TypeReference<Contacts>() {};
      HttpResponse response =
          getContactsForHttpResponse(
              accessToken,
              xeroTenantId,
              ifModifiedSince,
              where,
              order,
              ids,
              page,
              includeArchived,
              summaryOnly,
              searchTerm,
              pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getContacts -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves all contacts in a Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Contacts array with 0 to N Contact
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param ids Filter by a comma separated list of ContactIDs. Allows you to retrieve a specific
   *     set of contacts in a single call.
   * @param page e.g. page&#x3D;1 - Up to 100 contacts will be returned in a single API call.
   * @param includeArchived e.g. includeArchived&#x3D;true - Contacts with a status of ARCHIVED will
   *     be included in the response
   * @param summaryOnly Use summaryOnly&#x3D;true in GET Contacts and Invoices endpoint to retrieve
   *     a smaller version of the response object. This returns only lightweight fields, excluding
   *     computation-heavy fields from the response, making the API calls quick and efficient.
   * @param searchTerm Search parameter that performs a case-insensitive text search across the
   *     Name, FirstName, LastName, ContactNumber and EmailAddress fields.
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getContactsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      List<UUID> ids,
      Integer page,
      Boolean includeArchived,
      Boolean summaryOnly,
      String searchTerm,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getContacts");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getContacts");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Contacts");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (ids != null) {
      String key = "IDs";
      Object value = ids;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (includeArchived != null) {
      String key = "includeArchived";
      Object value = includeArchived;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (summaryOnly != null) {
      String key = "summaryOnly";
      Object value = summaryOnly;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (searchTerm != null) {
      String key = "searchTerm";
      Object value = searchTerm;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific credit note using a unique credit note Id
   *
   * <p><b>200</b> - Success - return response of type Credit Notes array with a unique CreditNote
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return CreditNotes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public CreditNotes getCreditNote(
      String accessToken, String xeroTenantId, UUID creditNoteID, Integer unitdp)
      throws IOException {
    try {
      TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>() {};
      HttpResponse response =
          getCreditNoteForHttpResponse(accessToken, xeroTenantId, creditNoteID, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNote -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific credit note using a unique credit note Id
   *
   * <p><b>200</b> - Success - return response of type Credit Notes array with a unique CreditNote
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNoteForHttpResponse(
      String accessToken, String xeroTenantId, UUID creditNoteID, Integer unitdp)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCreditNote");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling getCreditNote");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCreditNote");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}");
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves credit notes as PDF files
   *
   * <p><b>200</b> - Success - return response of binary data from the Attachment to a Credit Note
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getCreditNoteAsPdf(
      String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getCreditNoteAsPdfForHttpResponse(accessToken, xeroTenantId, creditNoteID);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNoteAsPdf -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves credit notes as PDF files
   *
   * <p><b>200</b> - Success - return response of binary data from the Attachment to a Credit Note
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNoteAsPdfForHttpResponse(
      String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCreditNoteAsPdf");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling getCreditNoteAsPdf");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCreditNoteAsPdf");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/pdf");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment on a specific credit note by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Credit Note as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getCreditNoteAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      String fileName,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getCreditNoteAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, creditNoteID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNoteAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment on a specific credit note by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Credit Note as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNoteAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      String fileName,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getCreditNoteAttachmentByFileName");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling"
              + " getCreditNoteAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " getCreditNoteAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getCreditNoteAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getCreditNoteAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific credit note using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Credit Note as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getCreditNoteAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getCreditNoteAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, creditNoteID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNoteAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific credit note using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Credit Note as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNoteAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID creditNoteID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCreditNoteAttachmentById");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling getCreditNoteAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling getCreditNoteAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getCreditNoteAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCreditNoteAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific credit notes
   *
   * <p><b>200</b> - Success - return response of type Attachments array with all Attachment for
   * specific Credit Note
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getCreditNoteAttachments(
      String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getCreditNoteAttachmentsForHttpResponse(accessToken, xeroTenantId, creditNoteID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNoteAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific credit notes
   *
   * <p><b>200</b> - Success - return response of type Attachments array with all Attachment for
   * specific Credit Note
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNoteAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCreditNoteAttachments");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling getCreditNoteAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCreditNoteAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records of a specific credit note
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getCreditNoteHistory(
      String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getCreditNoteHistoryForHttpResponse(accessToken, xeroTenantId, creditNoteID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNoteHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records of a specific credit note
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param creditNoteID Unique identifier for a Credit Note
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNoteHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCreditNoteHistory");
    } // verify the required parameter 'creditNoteID' is set
    if (creditNoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'creditNoteID' when calling getCreditNoteHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCreditNoteHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("CreditNoteID", creditNoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves any credit notes
   *
   * <p><b>200</b> - Success - return response of type Credit Notes array of CreditNote
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 credit notes will be returned in a single API call
   *     with line items shown for each credit note
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return CreditNotes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public CreditNotes getCreditNotes(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>() {};
      HttpResponse response =
          getCreditNotesForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCreditNotes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves any credit notes
   *
   * <p><b>200</b> - Success - return response of type Credit Notes array of CreditNote
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 credit notes will be returned in a single API call
   *     with line items shown for each credit note
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCreditNotesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCreditNotes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCreditNotes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/CreditNotes");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves currencies for your Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Currencies array with all Currencies
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return Currencies
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Currencies getCurrencies(
      String accessToken, String xeroTenantId, String where, String order) throws IOException {
    try {
      TypeReference<Currencies> typeRef = new TypeReference<Currencies>() {};
      HttpResponse response = getCurrenciesForHttpResponse(accessToken, xeroTenantId, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getCurrencies -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves currencies for your Xero organisation
   *
   * <p><b>200</b> - Success - return response of type Currencies array with all Currencies
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getCurrenciesForHttpResponse(
      String accessToken, String xeroTenantId, String where, String order) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getCurrencies");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getCurrencies");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Currencies");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific employee used in Xero payrun using a unique employee Id This endpoint is
   * deprecated and will be removed April 28, 2026
   *
   * <p><b>200</b> - Success - return response of type Employees array with specified Employee
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Unique identifier for a Employee
   * @param accessToken Authorization token for user set in header of each request
   * @return Employees
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Employees getEmployee(String accessToken, String xeroTenantId, UUID employeeID)
      throws IOException {
    try {
      TypeReference<Employees> typeRef = new TypeReference<Employees>() {};
      HttpResponse response = getEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployee -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific employee used in Xero payrun using a unique employee Id This endpoint is
   * deprecated and will be removed April 28, 2026
   *
   * <p><b>200</b> - Success - return response of type Employees array with specified Employee
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Unique identifier for a Employee
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployee");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployee");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployee");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves employees used in Xero payrun This endpoint is deprecated and will be removed April
   * 28, 2026
   *
   * <p><b>200</b> - Success - return response of type Employees array with all Employee
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return Employees
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Employees getEmployees(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    try {
      TypeReference<Employees> typeRef = new TypeReference<Employees>() {};
      HttpResponse response =
          getEmployeesForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployees -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves employees used in Xero payrun This endpoint is deprecated and will be removed April
   * 28, 2026
   *
   * <p><b>200</b> - Success - return response of type Employees array with all Employee
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployees");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployees");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific expense claim using a unique expense claim Id
   *
   * <p><b>200</b> - Success - return response of type ExpenseClaims array with specified
   * ExpenseClaim
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaimID Unique identifier for a ExpenseClaim
   * @param accessToken Authorization token for user set in header of each request
   * @return ExpenseClaims
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ExpenseClaims getExpenseClaim(String accessToken, String xeroTenantId, UUID expenseClaimID)
      throws IOException {
    try {
      TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>() {};
      HttpResponse response =
          getExpenseClaimForHttpResponse(accessToken, xeroTenantId, expenseClaimID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getExpenseClaim -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific expense claim using a unique expense claim Id
   *
   * <p><b>200</b> - Success - return response of type ExpenseClaims array with specified
   * ExpenseClaim
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaimID Unique identifier for a ExpenseClaim
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getExpenseClaimForHttpResponse(
      String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getExpenseClaim");
    } // verify the required parameter 'expenseClaimID' is set
    if (expenseClaimID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'expenseClaimID' when calling getExpenseClaim");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getExpenseClaim");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ExpenseClaimID", expenseClaimID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records of a specific expense claim
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaimID Unique identifier for a ExpenseClaim
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getExpenseClaimHistory(
      String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getExpenseClaimHistoryForHttpResponse(accessToken, xeroTenantId, expenseClaimID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getExpenseClaimHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records of a specific expense claim
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param expenseClaimID Unique identifier for a ExpenseClaim
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getExpenseClaimHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getExpenseClaimHistory");
    } // verify the required parameter 'expenseClaimID' is set
    if (expenseClaimID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'expenseClaimID' when calling getExpenseClaimHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getExpenseClaimHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ExpenseClaimID", expenseClaimID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves expense claims
   *
   * <p><b>200</b> - Success - return response of type ExpenseClaims array with all ExpenseClaims
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return ExpenseClaims
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ExpenseClaims getExpenseClaims(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    try {
      TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>() {};
      HttpResponse response =
          getExpenseClaimsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getExpenseClaims -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves expense claims
   *
   * <p><b>200</b> - Success - return response of type ExpenseClaims array with all ExpenseClaims
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getExpenseClaimsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getExpenseClaims");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getExpenseClaims");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/ExpenseClaims");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific sales invoice or purchase bill using a unique invoice Id
   *
   * <p><b>200</b> - Success - return response of type Invoices array with specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return Invoices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Invoices getInvoice(
      String accessToken, String xeroTenantId, UUID invoiceID, Integer unitdp) throws IOException {
    try {
      TypeReference<Invoices> typeRef = new TypeReference<Invoices>() {};
      HttpResponse response =
          getInvoiceForHttpResponse(accessToken, xeroTenantId, invoiceID, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoice -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific sales invoice or purchase bill using a unique invoice Id
   *
   * <p><b>200</b> - Success - return response of type Invoices array with specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceForHttpResponse(
      String accessToken, String xeroTenantId, UUID invoiceID, Integer unitdp) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoice");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getInvoice");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoice");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}");
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves invoices or purchase bills as PDF files
   *
   * <p><b>200</b> - Success - return response of byte array pdf version of specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getInvoiceAsPdf(
      String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response = getInvoiceAsPdfForHttpResponse(accessToken, xeroTenantId, invoiceID);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoiceAsPdf -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves invoices or purchase bills as PDF files
   *
   * <p><b>200</b> - Success - return response of byte array pdf version of specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceAsPdfForHttpResponse(
      String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoiceAsPdf");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getInvoiceAsPdf");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoiceAsPdf");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/pdf");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves an attachment from a specific invoice or purchase bill by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Invoice as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getInvoiceAttachmentByFileName(
      String accessToken, String xeroTenantId, UUID invoiceID, String fileName, String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getInvoiceAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, invoiceID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoiceAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves an attachment from a specific invoice or purchase bill by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Invoice as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceAttachmentByFileNameForHttpResponse(
      String accessToken, String xeroTenantId, UUID invoiceID, String fileName, String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getInvoiceAttachmentByFileName");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getInvoiceAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling getInvoiceAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getInvoiceAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getInvoiceAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific invoices or purchase bills by using a unique
   * attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Invoice as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getInvoiceAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getInvoiceAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, invoiceID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoiceAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific invoices or purchase bills by using a unique
   * attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Invoice as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID invoiceID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoiceAttachmentById");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getInvoiceAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling getInvoiceAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getInvoiceAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoiceAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific invoice or purchase bill
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachments for
   * specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getInvoiceAttachments(String accessToken, String xeroTenantId, UUID invoiceID)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getInvoiceAttachmentsForHttpResponse(accessToken, xeroTenantId, invoiceID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoiceAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific invoice or purchase bill
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachments for
   * specified Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoiceAttachments");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getInvoiceAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoiceAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records for a specific invoice
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getInvoiceHistory(String accessToken, String xeroTenantId, UUID invoiceID)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getInvoiceHistoryForHttpResponse(accessToken, xeroTenantId, invoiceID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoiceHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records for a specific invoice
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoiceHistory");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getInvoiceHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoiceHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves invoice reminder settings
   *
   * <p><b>200</b> - Success - return response of Invoice Reminders
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return InvoiceReminders
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public InvoiceReminders getInvoiceReminders(String accessToken, String xeroTenantId)
      throws IOException {
    try {
      TypeReference<InvoiceReminders> typeRef = new TypeReference<InvoiceReminders>() {};
      HttpResponse response = getInvoiceRemindersForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoiceReminders -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves invoice reminder settings
   *
   * <p><b>200</b> - Success - return response of Invoice Reminders
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoiceRemindersForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoiceReminders");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoiceReminders");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/InvoiceReminders/Settings");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves sales invoices or purchase bills
   *
   * <p><b>200</b> - Success - return response of type Invoices array with all Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param ids Filter by a comma-separated list of InvoicesIDs.
   * @param invoiceNumbers Filter by a comma-separated list of InvoiceNumbers.
   * @param contactIDs Filter by a comma-separated list of ContactIDs.
   * @param statuses Filter by a comma-separated list Statuses. For faster response times we
   *     recommend using these explicit parameters instead of passing OR conditions into the Where
   *     filter.
   * @param page e.g. page&#x3D;1 – Up to 100 invoices will be returned in a single API call with
   *     line items shown for each invoice
   * @param includeArchived e.g. includeArchived&#x3D;true - Invoices with a status of ARCHIVED will
   *     be included in the response
   * @param createdByMyApp When set to true you&#39;ll only retrieve Invoices created by your app
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param summaryOnly Use summaryOnly&#x3D;true in GET Contacts and Invoices endpoint to retrieve
   *     a smaller version of the response object. This returns only lightweight fields, excluding
   *     computation-heavy fields from the response, making the API calls quick and efficient.
   * @param pageSize Number of records to retrieve per page
   * @param searchTerm Search parameter that performs a case-insensitive text search across the
   *     fields e.g. InvoiceNumber, Reference.
   * @param accessToken Authorization token for user set in header of each request
   * @return Invoices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Invoices getInvoices(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      List<UUID> ids,
      List<String> invoiceNumbers,
      List<UUID> contactIDs,
      List<String> statuses,
      Integer page,
      Boolean includeArchived,
      Boolean createdByMyApp,
      Integer unitdp,
      Boolean summaryOnly,
      Integer pageSize,
      String searchTerm)
      throws IOException {
    try {
      TypeReference<Invoices> typeRef = new TypeReference<Invoices>() {};
      HttpResponse response =
          getInvoicesForHttpResponse(
              accessToken,
              xeroTenantId,
              ifModifiedSince,
              where,
              order,
              ids,
              invoiceNumbers,
              contactIDs,
              statuses,
              page,
              includeArchived,
              createdByMyApp,
              unitdp,
              summaryOnly,
              pageSize,
              searchTerm);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getInvoices -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves sales invoices or purchase bills
   *
   * <p><b>200</b> - Success - return response of type Invoices array with all Invoices
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param ids Filter by a comma-separated list of InvoicesIDs.
   * @param invoiceNumbers Filter by a comma-separated list of InvoiceNumbers.
   * @param contactIDs Filter by a comma-separated list of ContactIDs.
   * @param statuses Filter by a comma-separated list Statuses. For faster response times we
   *     recommend using these explicit parameters instead of passing OR conditions into the Where
   *     filter.
   * @param page e.g. page&#x3D;1 – Up to 100 invoices will be returned in a single API call with
   *     line items shown for each invoice
   * @param includeArchived e.g. includeArchived&#x3D;true - Invoices with a status of ARCHIVED will
   *     be included in the response
   * @param createdByMyApp When set to true you&#39;ll only retrieve Invoices created by your app
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param summaryOnly Use summaryOnly&#x3D;true in GET Contacts and Invoices endpoint to retrieve
   *     a smaller version of the response object. This returns only lightweight fields, excluding
   *     computation-heavy fields from the response, making the API calls quick and efficient.
   * @param pageSize Number of records to retrieve per page
   * @param searchTerm Search parameter that performs a case-insensitive text search across the
   *     fields e.g. InvoiceNumber, Reference.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getInvoicesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      List<UUID> ids,
      List<String> invoiceNumbers,
      List<UUID> contactIDs,
      List<String> statuses,
      Integer page,
      Boolean includeArchived,
      Boolean createdByMyApp,
      Integer unitdp,
      Boolean summaryOnly,
      Integer pageSize,
      String searchTerm)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getInvoices");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getInvoices");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (ids != null) {
      String key = "IDs";
      Object value = ids;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (invoiceNumbers != null) {
      String key = "InvoiceNumbers";
      Object value = invoiceNumbers;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (contactIDs != null) {
      String key = "ContactIDs";
      Object value = contactIDs;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (statuses != null) {
      String key = "Statuses";
      Object value = statuses;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (includeArchived != null) {
      String key = "includeArchived";
      Object value = includeArchived;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (createdByMyApp != null) {
      String key = "createdByMyApp";
      Object value = createdByMyApp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (summaryOnly != null) {
      String key = "summaryOnly";
      Object value = summaryOnly;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (searchTerm != null) {
      String key = "searchTerm";
      Object value = searchTerm;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific item using a unique item Id
   *
   * <p><b>200</b> - Success - return response of type Items array with specified Item
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return Items
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Items getItem(String accessToken, String xeroTenantId, UUID itemID, Integer unitdp)
      throws IOException {
    try {
      TypeReference<Items> typeRef = new TypeReference<Items>() {};
      HttpResponse response = getItemForHttpResponse(accessToken, xeroTenantId, itemID, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getItem -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific item using a unique item Id
   *
   * <p><b>200</b> - Success - return response of type Items array with specified Item
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getItemForHttpResponse(
      String accessToken, String xeroTenantId, UUID itemID, Integer unitdp) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getItem");
    } // verify the required parameter 'itemID' is set
    if (itemID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'itemID' when calling getItem");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getItem");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ItemID", itemID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Items/{ItemID}");
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history for a specific item
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getItemHistory(String accessToken, String xeroTenantId, UUID itemID)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response = getItemHistoryForHttpResponse(accessToken, xeroTenantId, itemID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getItemHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history for a specific item
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param itemID Unique identifier for an Item
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getItemHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID itemID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getItemHistory");
    } // verify the required parameter 'itemID' is set
    if (itemID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'itemID' when calling getItemHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getItemHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ItemID", itemID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Items/{ItemID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves items
   *
   * <p><b>200</b> - Success - return response of type Items array with all Item
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return Items
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Items getItems(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer unitdp)
      throws IOException {
    try {
      TypeReference<Items> typeRef = new TypeReference<Items>() {};
      HttpResponse response =
          getItemsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getItems -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves items
   *
   * <p><b>200</b> - Success - return response of type Items array with all Item
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getItemsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer unitdp)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getItems");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getItems");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Items");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific journal using a unique journal Id.
   *
   * <p><b>200</b> - Success - return response of type Journals array with specified Journal
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param journalID Unique identifier for a Journal
   * @param accessToken Authorization token for user set in header of each request
   * @return Journals
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Journals getJournal(String accessToken, String xeroTenantId, UUID journalID)
      throws IOException {
    try {
      TypeReference<Journals> typeRef = new TypeReference<Journals>() {};
      HttpResponse response = getJournalForHttpResponse(accessToken, xeroTenantId, journalID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getJournal -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific journal using a unique journal Id.
   *
   * <p><b>200</b> - Success - return response of type Journals array with specified Journal
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param journalID Unique identifier for a Journal
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getJournalForHttpResponse(
      String accessToken, String xeroTenantId, UUID journalID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getJournal");
    } // verify the required parameter 'journalID' is set
    if (journalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'journalID' when calling getJournal");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getJournal");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("JournalID", journalID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Journals/{JournalID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific journal using a unique journal number.
   *
   * <p><b>200</b> - Success - return response of type Journals array with specified Journal
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param journalNumber Number of a Journal
   * @param accessToken Authorization token for user set in header of each request
   * @return Journals
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Journals getJournalByNumber(String accessToken, String xeroTenantId, Integer journalNumber)
      throws IOException {
    try {
      TypeReference<Journals> typeRef = new TypeReference<Journals>() {};
      HttpResponse response =
          getJournalByNumberForHttpResponse(accessToken, xeroTenantId, journalNumber);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getJournalByNumber -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific journal using a unique journal number.
   *
   * <p><b>200</b> - Success - return response of type Journals array with specified Journal
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param journalNumber Number of a Journal
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getJournalByNumberForHttpResponse(
      String accessToken, String xeroTenantId, Integer journalNumber) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getJournalByNumber");
    } // verify the required parameter 'journalNumber' is set
    if (journalNumber == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'journalNumber' when calling getJournalByNumber");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getJournalByNumber");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("JournalNumber", journalNumber);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Journals/{JournalNumber}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves journals
   *
   * <p><b>200</b> - Success - return response of type Journals array with all Journals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param offset Offset by a specified journal number. e.g. journals with a JournalNumber greater
   *     than the offset will be returned
   * @param paymentsOnly Filter to retrieve journals on a cash basis. Journals are returned on an
   *     accrual basis by default.
   * @param accessToken Authorization token for user set in header of each request
   * @return Journals
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Journals getJournals(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      Integer offset,
      Boolean paymentsOnly)
      throws IOException {
    try {
      TypeReference<Journals> typeRef = new TypeReference<Journals>() {};
      HttpResponse response =
          getJournalsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, offset, paymentsOnly);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getJournals -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves journals
   *
   * <p><b>200</b> - Success - return response of type Journals array with all Journals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param offset Offset by a specified journal number. e.g. journals with a JournalNumber greater
   *     than the offset will be returned
   * @param paymentsOnly Filter to retrieve journals on a cash basis. Journals are returned on an
   *     accrual basis by default.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getJournalsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      Integer offset,
      Boolean paymentsOnly)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getJournals");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getJournals");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Journals");
    if (offset != null) {
      String key = "offset";
      Object value = offset;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (paymentsOnly != null) {
      String key = "paymentsOnly";
      Object value = paymentsOnly;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific linked transaction (billable expenses) using a unique linked transaction
   * Id
   *
   * <p><b>200</b> - Success - return response of type LinkedTransactions array with a specified
   * LinkedTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param linkedTransactionID Unique identifier for a LinkedTransaction
   * @param accessToken Authorization token for user set in header of each request
   * @return LinkedTransactions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LinkedTransactions getLinkedTransaction(
      String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
    try {
      TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>() {};
      HttpResponse response =
          getLinkedTransactionForHttpResponse(accessToken, xeroTenantId, linkedTransactionID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getLinkedTransaction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific linked transaction (billable expenses) using a unique linked transaction
   * Id
   *
   * <p><b>200</b> - Success - return response of type LinkedTransactions array with a specified
   * LinkedTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param linkedTransactionID Unique identifier for a LinkedTransaction
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getLinkedTransactionForHttpResponse(
      String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getLinkedTransaction");
    } // verify the required parameter 'linkedTransactionID' is set
    if (linkedTransactionID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'linkedTransactionID' when calling getLinkedTransaction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getLinkedTransaction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("LinkedTransactionID", linkedTransactionID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/LinkedTransactions/{LinkedTransactionID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves linked transactions (billable expenses)
   *
   * <p><b>200</b> - Success - return response of type LinkedTransactions array with all
   * LinkedTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Up to 100 linked transactions will be returned in a single API call. Use the page
   *     parameter to specify the page to be returned e.g. page&#x3D;1.
   * @param linkedTransactionID The Xero identifier for an Linked Transaction
   * @param sourceTransactionID Filter by the SourceTransactionID. Get the linked transactions
   *     created from a particular ACCPAY invoice
   * @param contactID Filter by the ContactID. Get all the linked transactions that have been
   *     assigned to a particular customer.
   * @param status Filter by the combination of ContactID and Status. Get the linked transactions
   *     associated to a customer and with a status
   * @param targetTransactionID Filter by the TargetTransactionID. Get all the linked transactions
   *     allocated to a particular ACCREC invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return LinkedTransactions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LinkedTransactions getLinkedTransactions(
      String accessToken,
      String xeroTenantId,
      Integer page,
      UUID linkedTransactionID,
      UUID sourceTransactionID,
      UUID contactID,
      String status,
      UUID targetTransactionID)
      throws IOException {
    try {
      TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>() {};
      HttpResponse response =
          getLinkedTransactionsForHttpResponse(
              accessToken,
              xeroTenantId,
              page,
              linkedTransactionID,
              sourceTransactionID,
              contactID,
              status,
              targetTransactionID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getLinkedTransactions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves linked transactions (billable expenses)
   *
   * <p><b>200</b> - Success - return response of type LinkedTransactions array with all
   * LinkedTransaction
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Up to 100 linked transactions will be returned in a single API call. Use the page
   *     parameter to specify the page to be returned e.g. page&#x3D;1.
   * @param linkedTransactionID The Xero identifier for an Linked Transaction
   * @param sourceTransactionID Filter by the SourceTransactionID. Get the linked transactions
   *     created from a particular ACCPAY invoice
   * @param contactID Filter by the ContactID. Get all the linked transactions that have been
   *     assigned to a particular customer.
   * @param status Filter by the combination of ContactID and Status. Get the linked transactions
   *     associated to a customer and with a status
   * @param targetTransactionID Filter by the TargetTransactionID. Get all the linked transactions
   *     allocated to a particular ACCREC invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getLinkedTransactionsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Integer page,
      UUID linkedTransactionID,
      UUID sourceTransactionID,
      UUID contactID,
      String status,
      UUID targetTransactionID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getLinkedTransactions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getLinkedTransactions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/LinkedTransactions");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (linkedTransactionID != null) {
      String key = "LinkedTransactionID";
      Object value = linkedTransactionID;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (sourceTransactionID != null) {
      String key = "SourceTransactionID";
      Object value = sourceTransactionID;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (contactID != null) {
      String key = "ContactID";
      Object value = contactID;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (status != null) {
      String key = "Status";
      Object value = status;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (targetTransactionID != null) {
      String key = "TargetTransactionID";
      Object value = targetTransactionID;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific manual journal
   *
   * <p><b>200</b> - Success - return response of type ManualJournals array with a specified
   * ManualJournals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param accessToken Authorization token for user set in header of each request
   * @return ManualJournals
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ManualJournals getManualJournal(
      String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
    try {
      TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>() {};
      HttpResponse response =
          getManualJournalForHttpResponse(accessToken, xeroTenantId, manualJournalID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getManualJournal -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific manual journal
   *
   * <p><b>200</b> - Success - return response of type ManualJournals array with a specified
   * ManualJournals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getManualJournalForHttpResponse(
      String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getManualJournal");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling getManualJournal");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getManualJournal");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific manual journal by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Manual Journal as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getManualJournalAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      String fileName,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getManualJournalAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, manualJournalID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getManualJournalAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific manual journal by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Manual Journal as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getManualJournalAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      String fileName,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getManualJournalAttachmentByFileName");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling"
              + " getManualJournalAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " getManualJournalAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getManualJournalAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getManualJournalAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Allows you to retrieve a specific attachment from a specific manual journal using a unique
   * attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Manual Journal as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getManualJournalAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getManualJournalAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, manualJournalID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getManualJournalAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Allows you to retrieve a specific attachment from a specific manual journal using a unique
   * attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Manual Journal as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getManualJournalAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID manualJournalID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getManualJournalAttachmentById");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling"
              + " getManualJournalAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling"
              + " getManualJournalAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getManualJournalAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getManualJournalAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachment for a specific manual journal
   *
   * <p><b>200</b> - Success - return response of type Attachments array with all Attachments for a
   * ManualJournals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getManualJournalAttachments(
      String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getManualJournalAttachmentsForHttpResponse(accessToken, xeroTenantId, manualJournalID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getManualJournalAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachment for a specific manual journal
   *
   * <p><b>200</b> - Success - return response of type Attachments array with all Attachments for a
   * ManualJournals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getManualJournalAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getManualJournalAttachments");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling"
              + " getManualJournalAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getManualJournalAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves manual journals
   *
   * <p><b>200</b> - Success - return response of type ManualJournals array with a all
   * ManualJournals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 manual journals will be returned in a single API call
   *     with line items shown for each overpayment
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return ManualJournals
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ManualJournals getManualJournals(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>() {};
      HttpResponse response =
          getManualJournalsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, page, pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getManualJournals -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves manual journals
   *
   * <p><b>200</b> - Success - return response of type ManualJournals array with a all
   * ManualJournals
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 manual journals will be returned in a single API call
   *     with line items shown for each overpayment
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getManualJournalsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getManualJournals");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getManualJournals");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/ManualJournals");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history for a specific manual journal
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getManualJournalsHistory(
      String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getManualJournalsHistoryForHttpResponse(accessToken, xeroTenantId, manualJournalID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getManualJournalsHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history for a specific manual journal
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param manualJournalID Unique identifier for a ManualJournal
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getManualJournalsHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getManualJournalsHistory");
    } // verify the required parameter 'manualJournalID' is set
    if (manualJournalID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'manualJournalID' when calling getManualJournalsHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getManualJournalsHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ManualJournalID", manualJournalID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a URL to an online invoice
   *
   * <p><b>200</b> - Success - return response of type OnlineInvoice array with one OnlineInvoice
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return OnlineInvoices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public OnlineInvoices getOnlineInvoice(String accessToken, String xeroTenantId, UUID invoiceID)
      throws IOException {
    try {
      TypeReference<OnlineInvoices> typeRef = new TypeReference<OnlineInvoices>() {};
      HttpResponse response = getOnlineInvoiceForHttpResponse(accessToken, xeroTenantId, invoiceID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOnlineInvoice -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a URL to an online invoice
   *
   * <p><b>200</b> - Success - return response of type OnlineInvoice array with one OnlineInvoice
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param invoiceID Unique identifier for an Invoice
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOnlineInvoiceForHttpResponse(
      String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOnlineInvoice");
    } // verify the required parameter 'invoiceID' is set
    if (invoiceID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'invoiceID' when calling getOnlineInvoice");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOnlineInvoice");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("InvoiceID", invoiceID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Invoices/{InvoiceID}/OnlineInvoice");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a list of the key actions your app has permission to perform in the connected Xero
   * organisation.
   *
   * <p><b>200</b> - Success - return response of type Actions array with all key actions
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return Actions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Actions getOrganisationActions(String accessToken, String xeroTenantId)
      throws IOException {
    try {
      TypeReference<Actions> typeRef = new TypeReference<Actions>() {};
      HttpResponse response = getOrganisationActionsForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOrganisationActions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a list of the key actions your app has permission to perform in the connected Xero
   * organisation.
   *
   * <p><b>200</b> - Success - return response of type Actions array with all key actions
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOrganisationActionsForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOrganisationActions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOrganisationActions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Organisation/Actions");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves the CIS settings for the Xero organistaion.
   *
   * <p><b>200</b> - Success - return response of type Organisation array with specified
   * Organisation
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param organisationID The unique Xero identifier for an organisation
   * @param accessToken Authorization token for user set in header of each request
   * @return CISOrgSettings
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public CISOrgSettings getOrganisationCISSettings(
      String accessToken, String xeroTenantId, UUID organisationID) throws IOException {
    try {
      TypeReference<CISOrgSettings> typeRef = new TypeReference<CISOrgSettings>() {};
      HttpResponse response =
          getOrganisationCISSettingsForHttpResponse(accessToken, xeroTenantId, organisationID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOrganisationCISSettings -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves the CIS settings for the Xero organistaion.
   *
   * <p><b>200</b> - Success - return response of type Organisation array with specified
   * Organisation
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param organisationID The unique Xero identifier for an organisation
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOrganisationCISSettingsForHttpResponse(
      String accessToken, String xeroTenantId, UUID organisationID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOrganisationCISSettings");
    } // verify the required parameter 'organisationID' is set
    if (organisationID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'organisationID' when calling"
              + " getOrganisationCISSettings");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOrganisationCISSettings");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("OrganisationID", organisationID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Organisation/{OrganisationID}/CISSettings");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves Xero organisation details
   *
   * <p><b>200</b> - Success - return response of type Organisation array with all Organisation
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return Organisations
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Organisations getOrganisations(String accessToken, String xeroTenantId)
      throws IOException {
    try {
      TypeReference<Organisations> typeRef = new TypeReference<Organisations>() {};
      HttpResponse response = getOrganisationsForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOrganisations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves Xero organisation details
   *
   * <p><b>200</b> - Success - return response of type Organisation array with all Organisation
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOrganisationsForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOrganisations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOrganisations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Organisation");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific overpayment using a unique overpayment Id
   *
   * <p><b>200</b> - Success - return response of type Overpayments array with specified
   * Overpayments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param accessToken Authorization token for user set in header of each request
   * @return Overpayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Overpayments getOverpayment(String accessToken, String xeroTenantId, UUID overpaymentID)
      throws IOException {
    try {
      TypeReference<Overpayments> typeRef = new TypeReference<Overpayments>() {};
      HttpResponse response =
          getOverpaymentForHttpResponse(accessToken, xeroTenantId, overpaymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOverpayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific overpayment using a unique overpayment Id
   *
   * <p><b>200</b> - Success - return response of type Overpayments array with specified
   * Overpayments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOverpaymentForHttpResponse(
      String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOverpayment");
    } // verify the required parameter 'overpaymentID' is set
    if (overpaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'overpaymentID' when calling getOverpayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOverpayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("OverpaymentID", overpaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Overpayments/{OverpaymentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records of a specific overpayment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getOverpaymentHistory(
      String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getOverpaymentHistoryForHttpResponse(accessToken, xeroTenantId, overpaymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOverpaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records of a specific overpayment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param overpaymentID Unique identifier for a Overpayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOverpaymentHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOverpaymentHistory");
    } // verify the required parameter 'overpaymentID' is set
    if (overpaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'overpaymentID' when calling getOverpaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOverpaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("OverpaymentID", overpaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves overpayments
   *
   * <p><b>200</b> - Success - return response of type Overpayments array with all Overpayments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 overpayments will be returned in a single API call
   *     with line items shown for each overpayment
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return Overpayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Overpayments getOverpayments(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<Overpayments> typeRef = new TypeReference<Overpayments>() {};
      HttpResponse response =
          getOverpaymentsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getOverpayments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves overpayments
   *
   * <p><b>200</b> - Success - return response of type Overpayments array with all Overpayments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 overpayments will be returned in a single API call
   *     with line items shown for each overpayment
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getOverpaymentsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getOverpayments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getOverpayments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Overpayments");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific payment for invoices and credit notes using a unique payment Id
   *
   * <p><b>200</b> - Success - return response of type Payments array for specified Payment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param accessToken Authorization token for user set in header of each request
   * @return Payments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Payments getPayment(String accessToken, String xeroTenantId, UUID paymentID)
      throws IOException {
    try {
      TypeReference<Payments> typeRef = new TypeReference<Payments>() {};
      HttpResponse response = getPaymentForHttpResponse(accessToken, xeroTenantId, paymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific payment for invoices and credit notes using a unique payment Id
   *
   * <p><b>200</b> - Success - return response of type Payments array for specified Payment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPaymentForHttpResponse(
      String accessToken, String xeroTenantId, UUID paymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPayment");
    } // verify the required parameter 'paymentID' is set
    if (paymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentID' when calling getPayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PaymentID", paymentID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Payments/{PaymentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records of a specific payment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getPaymentHistory(String accessToken, String xeroTenantId, UUID paymentID)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getPaymentHistoryForHttpResponse(accessToken, xeroTenantId, paymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records of a specific payment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paymentID Unique identifier for a Payment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPaymentHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID paymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPaymentHistory");
    } // verify the required parameter 'paymentID' is set
    if (paymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentID' when calling getPaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PaymentID", paymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Payments/{PaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves payment services
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array for all PaymentService
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return PaymentServices
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaymentServices getPaymentServices(String accessToken, String xeroTenantId)
      throws IOException {
    try {
      TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>() {};
      HttpResponse response = getPaymentServicesForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPaymentServices -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves payment services
   *
   * <p><b>200</b> - Success - return response of type PaymentServices array for all PaymentService
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPaymentServicesForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPaymentServices");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPaymentServices");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PaymentServices");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves payments for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for all Payments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page Up to 100 payments will be returned in a single API call
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return Payments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Payments getPayments(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<Payments> typeRef = new TypeReference<Payments>() {};
      HttpResponse response =
          getPaymentsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, page, pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPayments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves payments for invoices and credit notes
   *
   * <p><b>200</b> - Success - return response of type Payments array for all Payments
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page Up to 100 payments will be returned in a single API call
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPaymentsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPayments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPayments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Payments");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Allows you to retrieve a specified prepayments
   *
   * <p><b>200</b> - Success - return response of type Prepayments array for a specified Prepayment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param accessToken Authorization token for user set in header of each request
   * @return Prepayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Prepayments getPrepayment(String accessToken, String xeroTenantId, UUID prepaymentID)
      throws IOException {
    try {
      TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>() {};
      HttpResponse response = getPrepaymentForHttpResponse(accessToken, xeroTenantId, prepaymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPrepayment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Allows you to retrieve a specified prepayments
   *
   * <p><b>200</b> - Success - return response of type Prepayments array for a specified Prepayment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPrepaymentForHttpResponse(
      String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPrepayment");
    } // verify the required parameter 'prepaymentID' is set
    if (prepaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'prepaymentID' when calling getPrepayment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPrepayment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PrepaymentID", prepaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Prepayments/{PrepaymentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history record for a specific prepayment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getPrepaymentHistory(
      String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getPrepaymentHistoryForHttpResponse(accessToken, xeroTenantId, prepaymentID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPrepaymentHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history record for a specific prepayment
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param prepaymentID Unique identifier for a PrePayment
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPrepaymentHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPrepaymentHistory");
    } // verify the required parameter 'prepaymentID' is set
    if (prepaymentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'prepaymentID' when calling getPrepaymentHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPrepaymentHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PrepaymentID", prepaymentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves prepayments
   *
   * <p><b>200</b> - Success - return response of type Prepayments array for all Prepayment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 prepayments will be returned in a single API call with
   *     line items shown for each overpayment
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return Prepayments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Prepayments getPrepayments(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>() {};
      HttpResponse response =
          getPrepaymentsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPrepayments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves prepayments
   *
   * <p><b>200</b> - Success - return response of type Prepayments array for all Prepayment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param page e.g. page&#x3D;1 – Up to 100 prepayments will be returned in a single API call with
   *     line items shown for each overpayment
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPrepaymentsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer page,
      Integer unitdp,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPrepayments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPrepayments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Prepayments");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific purchase order using a unique purchase order Id
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array for specified
   * PurchaseOrder
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return PurchaseOrders
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PurchaseOrders getPurchaseOrder(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    try {
      TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>() {};
      HttpResponse response =
          getPurchaseOrderForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrder -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific purchase order using a unique purchase order Id
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array for specified
   * PurchaseOrder
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderForHttpResponse(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPurchaseOrder");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrder");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPurchaseOrder");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves specific purchase order as PDF files using a unique purchase order Id
   *
   * <p><b>200</b> - Success - return response of byte array pdf version of specified Purchase
   * Orders
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getPurchaseOrderAsPdf(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getPurchaseOrderAsPdfForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrderAsPdf -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves specific purchase order as PDF files using a unique purchase order Id
   *
   * <p><b>200</b> - Success - return response of byte array pdf version of specified Purchase
   * Orders
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderAsPdfForHttpResponse(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderAsPdf");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderAsPdf");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPurchaseOrderAsPdf");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/pdf");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment for a specific purchase order by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Purchase Order as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getPurchaseOrderAttachmentByFileName(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      String fileName,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getPurchaseOrderAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, purchaseOrderID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrderAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment for a specific purchase order by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Purchase Order as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderAttachmentByFileNameForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      String fileName,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling"
              + " getPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling"
              + " getPurchaseOrderAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getPurchaseOrderAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getPurchaseOrderAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves specific attachment for a specific purchase order using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Account as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getPurchaseOrderAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getPurchaseOrderAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, purchaseOrderID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrderAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves specific attachment for a specific purchase order using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Account as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID purchaseOrderID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getPurchaseOrderAttachmentById");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling"
              + " getPurchaseOrderAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling"
              + " getPurchaseOrderAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getPurchaseOrderAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getPurchaseOrderAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Purchase Orders
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getPurchaseOrderAttachments(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getPurchaseOrderAttachmentsForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrderAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Purchase Orders
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderAttachments");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling"
              + " getPurchaseOrderAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPurchaseOrderAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific purchase order using purchase order number
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array for specified
   * PurchaseOrder
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderNumber Unique identifier for a PurchaseOrder
   * @param accessToken Authorization token for user set in header of each request
   * @return PurchaseOrders
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PurchaseOrders getPurchaseOrderByNumber(
      String accessToken, String xeroTenantId, String purchaseOrderNumber) throws IOException {
    try {
      TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>() {};
      HttpResponse response =
          getPurchaseOrderByNumberForHttpResponse(accessToken, xeroTenantId, purchaseOrderNumber);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrderByNumber -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific purchase order using purchase order number
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array for specified
   * PurchaseOrder
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderNumber Unique identifier for a PurchaseOrder
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderByNumberForHttpResponse(
      String accessToken, String xeroTenantId, String purchaseOrderNumber) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderByNumber");
    } // verify the required parameter 'purchaseOrderNumber' is set
    if (purchaseOrderNumber == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderNumber' when calling"
              + " getPurchaseOrderByNumber");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPurchaseOrderByNumber");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderNumber", purchaseOrderNumber);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderNumber}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getPurchaseOrderHistory(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getPurchaseOrderHistoryForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrderHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history for a specific purchase order
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param purchaseOrderID Unique identifier for an Purchase Order
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrderHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderHistory");
    } // verify the required parameter 'purchaseOrderID' is set
    if (purchaseOrderID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPurchaseOrderHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PurchaseOrderID", purchaseOrderID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves purchase orders
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array of all PurchaseOrder
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param status Filter by purchase order status
   * @param dateFrom Filter by purchase order date (e.g. GET
   *     https://.../PurchaseOrders?DateFrom&#x3D;2015-12-01&amp;DateTo&#x3D;2015-12-31
   * @param dateTo Filter by purchase order date (e.g. GET
   *     https://.../PurchaseOrders?DateFrom&#x3D;2015-12-01&amp;DateTo&#x3D;2015-12-31
   * @param order Order by an any element
   * @param page To specify a page, append the page parameter to the URL e.g. ?page&#x3D;1. If there
   *     are 100 records in the response you will need to check if there is any more data by
   *     fetching the next page e.g ?page&#x3D;2 and continuing this process until no more results
   *     are returned.
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return PurchaseOrders
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PurchaseOrders getPurchaseOrders(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String status,
      String dateFrom,
      String dateTo,
      String order,
      Integer page,
      Integer pageSize)
      throws IOException {
    try {
      TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>() {};
      HttpResponse response =
          getPurchaseOrdersForHttpResponse(
              accessToken,
              xeroTenantId,
              ifModifiedSince,
              status,
              dateFrom,
              dateTo,
              order,
              page,
              pageSize);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPurchaseOrders -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves purchase orders
   *
   * <p><b>200</b> - Success - return response of type PurchaseOrder array of all PurchaseOrder
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param status Filter by purchase order status
   * @param dateFrom Filter by purchase order date (e.g. GET
   *     https://.../PurchaseOrders?DateFrom&#x3D;2015-12-01&amp;DateTo&#x3D;2015-12-31
   * @param dateTo Filter by purchase order date (e.g. GET
   *     https://.../PurchaseOrders?DateFrom&#x3D;2015-12-01&amp;DateTo&#x3D;2015-12-31
   * @param order Order by an any element
   * @param page To specify a page, append the page parameter to the URL e.g. ?page&#x3D;1. If there
   *     are 100 records in the response you will need to check if there is any more data by
   *     fetching the next page e.g ?page&#x3D;2 and continuing this process until no more results
   *     are returned.
   * @param pageSize Number of records to retrieve per page
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPurchaseOrdersForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String status,
      String dateFrom,
      String dateTo,
      String order,
      Integer page,
      Integer pageSize)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPurchaseOrders");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPurchaseOrders");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PurchaseOrders");
    if (status != null) {
      String key = "Status";
      Object value = status;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (dateFrom != null) {
      String key = "DateFrom";
      Object value = dateFrom;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (dateTo != null) {
      String key = "DateTo";
      Object value = dateTo;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (pageSize != null) {
      String key = "pageSize";
      Object value = pageSize;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific quote using a unique quote Id
   *
   * <p><b>200</b> - Success - return response of type Quotes array with specified Quote
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return Quotes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Quotes getQuote(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
    try {
      TypeReference<Quotes> typeRef = new TypeReference<Quotes>() {};
      HttpResponse response = getQuoteForHttpResponse(accessToken, xeroTenantId, quoteID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuote -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific quote using a unique quote Id
   *
   * <p><b>200</b> - Success - return response of type Quotes array with specified Quote
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuoteForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getQuote");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling getQuote");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuote");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific quote as a PDF file using a unique quote Id
   *
   * <p><b>200</b> - Success - return response of byte array pdf version of specified Quotes
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getQuoteAsPdf(String accessToken, String xeroTenantId, UUID quoteID)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response = getQuoteAsPdfForHttpResponse(accessToken, xeroTenantId, quoteID);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuoteAsPdf -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific quote as a PDF file using a unique quote Id
   *
   * <p><b>200</b> - Success - return response of byte array pdf version of specified Quotes
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuoteAsPdfForHttpResponse(
      String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getQuoteAsPdf");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling getQuoteAsPdf");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuoteAsPdf");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/pdf");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific quote by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Quote as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getQuoteAttachmentByFileName(
      String accessToken, String xeroTenantId, UUID quoteID, String fileName, String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getQuoteAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, quoteID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuoteAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific quote by filename
   *
   * <p><b>200</b> - Success - return response of attachment for Quote as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuoteAttachmentByFileNameForHttpResponse(
      String accessToken, String xeroTenantId, UUID quoteID, String fileName, String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getQuoteAttachmentByFileName");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling getQuoteAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling getQuoteAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getQuoteAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuoteAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific quote using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Quote as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getQuoteAttachmentById(
      String accessToken, String xeroTenantId, UUID quoteID, UUID attachmentID, String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getQuoteAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, quoteID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuoteAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific quote using a unique attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Quote as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuoteAttachmentByIdForHttpResponse(
      String accessToken, String xeroTenantId, UUID quoteID, UUID attachmentID, String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getQuoteAttachmentById");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling getQuoteAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling getQuoteAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getQuoteAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuoteAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific quote
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getQuoteAttachments(String accessToken, String xeroTenantId, UUID quoteID)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getQuoteAttachmentsForHttpResponse(accessToken, xeroTenantId, quoteID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuoteAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific quote
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachment
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuoteAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getQuoteAttachments");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling getQuoteAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuoteAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves history records of a specific quote
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getQuoteHistory(String accessToken, String xeroTenantId, UUID quoteID)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response = getQuoteHistoryForHttpResponse(accessToken, xeroTenantId, quoteID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuoteHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves history records of a specific quote
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param quoteID Unique identifier for an Quote
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuoteHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getQuoteHistory");
    } // verify the required parameter 'quoteID' is set
    if (quoteID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'quoteID' when calling getQuoteHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuoteHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("QuoteID", quoteID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes/{QuoteID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves sales quotes
   *
   * <p><b>200</b> - Success - return response of type quotes array with all quotes
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param dateFrom Filter for quotes after a particular date
   * @param dateTo Filter for quotes before a particular date
   * @param expiryDateFrom Filter for quotes expiring after a particular date
   * @param expiryDateTo Filter for quotes before a particular date
   * @param contactID Filter for quotes belonging to a particular contact
   * @param status Filter for quotes of a particular Status
   * @param page e.g. page&#x3D;1 – Up to 100 Quotes will be returned in a single API call with line
   *     items shown for each quote
   * @param order Order by an any element
   * @param quoteNumber Filter by quote number (e.g. GET
   *     https://.../Quotes?QuoteNumber&#x3D;QU-0001)
   * @param accessToken Authorization token for user set in header of each request
   * @return Quotes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Quotes getQuotes(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      LocalDate dateFrom,
      LocalDate dateTo,
      LocalDate expiryDateFrom,
      LocalDate expiryDateTo,
      UUID contactID,
      String status,
      Integer page,
      String order,
      String quoteNumber)
      throws IOException {
    try {
      TypeReference<Quotes> typeRef = new TypeReference<Quotes>() {};
      HttpResponse response =
          getQuotesForHttpResponse(
              accessToken,
              xeroTenantId,
              ifModifiedSince,
              dateFrom,
              dateTo,
              expiryDateFrom,
              expiryDateTo,
              contactID,
              status,
              page,
              order,
              quoteNumber);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getQuotes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves sales quotes
   *
   * <p><b>200</b> - Success - return response of type quotes array with all quotes
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param dateFrom Filter for quotes after a particular date
   * @param dateTo Filter for quotes before a particular date
   * @param expiryDateFrom Filter for quotes expiring after a particular date
   * @param expiryDateTo Filter for quotes before a particular date
   * @param contactID Filter for quotes belonging to a particular contact
   * @param status Filter for quotes of a particular Status
   * @param page e.g. page&#x3D;1 – Up to 100 Quotes will be returned in a single API call with line
   *     items shown for each quote
   * @param order Order by an any element
   * @param quoteNumber Filter by quote number (e.g. GET
   *     https://.../Quotes?QuoteNumber&#x3D;QU-0001)
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getQuotesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      LocalDate dateFrom,
      LocalDate dateTo,
      LocalDate expiryDateFrom,
      LocalDate expiryDateTo,
      UUID contactID,
      String status,
      Integer page,
      String order,
      String quoteNumber)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getQuotes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getQuotes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Quotes");
    if (dateFrom != null) {
      String key = "DateFrom";
      Object value = dateFrom;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (dateTo != null) {
      String key = "DateTo";
      Object value = dateTo;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (expiryDateFrom != null) {
      String key = "ExpiryDateFrom";
      Object value = expiryDateFrom;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (expiryDateTo != null) {
      String key = "ExpiryDateTo";
      Object value = expiryDateTo;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (contactID != null) {
      String key = "ContactID";
      Object value = contactID;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (status != null) {
      String key = "Status";
      Object value = status;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (quoteNumber != null) {
      String key = "QuoteNumber";
      Object value = quoteNumber;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific draft expense claim receipt by using a unique receipt Id
   *
   * <p><b>200</b> - Success - return response of type Receipts array for a specified Receipt
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return Receipts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Receipts getReceipt(
      String accessToken, String xeroTenantId, UUID receiptID, Integer unitdp) throws IOException {
    try {
      TypeReference<Receipts> typeRef = new TypeReference<Receipts>() {};
      HttpResponse response =
          getReceiptForHttpResponse(accessToken, xeroTenantId, receiptID, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReceipt -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific draft expense claim receipt by using a unique receipt Id
   *
   * <p><b>200</b> - Success - return response of type Receipts array for a specified Receipt
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReceiptForHttpResponse(
      String accessToken, String xeroTenantId, UUID receiptID, Integer unitdp) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReceipt");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling getReceipt");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReceipt");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Receipts/{ReceiptID}");
    if (unitdp != null) {
      String key = "unitdp";
      Object value = unitdp;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachment from a specific expense claim receipts by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Receipt as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getReceiptAttachmentByFileName(
      String accessToken, String xeroTenantId, UUID receiptID, String fileName, String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getReceiptAttachmentByFileNameForHttpResponse(
              accessToken, xeroTenantId, receiptID, fileName, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReceiptAttachmentByFileName -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachment from a specific expense claim receipts by file name
   *
   * <p><b>200</b> - Success - return response of attachment for Receipt as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param fileName Name of the attachment
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReceiptAttachmentByFileNameForHttpResponse(
      String accessToken, String xeroTenantId, UUID receiptID, String fileName, String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " getReceiptAttachmentByFileName");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling getReceiptAttachmentByFileName");
    } // verify the required parameter 'fileName' is set
    if (fileName == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'fileName' when calling getReceiptAttachmentByFileName");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling"
              + " getReceiptAttachmentByFileName");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " getReceiptAttachmentByFileName");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);
    uriVariables.put("FileName", fileName);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{FileName}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific attachments from a specific expense claim receipts by using a unique
   * attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Receipt as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return ByteArrayInputStream
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ByteArrayInputStream getReceiptAttachmentById(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    try {
      TypeReference<File> typeRef = new TypeReference<File>() {};
      HttpResponse response =
          getReceiptAttachmentByIdForHttpResponse(
              accessToken, xeroTenantId, receiptID, attachmentID, contentType);
      InputStream is = response.getContent();
      return convertInputToByteArray(is);

    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReceiptAttachmentById -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific attachments from a specific expense claim receipts by using a unique
   * attachment Id
   *
   * <p><b>200</b> - Success - return response of attachment for Receipt as binary data
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param attachmentID Unique identifier for Attachment object
   * @param contentType The mime type of the attachment file you are retrieving i.e image/jpg,
   *     application/pdf
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReceiptAttachmentByIdForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID receiptID,
      UUID attachmentID,
      String contentType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReceiptAttachmentById");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling getReceiptAttachmentById");
    } // verify the required parameter 'attachmentID' is set
    if (attachmentID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'attachmentID' when calling getReceiptAttachmentById");
    } // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'contentType' when calling getReceiptAttachmentById");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReceiptAttachmentById");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.set("contentType", contentType);
    headers.setAccept("application/octet-stream");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);
    uriVariables.put("AttachmentID", attachmentID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{AttachmentID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves attachments for a specific expense claim receipt
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachments for a
   * specified Receipt
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param accessToken Authorization token for user set in header of each request
   * @return Attachments
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Attachments getReceiptAttachments(String accessToken, String xeroTenantId, UUID receiptID)
      throws IOException {
    try {
      TypeReference<Attachments> typeRef = new TypeReference<Attachments>() {};
      HttpResponse response =
          getReceiptAttachmentsForHttpResponse(accessToken, xeroTenantId, receiptID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReceiptAttachments -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves attachments for a specific expense claim receipt
   *
   * <p><b>200</b> - Success - return response of type Attachments array of Attachments for a
   * specified Receipt
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReceiptAttachmentsForHttpResponse(
      String accessToken, String xeroTenantId, UUID receiptID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReceiptAttachments");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling getReceiptAttachments");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReceiptAttachments");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a history record for a specific receipt
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param accessToken Authorization token for user set in header of each request
   * @return HistoryRecords
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public HistoryRecords getReceiptHistory(String accessToken, String xeroTenantId, UUID receiptID)
      throws IOException {
    try {
      TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>() {};
      HttpResponse response =
          getReceiptHistoryForHttpResponse(accessToken, xeroTenantId, receiptID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReceiptHistory -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a history record for a specific receipt
   *
   * <p><b>200</b> - Success - return response of HistoryRecords array of 0 to N HistoryRecord
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param receiptID Unique identifier for a Receipt
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReceiptHistoryForHttpResponse(
      String accessToken, String xeroTenantId, UUID receiptID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReceiptHistory");
    } // verify the required parameter 'receiptID' is set
    if (receiptID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'receiptID' when calling getReceiptHistory");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReceiptHistory");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReceiptID", receiptID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Receipts/{ReceiptID}/History");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves draft expense claim receipts for any user
   *
   * <p><b>200</b> - Success - return response of type Receipts array for all Receipt
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return Receipts
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Receipts getReceipts(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer unitdp)
      throws IOException {
    try {
      TypeReference<Receipts> typeRef = new TypeReference<Receipts>() {};
      HttpResponse response =
          getReceiptsForHttpResponse(
              accessToken, xeroTenantId, ifModifiedSince, where, order, unitdp);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReceipts -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves draft expense claim receipts for any user
   *
   * <p><b>200</b> - Success - return response of type Receipts array for all Receipt
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param ifModifiedSince Only records created or modified since this timestamp will be returned
   * @param where Filter by an any element
   * @param order Order by an any element
   * @param unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal
   *     places for unit amounts
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReceiptsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      OffsetDateTime ifModifiedSince,
      String where,
      String order,
      Integer unitdp)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReceipts");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReceipts");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("xero-tenant-id", xeroTenantId);
    if (ifModifiedSince != null) {
      headers.setIfModifiedSince(ifModifiedSince.toString());
    }
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Receipts");
    if (where != null) {
      String key = "where";
      Object value = where;
      if (value instanceof Collection) {
        List valueList = new ArrayList<>((Collection) value);
        if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
          List<String> list = new ArrayList<String>();
          for (int i = 0; i < valueList.size(); i++) {
            list.add(valueList.get(i).toString());
          }
          uriBuilder = uriBuilder.queryParam(key, String.join(",", list));
        } else {
          uriBuilder = uriBuilder.queryParam(key, String.join(",", valueList));
        }
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (order != null) {
      String key = "order";
      Object value = order;
      if (value instanceof Collection) {
        List valueList = new Ar