/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** TaxRate */
public class TaxRate {
  StringUtil util = new StringUtil();

  @JsonProperty("Name")
  private String name;

  @JsonProperty("TaxType")
  private String taxType;

  @JsonProperty("TaxComponents")
  private List<TaxComponent> taxComponents = new ArrayList<TaxComponent>();

  /** See Status Codes */
  public enum StatusEnum {
    /** ACTIVE */
    ACTIVE("ACTIVE"),

    /** DELETED */
    DELETED("DELETED"),

    /** ARCHIVED */
    ARCHIVED("ARCHIVED"),

    /** PENDING */
    PENDING("PENDING");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Status")
  private StatusEnum status;

  /** See ReportTaxTypes */
  public enum ReportTaxTypeEnum {
    /** AVALARA */
    AVALARA("AVALARA"),

    /** BASEXCLUDED */
    BASEXCLUDED("BASEXCLUDED"),

    /** CAPITALSALESOUTPUT */
    CAPITALSALESOUTPUT("CAPITALSALESOUTPUT"),

    /** CAPITALEXPENSESINPUT */
    CAPITALEXPENSESINPUT("CAPITALEXPENSESINPUT"),

    /** ECOUTPUT */
    ECOUTPUT("ECOUTPUT"),

    /** ECOUTPUTSERVICES */
    ECOUTPUTSERVICES("ECOUTPUTSERVICES"),

    /** ECINPUT */
    ECINPUT("ECINPUT"),

    /** ECACQUISITIONS */
    ECACQUISITIONS("ECACQUISITIONS"),

    /** EXEMPTEXPENSES */
    EXEMPTEXPENSES("EXEMPTEXPENSES"),

    /** EXEMPTINPUT */
    EXEMPTINPUT("EXEMPTINPUT"),

    /** EXEMPTOUTPUT */
    EXEMPTOUTPUT("EXEMPTOUTPUT"),

    /** GSTONIMPORTS */
    GSTONIMPORTS("GSTONIMPORTS"),

    /** INPUT */
    INPUT("INPUT"),

    /** INPUTTAXED */
    INPUTTAXED("INPUTTAXED"),

    /** MOSSSALES */
    MOSSSALES("MOSSSALES"),

    /** NONE */
    NONE("NONE"),

    /** NONEOUTPUT */
    NONEOUTPUT("NONEOUTPUT"),

    /** OUTPUT */
    OUTPUT("OUTPUT"),

    /** PURCHASESINPUT */
    PURCHASESINPUT("PURCHASESINPUT"),

    /** SALESOUTPUT */
    SALESOUTPUT("SALESOUTPUT"),

    /** EXEMPTCAPITAL */
    EXEMPTCAPITAL("EXEMPTCAPITAL"),

    /** EXEMPTEXPORT */
    EXEMPTEXPORT("EXEMPTEXPORT"),

    /** CAPITALEXINPUT */
    CAPITALEXINPUT("CAPITALEXINPUT"),

    /** GSTONCAPIMPORTS */
    GSTONCAPIMPORTS("GSTONCAPIMPORTS"),

    /** GSTONCAPITALIMPORTS */
    GSTONCAPITALIMPORTS("GSTONCAPITALIMPORTS"),

    /** REVERSECHARGES */
    REVERSECHARGES("REVERSECHARGES"),

    /** PAYMENTS */
    PAYMENTS("PAYMENTS"),

    /** INVOICE */
    INVOICE("INVOICE"),

    /** CASH */
    CASH("CASH"),

    /** ACCRUAL */
    ACCRUAL("ACCRUAL"),

    /** FLATRATECASH */
    FLATRATECASH("FLATRATECASH"),

    /** FLATRATEACCRUAL */
    FLATRATEACCRUAL("FLATRATEACCRUAL"),

    /** ACCRUALS */
    ACCRUALS("ACCRUALS"),

    /** TXCA */
    TXCA("TXCA"),

    /** SRCAS */
    SRCAS("SRCAS"),

    /** DSOUTPUT */
    DSOUTPUT("DSOUTPUT"),

    /** BLINPUT2 */
    BLINPUT2("BLINPUT2"),

    /** EPINPUT */
    EPINPUT("EPINPUT"),

    /** IMINPUT2 */
    IMINPUT2("IMINPUT2"),

    /** MEINPUT */
    MEINPUT("MEINPUT"),

    /** IGDSINPUT2 */
    IGDSINPUT2("IGDSINPUT2"),

    /** ESN33OUTPUT */
    ESN33OUTPUT("ESN33OUTPUT"),

    /** OPINPUT */
    OPINPUT("OPINPUT"),

    /** OSOUTPUT */
    OSOUTPUT("OSOUTPUT"),

    /** TXN33INPUT */
    TXN33INPUT("TXN33INPUT"),

    /** TXESSINPUT */
    TXESSINPUT("TXESSINPUT"),

    /** TXREINPUT */
    TXREINPUT("TXREINPUT"),

    /** TXPETINPUT */
    TXPETINPUT("TXPETINPUT"),

    /** NRINPUT */
    NRINPUT("NRINPUT"),

    /** ES33OUTPUT */
    ES33OUTPUT("ES33OUTPUT"),

    /** ZERORATEDINPUT */
    ZERORATEDINPUT("ZERORATEDINPUT"),

    /** ZERORATEDOUTPUT */
    ZERORATEDOUTPUT("ZERORATEDOUTPUT"),

    /** DRCHARGESUPPLY */
    DRCHARGESUPPLY("DRCHARGESUPPLY"),

    /** DRCHARGE */
    DRCHARGE("DRCHARGE"),

    /** CAPINPUT */
    CAPINPUT("CAPINPUT"),

    /** CAPIMPORTS */
    CAPIMPORTS("CAPIMPORTS"),

    /** IMINPUT */
    IMINPUT("IMINPUT"),

    /** INPUT2 */
    INPUT2("INPUT2"),

    /** CIUINPUT */
    CIUINPUT("CIUINPUT"),

    /** SRINPUT */
    SRINPUT("SRINPUT"),

    /** OUTPUT2 */
    OUTPUT2("OUTPUT2"),

    /** SROUTPUT */
    SROUTPUT("SROUTPUT"),

    /** CAPOUTPUT */
    CAPOUTPUT("CAPOUTPUT"),

    /** SROUTPUT2 */
    SROUTPUT2("SROUTPUT2"),

    /** CIUOUTPUT */
    CIUOUTPUT("CIUOUTPUT"),

    /** ZROUTPUT */
    ZROUTPUT("ZROUTPUT"),

    /** ZREXPORT */
    ZREXPORT("ZREXPORT"),

    /** ACC28PLUS */
    ACC28PLUS("ACC28PLUS"),

    /** ACCUPTO28 */
    ACCUPTO28("ACCUPTO28"),

    /** OTHEROUTPUT */
    OTHEROUTPUT("OTHEROUTPUT"),

    /** SHOUTPUT */
    SHOUTPUT("SHOUTPUT"),

    /** ZRINPUT */
    ZRINPUT("ZRINPUT"),

    /** BADDEBT */
    BADDEBT("BADDEBT"),

    /** OTHERINPUT */
    OTHERINPUT("OTHERINPUT"),

    /** BADDEBTRELIEF */
    BADDEBTRELIEF("BADDEBTRELIEF"),

    /** IGDSINPUT3 */
    IGDSINPUT3("IGDSINPUT3"),

    /** SROVR */
    SROVR("SROVR"),

    /** TOURISTREFUND */
    TOURISTREFUND("TOURISTREFUND"),

    /** TXRCN33 */
    TXRCN33("TXRCN33"),

    /** TXRCRE */
    TXRCRE("TXRCRE"),

    /** TXRCESS */
    TXRCESS("TXRCESS"),

    /** TXRCTS */
    TXRCTS("TXRCTS"),

    /** CAPEXINPUT */
    CAPEXINPUT("CAPEXINPUT"),

    /** UNDEFINED */
    UNDEFINED("UNDEFINED"),

    /** CAPEXOUTPUT */
    CAPEXOUTPUT("CAPEXOUTPUT"),

    /** ZEROEXPOUTPUT */
    ZEROEXPOUTPUT("ZEROEXPOUTPUT"),

    /** GOODSIMPORT */
    GOODSIMPORT("GOODSIMPORT"),

    /** NONEINPUT */
    NONEINPUT("NONEINPUT"),

    /** NOTREPORTED */
    NOTREPORTED("NOTREPORTED"),

    /** SROVRRS */
    SROVRRS("SROVRRS"),

    /** SROVRLVG */
    SROVRLVG("SROVRLVG"),

    /** SRLVG */
    SRLVG("SRLVG"),

    /** IM */
    IM("IM"),

    /** IMESS */
    IMESS("IMESS"),

    /** IMN33 */
    IMN33("IMN33"),

    /** IMRE */
    IMRE("IMRE"),

    /** BADDEBTRECOVERY */
    BADDEBTRECOVERY("BADDEBTRECOVERY"),

    /** USSALESTAX */
    USSALESTAX("USSALESTAX"),

    /** BLINPUT3 */
    BLINPUT3("BLINPUT3");

    private String value;

    ReportTaxTypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static ReportTaxTypeEnum fromValue(String value) {
      for (ReportTaxTypeEnum b : ReportTaxTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("ReportTaxType")
  private ReportTaxTypeEnum reportTaxType;

  @JsonProperty("CanApplyToAssets")
  private Boolean canApplyToAssets;

  @JsonProperty("CanApplyToEquity")
  private Boolean canApplyToEquity;

  @JsonProperty("CanApplyToExpenses")
  private Boolean canApplyToExpenses;

  @JsonProperty("CanApplyToLiabilities")
  private Boolean canApplyToLiabilities;

  @JsonProperty("CanApplyToRevenue")
  private Boolean canApplyToRevenue;

  @JsonProperty("DisplayTaxRate")
  private Double displayTaxRate;

  @JsonProperty("EffectiveRate")
  private Double effectiveRate;

  /**
   * Name of tax rate
   *
   * @param name String
   * @return TaxRate
   */
  public TaxRate name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of tax rate
   *
   * @return name
   */
  @ApiModelProperty(value = "Name of tax rate")
  /**
   * Name of tax rate
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * Name of tax rate
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The tax type
   *
   * @param taxType String
   * @return TaxRate
   */
  public TaxRate taxType(String taxType) {
    this.taxType = taxType;
    return this;
  }

  /**
   * The tax type
   *
   * @return taxType
   */
  @ApiModelProperty(value = "The tax type")
  /**
   * The tax type
   *
   * @return taxType String
   */
  public String getTaxType() {
    return taxType;
  }

  /**
   * The tax type
   *
   * @param taxType String
   */
  public void setTaxType(String taxType) {
    this.taxType = taxType;
  }

  /**
   * See TaxComponents
   *
   * @param taxComponents List&lt;TaxComponent&gt;
   * @return TaxRate
   */
  public TaxRate taxComponents(List<TaxComponent> taxComponents) {
    this.taxComponents = taxComponents;
    return this;
  }

  /**
   * See TaxComponents
   *
   * @param taxComponentsItem TaxComponent
   * @return TaxRate
   */
  public TaxRate addTaxComponentsItem(TaxComponent taxComponentsItem) {
    if (this.taxComponents == null) {
      this.taxComponents = new ArrayList<TaxComponent>();
    }
    this.taxComponents.add(taxComponentsItem);
    return this;
  }

  /**
   * See TaxComponents
   *
   * @return taxComponents
   */
  @ApiModelProperty(value = "See TaxComponents")
  /**
   * See TaxComponents
   *
   * @return taxComponents List<TaxComponent>
   */
  public List<TaxComponent> getTaxComponents() {
    return taxComponents;
  }

  /**
   * See TaxComponents
   *
   * @param taxComponents List&lt;TaxComponent&gt;
   */
  public void setTaxComponents(List<TaxComponent> taxComponents) {
    this.taxComponents = taxComponents;
  }

  /**
   * See Status Codes
   *
   * @param status StatusEnum
   * @return TaxRate
   */
  public TaxRate status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * See Status Codes
   *
   * @return status
   */
  @ApiModelProperty(value = "See Status Codes")
  /**
   * See Status Codes
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * See Status Codes
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * See ReportTaxTypes
   *
   * @param reportTaxType ReportTaxTypeEnum
   * @return TaxRate
   */
  public TaxRate reportTaxType(ReportTaxTypeEnum reportTaxType) {
    this.reportTaxType = reportTaxType;
    return this;
  }

  /**
   * See ReportTaxTypes
   *
   * @return reportTaxType
   */
  @ApiModelProperty(value = "See ReportTaxTypes")
  /**
   * See ReportTaxTypes
   *
   * @return reportTaxType ReportTaxTypeEnum
   */
  public ReportTaxTypeEnum getReportTaxType() {
    return reportTaxType;
  }

  /**
   * See ReportTaxTypes
   *
   * @param reportTaxType ReportTaxTypeEnum
   */
  public void setReportTaxType(ReportTaxTypeEnum reportTaxType) {
    this.reportTaxType = reportTaxType;
  }

  /**
   * Boolean to describe if tax rate can be used for asset accounts i.e. true,false
   *
   * @return canApplyToAssets
   */
  @ApiModelProperty(
      value = "Boolean to describe if tax rate can be used for asset accounts i.e.  true,false")
  /**
   * Boolean to describe if tax rate can be used for asset accounts i.e. true,false
   *
   * @return canApplyToAssets Boolean
   */
  public Boolean getCanApplyToAssets() {
    return canApplyToAssets;
  }

  /**
   * Boolean to describe if tax rate can be used for equity accounts i.e true,false
   *
   * @return canApplyToEquity
   */
  @ApiModelProperty(
      value = "Boolean to describe if tax rate can be used for equity accounts i.e true,false")
  /**
   * Boolean to describe if tax rate can be used for equity accounts i.e true,false
   *
   * @return canApplyToEquity Boolean
   */
  public Boolean getCanApplyToEquity() {
    return canApplyToEquity;
  }

  /**
   * Boolean to describe if tax rate can be used for expense accounts i.e. true,false
   *
   * @return canApplyToExpenses
   */
  @ApiModelProperty(
      value = "Boolean to describe if tax rate can be used for expense accounts  i.e. true,false")
  /**
   * Boolean to describe if tax rate can be used for expense accounts i.e. true,false
   *
   * @return canApplyToExpenses Boolean
   */
  public Boolean getCanApplyToExpenses() {
    return canApplyToExpenses;
  }

  /**
   * Boolean to describe if tax rate can be used for liability accounts i.e. true,false
   *
   * @return canApplyToLiabilities
   */
  @ApiModelProperty(
      value = "Boolean to describe if tax rate can be used for liability accounts  i.e. true,false")
  /**
   * Boolean to describe if tax rate can be used for liability accounts i.e. true,false
   *
   * @return canApplyToLiabilities Boolean
   */
  public Boolean getCanApplyToLiabilities() {
    return canApplyToLiabilities;
  }

  /**
   * Boolean to describe if tax rate can be used for revenue accounts i.e. true,false
   *
   * @return canApplyToRevenue
   */
  @ApiModelProperty(
      value = "Boolean to describe if tax rate can be used for revenue accounts i.e. true,false")
  /**
   * Boolean to describe if tax rate can be used for revenue accounts i.e. true,false
   *
   * @return canApplyToRevenue Boolean
   */
  public Boolean getCanApplyToRevenue() {
    return canApplyToRevenue;
  }

  /**
   * Tax Rate (decimal to 4dp) e.g 12.5000
   *
   * @return displayTaxRate
   */
  @ApiModelProperty(value = "Tax Rate (decimal to 4dp) e.g 12.5000")
  /**
   * Tax Rate (decimal to 4dp) e.g 12.5000
   *
   * @return displayTaxRate Double
   */
  public Double getDisplayTaxRate() {
    return displayTaxRate;
  }

  /**
   * Effective Tax Rate (decimal to 4dp) e.g 12.5000
   *
   * @return effectiveRate
   */
  @ApiModelProperty(value = "Effective Tax Rate (decimal to 4dp) e.g 12.5000")
  /**
   * Effective Tax Rate (decimal to 4dp) e.g 12.5000
   *
   * @return effectiveRate Double
   */
  public Double getEffectiveRate() {
    return effectiveRate;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxRate taxRate = (TaxRate) o;
    return Objects.equals(this.name, taxRate.name)
        && Objects.equals(this.taxType, taxRate.taxType)
        && Objects.equals(this.taxComponents, taxRate.taxComponents)
        && Objects.equals(this.status, taxRate.status)
        && Objects.equals(this.reportTaxType, taxRate.reportTaxType)
        && Objects.equals(this.canApplyToAssets, taxRate.canApplyToAssets)
        && Objects.equals(this.canApplyToEquity, taxRate.canApplyToEquity)
        && Objects.equals(this.canApplyToExpenses, taxRate.canApplyToExpenses)
        && Objects.equals(this.canApplyToLiabilities, taxRate.canApplyToLiabilities)
        && Objects.equals(this.canApplyToRevenue, taxRate.canApplyToRevenue)
        && Objects.equals(this.displayTaxRate, taxRate.displayTaxRate)
        && Objects.equals(this.effectiveRate, taxRate.effectiveRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        name,
        taxType,
        taxComponents,
        status,
        reportTaxType,
        canApplyToAssets,
        canApplyToEquity,
        canApplyToExpenses,
        canApplyToLiabilities,
        canApplyToRevenue,
        displayTaxRate,
        effectiveRate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxRate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    taxType: ").append(toIndentedString(taxType)).append("\n");
    sb.append("    taxComponents: ").append(toIndentedString(taxComponents)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reportTaxType: ").append(toIndentedString(reportTaxType)).append("\n");
    sb.append("    canApplyToAssets: ").append(toIndentedString(canApplyToAssets)).append("\n");
    sb.append("    canApplyToEquity: ").append(toIndentedString(canApplyToEquity)).append("\n");
    sb.append("    canApplyToExpenses: ").append(toIndentedString(canApplyToExpenses)).append("\n");
    sb.append("    canApplyToLiabilities: ")
        .append(toIndentedString(canApplyToLiabilities))
        .append("\n");
    sb.append("    canApplyToRevenue: ").append(toIndentedString(canApplyToRevenue)).append("\n");
    sb.append("    displayTaxRate: ").append(toIndentedString(displayTaxRate)).append("\n");
    sb.append("    effectiveRate: ").append(toIndentedString(effectiveRate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
