/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** TrackingOption */
public class TrackingOption {
  StringUtil util = new StringUtil();

  @JsonProperty("TrackingOptionID")
  private UUID trackingOptionID;

  @JsonProperty("Name")
  private String name;

  /** The status of a tracking option */
  public enum StatusEnum {
    /** ACTIVE */
    ACTIVE("ACTIVE"),

    /** ARCHIVED */
    ARCHIVED("ARCHIVED"),

    /** DELETED */
    DELETED("DELETED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Status")
  private StatusEnum status;

  @JsonProperty("TrackingCategoryID")
  private UUID trackingCategoryID;

  /**
   * The Xero identifier for a tracking option e.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a
   *
   * @param trackingOptionID UUID
   * @return TrackingOption
   */
  public TrackingOption trackingOptionID(UUID trackingOptionID) {
    this.trackingOptionID = trackingOptionID;
    return this;
  }

  /**
   * The Xero identifier for a tracking option e.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a
   *
   * @return trackingOptionID
   */
  @ApiModelProperty(
      value = "The Xero identifier for a tracking option e.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a")
  /**
   * The Xero identifier for a tracking option e.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a
   *
   * @return trackingOptionID UUID
   */
  public UUID getTrackingOptionID() {
    return trackingOptionID;
  }

  /**
   * The Xero identifier for a tracking option e.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a
   *
   * @param trackingOptionID UUID
   */
  public void setTrackingOptionID(UUID trackingOptionID) {
    this.trackingOptionID = trackingOptionID;
  }

  /**
   * The name of the tracking option e.g. Marketing, East (max length &#x3D; 100)
   *
   * @param name String
   * @return TrackingOption
   */
  public TrackingOption name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the tracking option e.g. Marketing, East (max length &#x3D; 100)
   *
   * @return name
   */
  @ApiModelProperty(
      value = "The name of the tracking option e.g. Marketing, East (max length = 100)")
  /**
   * The name of the tracking option e.g. Marketing, East (max length &#x3D; 100)
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * The name of the tracking option e.g. Marketing, East (max length &#x3D; 100)
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The status of a tracking option
   *
   * @param status StatusEnum
   * @return TrackingOption
   */
  public TrackingOption status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of a tracking option
   *
   * @return status
   */
  @ApiModelProperty(value = "The status of a tracking option")
  /**
   * The status of a tracking option
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of a tracking option
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * Filter by a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   *
   * @param trackingCategoryID UUID
   * @return TrackingOption
   */
  public TrackingOption trackingCategoryID(UUID trackingCategoryID) {
    this.trackingCategoryID = trackingCategoryID;
    return this;
  }

  /**
   * Filter by a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   *
   * @return trackingCategoryID
   */
  @ApiModelProperty(
      value = "Filter by a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
  /**
   * Filter by a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   *
   * @return trackingCategoryID UUID
   */
  public UUID getTrackingCategoryID() {
    return trackingCategoryID;
  }

  /**
   * Filter by a tracking category e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   *
   * @param trackingCategoryID UUID
   */
  public void setTrackingCategoryID(UUID trackingCategoryID) {
    this.trackingCategoryID = trackingCategoryID;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrackingOption trackingOption = (TrackingOption) o;
    return Objects.equals(this.trackingOptionID, trackingOption.trackingOptionID)
        && Objects.equals(this.name, trackingOption.name)
        && Objects.equals(this.status, trackingOption.status)
        && Objects.equals(this.trackingCategoryID, trackingOption.trackingCategoryID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trackingOptionID, name, status, trackingCategoryID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrackingOption {\n");
    sb.append("    trackingOptionID: ").append(toIndentedString(trackingOptionID)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    trackingCategoryID: ").append(toIndentedString(trackingCategoryID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
