/*
 * Xero Assets API
 * The Assets API exposes fixed asset related functions of the Xero Accounting application and can be used for a variety of purposes such as creating assets, retrieving asset valuations etc.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** Asset */
public class Asset {
  StringUtil util = new StringUtil();

  @JsonProperty("assetId")
  private UUID assetId;

  @JsonProperty("assetName")
  private String assetName;

  @JsonProperty("assetTypeId")
  private UUID assetTypeId;

  @JsonProperty("assetNumber")
  private String assetNumber;

  @JsonProperty("purchaseDate")
  private LocalDate purchaseDate;

  @JsonProperty("purchasePrice")
  private Double purchasePrice;

  @JsonProperty("disposalDate")
  private LocalDate disposalDate;

  @JsonProperty("disposalPrice")
  private Double disposalPrice;

  @JsonProperty("assetStatus")
  private AssetStatus assetStatus;

  @JsonProperty("warrantyExpiryDate")
  private String warrantyExpiryDate;

  @JsonProperty("serialNumber")
  private String serialNumber;

  @JsonProperty("bookDepreciationSetting")
  private BookDepreciationSetting bookDepreciationSetting;

  @JsonProperty("bookDepreciationDetail")
  private BookDepreciationDetail bookDepreciationDetail;

  @JsonProperty("canRollback")
  private Boolean canRollback;

  @JsonProperty("accountingBookValue")
  private Double accountingBookValue;

  @JsonProperty("isDeleteEnabledForDate")
  private Boolean isDeleteEnabledForDate;

  /**
   * The Xero-generated Id for the asset
   *
   * @param assetId UUID
   * @return Asset
   */
  public Asset assetId(UUID assetId) {
    this.assetId = assetId;
    return this;
  }

  /**
   * The Xero-generated Id for the asset
   *
   * @return assetId
   */
  @ApiModelProperty(
      example = "3b5b3a38-5649-495f-87a1-14a4e5918634",
      value = "The Xero-generated Id for the asset")
  /**
   * The Xero-generated Id for the asset
   *
   * @return assetId UUID
   */
  public UUID getAssetId() {
    return assetId;
  }

  /**
   * The Xero-generated Id for the asset
   *
   * @param assetId UUID
   */
  public void setAssetId(UUID assetId) {
    this.assetId = assetId;
  }

  /**
   * The name of the asset
   *
   * @param assetName String
   * @return Asset
   */
  public Asset assetName(String assetName) {
    this.assetName = assetName;
    return this;
  }

  /**
   * The name of the asset
   *
   * @return assetName
   */
  @ApiModelProperty(example = "Awesome Truck 3", required = true, value = "The name of the asset")
  /**
   * The name of the asset
   *
   * @return assetName String
   */
  public String getAssetName() {
    return assetName;
  }

  /**
   * The name of the asset
   *
   * @param assetName String
   */
  public void setAssetName(String assetName) {
    this.assetName = assetName;
  }

  /**
   * The Xero-generated Id for the asset type
   *
   * @param assetTypeId UUID
   * @return Asset
   */
  public Asset assetTypeId(UUID assetTypeId) {
    this.assetTypeId = assetTypeId;
    return this;
  }

  /**
   * The Xero-generated Id for the asset type
   *
   * @return assetTypeId
   */
  @ApiModelProperty(
      example = "3b5b3a38-5649-495f-87a1-14a4e5918634",
      value = "The Xero-generated Id for the asset type")
  /**
   * The Xero-generated Id for the asset type
   *
   * @return assetTypeId UUID
   */
  public UUID getAssetTypeId() {
    return assetTypeId;
  }

  /**
   * The Xero-generated Id for the asset type
   *
   * @param assetTypeId UUID
   */
  public void setAssetTypeId(UUID assetTypeId) {
    this.assetTypeId = assetTypeId;
  }

  /**
   * Must be unique.
   *
   * @param assetNumber String
   * @return Asset
   */
  public Asset assetNumber(String assetNumber) {
    this.assetNumber = assetNumber;
    return this;
  }

  /**
   * Must be unique.
   *
   * @return assetNumber
   */
  @ApiModelProperty(example = "FA-0013", value = "Must be unique.")
  /**
   * Must be unique.
   *
   * @return assetNumber String
   */
  public String getAssetNumber() {
    return assetNumber;
  }

  /**
   * Must be unique.
   *
   * @param assetNumber String
   */
  public void setAssetNumber(String assetNumber) {
    this.assetNumber = assetNumber;
  }

  /**
   * The date the asset was purchased YYYY-MM-DD
   *
   * @param purchaseDate LocalDate
   * @return Asset
   */
  public Asset purchaseDate(LocalDate purchaseDate) {
    this.purchaseDate = purchaseDate;
    return this;
  }

  /**
   * The date the asset was purchased YYYY-MM-DD
   *
   * @return purchaseDate
   */
  @ApiModelProperty(value = "The date the asset was purchased YYYY-MM-DD")
  /**
   * The date the asset was purchased YYYY-MM-DD
   *
   * @return purchaseDate LocalDate
   */
  public LocalDate getPurchaseDate() {
    return purchaseDate;
  }

  /**
   * The date the asset was purchased YYYY-MM-DD
   *
   * @param purchaseDate LocalDate
   */
  public void setPurchaseDate(LocalDate purchaseDate) {
    this.purchaseDate = purchaseDate;
  }

  /**
   * The purchase price of the asset
   *
   * @param purchasePrice Double
   * @return Asset
   */
  public Asset purchasePrice(Double purchasePrice) {
    this.purchasePrice = purchasePrice;
    return this;
  }

  /**
   * The purchase price of the asset
   *
   * @return purchasePrice
   */
  @ApiModelProperty(example = "1000.0000", value = "The purchase price of the asset")
  /**
   * The purchase price of the asset
   *
   * @return purchasePrice Double
   */
  public Double getPurchasePrice() {
    return purchasePrice;
  }

  /**
   * The purchase price of the asset
   *
   * @param purchasePrice Double
   */
  public void setPurchasePrice(Double purchasePrice) {
    this.purchasePrice = purchasePrice;
  }

  /**
   * The date the asset was disposed
   *
   * @param disposalDate LocalDate
   * @return Asset
   */
  public Asset disposalDate(LocalDate disposalDate) {
    this.disposalDate = disposalDate;
    return this;
  }

  /**
   * The date the asset was disposed
   *
   * @return disposalDate
   */
  @ApiModelProperty(value = "The date the asset was disposed")
  /**
   * The date the asset was disposed
   *
   * @return disposalDate LocalDate
   */
  public LocalDate getDisposalDate() {
    return disposalDate;
  }

  /**
   * The date the asset was disposed
   *
   * @param disposalDate LocalDate
   */
  public void setDisposalDate(LocalDate disposalDate) {
    this.disposalDate = disposalDate;
  }

  /**
   * The price the asset was disposed at
   *
   * @param disposalPrice Double
   * @return Asset
   */
  public Asset disposalPrice(Double disposalPrice) {
    this.disposalPrice = disposalPrice;
    return this;
  }

  /**
   * The price the asset was disposed at
   *
   * @return disposalPrice
   */
  @ApiModelProperty(example = "1.0000", value = "The price the asset was disposed at")
  /**
   * The price the asset was disposed at
   *
   * @return disposalPrice Double
   */
  public Double getDisposalPrice() {
    return disposalPrice;
  }

  /**
   * The price the asset was disposed at
   *
   * @param disposalPrice Double
   */
  public void setDisposalPrice(Double disposalPrice) {
    this.disposalPrice = disposalPrice;
  }

  /**
   * assetStatus
   *
   * @param assetStatus AssetStatus
   * @return Asset
   */
  public Asset assetStatus(AssetStatus assetStatus) {
    this.assetStatus = assetStatus;
    return this;
  }

  /**
   * Get assetStatus
   *
   * @return assetStatus
   */
  @ApiModelProperty(value = "")
  /**
   * assetStatus
   *
   * @return assetStatus AssetStatus
   */
  public AssetStatus getAssetStatus() {
    return assetStatus;
  }

  /**
   * assetStatus
   *
   * @param assetStatus AssetStatus
   */
  public void setAssetStatus(AssetStatus assetStatus) {
    this.assetStatus = assetStatus;
  }

  /**
   * The date the asset’s warranty expires (if needed) YYYY-MM-DD
   *
   * @param warrantyExpiryDate String
   * @return Asset
   */
  public Asset warrantyExpiryDate(String warrantyExpiryDate) {
    this.warrantyExpiryDate = warrantyExpiryDate;
    return this;
  }

  /**
   * The date the asset’s warranty expires (if needed) YYYY-MM-DD
   *
   * @return warrantyExpiryDate
   */
  @ApiModelProperty(
      example = "ca4c6b39-4f4f-43e8-98da-5e1f350a6694",
      value = "The date the asset’s warranty expires (if needed) YYYY-MM-DD")
  /**
   * The date the asset’s warranty expires (if needed) YYYY-MM-DD
   *
   * @return warrantyExpiryDate String
   */
  public String getWarrantyExpiryDate() {
    return warrantyExpiryDate;
  }

  /**
   * The date the asset’s warranty expires (if needed) YYYY-MM-DD
   *
   * @param warrantyExpiryDate String
   */
  public void setWarrantyExpiryDate(String warrantyExpiryDate) {
    this.warrantyExpiryDate = warrantyExpiryDate;
  }

  /**
   * The asset&#39;s serial number
   *
   * @param serialNumber String
   * @return Asset
   */
  public Asset serialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
    return this;
  }

  /**
   * The asset&#39;s serial number
   *
   * @return serialNumber
   */
  @ApiModelProperty(
      example = "ca4c6b39-4f4f-43e8-98da-5e1f350a6694",
      value = "The asset's serial number")
  /**
   * The asset&#39;s serial number
   *
   * @return serialNumber String
   */
  public String getSerialNumber() {
    return serialNumber;
  }

  /**
   * The asset&#39;s serial number
   *
   * @param serialNumber String
   */
  public void setSerialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
  }

  /**
   * bookDepreciationSetting
   *
   * @param bookDepreciationSetting BookDepreciationSetting
   * @return Asset
   */
  public Asset bookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
    this.bookDepreciationSetting = bookDepreciationSetting;
    return this;
  }

  /**
   * Get bookDepreciationSetting
   *
   * @return bookDepreciationSetting
   */
  @ApiModelProperty(value = "")
  /**
   * bookDepreciationSetting
   *
   * @return bookDepreciationSetting BookDepreciationSetting
   */
  public BookDepreciationSetting getBookDepreciationSetting() {
    return bookDepreciationSetting;
  }

  /**
   * bookDepreciationSetting
   *
   * @param bookDepreciationSetting BookDepreciationSetting
   */
  public void setBookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
    this.bookDepreciationSetting = bookDepreciationSetting;
  }

  /**
   * bookDepreciationDetail
   *
   * @param bookDepreciationDetail BookDepreciationDetail
   * @return Asset
   */
  public Asset bookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
    this.bookDepreciationDetail = bookDepreciationDetail;
    return this;
  }

  /**
   * Get bookDepreciationDetail
   *
   * @return bookDepreciationDetail
   */
  @ApiModelProperty(value = "")
  /**
   * bookDepreciationDetail
   *
   * @return bookDepreciationDetail BookDepreciationDetail
   */
  public BookDepreciationDetail getBookDepreciationDetail() {
    return bookDepreciationDetail;
  }

  /**
   * bookDepreciationDetail
   *
   * @param bookDepreciationDetail BookDepreciationDetail
   */
  public void setBookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
    this.bookDepreciationDetail = bookDepreciationDetail;
  }

  /**
   * Boolean to indicate whether depreciation can be rolled back for this asset individually. This
   * is true if it doesn&#39;t have &#39;legacy&#39; journal entries and if there is no lock period
   * that would prevent this asset from rolling back.
   *
   * @param canRollback Boolean
   * @return Asset
   */
  public Asset canRollback(Boolean canRollback) {
    this.canRollback = canRollback;
    return this;
  }

  /**
   * Boolean to indicate whether depreciation can be rolled back for this asset individually. This
   * is true if it doesn&#39;t have &#39;legacy&#39; journal entries and if there is no lock period
   * that would prevent this asset from rolling back.
   *
   * @return canRollback
   */
  @ApiModelProperty(
      example = "true",
      value =
          "Boolean to indicate whether depreciation can be rolled back for this asset individually."
              + " This is true if it doesn't have 'legacy' journal entries and if there is no lock"
              + " period that would prevent this asset from rolling back.")
  /**
   * Boolean to indicate whether depreciation can be rolled back for this asset individually. This
   * is true if it doesn&#39;t have &#39;legacy&#39; journal entries and if there is no lock period
   * that would prevent this asset from rolling back.
   *
   * @return canRollback Boolean
   */
  public Boolean getCanRollback() {
    return canRollback;
  }

  /**
   * Boolean to indicate whether depreciation can be rolled back for this asset individually. This
   * is true if it doesn&#39;t have &#39;legacy&#39; journal entries and if there is no lock period
   * that would prevent this asset from rolling back.
   *
   * @param canRollback Boolean
   */
  public void setCanRollback(Boolean canRollback) {
    this.canRollback = canRollback;
  }

  /**
   * The accounting value of the asset
   *
   * @param accountingBookValue Double
   * @return Asset
   */
  public Asset accountingBookValue(Double accountingBookValue) {
    this.accountingBookValue = accountingBookValue;
    return this;
  }

  /**
   * The accounting value of the asset
   *
   * @return accountingBookValue
   */
  @ApiModelProperty(example = "0", value = "The accounting value of the asset")
  /**
   * The accounting value of the asset
   *
   * @return accountingBookValue Double
   */
  public Double getAccountingBookValue() {
    return accountingBookValue;
  }

  /**
   * The accounting value of the asset
   *
   * @param accountingBookValue Double
   */
  public void setAccountingBookValue(Double accountingBookValue) {
    this.accountingBookValue = accountingBookValue;
  }

  /**
   * Boolean to indicate whether delete is enabled
   *
   * @param isDeleteEnabledForDate Boolean
   * @return Asset
   */
  public Asset isDeleteEnabledForDate(Boolean isDeleteEnabledForDate) {
    this.isDeleteEnabledForDate = isDeleteEnabledForDate;
    return this;
  }

  /**
   * Boolean to indicate whether delete is enabled
   *
   * @return isDeleteEnabledForDate
   */
  @ApiModelProperty(example = "true", value = "Boolean to indicate whether delete is enabled")
  /**
   * Boolean to indicate whether delete is enabled
   *
   * @return isDeleteEnabledForDate Boolean
   */
  public Boolean getIsDeleteEnabledForDate() {
    return isDeleteEnabledForDate;
  }

  /**
   * Boolean to indicate whether delete is enabled
   *
   * @param isDeleteEnabledForDate Boolean
   */
  public void setIsDeleteEnabledForDate(Boolean isDeleteEnabledForDate) {
    this.isDeleteEnabledForDate = isDeleteEnabledForDate;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Asset asset = (Asset) o;
    return Objects.equals(this.assetId, asset.assetId)
        && Objects.equals(this.assetName, asset.assetName)
        && Objects.equals(this.assetTypeId, asset.assetTypeId)
        && Objects.equals(this.assetNumber, asset.assetNumber)
        && Objects.equals(this.purchaseDate, asset.purchaseDate)
        && Objects.equals(this.purchasePrice, asset.purchasePrice)
        && Objects.equals(this.disposalDate, asset.disposalDate)
        && Objects.equals(this.disposalPrice, asset.disposalPrice)
        && Objects.equals(this.assetStatus, asset.assetStatus)
        && Objects.equals(this.warrantyExpiryDate, asset.warrantyExpiryDate)
        && Objects.equals(this.serialNumber, asset.serialNumber)
        && Objects.equals(this.bookDepreciationSetting, asset.bookDepreciationSetting)
        && Objects.equals(this.bookDepreciationDetail, asset.bookDepreciationDetail)
        && Objects.equals(this.canRollback, asset.canRollback)
        && Objects.equals(this.accountingBookValue, asset.accountingBookValue)
        && Objects.equals(this.isDeleteEnabledForDate, asset.isDeleteEnabledForDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        assetId,
        assetName,
        assetTypeId,
        assetNumber,
        purchaseDate,
        purchasePrice,
        disposalDate,
        disposalPrice,
        assetStatus,
        warrantyExpiryDate,
        serialNumber,
        bookDepreciationSetting,
        bookDepreciationDetail,
        canRollback,
        accountingBookValue,
        isDeleteEnabledForDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Asset {\n");
    sb.append("    assetId: ").append(toIndentedString(assetId)).append("\n");
    sb.append("    assetName: ").append(toIndentedString(assetName)).append("\n");
    sb.append("    assetTypeId: ").append(toIndentedString(assetTypeId)).append("\n");
    sb.append("    assetNumber: ").append(toIndentedString(assetNumber)).append("\n");
    sb.append("    purchaseDate: ").append(toIndentedString(purchaseDate)).append("\n");
    sb.append("    purchasePrice: ").append(toIndentedString(purchasePrice)).append("\n");
    sb.append("    disposalDate: ").append(toIndentedString(disposalDate)).append("\n");
    sb.append("    disposalPrice: ").append(toIndentedString(disposalPrice)).append("\n");
    sb.append("    assetStatus: ").append(toIndentedString(assetStatus)).append("\n");
    sb.append("    warrantyExpiryDate: ").append(toIndentedString(warrantyExpiryDate)).append("\n");
    sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
    sb.append("    bookDepreciationSetting: ")
        .append(toIndentedString(bookDepreciationSetting))
        .append("\n");
    sb.append("    bookDepreciationDetail: ")
        .append(toIndentedString(bookDepreciationDetail))
        .append("\n");
    sb.append("    canRollback: ").append(toIndentedString(canRollback)).append("\n");
    sb.append("    accountingBookValue: ")
        .append(toIndentedString(accountingBookValue))
        .append("\n");
    sb.append("    isDeleteEnabledForDate: ")
        .append(toIndentedString(isDeleteEnabledForDate))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
