/*
 * Xero Assets API
 * The Assets API exposes fixed asset related functions of the Xero Accounting application and can be used for a variety of purposes such as creating assets, retrieving asset valuations etc.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** FieldValidationErrorsElement */
public class FieldValidationErrorsElement {
  StringUtil util = new StringUtil();

  @JsonProperty("fieldName")
  private String fieldName;

  @JsonProperty("valueProvided")
  private String valueProvided;

  @JsonProperty("localisedMessage")
  private String localisedMessage;

  @JsonProperty("type")
  private String type;

  @JsonProperty("title")
  private String title;

  @JsonProperty("detail")
  private String detail;

  /**
   * The field name of the erroneous field
   *
   * @param fieldName String
   * @return FieldValidationErrorsElement
   */
  public FieldValidationErrorsElement fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * The field name of the erroneous field
   *
   * @return fieldName
   */
  @ApiModelProperty(value = "The field name of the erroneous field")
  /**
   * The field name of the erroneous field
   *
   * @return fieldName String
   */
  public String getFieldName() {
    return fieldName;
  }

  /**
   * The field name of the erroneous field
   *
   * @param fieldName String
   */
  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  /**
   * The provided value
   *
   * @param valueProvided String
   * @return FieldValidationErrorsElement
   */
  public FieldValidationErrorsElement valueProvided(String valueProvided) {
    this.valueProvided = valueProvided;
    return this;
  }

  /**
   * The provided value
   *
   * @return valueProvided
   */
  @ApiModelProperty(value = "The provided value")
  /**
   * The provided value
   *
   * @return valueProvided String
   */
  public String getValueProvided() {
    return valueProvided;
  }

  /**
   * The provided value
   *
   * @param valueProvided String
   */
  public void setValueProvided(String valueProvided) {
    this.valueProvided = valueProvided;
  }

  /**
   * Explanation of the field validation error
   *
   * @param localisedMessage String
   * @return FieldValidationErrorsElement
   */
  public FieldValidationErrorsElement localisedMessage(String localisedMessage) {
    this.localisedMessage = localisedMessage;
    return this;
  }

  /**
   * Explanation of the field validation error
   *
   * @return localisedMessage
   */
  @ApiModelProperty(value = "Explanation of the field validation error")
  /**
   * Explanation of the field validation error
   *
   * @return localisedMessage String
   */
  public String getLocalisedMessage() {
    return localisedMessage;
  }

  /**
   * Explanation of the field validation error
   *
   * @param localisedMessage String
   */
  public void setLocalisedMessage(String localisedMessage) {
    this.localisedMessage = localisedMessage;
  }

  /**
   * Internal type of the field validation error message
   *
   * @param type String
   * @return FieldValidationErrorsElement
   */
  public FieldValidationErrorsElement type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Internal type of the field validation error message
   *
   * @return type
   */
  @ApiModelProperty(value = "Internal type of the field validation error message")
  /**
   * Internal type of the field validation error message
   *
   * @return type String
   */
  public String getType() {
    return type;
  }

  /**
   * Internal type of the field validation error message
   *
   * @param type String
   */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Title of the field validation error
   *
   * @param title String
   * @return FieldValidationErrorsElement
   */
  public FieldValidationErrorsElement title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Title of the field validation error
   *
   * @return title
   */
  @ApiModelProperty(value = "Title of the field validation error")
  /**
   * Title of the field validation error
   *
   * @return title String
   */
  public String getTitle() {
    return title;
  }

  /**
   * Title of the field validation error
   *
   * @param title String
   */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Detail of the field validation error
   *
   * @param detail String
   * @return FieldValidationErrorsElement
   */
  public FieldValidationErrorsElement detail(String detail) {
    this.detail = detail;
    return this;
  }

  /**
   * Detail of the field validation error
   *
   * @return detail
   */
  @ApiModelProperty(value = "Detail of the field validation error")
  /**
   * Detail of the field validation error
   *
   * @return detail String
   */
  public String getDetail() {
    return detail;
  }

  /**
   * Detail of the field validation error
   *
   * @param detail String
   */
  public void setDetail(String detail) {
    this.detail = detail;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FieldValidationErrorsElement fieldValidationErrorsElement = (FieldValidationErrorsElement) o;
    return Objects.equals(this.fieldName, fieldValidationErrorsElement.fieldName)
        && Objects.equals(this.valueProvided, fieldValidationErrorsElement.valueProvided)
        && Objects.equals(this.localisedMessage, fieldValidationErrorsElement.localisedMessage)
        && Objects.equals(this.type, fieldValidationErrorsElement.type)
        && Objects.equals(this.title, fieldValidationErrorsElement.title)
        && Objects.equals(this.detail, fieldValidationErrorsElement.detail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, valueProvided, localisedMessage, type, title, detail);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FieldValidationErrorsElement {\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    valueProvided: ").append(toIndentedString(valueProvided)).append("\n");
    sb.append("    localisedMessage: ").append(toIndentedString(localisedMessage)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
