/*
 * Xero Bank Feeds API
 * The Bank Feeds API is a closed API that is only available to financial institutions that have an established financial services partnership with Xero. If you're an existing financial services partner that wants access, contact your local Partner Manager. If you're a financial institution who wants to provide bank feeds to your business customers, contact us to become a financial services partner.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.bankfeeds;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * If the statement balances are credit or debit, the CreditDebitIndicator should be specified from
 * the perspective of the Customer.
 */
public enum CreditDebitIndicator {

  /** CREDIT */
  CREDIT("CREDIT"),

  /** DEBIT */
  DEBIT("DEBIT");

  private String value;

  CreditDebitIndicator(String value) {
    this.value = value;
  }

  /**
   * @return String value
   */
  @JsonValue
  public String getValue() {
    return value;
  }

  /**
   * toString
   *
   * @return String value
   */
  @Override
  public String toString() {
    return String.valueOf(value);
  }

  /**
   * fromValue
   *
   * @param value String
   */
  @JsonCreator
  public static CreditDebitIndicator fromValue(String value) {
    for (CreditDebitIndicator b : CreditDebitIndicator.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}
