/*
 * Xero Bank Feeds API
 * The Bank Feeds API is a closed API that is only available to financial institutions that have an established financial services partnership with Xero. If you're an existing financial services partner that wants access, contact your local Partner Manager. If you're a financial institution who wants to provide bank feeds to your business customers, contact us to become a financial services partner.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.bankfeeds;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

/** the lines details for a statement */
@ApiModel(description = "the lines details for a statement")
public class StatementLine {
  StringUtil util = new StringUtil();

  @JsonProperty("postedDate")
  private LocalDate postedDate;

  @JsonProperty("description")
  private String description;

  @JsonProperty("amount")
  private Double amount;

  @JsonProperty("creditDebitIndicator")
  private CreditDebitIndicator creditDebitIndicator;

  @JsonProperty("transactionId")
  private String transactionId;

  @JsonProperty("payeeName")
  private String payeeName;

  @JsonProperty("reference")
  private String reference;

  @JsonProperty("chequeNumber")
  private String chequeNumber;

  @JsonProperty("transactionType")
  private String transactionType;

  /**
   * The date that the transaction was processed or cleared as seen in internet banking ISO-8601
   * YYYY-MM-DD
   *
   * @param postedDate LocalDate
   * @return StatementLine
   */
  public StatementLine postedDate(LocalDate postedDate) {
    this.postedDate = postedDate;
    return this;
  }

  /**
   * The date that the transaction was processed or cleared as seen in internet banking ISO-8601
   * YYYY-MM-DD
   *
   * @return postedDate
   */
  @ApiModelProperty(
      example = "Sun Jun 10 00:00:00 UTC 2018",
      value =
          "The date that the transaction was processed or cleared as seen in internet banking"
              + " ISO-8601 YYYY-MM-DD")
  /**
   * The date that the transaction was processed or cleared as seen in internet banking ISO-8601
   * YYYY-MM-DD
   *
   * @return postedDate LocalDate
   */
  public LocalDate getPostedDate() {
    return postedDate;
  }

  /**
   * The date that the transaction was processed or cleared as seen in internet banking ISO-8601
   * YYYY-MM-DD
   *
   * @param postedDate LocalDate
   */
  public void setPostedDate(LocalDate postedDate) {
    this.postedDate = postedDate;
  }

  /**
   * Transaction description
   *
   * @param description String
   * @return StatementLine
   */
  public StatementLine description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Transaction description
   *
   * @return description
   */
  @ApiModelProperty(example = "Description for statement line 2", value = "Transaction description")
  /**
   * Transaction description
   *
   * @return description String
   */
  public String getDescription() {
    return description;
  }

  /**
   * Transaction description
   *
   * @param description String
   */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Transaction amount
   *
   * @param amount Double
   * @return StatementLine
   */
  public StatementLine amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Transaction amount
   *
   * @return amount
   */
  @ApiModelProperty(example = "5.00", value = "Transaction amount")
  /**
   * Transaction amount
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * Transaction amount
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * creditDebitIndicator
   *
   * @param creditDebitIndicator CreditDebitIndicator
   * @return StatementLine
   */
  public StatementLine creditDebitIndicator(CreditDebitIndicator creditDebitIndicator) {
    this.creditDebitIndicator = creditDebitIndicator;
    return this;
  }

  /**
   * Get creditDebitIndicator
   *
   * @return creditDebitIndicator
   */
  @ApiModelProperty(value = "")
  /**
   * creditDebitIndicator
   *
   * @return creditDebitIndicator CreditDebitIndicator
   */
  public CreditDebitIndicator getCreditDebitIndicator() {
    return creditDebitIndicator;
  }

  /**
   * creditDebitIndicator
   *
   * @param creditDebitIndicator CreditDebitIndicator
   */
  public void setCreditDebitIndicator(CreditDebitIndicator creditDebitIndicator) {
    this.creditDebitIndicator = creditDebitIndicator;
  }

  /**
   * Financial institute&#39;s internal transaction identifier. If provided this field is factored
   * into duplicate detection.
   *
   * @param transactionId String
   * @return StatementLine
   */
  public StatementLine transactionId(String transactionId) {
    this.transactionId = transactionId;
    return this;
  }

  /**
   * Financial institute&#39;s internal transaction identifier. If provided this field is factored
   * into duplicate detection.
   *
   * @return transactionId
   */
  @ApiModelProperty(
      example = "transaction-id-2",
      value =
          "Financial institute's internal transaction identifier. If provided this field is"
              + " factored into duplicate detection.")
  /**
   * Financial institute&#39;s internal transaction identifier. If provided this field is factored
   * into duplicate detection.
   *
   * @return transactionId String
   */
  public String getTransactionId() {
    return transactionId;
  }

  /**
   * Financial institute&#39;s internal transaction identifier. If provided this field is factored
   * into duplicate detection.
   *
   * @param transactionId String
   */
  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  /**
   * Typically the merchant or payee name
   *
   * @param payeeName String
   * @return StatementLine
   */
  public StatementLine payeeName(String payeeName) {
    this.payeeName = payeeName;
    return this;
  }

  /**
   * Typically the merchant or payee name
   *
   * @return payeeName
   */
  @ApiModelProperty(
      example = "Payee name for statement line 2",
      value = "Typically the merchant or payee name")
  /**
   * Typically the merchant or payee name
   *
   * @return payeeName String
   */
  public String getPayeeName() {
    return payeeName;
  }

  /**
   * Typically the merchant or payee name
   *
   * @param payeeName String
   */
  public void setPayeeName(String payeeName) {
    this.payeeName = payeeName;
  }

  /**
   * Optional field to enhance the Description
   *
   * @param reference String
   * @return StatementLine
   */
  public StatementLine reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Optional field to enhance the Description
   *
   * @return reference
   */
  @ApiModelProperty(
      example = "Reference for statement line 2",
      value = "Optional field to enhance the Description")
  /**
   * Optional field to enhance the Description
   *
   * @return reference String
   */
  public String getReference() {
    return reference;
  }

  /**
   * Optional field to enhance the Description
   *
   * @param reference String
   */
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The cheque/check number
   *
   * @param chequeNumber String
   * @return StatementLine
   */
  public StatementLine chequeNumber(String chequeNumber) {
    this.chequeNumber = chequeNumber;
    return this;
  }

  /**
   * The cheque/check number
   *
   * @return chequeNumber
   */
  @ApiModelProperty(example = "021", value = "The cheque/check number")
  /**
   * The cheque/check number
   *
   * @return chequeNumber String
   */
  public String getChequeNumber() {
    return chequeNumber;
  }

  /**
   * The cheque/check number
   *
   * @param chequeNumber String
   */
  public void setChequeNumber(String chequeNumber) {
    this.chequeNumber = chequeNumber;
  }

  /**
   * Descriptive transaction type
   *
   * @param transactionType String
   * @return StatementLine
   */
  public StatementLine transactionType(String transactionType) {
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Descriptive transaction type
   *
   * @return transactionType
   */
  @ApiModelProperty(example = "Refund", value = "Descriptive transaction type")
  /**
   * Descriptive transaction type
   *
   * @return transactionType String
   */
  public String getTransactionType() {
    return transactionType;
  }

  /**
   * Descriptive transaction type
   *
   * @param transactionType String
   */
  public void setTransactionType(String transactionType) {
    this.transactionType = transactionType;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatementLine statementLine = (StatementLine) o;
    return Objects.equals(this.postedDate, statementLine.postedDate)
        && Objects.equals(this.description, statementLine.description)
        && Objects.equals(this.amount, statementLine.amount)
        && Objects.equals(this.creditDebitIndicator, statementLine.creditDebitIndicator)
        && Objects.equals(this.transactionId, statementLine.transactionId)
        && Objects.equals(this.payeeName, statementLine.payeeName)
        && Objects.equals(this.reference, statementLine.reference)
        && Objects.equals(this.chequeNumber, statementLine.chequeNumber)
        && Objects.equals(this.transactionType, statementLine.transactionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        postedDate,
        description,
        amount,
        creditDebitIndicator,
        transactionId,
        payeeName,
        reference,
        chequeNumber,
        transactionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatementLine {\n");
    sb.append("    postedDate: ").append(toIndentedString(postedDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    creditDebitIndicator: ")
        .append(toIndentedString(creditDebitIndicator))
        .append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    payeeName: ").append(toIndentedString(payeeName)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    chequeNumber: ").append(toIndentedString(chequeNumber)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
