/*
 * Xero Files API
 * These endpoints are specific to Xero Files API
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Files */
public class Files {
  StringUtil util = new StringUtil();

  @JsonProperty("TotalCount")
  private Integer totalCount;

  @JsonProperty("Page")
  private Integer page;

  @JsonProperty("PerPage")
  private Integer perPage;

  @JsonProperty("Items")
  private List<FileObject> items = new ArrayList<FileObject>();

  /**
   * totalCount
   *
   * @param totalCount Integer
   * @return Files
   */
  public Files totalCount(Integer totalCount) {
    this.totalCount = totalCount;
    return this;
  }

  /**
   * Get totalCount
   *
   * @return totalCount
   */
  @ApiModelProperty(example = "2", value = "")
  /**
   * totalCount
   *
   * @return totalCount Integer
   */
  public Integer getTotalCount() {
    return totalCount;
  }

  /**
   * totalCount
   *
   * @param totalCount Integer
   */
  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  /**
   * page
   *
   * @param page Integer
   * @return Files
   */
  public Files page(Integer page) {
    this.page = page;
    return this;
  }

  /**
   * Get page
   *
   * @return page
   */
  @ApiModelProperty(example = "1", value = "")
  /**
   * page
   *
   * @return page Integer
   */
  public Integer getPage() {
    return page;
  }

  /**
   * page
   *
   * @param page Integer
   */
  public void setPage(Integer page) {
    this.page = page;
  }

  /**
   * perPage
   *
   * @param perPage Integer
   * @return Files
   */
  public Files perPage(Integer perPage) {
    this.perPage = perPage;
    return this;
  }

  /**
   * Get perPage
   *
   * @return perPage
   */
  @ApiModelProperty(example = "50", value = "")
  /**
   * perPage
   *
   * @return perPage Integer
   */
  public Integer getPerPage() {
    return perPage;
  }

  /**
   * perPage
   *
   * @param perPage Integer
   */
  public void setPerPage(Integer perPage) {
    this.perPage = perPage;
  }

  /**
   * items
   *
   * @param items List&lt;FileObject&gt;
   * @return Files
   */
  public Files items(List<FileObject> items) {
    this.items = items;
    return this;
  }

  /**
   * items
   *
   * @param itemsItem FileObject
   * @return Files
   */
  public Files addItemsItem(FileObject itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<FileObject>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   *
   * @return items
   */
  @ApiModelProperty(value = "")
  /**
   * items
   *
   * @return items List<FileObject>
   */
  public List<FileObject> getItems() {
    return items;
  }

  /**
   * items
   *
   * @param items List&lt;FileObject&gt;
   */
  public void setItems(List<FileObject> items) {
    this.items = items;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Files files = (Files) o;
    return Objects.equals(this.totalCount, files.totalCount)
        && Objects.equals(this.page, files.page)
        && Objects.equals(this.perPage, files.perPage)
        && Objects.equals(this.items, files.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalCount, page, perPage, items);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Files {\n");
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    perPage: ").append(toIndentedString(perPage)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
