/*
 * Xero Files API
 * These endpoints are specific to Xero Files API
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** Folder */
public class Folder {
  StringUtil util = new StringUtil();

  @JsonProperty("Name")
  private String name;

  @JsonProperty("FileCount")
  private Integer fileCount;

  @JsonProperty("Email")
  private String email;

  @JsonProperty("IsInbox")
  private Boolean isInbox;

  @JsonProperty("Id")
  private UUID id;

  /**
   * The name of the folder
   *
   * @param name String
   * @return Folder
   */
  public Folder name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the folder
   *
   * @return name
   */
  @ApiModelProperty(example = "assets", value = "The name of the folder")
  /**
   * The name of the folder
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * The name of the folder
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The number of files in the folder
   *
   * @param fileCount Integer
   * @return Folder
   */
  public Folder fileCount(Integer fileCount) {
    this.fileCount = fileCount;
    return this;
  }

  /**
   * The number of files in the folder
   *
   * @return fileCount
   */
  @ApiModelProperty(example = "5", value = "The number of files in the folder")
  /**
   * The number of files in the folder
   *
   * @return fileCount Integer
   */
  public Integer getFileCount() {
    return fileCount;
  }

  /**
   * The number of files in the folder
   *
   * @param fileCount Integer
   */
  public void setFileCount(Integer fileCount) {
    this.fileCount = fileCount;
  }

  /**
   * The email address used to email files to the inbox. Only the inbox will have this element.
   *
   * @param email String
   * @return Folder
   */
  public Folder email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email address used to email files to the inbox. Only the inbox will have this element.
   *
   * @return email
   */
  @ApiModelProperty(
      example = "foo@bar.com",
      value =
          "The email address used to email files to the inbox. Only the inbox will have this"
              + " element.")
  /**
   * The email address used to email files to the inbox. Only the inbox will have this element.
   *
   * @return email String
   */
  public String getEmail() {
    return email;
  }

  /**
   * The email address used to email files to the inbox. Only the inbox will have this element.
   *
   * @param email String
   */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.
   *
   * @param isInbox Boolean
   * @return Folder
   */
  public Folder isInbox(Boolean isInbox) {
    this.isInbox = isInbox;
    return this;
  }

  /**
   * to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.
   *
   * @return isInbox
   */
  @ApiModelProperty(
      example = "true",
      value = "to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.")
  /**
   * to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.
   *
   * @return isInbox Boolean
   */
  public Boolean getIsInbox() {
    return isInbox;
  }

  /**
   * to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.
   *
   * @param isInbox Boolean
   */
  public void setIsInbox(Boolean isInbox) {
    this.isInbox = isInbox;
  }

  /**
   * Xero unique identifier for a folder Files
   *
   * @param id UUID
   * @return Folder
   */
  public Folder id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Xero unique identifier for a folder Files
   *
   * @return id
   */
  @ApiModelProperty(
      example = "4ff1e5cc-9835-40d5-bb18-09fdb118db9c",
      value = "Xero unique identifier for a folder  Files")
  /**
   * Xero unique identifier for a folder Files
   *
   * @return id UUID
   */
  public UUID getId() {
    return id;
  }

  /**
   * Xero unique identifier for a folder Files
   *
   * @param id UUID
   */
  public void setId(UUID id) {
    this.id = id;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Folder folder = (Folder) o;
    return Objects.equals(this.name, folder.name)
        && Objects.equals(this.fileCount, folder.fileCount)
        && Objects.equals(this.email, folder.email)
        && Objects.equals(this.isInbox, folder.isInbox)
        && Objects.equals(this.id, folder.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, fileCount, email, isInbox, id);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Folder {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    fileCount: ").append(toIndentedString(fileCount)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    isInbox: ").append(toIndentedString(isInbox)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
