/*
 * Xero Files API
 * These endpoints are specific to Xero Files API
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** User */
public class User {
  StringUtil util = new StringUtil();

  @JsonProperty("Id")
  private UUID id;

  @JsonProperty("Name")
  private String name;

  @JsonProperty("FirstName")
  private String firstName;

  @JsonProperty("LastName")
  private String lastName;

  @JsonProperty("FullName")
  private String fullName;

  /**
   * Xero identifier
   *
   * @param id UUID
   * @return User
   */
  public User id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Xero identifier
   *
   * @return id
   */
  @ApiModelProperty(
      example = "4ff1e5cc-9835-40d5-bb18-09fdb118db9c",
      required = true,
      value = "Xero identifier")
  /**
   * Xero identifier
   *
   * @return id UUID
   */
  public UUID getId() {
    return id;
  }

  /**
   * Xero identifier
   *
   * @param id UUID
   */
  public void setId(UUID id) {
    this.id = id;
  }

  /**
   * Key is Name, but returns Email address of user who created the file
   *
   * @param name String
   * @return User
   */
  public User name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Key is Name, but returns Email address of user who created the file
   *
   * @return name
   */
  @ApiModelProperty(
      example = "john.smith@mail.com",
      value = "Key is Name, but returns Email address of user who created the file")
  /**
   * Key is Name, but returns Email address of user who created the file
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * Key is Name, but returns Email address of user who created the file
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * First name of user
   *
   * @param firstName String
   * @return User
   */
  public User firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * First name of user
   *
   * @return firstName
   */
  @ApiModelProperty(example = "John", value = "First name of user")
  /**
   * First name of user
   *
   * @return firstName String
   */
  public String getFirstName() {
    return firstName;
  }

  /**
   * First name of user
   *
   * @param firstName String
   */
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * Last name of user
   *
   * @param lastName String
   * @return User
   */
  public User lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * Last name of user
   *
   * @return lastName
   */
  @ApiModelProperty(example = "Smith", value = "Last name of user")
  /**
   * Last name of user
   *
   * @return lastName String
   */
  public String getLastName() {
    return lastName;
  }

  /**
   * Last name of user
   *
   * @param lastName String
   */
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /**
   * Last name of user
   *
   * @param fullName String
   * @return User
   */
  public User fullName(String fullName) {
    this.fullName = fullName;
    return this;
  }

  /**
   * Last name of user
   *
   * @return fullName
   */
  @ApiModelProperty(example = "Smith", value = "Last name of user")
  /**
   * Last name of user
   *
   * @return fullName String
   */
  public String getFullName() {
    return fullName;
  }

  /**
   * Last name of user
   *
   * @param fullName String
   */
  public void setFullName(String fullName) {
    this.fullName = fullName;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.id, user.id)
        && Objects.equals(this.name, user.name)
        && Objects.equals(this.firstName, user.firstName)
        && Objects.equals(this.lastName, user.lastName)
        && Objects.equals(this.fullName, user.fullName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, firstName, lastName, fullName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
