/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/** AccountUsageResponse */
public class AccountUsageResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("organisationId")
  private UUID organisationId;

  @JsonProperty("startMonth")
  private String startMonth;

  @JsonProperty("endMonth")
  private String endMonth;

  @JsonProperty("accountUsage")
  private List<AccountUsage> accountUsage = new ArrayList<AccountUsage>();

  /**
   * The requested Organisation to which the data pertains
   *
   * @param organisationId UUID
   * @return AccountUsageResponse
   */
  public AccountUsageResponse organisationId(UUID organisationId) {
    this.organisationId = organisationId;
    return this;
  }

  /**
   * The requested Organisation to which the data pertains
   *
   * @return organisationId
   */
  @ApiModelProperty(value = "The requested Organisation to which the data pertains")
  /**
   * The requested Organisation to which the data pertains
   *
   * @return organisationId UUID
   */
  public UUID getOrganisationId() {
    return organisationId;
  }

  /**
   * The requested Organisation to which the data pertains
   *
   * @param organisationId UUID
   */
  public void setOrganisationId(UUID organisationId) {
    this.organisationId = organisationId;
  }

  /**
   * The start month of the report
   *
   * @param startMonth String
   * @return AccountUsageResponse
   */
  public AccountUsageResponse startMonth(String startMonth) {
    this.startMonth = startMonth;
    return this;
  }

  /**
   * The start month of the report
   *
   * @return startMonth
   */
  @ApiModelProperty(value = "The start month of the report")
  /**
   * The start month of the report
   *
   * @return startMonth String
   */
  public String getStartMonth() {
    return startMonth;
  }

  /**
   * The start month of the report
   *
   * @param startMonth String
   */
  public void setStartMonth(String startMonth) {
    this.startMonth = startMonth;
  }

  /**
   * The end month of the report
   *
   * @param endMonth String
   * @return AccountUsageResponse
   */
  public AccountUsageResponse endMonth(String endMonth) {
    this.endMonth = endMonth;
    return this;
  }

  /**
   * The end month of the report
   *
   * @return endMonth
   */
  @ApiModelProperty(value = "The end month of the report")
  /**
   * The end month of the report
   *
   * @return endMonth String
   */
  public String getEndMonth() {
    return endMonth;
  }

  /**
   * The end month of the report
   *
   * @param endMonth String
   */
  public void setEndMonth(String endMonth) {
    this.endMonth = endMonth;
  }

  /**
   * accountUsage
   *
   * @param accountUsage List&lt;AccountUsage&gt;
   * @return AccountUsageResponse
   */
  public AccountUsageResponse accountUsage(List<AccountUsage> accountUsage) {
    this.accountUsage = accountUsage;
    return this;
  }

  /**
   * accountUsage
   *
   * @param accountUsageItem AccountUsage
   * @return AccountUsageResponse
   */
  public AccountUsageResponse addAccountUsageItem(AccountUsage accountUsageItem) {
    if (this.accountUsage == null) {
      this.accountUsage = new ArrayList<AccountUsage>();
    }
    this.accountUsage.add(accountUsageItem);
    return this;
  }

  /**
   * Get accountUsage
   *
   * @return accountUsage
   */
  @ApiModelProperty(value = "")
  /**
   * accountUsage
   *
   * @return accountUsage List<AccountUsage>
   */
  public List<AccountUsage> getAccountUsage() {
    return accountUsage;
  }

  /**
   * accountUsage
   *
   * @param accountUsage List&lt;AccountUsage&gt;
   */
  public void setAccountUsage(List<AccountUsage> accountUsage) {
    this.accountUsage = accountUsage;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountUsageResponse accountUsageResponse = (AccountUsageResponse) o;
    return Objects.equals(this.organisationId, accountUsageResponse.organisationId)
        && Objects.equals(this.startMonth, accountUsageResponse.startMonth)
        && Objects.equals(this.endMonth, accountUsageResponse.endMonth)
        && Objects.equals(this.accountUsage, accountUsageResponse.accountUsage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(organisationId, startMonth, endMonth, accountUsage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountUsageResponse {\n");
    sb.append("    organisationId: ").append(toIndentedString(organisationId)).append("\n");
    sb.append("    startMonth: ").append(toIndentedString(startMonth)).append("\n");
    sb.append("    endMonth: ").append(toIndentedString(endMonth)).append("\n");
    sb.append("    accountUsage: ").append(toIndentedString(accountUsage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
